/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;

public final class Version {
    public static final String PRODUCT_NAME = "DBRecover for Oracle";
    public static final String COMPANY_INFO = "Copyright (c) 2009 - 2025 DBRECOVER.COM";
    public static final String PRM_VERSION = "2512";
    public static final String PRM_LONG_VERSION = "Version 2512";
    public static final String PRM_BUILD_DATE = "2025.12.01";
    public static final String COMPANY_YEAR_PERIOD = "2009 - 2025";
    public static final String CONFIG_FILE_NAME = "dbrecover-oracle.conf";
    public static final String REGISTER_FILE_NAME = "dbrecover-oracle.info";
    public static final String CONFIG_DIR = "./config";

    public static boolean ensureConfigDirExists() {
        File file = new File(CONFIG_DIR);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean ensureConfigFileExists() {
        if (!Version.ensureConfigDirExists()) {
            return false;
        }
        File file = new File("./config/dbrecover-oracle.conf");
        if (!file.exists()) {
            try {
                Properties properties = new Properties();
                properties.setProperty("IsRestrictMode", "yes");
                Locale locale = Locale.getDefault();
                if (locale.getLanguage().equals(Locale.CHINESE.getLanguage())) {
                    properties.setProperty("lang", "zh_cn");
                } else {
                    properties.setProperty("lang", "en_us");
                }
                properties.setProperty("lob_batch_size", "500");
                properties.setProperty("scan_row_limit", "1000");
                properties.setProperty("view_row_limit", "1000");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, "config by DBRECOVER");
                fileOutputStream.close();
                return true;
            }
            catch (Exception exception) {
                System.err.println("Failed to create default config file: " + exception.getMessage());
                return false;
            }
        }
        return true;
    }

    public static String getConfigFilePath() {
        return "./config/dbrecover-oracle.conf";
    }

    public static String getRegisterFilePath() {
        return "./config/dbrecover-oracle.info";
    }
}

