/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.bridge;

import com.dbrecover.gui.bridge.I;
import com.dbrecover.gui.bridge.I1;
import com.dbrecover.gui.bridge.MultiThreadDataBridgeDialog;
import com.dbrecover.gui.bridge.O0;
import com.dbrecover.gui.bridge.OracleDBConnectionSetupDialog;
import com.dbrecover.gui.bridge.SchemaDataBridgeProgressDialog;
import com.dbrecover.gui.bridge.l1;
import com.dbrecover.gui.bridge.lI;
import com.dbrecover.gui.core.general.GeneralWaittingDialog;
import com.dbrecover.gui.core.general.GeneralWaittingWithTextAreaDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import o._f0;
import o._l0;
import o.a_a;
import o.lIl;
import o.y0;
import o.\u03b7;

public class DataBridgeSetupDialog
extends JDialog {
    private JComboBox supportedColTypes = null;
    private DefaultTableModel colInfoTableModel = null;
    private y0 colTemplateForDataBridge = null;
    private boolean doesTheColTypeCanBeEdited = false;
    private String tableNameInColumnTemplate = null;
    private I schemaDataBridgeTableModel = null;
    private boolean isSchemaDataBridge = false;
    private String schemaNameForDataBridge = null;
    private long totallyInsertedRowCount = 0L;
    private double elapsedTimeForDataBridge;
    private boolean isLobSegmentUnloadNonBts = false;
    private JLabel jLabel_thread_count;
    private JSpinner jSpinner_thread_count;
    private JButton jButton_cancel;
    private JButton jButton_create_db_connection;
    private JButton jButton_start_data_bridge;
    private JCheckBox jCheckBox_if_to_create_table;
    private JCheckBox jCheckBox_if_to_scan_data;
    private JCheckBox jCheckBox_unload_deleted_data_only;
    private JComboBox jComboBox_db_connection;
    private JComboBox jComboBox_lob_extract_method;
    private JComboBox jComboBox_tablespace;
    private JLabel jLabel_db_connection;
    private JLabel jLabel_need_to_specify_dataobjid;
    private JLabel jLabel_tablespace;
    private JLabel jLabel_target_table_name;
    private JScrollPane jScrollPane1;
    private JTable jTable_column_info;
    private JTextField jTextField_specify_dataobjid;
    private JTextField jTextField_target_table_name;
    private static final Color BG_COLOR = new Color(30, 36, 48);
    private static final Color PANEL_BG = new Color(42, 50, 66);
    private static final Color CARD_BG = new Color(55, 65, 85);
    private static final Color PRIMARY_COLOR = new Color(66, 165, 245);
    private static final Color SUCCESS_COLOR = new Color(102, 187, 106);
    private static final Color TEXT_PRIMARY = new Color(255, 255, 255);
    private static final Color TEXT_SECONDARY = new Color(200, 210, 220);
    private static final Color BORDER_COLOR = new Color(70, 85, 110);
    private static final Color TABLE_ROW_ODD = new Color(40, 48, 65);
    private static final Color TABLE_ROW_EVEN = new Color(50, 60, 80);
    private static final Color TABLE_HEADER_BG = new Color(60, 75, 100);
    private static final Color TABLE_HEADER_FG = new Color(255, 255, 255);
    private static final String FONT_FAMILY = "Microsoft YaHei";
    private static final String FONT_MONO = "Consolas";

    public DataBridgeSetupDialog(Frame frame, y0 y02, boolean bl) {
        super(frame, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge"), true);
        this.initComponents();
        this.isSchemaDataBridge = false;
        this.colTemplateForDataBridge = y02;
        this.doesTheColTypeCanBeEdited = bl;
        this.jTextField_target_table_name.setEditable(false);
        this.jTextField_target_table_name.setBackground(Color.GRAY);
        this.jCheckBox_if_to_create_table.setSelected(false);
        this.jCheckBox_if_to_scan_data.setSelected(false);
        this.jTextField_specify_dataobjid.setEditable(false);
        this.jTextField_specify_dataobjid.setBackground(Color.GRAY);
        if (!lIl.O0().a_()) {
            this.jCheckBox_if_to_scan_data.setEnabled(false);
        }
        this.loadDBConnectionDataFromFile();
        this.initDBConnectionComboBox();
        this.supportedColTypes = new JComboBox();
        String[] stringArray = a_a.lI();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.supportedColTypes.addItem(stringArray[i2]);
        }
        if (_l0.bV == 0) {
            this.jComboBox_lob_extract_method.addItem(ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_based_on_lob_index"));
            this.jComboBox_lob_extract_method.addItem(ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_based_on_lob_scan"));
        } else {
            this.jComboBox_lob_extract_method.addItem(ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_based_on_lob_scan"));
            this.jComboBox_lob_extract_method.setEnabled(false);
        }
        this.customizeMyJTable();
        this.loadColumnTemplateInfo();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public DataBridgeSetupDialog(Frame frame, y0 y02, boolean bl, boolean bl2) {
        super(frame, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge"), true);
        this.initComponents();
        this.isLobSegmentUnloadNonBts = true;
        this.isSchemaDataBridge = false;
        this.colTemplateForDataBridge = y02;
        this.doesTheColTypeCanBeEdited = bl;
        this.jTextField_target_table_name.setEditable(false);
        this.jTextField_target_table_name.setBackground(Color.GRAY);
        this.jCheckBox_if_to_create_table.setSelected(false);
        this.jCheckBox_if_to_scan_data.setSelected(false);
        this.jCheckBox_if_to_scan_data.setEnabled(false);
        this.jTextField_specify_dataobjid.setEditable(false);
        this.jTextField_specify_dataobjid.setBackground(Color.GRAY);
        this.jCheckBox_unload_deleted_data_only.setSelected(false);
        this.jCheckBox_unload_deleted_data_only.setEnabled(false);
        this.loadDBConnectionDataFromFile();
        this.initDBConnectionComboBox();
        this.supportedColTypes = new JComboBox();
        String[] stringArray = new String[]{"BLOB", "CLOB", "NCLOB"};
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.supportedColTypes.addItem(stringArray[i2]);
        }
        if (_l0.bV == 0) {
            this.jComboBox_lob_extract_method.addItem(ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_based_on_lob_index"));
            this.jComboBox_lob_extract_method.addItem(ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_based_on_lob_scan"));
        } else {
            this.jComboBox_lob_extract_method.addItem(ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_based_on_lob_scan"));
            this.jComboBox_lob_extract_method.setEnabled(false);
        }
        this.customizeMyJTableLobSegmentNonBts();
        this.loadColumnTemplateInfo();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public DataBridgeSetupDialog(Frame frame, String string) {
        super(frame, "Data Bridge for Schema", true);
        this.isSchemaDataBridge = true;
        this.schemaNameForDataBridge = string;
        this.loadDBConnectionDataFromFile();
        this.initComponentsModern();
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void initComponentsModern() {
        this.getContentPane().setBackground(BG_COLOR);
        JPanel jPanel = new JPanel(new BorderLayout(0, 20));
        jPanel.setBackground(BG_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JPanel jPanel2 = this.createModernTablePanel();
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 15));
        jPanel3.setBackground(BG_COLOR);
        JPanel jPanel4 = this.createModernSettingsPanel();
        jPanel3.add((Component)jPanel4, "Center");
        JPanel jPanel5 = this.createModernButtonPanel();
        jPanel3.add((Component)jPanel5, "South");
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel);
        this.setPreferredSize(new Dimension(900, 580));
    }

    private JPanel createModernTablePanel() {
        ArrayList arrayList;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        jPanel.setBackground(BG_COLOR);
        this.schemaDataBridgeTableModel = new I();
        this.jTable_column_info = new JTable(this.schemaDataBridgeTableModel);
        this.jTable_column_info.setBackground(TABLE_ROW_EVEN);
        this.jTable_column_info.setForeground(TEXT_PRIMARY);
        this.jTable_column_info.setSelectionBackground(new Color(66, 165, 245, 100));
        this.jTable_column_info.setSelectionForeground(Color.WHITE);
        this.jTable_column_info.setGridColor(BORDER_COLOR);
        this.jTable_column_info.setRowHeight(28);
        this.jTable_column_info.setFont(new Font(FONT_FAMILY, 0, 13));
        this.jTable_column_info.getTableHeader().setBackground(TABLE_HEADER_BG);
        this.jTable_column_info.getTableHeader().setForeground(TABLE_HEADER_FG);
        this.jTable_column_info.getTableHeader().setFont(new Font(FONT_FAMILY, 1, 13));
        this.jTable_column_info.getTableHeader().setPreferredSize(new Dimension(0, 32));
        this.jTable_column_info.getTableHeader().setReorderingAllowed(false);
        this.jTable_column_info.getTableHeader().setOpaque(true);
        this.jTable_column_info.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
                jLabel.setBackground(TABLE_HEADER_BG);
                jLabel.setForeground(TABLE_HEADER_FG);
                jLabel.setFont(new Font(DataBridgeSetupDialog.FONT_FAMILY, 1, 13));
                jLabel.setHorizontalAlignment(2);
                jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
                jLabel.setOpaque(true);
                return jLabel;
            }
        });
        this.jTable_column_info.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
                if (!bl) {
                    component.setBackground(n2 % 2 == 0 ? TABLE_ROW_EVEN : TABLE_ROW_ODD);
                } else {
                    component.setBackground(new Color(66, 165, 245, 100));
                }
                component.setForeground(Color.WHITE);
                this.setFont(new Font(DataBridgeSetupDialog.FONT_FAMILY, 0, 13));
                this.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
                return component;
            }
        });
        if (this.schemaNameForDataBridge != null && (arrayList = _l0.I1.l1(this.schemaNameForDataBridge)) != null) {
            for (\u03b7 \u03b72 : arrayList) {
                this.schemaDataBridgeTableModel.addRow(new Object[]{\u03b72.tableName, Boolean.TRUE});
            }
            arrayList.clear();
        }
        this.jScrollPane1 = new JScrollPane(this.jTable_column_info);
        this.jScrollPane1.getViewport().setBackground(TABLE_ROW_EVEN);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
        jPanel.add((Component)this.jScrollPane1, "Center");
        return jPanel;
    }

    private JPanel createModernSettingsPanel() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(BG_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 0, 8, 40);
        this.jCheckBox_if_to_create_table = new JCheckBox(resourceBundle.getString("data_bridge_if_need_to_add_suffix_for_tables"));
        this.jCheckBox_if_to_create_table.setFont(new Font(FONT_FAMILY, 0, 12));
        this.jCheckBox_if_to_create_table.setForeground(TEXT_SECONDARY);
        this.jCheckBox_if_to_create_table.setBackground(BG_COLOR);
        this.jCheckBox_if_to_create_table.addActionListener(actionEvent -> this.jTextField_target_table_name.setEnabled(this.jCheckBox_if_to_create_table.isSelected()));
        jPanel.add((Component)this.jCheckBox_if_to_create_table, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 40);
        JLabel jLabel = new JLabel(resourceBundle.getString("data_bridge_suffix_for_tables"));
        jLabel.setFont(new Font(FONT_FAMILY, 0, 12));
        jLabel.setForeground(TEXT_SECONDARY);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 40);
        this.jTextField_target_table_name = new JTextField(15);
        this.jTextField_target_table_name.setEnabled(false);
        this.jTextField_target_table_name.setFont(new Font(FONT_FAMILY, 0, 12));
        this.jTextField_target_table_name.setPreferredSize(new Dimension(180, 28));
        jPanel.add((Component)this.jTextField_target_table_name, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.35;
        gridBagConstraints.insets = new Insets(0, 0, 5, 40);
        JLabel jLabel2 = new JLabel(resourceBundle.getString("data_bridge_db_connection"));
        jLabel2.setFont(new Font(FONT_FAMILY, 0, 12));
        jLabel2.setForeground(TEXT_SECONDARY);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 8, 40);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.setBackground(BG_COLOR);
        this.jComboBox_db_connection = new JComboBox();
        this.jComboBox_db_connection.setPreferredSize(new Dimension(190, 28));
        this.jComboBox_db_connection.setFont(new Font(FONT_FAMILY, 0, 12));
        this.initDBConnectionComboBox();
        this.jComboBox_db_connection.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                String string = (String)itemEvent.getItem();
                lI lI2 = (lI)O0.lO0.get(string);
                if (lI2 == null) {
                    this.jComboBox_tablespace.removeAllItems();
                    return;
                }
                Object[] objectArray = _f0.O0(lI2._1(), lI2.getUserName(), lI2.getPassword());
                this.jComboBox_tablespace.removeAllItems();
                if (objectArray != null) {
                    for (Object object : objectArray) {
                        this.jComboBox_tablespace.addItem(object);
                    }
                }
            }
        });
        jPanel2.add(this.jComboBox_db_connection);
        this.jButton_create_db_connection = new JButton("+");
        this.jButton_create_db_connection.setFont(new Font(FONT_FAMILY, 1, 14));
        this.jButton_create_db_connection.setBackground(PRIMARY_COLOR);
        this.jButton_create_db_connection.setForeground(Color.WHITE);
        this.jButton_create_db_connection.setPreferredSize(new Dimension(32, 28));
        this.jButton_create_db_connection.setBorderPainted(false);
        this.jButton_create_db_connection.setFocusPainted(false);
        this.jButton_create_db_connection.setCursor(new Cursor(12));
        this.jButton_create_db_connection.addActionListener(actionEvent -> {
            OracleDBConnectionSetupDialog oracleDBConnectionSetupDialog = new OracleDBConnectionSetupDialog(this);
            ArrayList arrayList = new ArrayList(4);
            oracleDBConnectionSetupDialog.setNewAddedDBConnectionList(arrayList);
            oracleDBConnectionSetupDialog.setCalledFromSchemaDataBridge();
            oracleDBConnectionSetupDialog.setVisible(true);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                this.jComboBox_db_connection.addItem(arrayList.get(i2));
            }
        });
        jPanel2.add(this.jButton_create_db_connection);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 40);
        JLabel jLabel3 = new JLabel(resourceBundle.getString("data_bridge_tablespace"));
        jLabel3.setFont(new Font(FONT_FAMILY, 0, 12));
        jLabel3.setForeground(TEXT_SECONDARY);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 40);
        this.jComboBox_tablespace = new JComboBox();
        this.jComboBox_tablespace.setPreferredSize(new Dimension(190, 28));
        this.jComboBox_tablespace.setFont(new Font(FONT_FAMILY, 0, 12));
        jPanel.add((Component)this.jComboBox_tablespace, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.35;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jCheckBox_if_to_scan_data = new JCheckBox(resourceBundle.getString("asm_select_all_files"));
        this.jCheckBox_if_to_scan_data.setFont(new Font(FONT_FAMILY, 0, 12));
        this.jCheckBox_if_to_scan_data.setForeground(TEXT_SECONDARY);
        this.jCheckBox_if_to_scan_data.setBackground(BG_COLOR);
        this.jCheckBox_if_to_scan_data.setSelected(true);
        this.jCheckBox_if_to_scan_data.addActionListener(actionEvent -> {
            int n2 = this.jTable_column_info.getRowCount();
            boolean bl = this.jCheckBox_if_to_scan_data.isSelected();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.jTable_column_info.setValueAt(bl, i2, 1);
            }
        });
        jPanel.add((Component)this.jCheckBox_if_to_scan_data, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jComboBox_lob_extract_method = new JComboBox();
        this.jComboBox_lob_extract_method.setPreferredSize(new Dimension(150, 28));
        this.jComboBox_lob_extract_method.setFont(new Font(FONT_FAMILY, 0, 12));
        if (_l0.bV == 0) {
            this.jComboBox_lob_extract_method.addItem(resourceBundle.getString("data_bridge_based_on_lob_index"));
            this.jComboBox_lob_extract_method.addItem(resourceBundle.getString("data_bridge_based_on_lob_scan"));
        } else {
            this.jComboBox_lob_extract_method.addItem(resourceBundle.getString("data_bridge_based_on_lob_scan"));
            this.jComboBox_lob_extract_method.setEnabled(false);
        }
        jPanel.add((Component)this.jComboBox_lob_extract_method, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 8, 0));
        jPanel3.setBackground(BG_COLOR);
        this.jLabel_thread_count = new JLabel(resourceBundle.getString("data_bridge_parallel_threads") + ":");
        this.jLabel_thread_count.setFont(new Font(FONT_FAMILY, 0, 12));
        this.jLabel_thread_count.setForeground(TEXT_SECONDARY);
        jPanel3.add(this.jLabel_thread_count);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 4, 1);
        this.jSpinner_thread_count = new JSpinner(spinnerNumberModel);
        this.jSpinner_thread_count.setPreferredSize(new Dimension(55, 26));
        this.jSpinner_thread_count.setFont(new Font(FONT_FAMILY, 0, 12));
        jPanel3.add(this.jSpinner_thread_count);
        JLabel jLabel4 = new JLabel("(1-4)");
        jLabel4.setFont(new Font(FONT_FAMILY, 0, 11));
        jLabel4.setForeground(new Color(140, 150, 165));
        jPanel3.add(jLabel4);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    private JPanel createModernButtonPanel() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        JPanel jPanel = new JPanel(new FlowLayout(2, 15, 15));
        jPanel.setBackground(BG_COLOR);
        this.jButton_cancel = new JButton(resourceBundle.getString("navigator_panel1_world_cancel"));
        this.jButton_cancel.setFont(new Font(FONT_FAMILY, 1, 13));
        this.jButton_cancel.setBackground(CARD_BG);
        this.jButton_cancel.setForeground(TEXT_PRIMARY);
        this.jButton_cancel.setPreferredSize(new Dimension(100, 36));
        this.jButton_cancel.setBorderPainted(false);
        this.jButton_cancel.setFocusPainted(false);
        this.jButton_cancel.setCursor(new Cursor(12));
        this.jButton_cancel.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        this.jButton_start_data_bridge = new JButton(resourceBundle.getString("data_bridge"));
        this.jButton_start_data_bridge.setFont(new Font(FONT_FAMILY, 1, 13));
        this.jButton_start_data_bridge.setBackground(PRIMARY_COLOR);
        this.jButton_start_data_bridge.setForeground(Color.WHITE);
        this.jButton_start_data_bridge.setPreferredSize(new Dimension(120, 36));
        this.jButton_start_data_bridge.setBorderPainted(false);
        this.jButton_start_data_bridge.setFocusPainted(false);
        this.jButton_start_data_bridge.setCursor(new Cursor(12));
        this.jButton_start_data_bridge.addActionListener(actionEvent -> this.jButton_start_data_bridgeActionPerformed(actionEvent));
        jPanel.add(this.jButton_cancel);
        jPanel.add(this.jButton_start_data_bridge);
        return jPanel;
    }

    private void customizeMyJTable() {
        this.colInfoTableModel = new l1(this.doesTheColTypeCanBeEdited);
        this.jTable_column_info.setModel(this.colInfoTableModel);
        this.jTable_column_info.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.jTable_column_info.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(this.supportedColTypes));
    }

    private void customizeMyJTableLobSegmentNonBts() {
        this.colInfoTableModel = new I1();
        this.jTable_column_info.setModel(this.colInfoTableModel);
        this.jTable_column_info.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.jTable_column_info.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(this.supportedColTypes));
    }

    private void customizeMyJTableForSchemaDataBridge() {
        ArrayList arrayList;
        this.schemaDataBridgeTableModel = new I();
        this.jTable_column_info.setModel(this.schemaDataBridgeTableModel);
        this.jTable_column_info.getTableHeader().setReorderingAllowed(false);
        if (this.schemaNameForDataBridge != null && (arrayList = _l0.I1.l1(this.schemaNameForDataBridge)) != null) {
            Iterator iterator = arrayList.iterator();
            Object[] objectArray = null;
            while (iterator.hasNext()) {
                \u03b7 \u03b72 = (\u03b7)iterator.next();
                objectArray = new Object[]{\u03b72.tableName, Boolean.TRUE};
                this.schemaDataBridgeTableModel.addRow(objectArray);
            }
            arrayList.clear();
        }
    }

    private void loadColumnTemplateInfo() {
        if (this.colTemplateForDataBridge != null) {
            String[] stringArray;
            String[] stringArray2 = this.colTemplateForDataBridge.l();
            int n2 = stringArray2.length;
            if (n2 != (stringArray = this.colTemplateForDataBridge.S5()).length) {
                System.out.println("Column name size and type size does not match!!!");
                return;
            }
            Object[] objectArray = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray = new Object[]{stringArray2[i2], stringArray[i2]};
                this.colInfoTableModel.addRow(objectArray);
            }
            this.tableNameInColumnTemplate = this.colTemplateForDataBridge.getTableName();
            this.colTemplateForDataBridge = null;
        }
    }

    private void loadDBConnectionDataFromFile() {
        File file;
        if (O0.lO0.size() == 0 && (file = new File("./config/dbconfig")).exists() && file.isFile() && file.canRead()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 4096);
                while ((string = bufferedReader.readLine()) != null) {
                    int n2 = string.indexOf("?!]");
                    String string2 = string.substring(3, n2);
                    String string3 = string.substring(n2 + 3);
                    int n3 = string3.indexOf("@//");
                    String string4 = string3.substring(0, n3);
                    string3 = string3.substring(n3 + 3);
                    int n4 = string3.indexOf(58);
                    String string5 = string3.substring(0, n4);
                    int n5 = string3.indexOf(47);
                    String string6 = string3.substring(n4 + 1, n5);
                    string3 = string3.substring(n5 + 1);
                    int n6 = string3.indexOf("[!?");
                    String string7 = string3.substring(0, n6);
                    int n7 = string3.indexOf("?!]");
                    String string8 = string3.substring(n6 + 3, n7);
                    boolean bl = !string3.endsWith("SN?!]");
                    lI lI2 = new lI(string2, string4, string8, string5, string6, string7, bl);
                    O0.lO0.put(string2, lI2);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private void initDBConnectionComboBox() {
        Set set = O0.lO0.keySet();
        Iterator iterator = set.iterator();
        this.jComboBox_db_connection.addItem("");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.jComboBox_db_connection.addItem(string);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable_column_info = new JTable();
        this.jCheckBox_if_to_create_table = new JCheckBox();
        this.jComboBox_db_connection = new JComboBox();
        this.jCheckBox_if_to_scan_data = new JCheckBox();
        this.jComboBox_tablespace = new JComboBox();
        this.jLabel_db_connection = new JLabel();
        this.jLabel_tablespace = new JLabel();
        this.jTextField_target_table_name = new JTextField();
        this.jLabel_target_table_name = new JLabel();
        this.jButton_start_data_bridge = new JButton();
        this.jButton_cancel = new JButton();
        this.jButton_create_db_connection = new JButton();
        this.jLabel_need_to_specify_dataobjid = new JLabel();
        this.jTextField_specify_dataobjid = new JTextField();
        this.jComboBox_lob_extract_method = new JComboBox();
        this.jCheckBox_unload_deleted_data_only = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jTable_column_info.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTable_column_info.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DataBridgeSetupDialog.this.jTable_column_infoMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable_column_info);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        this.jCheckBox_if_to_create_table.setText(resourceBundle.getString("data_bridge_if_to_create_table"));
        this.jCheckBox_if_to_create_table.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox_if_to_create_table.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox_if_to_create_table.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataBridgeSetupDialog.this.jCheckBox_if_to_create_tableActionPerformed(actionEvent);
            }
        });
        this.jComboBox_db_connection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DataBridgeSetupDialog.this.jComboBox_db_connectionItemStateChanged(itemEvent);
            }
        });
        this.jCheckBox_if_to_scan_data.setText(resourceBundle.getString("data_bridge_if_unload_truncated"));
        this.jCheckBox_if_to_scan_data.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox_if_to_scan_data.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox_if_to_scan_data.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataBridgeSetupDialog.this.jCheckBox_if_to_scan_dataActionPerformed(actionEvent);
            }
        });
        this.jLabel_db_connection.setText(resourceBundle.getString("data_bridge_db_connection"));
        this.jLabel_tablespace.setText(resourceBundle.getString("data_bridge_tablespace"));
        this.jLabel_target_table_name.setText(resourceBundle.getString("data_bridge_target_table"));
        this.jButton_start_data_bridge.setText(resourceBundle.getString("data_bridge"));
        this.jButton_start_data_bridge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataBridgeSetupDialog.this.jButton_start_data_bridgeActionPerformed(actionEvent);
            }
        });
        this.jButton_cancel.setText(resourceBundle.getString("navigator_panel1_world_cancel"));
        this.jButton_cancel.setMaximumSize(new Dimension(116, 29));
        this.jButton_cancel.setMinimumSize(new Dimension(116, 29));
        this.jButton_cancel.setPreferredSize(new Dimension(116, 29));
        this.jButton_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataBridgeSetupDialog.this.jButton_cancelActionPerformed(actionEvent);
            }
        });
        this.jButton_create_db_connection.setIcon(new ImageIcon(this.getClass().getResource("/com/dbrecover/gui/resources/plus.png")));
        this.jButton_create_db_connection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataBridgeSetupDialog.this.jButton_create_db_connectionActionPerformed(actionEvent);
            }
        });
        this.jLabel_need_to_specify_dataobjid.setText(resourceBundle.getString("data_bridge_unload_truncated_with_data_obj_id"));
        this.jCheckBox_unload_deleted_data_only.setText(resourceBundle.getString("text_deleted_data_only_bridge_mode"));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_if_to_create_table, -2, 215, -2).addComponent(this.jLabel_target_table_name, -2, 144, -2).addComponent(this.jTextField_target_table_name, -2, 186, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(115, 115, 115).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_db_connection, -2, 123, -2).addComponent(this.jLabel_tablespace, -2, 99, -2))).addGroup(groupLayout.createSequentialGroup().addGap(261, 261, 261).addComponent(this.jButton_create_db_connection, -2, 37, -2)).addGroup(groupLayout.createSequentialGroup().addGap(63, 63, 63).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_db_connection, -2, 190, -2).addComponent(this.jComboBox_tablespace, -2, 176, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 93, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_unload_deleted_data_only, GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBox_if_to_scan_data, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_need_to_specify_dataobjid, GroupLayout.Alignment.TRAILING).addComponent(this.jTextField_specify_dataobjid, GroupLayout.Alignment.TRAILING, -2, 104, -2).addComponent(this.jComboBox_lob_extract_method, GroupLayout.Alignment.TRAILING, -2, 150, -2))).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton_start_data_bridge, -1, 121, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_cancel, -1, 121, Short.MAX_VALUE))).addGap(36, 36, 36)).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane1).addContainerGap()));
        groupLayout.linkSize(0, this.jComboBox_db_connection, this.jComboBox_tablespace);
        groupLayout.linkSize(0, this.jButton_cancel, this.jButton_start_data_bridge);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 256, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.jCheckBox_if_to_create_table, -2, 14, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel_target_table_name).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_target_table_name, -2, -1, -2).addGap(144, 144, 144)).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_start_data_bridge).addComponent(this.jButton_cancel, -2, -1, -2)).addGap(23, 23, 23)))).addGroup(groupLayout.createSequentialGroup().addGap(294, 294, 294).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel_db_connection).addGap(49, 49, 49).addComponent(this.jLabel_tablespace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_tablespace, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton_create_db_connection, -2, 17, -2).addComponent(this.jComboBox_db_connection, -2, -1, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCheckBox_unload_deleted_data_only).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_if_to_scan_data).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_need_to_specify_dataobjid).addGap(7, 7, 7).addComponent(this.jTextField_specify_dataobjid, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBox_lob_extract_method, -2, -1, -2))).addContainerGap()));
        groupLayout.linkSize(1, this.jButton_cancel, this.jButton_start_data_bridge);
    }

    private void jTable_column_infoMouseClicked(MouseEvent mouseEvent) {
        if (this.isSchemaDataBridge && mouseEvent.isShiftDown() && this.jTable_column_info.getSelectedColumn() == 1) {
            int[] nArray = this.jTable_column_info.getSelectedRows();
            Boolean bl = (Boolean)this.jTable_column_info.getValueAt(this.jTable_column_info.getSelectedRow(), 1);
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.jTable_column_info.setValueAt(bl, nArray[i2], 1);
            }
        }
    }

    private void jCheckBox_if_to_scan_dataActionPerformed(ActionEvent actionEvent) {
        if (this.isSchemaDataBridge) {
            int n2 = this.jTable_column_info.getRowCount();
            if (this.jCheckBox_if_to_scan_data.isSelected()) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.jTable_column_info.setValueAt(true, i2, 1);
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.jTable_column_info.setValueAt(false, i3, 1);
                }
            }
            return;
        }
        if (this.jCheckBox_if_to_scan_data.isSelected()) {
            this.jTextField_specify_dataobjid.setEditable(true);
            this.jTextField_specify_dataobjid.setBackground(Color.WHITE);
            this.jComboBox_lob_extract_method.setSelectedIndex(1);
            this.jComboBox_lob_extract_method.setEnabled(false);
            String string = lIl.O0().__a();
            if (string != null) {
                this.jTextField_specify_dataobjid.setText(string);
                lIl.O0().IlI(null);
            }
        } else {
            this.jTextField_specify_dataobjid.setEditable(false);
            this.jTextField_specify_dataobjid.setBackground(Color.GRAY);
            this.jComboBox_lob_extract_method.setSelectedIndex(0);
            this.jComboBox_lob_extract_method.setEnabled(true);
        }
    }

    private void jComboBox_db_connectionItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)itemEvent.getItem();
            lI lI2 = (lI)O0.lO0.get(string);
            if (lI2 == null) {
                this.jComboBox_tablespace.removeAllItems();
                return;
            }
            Object[] objectArray = _f0.O0(lI2._1(), lI2.getUserName(), lI2.getPassword());
            if (objectArray == null) {
                JOptionPane.showMessageDialog(this, "can not access dba_tablespaces, pls check prm.log and your database connection ; you'd better grant dba to the TARGET_USER.  ", ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
            }
            this.jComboBox_tablespace.removeAllItems();
            if (objectArray != null) {
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.jComboBox_tablespace.addItem(objectArray[i2]);
                }
                objectArray = null;
            }
        }
    }

    private void jButton_start_data_bridgeActionPerformed(ActionEvent actionEvent) {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        String string;
        String string2;
        String string3 = (String)this.jComboBox_lob_extract_method.getSelectedItem();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        String string4 = resourceBundle.getString("data_bridge_based_on_lob_index");
        String string5 = resourceBundle.getString("data_bridge_based_on_lob_scan");
        if (string3.equals(string4)) {
            a_a.m0m = 0;
        } else if (string3.equals(string5)) {
            a_a.m0m = 1;
        }
        if (this.isSchemaDataBridge) {
            boolean bl = false;
            try {
                bl = this.dataBridgeForSchema();
            }
            catch (Exception exception) {
                System.err.println("Exception to data bridge for schema: " + this.schemaNameForDataBridge);
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
            if (bl) {
                this.setVisible(false);
                this.dispose();
            }
            return;
        }
        boolean bl = false;
        long l2 = -1L;
        long[] lArray = new long[1];
        if (this.jCheckBox_if_to_scan_data.isSelected()) {
            string2 = this.jTextField_specify_dataobjid.getText().trim();
            if (!string2.equals("")) {
                try {
                    l2 = Long.parseLong(string2);
                    bl = true;
                    lArray[0] = Long.parseLong(string2);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, resourceBundle.getString("invalid_specified_data_objid_truncated_bts_mode"), resourceBundle.getString("production_name"), 2);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, resourceBundle.getString("invalid_specified_data_objid_truncated_bts_mode"), resourceBundle.getString("production_name"), 2);
                return;
            }
        }
        if (this.jCheckBox_if_to_create_table.isSelected()) {
            string2 = this.jTextField_target_table_name.getText().trim();
            if (string2.equals("")) {
                String string6 = resourceBundle.getString("data_bridge_target_table_is_not_exist");
                JOptionPane.showMessageDialog(this, string6, resourceBundle.getString("production_name"), 2);
                return;
            }
        } else {
            string2 = this.tableNameInColumnTemplate;
        }
        if ((string = (String)this.jComboBox_db_connection.getSelectedItem()).equals("")) {
            String string7 = resourceBundle.getString("data_bridge_db_connection_not_choosen");
            JOptionPane.showMessageDialog(this, string7, resourceBundle.getString("production_name"), 2);
            return;
        }
        if (this.jCheckBox_if_to_scan_data.isSelected()) {
            String string8 = lIl.O0().__();
            stringArray2 = lIl.O0().___();
            stringArray = lIl.O0()._0();
            String string9 = stringArray == null ? _l0.I1.O0(string8, (String)stringArray2) : _l0.I1.O0(string8, (String)stringArray2, (String)stringArray);
            object = new ArrayList(64);
            GeneralWaittingWithTextAreaDialog generalWaittingWithTextAreaDialog = new GeneralWaittingWithTextAreaDialog((ArrayList)object, this);
            new Thread(() -> {
                PrintStream printStream = System.out;
                System.setOut(new PrintStream(new com.dbrecover.gui.core.general.I1((ArrayList)object), true));
                if (!_l0.I1.Il(null, "PRM_EXTENT_INFO")) {
                    _l0.I1.\u03bd();
                    _l0.I1.scanDatabase();
                }
                System.out.println("\nExtent scanning, please waiting...\n");
                _l0.I1.l(lArray[0]);
                System.setOut(printStream);
                generalWaittingWithTextAreaDialog.stopWork();
            }).start();
            generalWaittingWithTextAreaDialog.startWork();
            generalWaittingWithTextAreaDialog.setVisible(true);
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(lArray[0]);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            _l0.I1.b0();
            long l3 = _l0.I1.O0(lArray[0], 0);
            if (l3 < 0L) {
                String string10 = lArray[0] + ": " + resourceBundle.getString("nonbootstrap_data_view_error");
                JOptionPane.showMessageDialog(this, string10, resourceBundle.getString("production_name"), 2);
                return;
            }
            arrayList2.add(l3);
            String string11 = _l0.I1.I1(string8, (String)stringArray2);
            lIl.O0().setDataBridgeWorkMode(2);
            lIl.O0().O0(arrayList2, arrayList, 0, false, string11, string9);
        }
        int n2 = this.colInfoTableModel.getRowCount();
        stringArray2 = new String[n2];
        stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray2[i2] = (String)this.colInfoTableModel.getValueAt(i2, 0);
            stringArray[i2] = (String)this.colInfoTableModel.getValueAt(i2, 1);
        }
        String string12 = (String)this.jComboBox_tablespace.getSelectedItem();
        if (string12.equals("")) {
            string12 = null;
        }
        lIl.O0().O0(string2, string12, stringArray2, stringArray);
        object = (lI)O0.lO0.get(string);
        lIl.O0().l1(((lI)object).getUserName(), ((lI)object).getPassword(), ((lI)object)._1());
        if (this.isLobSegmentUnloadNonBts) {
            lIl.O0().setDataBridgeWorkMode(7);
            lIl.O0().I(Long.parseLong(this.tableNameInColumnTemplate.substring(3)));
        }
        int n3 = lIl.O0().B8();
        lIl.O0().OO(this.jCheckBox_unload_deleted_data_only.isSelected());
        this.startDataBridge(n3);
        this.setVisible(false);
        this.dispose();
    }

    private void startDataBridge(int n2) {
        GeneralWaittingDialog generalWaittingDialog = new GeneralWaittingDialog(this);
        generalWaittingDialog.setDataBridgeWorkMode(n2);
        generalWaittingDialog.startWorkForDataBridge();
        generalWaittingDialog.setVisible(true);
    }

    private boolean dataBridgeForSchema() throws Exception {
        int n2;
        String string;
        int n3 = this.jTable_column_info.getRowCount();
        if (n3 == 0) {
            String string2 = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_no_tables_for_schema");
            JOptionPane.showMessageDialog(this, string2, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
            return false;
        }
        String string3 = (String)this.jComboBox_db_connection.getSelectedItem();
        if (string3.equals("")) {
            String string4 = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_db_connection_not_choosen");
            JOptionPane.showMessageDialog(this, string4, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!((Boolean)this.jTable_column_info.getValueAt(i2, 1)).booleanValue()) continue;
            arrayList.add((String)this.jTable_column_info.getValueAt(i2, 0));
        }
        if (arrayList.isEmpty()) {
            String string5 = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_at_least_select_one_table");
            JOptionPane.showMessageDialog(this, string5, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
            return false;
        }
        String string6 = null;
        if (this.jCheckBox_if_to_create_table.isSelected() && (string6 = this.jTextField_target_table_name.getText().trim()).equals("")) {
            string6 = null;
        }
        if ((string = (String)this.jComboBox_tablespace.getSelectedItem()).equals("")) {
            string = null;
        }
        int n4 = n2 = this.jSpinner_thread_count != null ? (Integer)this.jSpinner_thread_count.getValue() : 1;
        if (n2 > 1) {
            MultiThreadDataBridgeDialog multiThreadDataBridgeDialog = new MultiThreadDataBridgeDialog(this, this.schemaNameForDataBridge, string3, string6, string, arrayList, n2);
            multiThreadDataBridgeDialog.startDataBridge();
            multiThreadDataBridgeDialog.setVisible(true);
        } else {
            SchemaDataBridgeProgressDialog schemaDataBridgeProgressDialog = new SchemaDataBridgeProgressDialog(this, this.schemaNameForDataBridge, string3, string6, string, arrayList);
            schemaDataBridgeProgressDialog.startDataBridge();
            schemaDataBridgeProgressDialog.setVisible(true);
        }
        return true;
    }

    private y0 getUnloadedTableColumnTemplateUnderBootstrap(String string) {
        String string2 = string;
        String string3 = this.schemaNameForDataBridge;
        lIl.O0().O(null);
        lIl.O0().setDataBridgeWorkMode(0);
        lIl.O0().B8(false);
        lIl.O0().setUnloadTableInfo(string3, string2);
        _l0.I1.\u03bb();
        _l0.I1.l1(string3, string2);
        y0 y02 = _l0.I1.O0();
        _l0.I1.\u03bc();
        return y02;
    }

    private void jButton_create_db_connectionActionPerformed(ActionEvent actionEvent) {
        OracleDBConnectionSetupDialog oracleDBConnectionSetupDialog = new OracleDBConnectionSetupDialog(this);
        ArrayList arrayList = new ArrayList(4);
        oracleDBConnectionSetupDialog.setNewAddedDBConnectionList(arrayList);
        oracleDBConnectionSetupDialog.setVisible(true);
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.jComboBox_db_connection.addItem(arrayList.get(i2));
        }
    }

    private void jCheckBox_if_to_create_tableActionPerformed(ActionEvent actionEvent) {
        if (this.jCheckBox_if_to_create_table.isSelected()) {
            this.jTextField_target_table_name.setEditable(true);
            this.jTextField_target_table_name.setBackground(Color.WHITE);
        } else {
            this.jTextField_target_table_name.setEditable(false);
            this.jTextField_target_table_name.setBackground(Color.GRAY);
        }
    }

    private void jButton_cancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

