/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.bridge;

import com.dbrecover.gui.bridge.S5;
import com.dbrecover.gui.bridge.l;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MultiThreadDataBridgeDialog
extends JDialog
implements l.O0 {
    private static final Color BG_COLOR = new Color(25, 30, 40);
    private static final Color PANEL_BG = new Color(35, 42, 55);
    private static final Color CARD_BG = new Color(45, 54, 70);
    private static final Color PRIMARY_COLOR = new Color(66, 165, 245);
    private static final Color SUCCESS_COLOR = new Color(102, 187, 106);
    private static final Color DANGER_COLOR = new Color(239, 83, 80);
    private static final Color WARNING_COLOR = new Color(255, 167, 38);
    private static final Color SKIP_COLOR = new Color(156, 39, 176);
    private static final Color PAUSE_COLOR = new Color(255, 193, 7);
    private static final Color TEXT_PRIMARY = new Color(236, 239, 244);
    private static final Color TEXT_SECONDARY = new Color(160, 170, 185);
    private static final Color BORDER_COLOR = new Color(60, 70, 90);
    private static final Color PROGRESS_BG = new Color(50, 60, 80);
    private static final Color TABLE_ROW_ODD = new Color(38, 46, 60);
    private static final Color TABLE_ROW_EVEN = new Color(45, 54, 70);
    private static final Color TABLE_SELECTED = new Color(66, 165, 245, 80);
    private l executor;
    private final String schemaName;
    private final int threadCount;
    private final ArrayList<String> tableList;
    private JLabel lblOverallProgress;
    private JLabel lblTotalRows;
    private JLabel lblElapsedTime;
    private JLabel lblGlobalStatus;
    private JProgressBar progressBarOverall;
    private JPanel workersPanel;
    private WorkerPanel[] workerPanels;
    private DefaultTableModel tableStatusModel;
    private JTable statusTable;
    private JButton btnPauseAll;
    private JButton btnStopAll;
    private final DecimalFormat rowFormatter = new DecimalFormat("#,###");
    private final DecimalFormat timeFormatter = new DecimalFormat("#,##0.000");
    private Timer uiUpdateTimer;

    public MultiThreadDataBridgeDialog(JDialog jDialog, String string, String string2, String string3, String string4, ArrayList<String> arrayList, int n2) {
        super(jDialog, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), true);
        this.schemaName = string;
        this.threadCount = n2;
        this.tableList = arrayList;
        this.initComponents();
        try {
            this.executor = new l(string, string2, string3, string4, arrayList, n2);
            this.executor.O0(this);
            this.executor.initialize();
            this.updateWorkerPanelsFromExecutor();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to initialize executor: " + exception.getMessage(), "Error", 0);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultiThreadDataBridgeDialog.this.handleWindowClose();
            }
        });
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(jDialog);
    }

    private void initComponents() {
        this.getContentPane().setBackground(BG_COLOR);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 12));
        jPanel.setBackground(BG_COLOR);
        jPanel.setBorder(new EmptyBorder(15, 20, 15, 20));
        JPanel jPanel2 = this.createHeaderPanel();
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBackground(BG_COLOR);
        JPanel jPanel4 = this.createGlobalStatsCard();
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(10));
        JPanel jPanel5 = this.createWorkersSection();
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createVerticalStrut(10));
        JPanel jPanel6 = this.createTableListPanel();
        jPanel3.add(jPanel6);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel7 = this.createButtonPanel();
        jPanel.add((Component)jPanel7, "South");
        this.getContentPane().add(jPanel);
        this.setPreferredSize(new Dimension(1100, 750));
    }

    private JPanel createHeaderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel("Multi-Thread Schema Data Bridge");
        jLabel.setFont(new Font("Segoe UI", 1, 20));
        jLabel.setForeground(TEXT_PRIMARY);
        JLabel jLabel2 = new JLabel("Schema: " + this.schemaName + " | Threads: " + this.threadCount);
        jLabel2.setFont(new Font("Segoe UI", 0, 12));
        jLabel2.setForeground(TEXT_SECONDARY);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(jLabel2);
        this.lblGlobalStatus = new JLabel("Ready");
        this.lblGlobalStatus.setFont(new Font("Segoe UI", 1, 14));
        this.lblGlobalStatus.setForeground(PRIMARY_COLOR);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.lblGlobalStatus, "East");
        return jPanel;
    }

    private JPanel createGlobalStatsCard() {
        JPanel jPanel = this.createCard();
        jPanel.setLayout(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 5));
        jPanel2.setOpaque(false);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        JLabel jLabel = new JLabel("Overall Progress");
        jLabel.setFont(new Font("Segoe UI", 1, 13));
        jLabel.setForeground(TEXT_PRIMARY);
        this.lblOverallProgress = new JLabel("0 / " + this.tableList.size() + " tables");
        this.lblOverallProgress.setFont(new Font("Consolas", 1, 13));
        this.lblOverallProgress.setForeground(PRIMARY_COLOR);
        jPanel3.add((Component)jLabel, "West");
        jPanel3.add((Component)this.lblOverallProgress, "East");
        this.progressBarOverall = this.createProgressBar(SUCCESS_COLOR);
        this.progressBarOverall.setMaximum(this.tableList.size());
        this.progressBarOverall.setValue(0);
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)this.progressBarOverall, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 20, 0));
        jPanel4.setOpaque(false);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setOpaque(false);
        JLabel jLabel2 = new JLabel("Total Inserted Rows");
        jLabel2.setFont(new Font("Segoe UI", 0, 11));
        jLabel2.setForeground(TEXT_SECONDARY);
        this.lblTotalRows = new JLabel("0");
        this.lblTotalRows.setFont(new Font("Consolas", 1, 20));
        this.lblTotalRows.setForeground(PRIMARY_COLOR);
        jPanel5.add(jLabel2);
        jPanel5.add(Box.createVerticalStrut(2));
        jPanel5.add(this.lblTotalRows);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setOpaque(false);
        JLabel jLabel3 = new JLabel("Elapsed Time (seconds)");
        jLabel3.setFont(new Font("Segoe UI", 0, 11));
        jLabel3.setForeground(TEXT_SECONDARY);
        this.lblElapsedTime = new JLabel("0.000");
        this.lblElapsedTime.setFont(new Font("Consolas", 1, 20));
        this.lblElapsedTime.setForeground(WARNING_COLOR);
        jPanel6.add(jLabel3);
        jPanel6.add(Box.createVerticalStrut(2));
        jPanel6.add(this.lblElapsedTime);
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel6);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    private JPanel createWorkersSection() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("Worker Threads");
        jLabel.setFont(new Font("Segoe UI", 1, 14));
        jLabel.setForeground(TEXT_PRIMARY);
        this.workersPanel = new JPanel(new FlowLayout(0, 10, 10));
        this.workersPanel.setOpaque(false);
        this.workerPanels = new WorkerPanel[this.threadCount];
        for (int i2 = 0; i2 < this.threadCount; ++i2) {
            this.workerPanels[i2] = new WorkerPanel(i2);
            this.workersPanel.add(this.workerPanels[i2]);
        }
        JScrollPane jScrollPane = new JScrollPane(this.workersPanel);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setPreferredSize(new Dimension(0, 140));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createTableListPanel() {
        JPanel jPanel = this.createCard();
        jPanel.setLayout(new BorderLayout(0, 8));
        JLabel jLabel = new JLabel("Table Processing Status");
        jLabel.setFont(new Font("Segoe UI", 1, 14));
        jLabel.setForeground(TEXT_PRIMARY);
        Object[] objectArray = new String[]{"Table Name", "Worker", "Status", "Rows", "Time(s)"};
        this.tableStatusModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        for (String string : this.tableList) {
            this.tableStatusModel.addRow(new Object[]{string, "-", "Pending", "-", "-"});
        }
        this.statusTable = new JTable(this.tableStatusModel);
        this.statusTable.setBackground(PANEL_BG);
        this.statusTable.setForeground(TEXT_PRIMARY);
        this.statusTable.setGridColor(BORDER_COLOR);
        this.statusTable.setSelectionBackground(TABLE_SELECTED);
        this.statusTable.setSelectionForeground(TEXT_PRIMARY);
        this.statusTable.setRowHeight(26);
        this.statusTable.setFont(new Font("Segoe UI", 0, 11));
        this.statusTable.getTableHeader().setBackground(BG_COLOR);
        this.statusTable.getTableHeader().setForeground(TEXT_SECONDARY);
        this.statusTable.getTableHeader().setFont(new Font("Segoe UI", 1, 11));
        this.statusTable.setShowVerticalLines(false);
        this.statusTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.statusTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.statusTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.statusTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.statusTable.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.statusTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
                if (!bl) {
                    component.setBackground(n2 % 2 == 0 ? TABLE_ROW_EVEN : TABLE_ROW_ODD);
                }
                if (n3 == 2) {
                    String string;
                    switch (string = (String)object) {
                        case "Processing": {
                            this.setForeground(WARNING_COLOR);
                            break;
                        }
                        case "Completed": {
                            this.setForeground(SUCCESS_COLOR);
                            break;
                        }
                        case "Skipped": {
                            this.setForeground(SKIP_COLOR);
                            break;
                        }
                        case "Failed": 
                        case "Stopped": {
                            this.setForeground(DANGER_COLOR);
                            break;
                        }
                        default: {
                            this.setForeground(TEXT_SECONDARY);
                            break;
                        }
                    }
                } else if (n3 == 1) {
                    this.setForeground(PRIMARY_COLOR);
                } else {
                    this.setForeground(TEXT_PRIMARY);
                }
                return component;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.statusTable);
        jScrollPane.setPreferredSize(new Dimension(0, 220));
        jScrollPane.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
        jScrollPane.getViewport().setBackground(PANEL_BG);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 10));
        jPanel.setOpaque(false);
        this.btnPauseAll = this.createStyledButton("|| PAUSE ALL", PAUSE_COLOR);
        this.btnPauseAll.addActionListener(this::handlePauseAllClick);
        this.btnStopAll = this.createStyledButton("[] STOP ALL", DANGER_COLOR);
        this.btnStopAll.addActionListener(this::handleStopAllClick);
        jPanel.add(this.btnPauseAll);
        jPanel.add(this.btnStopAll);
        return jPanel;
    }

    private void updateWorkerPanelsFromExecutor() {
        if (this.executor == null) {
            return;
        }
        int n2 = this.executor.a0();
        for (int i2 = 0; i2 < this.workerPanels.length; ++i2) {
            if (i2 < n2) {
                S5 s5 = this.executor.O0(i2);
                if (s5 == null) continue;
                this.workerPanels[i2].updateProgress(0, s5.b0());
                continue;
            }
            this.workerPanels[i2].updateStatus("No Tasks");
            this.workerPanels[i2].setEnabled(false);
        }
        for (S5 s5 : this.executor.l()) {
            int n3 = s5.h0();
            for (String string : s5.lll()) {
                this.updateTableWorker(string, "W" + (n3 + 1));
            }
        }
    }

    private void updateTableWorker(String string, String string2) {
        SwingUtilities.invokeLater(() -> {
            for (int i2 = 0; i2 < this.tableStatusModel.getRowCount(); ++i2) {
                if (!string.equals(this.tableStatusModel.getValueAt(i2, 0))) continue;
                this.tableStatusModel.setValueAt(string2, i2, 1);
                break;
            }
        });
    }

    private void updateTableStatus(String string, String string2, String string3, String string4) {
        SwingUtilities.invokeLater(() -> {
            for (int i2 = 0; i2 < this.tableStatusModel.getRowCount(); ++i2) {
                if (!string.equals(this.tableStatusModel.getValueAt(i2, 0))) continue;
                this.tableStatusModel.setValueAt(string2, i2, 2);
                this.tableStatusModel.setValueAt(string3, i2, 3);
                this.tableStatusModel.setValueAt(string4, i2, 4);
                this.statusTable.scrollRectToVisible(this.statusTable.getCellRect(i2, 0, true));
                break;
            }
        });
    }

    private JPanel createCard() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(CARD_BG);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1, true), new EmptyBorder(12, 16, 12, 16)));
        return jPanel;
    }

    private JProgressBar createProgressBar(final Color color) {
        JProgressBar jProgressBar = new JProgressBar(){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(PROGRESS_BG);
                graphics2D.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 8, 8);
                int n2 = (int)((double)this.getValue() / (double)this.getMaximum() * (double)this.getWidth());
                if (n2 > 0) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, n2, 0.0f, color.brighter());
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRoundRect(0, 0, n2, this.getHeight(), 8, 8);
                }
                graphics2D.dispose();
            }
        };
        jProgressBar.setPreferredSize(new Dimension(0, 12));
        jProgressBar.setBorderPainted(false);
        jProgressBar.setOpaque(false);
        return jProgressBar;
    }

    private JProgressBar createMiniProgressBar(Color color) {
        JProgressBar jProgressBar = this.createProgressBar(color);
        jProgressBar.setPreferredSize(new Dimension(0, 8));
        return jProgressBar;
    }

    private JButton createStyledButton(String string, final Color color) {
        JButton jButton = new JButton(string){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color2 = this.isEnabled() ? (this.getModel().isPressed() ? color.darker() : (this.getModel().isRollover() ? color.brighter() : color)) : new Color(80, 80, 80);
                graphics2D.setColor(color2);
                graphics2D.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
                graphics2D.setColor(this.isEnabled() ? Color.WHITE : new Color(150, 150, 150));
                graphics2D.setFont(this.getFont());
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n2 = (this.getWidth() - fontMetrics.stringWidth(this.getText())) / 2;
                int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                graphics2D.drawString(this.getText(), n2, n3);
                graphics2D.dispose();
            }
        };
        jButton.setFont(new Font("Segoe UI", 1, 13));
        jButton.setPreferredSize(new Dimension(140, 40));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private JButton createMiniButton(String string, final Color color) {
        JButton jButton = new JButton(string){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color2 = this.isEnabled() ? (this.getModel().isPressed() ? color.darker() : (this.getModel().isRollover() ? color.brighter() : color)) : new Color(80, 80, 80);
                graphics2D.setColor(color2);
                graphics2D.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 5, 5);
                graphics2D.setColor(this.isEnabled() ? Color.WHITE : new Color(150, 150, 150));
                graphics2D.setFont(this.getFont());
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n2 = (this.getWidth() - fontMetrics.stringWidth(this.getText())) / 2;
                int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                graphics2D.drawString(this.getText(), n2, n3);
                graphics2D.dispose();
            }
        };
        jButton.setFont(new Font("Segoe UI", 1, 9));
        jButton.setPreferredSize(new Dimension(26, 20));
        jButton.setMinimumSize(new Dimension(26, 20));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void handlePauseAllClick(ActionEvent actionEvent) {
        if (this.executor == null) {
            return;
        }
        if (this.executor.\u03bb()) {
            this.executor.w0_();
            this.btnPauseAll.setText("|| PAUSE ALL");
            this.lblGlobalStatus.setText("Running");
            this.lblGlobalStatus.setForeground(SUCCESS_COLOR);
        } else {
            this.executor.v0_();
            this.btnPauseAll.setText("> RESUME ALL");
            this.lblGlobalStatus.setText("Paused");
            this.lblGlobalStatus.setForeground(PAUSE_COLOR);
        }
    }

    private void handleStopAllClick(ActionEvent actionEvent) {
        if (this.executor == null) {
            return;
        }
        if (this.executor.\u03bd()) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Stop all workers? Completed tables and data already inserted will be preserved.", "Confirm Stop", 0, 2);
        if (n2 == 0) {
            this.executor.x0_();
            this.btnStopAll.setEnabled(false);
            this.btnPauseAll.setEnabled(false);
            this.lblGlobalStatus.setText("Stopping...");
            this.lblGlobalStatus.setForeground(DANGER_COLOR);
        }
    }

    private void handleWindowClose() {
        if (this.executor == null || this.executor.\u03bd()) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Stop all workers and close?", "Confirm Close", 0, 2);
        if (n2 == 0) {
            if (this.executor != null) {
                this.executor.x0_();
            }
            if (this.uiUpdateTimer != null) {
                this.uiUpdateTimer.stop();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void startDataBridge() {
        if (this.executor == null) {
            return;
        }
        this.lblGlobalStatus.setText("Running");
        this.lblGlobalStatus.setForeground(SUCCESS_COLOR);
        this.startUIUpdateTimer();
        this.executor.s0_();
    }

    private void startUIUpdateTimer() {
        this.uiUpdateTimer = new Timer(100, actionEvent -> {
            if (this.executor == null) {
                return;
            }
            long l2 = System.currentTimeMillis() - this.executor.getStartTime();
            if (this.executor.getStartTime() > 0L) {
                this.lblElapsedTime.setText(this.timeFormatter.format((double)l2 / 1000.0));
            }
            this.lblTotalRows.setText(this.rowFormatter.format(this.executor.OO0()));
            int n2 = this.executor.f0();
            this.lblOverallProgress.setText(n2 + " / " + this.tableList.size() + " tables");
            this.progressBarOverall.setValue(n2);
            for (int i2 = 0; i2 < this.executor.a0(); ++i2) {
                S5 s5 = this.executor.O0(i2);
                if (s5 == null || i2 >= this.workerPanels.length) continue;
                this.workerPanels[i2].updateCurrentTable(s5.g0());
                this.workerPanels[i2].updateRows(s5.l1l1());
                this.workerPanels[i2].updateProgress(s5.l0(), s5.b0());
            }
        });
        this.uiUpdateTimer.start();
    }

    @Override
    public void onWorkerTableStarted(int n2, String string) {
        SwingUtilities.invokeLater(() -> {
            if (n2 < this.workerPanels.length) {
                this.workerPanels[n2].updateCurrentTable(string);
            }
            this.updateTableStatus(string, "Processing", "0", "-");
        });
    }

    @Override
    public void onWorkerTableCompleted(int n2, String string, long l2, double d2) {
        SwingUtilities.invokeLater(() -> this.updateTableStatus(string, "Completed", this.rowFormatter.format(l2), this.timeFormatter.format(d2)));
    }

    @Override
    public void onWorkerTableFailed(int n2, String string, String string2) {
        SwingUtilities.invokeLater(() -> this.updateTableStatus(string, "Failed", "-", "-"));
    }

    @Override
    public void onWorkerTableSkipped(int n2, String string, long l2, double d2) {
        SwingUtilities.invokeLater(() -> this.updateTableStatus(string, "Skipped", this.rowFormatter.format(l2), this.timeFormatter.format(d2)));
    }

    @Override
    public void onWorkerStatusChanged(int n2, String string) {
        SwingUtilities.invokeLater(() -> {
            if (n2 < this.workerPanels.length) {
                this.workerPanels[n2].updateStatus(string);
            }
        });
    }

    @Override
    public void onWorkerRowCountUpdated(int n2, long l2) {
    }

    @Override
    public void onAllWorkersCompleted() {
        SwingUtilities.invokeLater(() -> {
            if (this.uiUpdateTimer != null) {
                this.uiUpdateTimer.stop();
            }
            this.lblGlobalStatus.setText(this.executor.\u03bc() ? "Stopped" : "Completed");
            this.lblGlobalStatus.setForeground(this.executor.\u03bc() ? DANGER_COLOR : SUCCESS_COLOR);
            this.btnPauseAll.setEnabled(false);
            this.btnStopAll.setText("CLOSE");
            this.btnStopAll.setEnabled(true);
            this.lblTotalRows.setText(this.rowFormatter.format(this.executor.OO0()));
            int n2 = this.executor.f0();
            this.lblOverallProgress.setText(n2 + " / " + this.tableList.size() + " tables");
            this.progressBarOverall.setValue(n2);
            this.showCompletionDialog();
        });
    }

    @Override
    public void onGlobalStatsUpdated(int n2, int n3, int n4, long l2) {
    }

    private void showCompletionDialog() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><div style='font-family: Segoe UI; padding: 10px;'>");
        if (this.executor.\u03bc()) {
            stringBuilder.append("<h3 style='color: #EF5350;'>Operation stopped by user</h3>");
        } else {
            stringBuilder.append("<h3 style='color: #66BB6A;'>Data Bridge Completed</h3>");
        }
        stringBuilder.append("<table style='margin-top: 10px;'>");
        stringBuilder.append("<tr><td>Completed tables:</td><td style='padding-left: 20px; color: #66BB6A;'><b>").append(this.executor.c0()).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Failed tables:</td><td style='padding-left: 20px; color: #EF5350;'><b>").append(this.executor.d0()).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Skipped tables:</td><td style='padding-left: 20px; color: #9C27B0;'><b>").append(this.executor.e0()).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Total rows inserted:</td><td style='padding-left: 20px; color: #42A5F5;'><b>").append(this.rowFormatter.format(this.executor.OO0())).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Total time:</td><td style='padding-left: 20px; color: #FFA726;'><b>").append(this.timeFormatter.format((double)(System.currentTimeMillis() - this.executor.getStartTime()) / 1000.0)).append(" seconds</b></td></tr>");
        stringBuilder.append("</table>");
        stringBuilder.append("<p style='margin-top: 15px; color: #888;'>Log file: ").append(this.executor.d0()).append("</p>");
        stringBuilder.append("</div></html>");
        JOptionPane.showMessageDialog(this, stringBuilder.toString(), resourceBundle.getString("production_name"), 1);
    }

    private class WorkerPanel
    extends JPanel {
        private final int workerId;
        private JLabel lblStatus;
        private JLabel lblCurrentTable;
        private JLabel lblProgress;
        private JLabel lblRows;
        private JProgressBar progressBar;
        private JButton btnPause;
        private JButton btnSkip;

        public WorkerPanel(int n2) {
            this.workerId = n2;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout(8, 8));
            this.setBackground(CARD_BG);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1, true), new EmptyBorder(12, 14, 12, 14)));
            JPanel jPanel = new JPanel(new BorderLayout(8, 0));
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel("Worker " + (this.workerId + 1));
            jLabel.setFont(new Font("Microsoft YaHei", 1, 13));
            jLabel.setForeground(PRIMARY_COLOR);
            this.lblStatus = new JLabel("Idle");
            this.lblStatus.setFont(new Font("Microsoft YaHei", 1, 12));
            this.lblStatus.setForeground(TEXT_SECONDARY);
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 0));
            jPanel2.setOpaque(false);
            this.btnPause = MultiThreadDataBridgeDialog.this.createMiniButton("||", PAUSE_COLOR);
            this.btnPause.setToolTipText("Pause/Resume this worker");
            this.btnPause.addActionListener(actionEvent -> this.togglePause());
            this.btnSkip = MultiThreadDataBridgeDialog.this.createMiniButton(">>", SKIP_COLOR);
            this.btnSkip.setToolTipText("Skip current table");
            this.btnSkip.addActionListener(actionEvent -> this.skipCurrent());
            jPanel2.add(this.btnPause);
            jPanel2.add(this.btnSkip);
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel3.setOpaque(false);
            jPanel3.add(jLabel);
            jPanel3.add(Box.createHorizontalStrut(10));
            jPanel3.add(this.lblStatus);
            jPanel.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel2, "East");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel4.setOpaque(false);
            this.lblCurrentTable = new JLabel("-");
            this.lblCurrentTable.setFont(new Font("Consolas", 1, 12));
            this.lblCurrentTable.setForeground(WARNING_COLOR);
            this.lblCurrentTable.setAlignmentX(0.0f);
            this.lblRows = new JLabel("0 rows");
            this.lblRows.setFont(new Font("Consolas", 0, 11));
            this.lblRows.setForeground(TEXT_SECONDARY);
            this.lblRows.setAlignmentX(0.0f);
            jPanel4.add(this.lblCurrentTable);
            jPanel4.add(Box.createVerticalStrut(4));
            jPanel4.add(this.lblRows);
            JPanel jPanel5 = new JPanel(new BorderLayout(8, 0));
            jPanel5.setOpaque(false);
            this.lblProgress = new JLabel("0 / 0");
            this.lblProgress.setFont(new Font("Consolas", 1, 11));
            this.lblProgress.setForeground(SUCCESS_COLOR);
            this.progressBar = MultiThreadDataBridgeDialog.this.createMiniProgressBar(SUCCESS_COLOR);
            jPanel5.add((Component)this.progressBar, "Center");
            jPanel5.add((Component)this.lblProgress, "East");
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel4, "Center");
            this.add((Component)jPanel5, "South");
            this.setPreferredSize(new Dimension(260, 115));
            this.setMinimumSize(new Dimension(240, 110));
        }

        private void togglePause() {
            if (MultiThreadDataBridgeDialog.this.executor == null) {
                return;
            }
            S5 s5 = MultiThreadDataBridgeDialog.this.executor.O0(this.workerId);
            if (s5 == null) {
                return;
            }
            if (s5.\u03be()) {
                MultiThreadDataBridgeDialog.this.executor.\u03b4(this.workerId);
                this.btnPause.setText("||");
            } else {
                MultiThreadDataBridgeDialog.this.executor.\u03b3(this.workerId);
                this.btnPause.setText(">");
            }
        }

        private void skipCurrent() {
            if (MultiThreadDataBridgeDialog.this.executor == null) {
                return;
            }
            MultiThreadDataBridgeDialog.this.executor.\u03b5(this.workerId);
        }

        public void updateStatus(String string) {
            this.lblStatus.setText(string);
            switch (string) {
                case "Running": {
                    this.lblStatus.setForeground(SUCCESS_COLOR);
                    break;
                }
                case "Paused": {
                    this.lblStatus.setForeground(PAUSE_COLOR);
                    this.btnPause.setText(">");
                    break;
                }
                case "Completed": {
                    this.lblStatus.setForeground(PRIMARY_COLOR);
                    this.btnPause.setEnabled(false);
                    this.btnSkip.setEnabled(false);
                    break;
                }
                case "Stopped": {
                    this.lblStatus.setForeground(DANGER_COLOR);
                    this.btnPause.setEnabled(false);
                    this.btnSkip.setEnabled(false);
                    break;
                }
                default: {
                    this.lblStatus.setForeground(TEXT_SECONDARY);
                }
            }
        }

        public void updateCurrentTable(String string) {
            this.lblCurrentTable.setText(string.isEmpty() ? "-" : string);
        }

        public void updateRows(long l2) {
            this.lblRows.setText(MultiThreadDataBridgeDialog.this.rowFormatter.format(l2) + " rows");
        }

        public void updateProgress(int n2, int n3) {
            this.lblProgress.setText(n2 + "/" + n3);
            if (n3 > 0) {
                this.progressBar.setMaximum(n3);
                this.progressBar.setValue(n2);
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.btnPause.setEnabled(bl);
            this.btnSkip.setEnabled(bl);
        }
    }
}

