/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.bridge;

import com.dbrecover.gui.bridge.DataBridgeSetupDialog;
import com.dbrecover.gui.bridge.Il;
import com.dbrecover.gui.bridge.O0;
import com.dbrecover.gui.bridge.lI;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import o._f0;
import o._l0;
import o.y0;

public class OracleDBConnectionSetupDialog
extends JDialog {
    private final ButtonGroup buttonGroup1;
    private Il dbConnectionTableModel = null;
    private List newAddedDBConnectionList = null;
    private y0 colTemplateForDataBridge = null;
    private boolean doesTheColInfoCanBeEdited = false;
    private boolean isLobSegmentUnloadNonBtsMode = false;
    private boolean isCalledFromSchemaDataBridge = false;
    private JButton jButton_cancel;
    private JButton jButton_save;
    private JButton jButton_test;
    private JLabel jLabel_connection_name;
    private JLabel jLabel_host;
    private JLabel jLabel_password;
    private JLabel jLabel_port;
    private JLabel jLabel_user;
    private JPasswordField jPasswordField_password;
    private JRadioButton jRadioButton_service_name;
    private JRadioButton jRadioButton_sid;
    private JScrollPane jScrollPane1;
    private JTable jTable_connection_info;
    private JTextField jTextField_connection_name;
    private JTextField jTextField_host_name;
    private JTextField jTextField_port;
    private JTextField jTextField_service_name;
    private JTextField jTextField_sid;
    private JTextField jTextField_user_name;

    public OracleDBConnectionSetupDialog(Frame frame) {
        super(frame, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_new_db_connection"), true);
        this.initComponents();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup1.add(this.jRadioButton_sid);
        this.buttonGroup1.add(this.jRadioButton_service_name);
        this.jRadioButton_sid.setSelected(true);
        this.jTextField_service_name.setEditable(false);
        this.jTextField_service_name.setBackground(Color.GRAY);
        this.customizeMyJTable();
        this.loadDataFromDBConfig();
        this.jTable_connection_info.setSelectionMode(0);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public OracleDBConnectionSetupDialog(Dialog dialog) {
        super(dialog, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_new_db_connection"), true);
        this.initComponents();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup1.add(this.jRadioButton_sid);
        this.buttonGroup1.add(this.jRadioButton_service_name);
        this.jRadioButton_sid.setSelected(true);
        this.jTextField_service_name.setEditable(false);
        this.jTextField_service_name.setBackground(Color.GRAY);
        this.customizeMyJTable();
        this.loadDataFromDBConfig();
        this.jTable_connection_info.setSelectionMode(0);
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private void customizeMyJTable() {
        this.dbConnectionTableModel = new Il();
        this.jTable_connection_info.setModel(this.dbConnectionTableModel);
        this.jTable_connection_info.getTableHeader().setReorderingAllowed(false);
    }

    public void setColumnTemplate(y0 y02) {
        this.colTemplateForDataBridge = y02;
    }

    public void setIfTheColumnInfoCanBeEdited(boolean bl) {
        this.doesTheColInfoCanBeEdited = bl;
    }

    public void setLobSegmentUnloadNonBtsMode() {
        this.isLobSegmentUnloadNonBtsMode = true;
    }

    public void setCalledFromSchemaDataBridge() {
        this.isCalledFromSchemaDataBridge = true;
    }

    private void loadDataFromDBConfig() {
        Collection collection = O0.lO0.values();
        Iterator iterator = collection.iterator();
        lI lI2 = null;
        while (iterator.hasNext()) {
            lI2 = (lI)iterator.next();
            Object[] objectArray = new Object[]{lI2.l1l1(), lI2.c0()};
            this.dbConnectionTableModel.addRow(objectArray);
        }
        this.jTable_connection_info.setAutoResizeMode(0);
        this.fitTableColumns(this.jTable_connection_info);
    }

    private void fitTableColumns(JTable jTable) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        int n2 = jTable.getRowCount();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n3 = jTableHeader.getColumnModel().getColumnIndex(tableColumn.getIdentifier());
            int n4 = (int)jTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(jTable, tableColumn.getIdentifier(), false, false, -1, n3).getPreferredSize().getWidth();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = (int)jTable.getCellRenderer(i2, n3).getTableCellRendererComponent(jTable, jTable.getValueAt(i2, n3), false, false, i2, n3).getPreferredSize().getWidth();
                n4 = Math.max(n4, n5);
            }
            jTableHeader.setResizingColumn(tableColumn);
            tableColumn.setWidth(n4 + jTable.getIntercellSpacing().width);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable_connection_info = new JTable();
        this.jButton_save = new JButton();
        this.jButton_test = new JButton();
        this.jButton_cancel = new JButton();
        this.jLabel_connection_name = new JLabel();
        this.jLabel_user = new JLabel();
        this.jLabel_password = new JLabel();
        this.jLabel_host = new JLabel();
        this.jLabel_port = new JLabel();
        this.jTextField_connection_name = new JTextField();
        this.jTextField_user_name = new JTextField();
        this.jTextField_host_name = new JTextField();
        this.jTextField_port = new JTextField();
        this.jPasswordField_password = new JPasswordField();
        this.jRadioButton_sid = new JRadioButton();
        this.jRadioButton_service_name = new JRadioButton();
        this.jTextField_sid = new JTextField();
        this.jTextField_service_name = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jTable_connection_info.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTable_connection_info.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                OracleDBConnectionSetupDialog.this.jTable_connection_infoMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable_connection_info);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        this.jButton_save.setText(resourceBundle.getString("data_bridge_save"));
        this.jButton_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleDBConnectionSetupDialog.this.jButton_saveActionPerformed(actionEvent);
            }
        });
        this.jButton_test.setText(resourceBundle.getString("data_bridge_test"));
        this.jButton_test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleDBConnectionSetupDialog.this.jButton_testActionPerformed(actionEvent);
            }
        });
        this.jButton_cancel.setText(resourceBundle.getString("navigator_panel1_world_cancel"));
        this.jButton_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleDBConnectionSetupDialog.this.jButton_cancelActionPerformed(actionEvent);
            }
        });
        this.jLabel_connection_name.setText(resourceBundle.getString("data_bridge_db_connection_name"));
        this.jLabel_user.setText(resourceBundle.getString("data_bridge_db_user"));
        this.jLabel_password.setText(resourceBundle.getString("data_bridge_db_password"));
        this.jLabel_host.setText(resourceBundle.getString("data_bridge_db_host"));
        this.jLabel_port.setText(resourceBundle.getString("data_bridge_db_port"));
        this.jRadioButton_sid.setText("SID");
        this.jRadioButton_sid.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton_sid.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton_sid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleDBConnectionSetupDialog.this.jRadioButton_sidActionPerformed(actionEvent);
            }
        });
        this.jRadioButton_service_name.setText(resourceBundle.getString("data_bridge_service_name"));
        this.jRadioButton_service_name.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton_service_name.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton_service_name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OracleDBConnectionSetupDialog.this.jRadioButton_service_nameActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 171, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_connection_name, -2, 128, -2).addComponent(this.jLabel_user).addComponent(this.jLabel_password).addComponent(this.jLabel_host).addComponent(this.jLabel_port).addComponent(this.jRadioButton_sid).addComponent(this.jRadioButton_service_name)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jButton_test, -2, 97, -2).addGap(52, 52, 52).addComponent(this.jButton_cancel, -2, 97, -2)).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_user_name, -1, 337, Short.MAX_VALUE).addComponent(this.jPasswordField_password, -2, 337, -2).addComponent(this.jTextField_host_name, -2, 146, -2).addComponent(this.jTextField_port, -2, 348, -2).addComponent(this.jTextField_sid, -2, 146, -2).addComponent(this.jTextField_service_name, -2, -1, -2).addComponent(this.jTextField_connection_name, -1, 420, Short.MAX_VALUE))))).addGroup(groupLayout.createSequentialGroup().addGap(193, 193, 193).addComponent(this.jButton_save, -2, 97, -2))).addContainerGap()));
        groupLayout.linkSize(0, this.jPasswordField_password, this.jTextField_connection_name, this.jTextField_host_name, this.jTextField_port, this.jTextField_service_name, this.jTextField_sid, this.jTextField_user_name);
        groupLayout.linkSize(0, this.jButton_cancel, this.jButton_save, this.jButton_test);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 333, -2).addGroup(groupLayout.createSequentialGroup().addGap(162, 162, 162).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel_host, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jTextField_host_name))).addGap(27, 27, 27).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel_port, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jTextField_port))).addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jRadioButton_sid, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jTextField_sid))).addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jRadioButton_service_name, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jTextField_service_name))).addGap(11, 11, 11)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_connection_name, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField_connection_name, -2, 0, Short.MAX_VALUE)).addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField_user_name, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel_user, -1, -1, Short.MAX_VALUE)).addGap(16, 16, 16).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordField_password).addComponent(this.jLabel_password, -1, -1, Short.MAX_VALUE)).addGap(235, 235, 235))).addGap(0, 0, 0).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_save, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_test).addComponent(this.jButton_cancel))).addContainerGap()));
        groupLayout.linkSize(1, this.jButton_cancel, this.jButton_save, this.jButton_test);
    }

    private void jTable_connection_infoMouseClicked(MouseEvent mouseEvent) {
        int n2 = this.jTable_connection_info.getSelectedRow();
        String string = (String)this.jTable_connection_info.getValueAt(n2, 0);
        Object v2 = O0.lO0.get(string);
        if (v2 != null) {
            lI lI2 = (lI)v2;
            this.jTextField_connection_name.setText(string);
            this.jTextField_user_name.setText(lI2.getUserName());
            this.jPasswordField_password.setText(lI2.getPassword());
            this.jTextField_host_name.setText(lI2.I1I1());
            this.jTextField_port.setText(lI2.a0());
            boolean bl = true;
            String string2 = lI2.b0();
            if (string2 == null) {
                bl = false;
                string2 = lI2.getServiceName();
            }
            if (bl) {
                this.jRadioButton_sid.setSelected(true);
                this.jRadioButton_service_name.setSelected(false);
                this.jTextField_sid.setText(string2);
                this.jTextField_service_name.setText("");
                this.jTextField_sid.setBackground(Color.WHITE);
                this.jTextField_service_name.setBackground(Color.GRAY);
                this.jTextField_service_name.setEditable(false);
                this.jTextField_sid.setEditable(true);
            } else {
                this.jRadioButton_sid.setSelected(false);
                this.jRadioButton_service_name.setSelected(true);
                this.jTextField_sid.setText("");
                this.jTextField_service_name.setText(string2);
                this.jTextField_sid.setBackground(Color.GRAY);
                this.jTextField_service_name.setBackground(Color.WHITE);
                this.jTextField_service_name.setEditable(true);
                this.jTextField_sid.setEditable(false);
            }
        }
    }

    private void jRadioButton_service_nameActionPerformed(ActionEvent actionEvent) {
        this.jTextField_service_name.setEditable(true);
        this.jTextField_sid.setEditable(false);
        this.jTextField_sid.setBackground(Color.GRAY);
        this.jTextField_service_name.setBackground(Color.WHITE);
    }

    private void jRadioButton_sidActionPerformed(ActionEvent actionEvent) {
        this.jTextField_sid.setEditable(true);
        this.jTextField_service_name.setEditable(false);
        this.jTextField_sid.setBackground(Color.WHITE);
        this.jTextField_service_name.setBackground(Color.GRAY);
    }

    private void jButton_cancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButton_testActionPerformed(ActionEvent actionEvent) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(128);
        if (this.jRadioButton_sid.isSelected()) {
            stringBuilder.append("jdbc:oracle:thin:@");
            stringBuilder.append(this.jTextField_host_name.getText().trim());
            stringBuilder.append(':');
            stringBuilder.append(this.jTextField_port.getText().trim());
            stringBuilder.append(':');
            stringBuilder.append(this.jTextField_sid.getText().trim());
        } else {
            stringBuilder.append("jdbc:oracle:thin:@//");
            stringBuilder.append(this.jTextField_host_name.getText().trim());
            stringBuilder.append(':');
            stringBuilder.append(this.jTextField_port.getText().trim());
            stringBuilder.append('/');
            stringBuilder.append(this.jTextField_service_name.getText().trim());
        }
        StringBuilder stringBuilder2 = new StringBuilder(16);
        char[] cArray = this.jPasswordField_password.getPassword();
        String string2 = new String(cArray);
        if (_f0.O0(stringBuilder.toString(), this.jTextField_user_name.getText().trim(), string2, stringBuilder2)) {
            string = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_connect_oracle_success");
            JOptionPane.showMessageDialog(this, string, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 1);
        } else {
            string = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_connect_oracle_failed");
            string = string + '\n';
            string = string + stringBuilder2.toString();
            JOptionPane.showMessageDialog(this, string, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
        }
        string2 = null;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = '\u0000';
        }
    }

    public void setNewAddedDBConnectionList(List list) {
        this.newAddedDBConnectionList = list;
    }

    private void jButton_saveActionPerformed(ActionEvent actionEvent) {
        try {
            boolean bl;
            String string;
            String string2 = this.jTextField_connection_name.getText().trim();
            if (string2.equals("")) {
                throw new NullPointerException();
            }
            String string3 = this.jTextField_user_name.getText().trim();
            if (string3.equals("")) {
                throw new NullPointerException();
            }
            String string4 = this.jTextField_host_name.getText().trim();
            if (string4.equals("")) {
                throw new NullPointerException();
            }
            String string5 = this.jTextField_port.getText().trim();
            if (string5.equals("")) {
                throw new NullPointerException();
            }
            if (this.jRadioButton_sid.isSelected()) {
                string = this.jTextField_sid.getText().trim();
                if (string.equals("")) {
                    throw new NullPointerException();
                }
                bl = true;
            } else {
                string = this.jTextField_service_name.getText().trim();
                if (string.equals("")) {
                    throw new NullPointerException();
                }
                bl = false;
            }
            char[] cArray = this.jPasswordField_password.getPassword();
            if (O0.lO0.containsKey(string2)) {
                String string6 = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_connection_name_duplicate");
                JOptionPane.showMessageDialog(this, string6, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
                return;
            }
            File file = new File("./config/dbconfig");
            boolean bl2 = !file.exists() || !file.isFile();
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("./config/dbconfig", true), 4096);
            lI lI2 = new lI(string2, string3, new String(cArray), string4, string5, string, bl);
            O0.lO0.put(string2, lI2);
            if (this.newAddedDBConnectionList != null) {
                this.newAddedDBConnectionList.add(string2);
            }
            bufferedWriter.write(lI2.toString());
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                cArray[i2] = '\u0000';
            }
            if (bl2 && !this.isCalledFromSchemaDataBridge) {
                try {
                    DataBridgeSetupDialog dataBridgeSetupDialog = null;
                    dataBridgeSetupDialog = this.isLobSegmentUnloadNonBtsMode ? new DataBridgeSetupDialog((Frame)_l0.O0, this.colTemplateForDataBridge, this.doesTheColInfoCanBeEdited, true) : new DataBridgeSetupDialog((Frame)_l0.O0, this.colTemplateForDataBridge, this.doesTheColInfoCanBeEdited);
                    this.setVisible(false);
                    dataBridgeSetupDialog.setVisible(true);
                    this.dispose();
                }
                catch (Exception exception) {}
            } else if (this.isCalledFromSchemaDataBridge) {
                Object[] objectArray = new Object[]{lI2.l1l1(), lI2.c0()};
                this.dbConnectionTableModel.addRow(objectArray);
                this.setVisible(false);
                this.dispose();
            } else {
                Object[] objectArray = new Object[]{lI2.l1l1(), lI2.c0()};
                this.dbConnectionTableModel.addRow(objectArray);
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (NullPointerException nullPointerException) {
            String string = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_fill_all_dbconnection_info_warning");
            JOptionPane.showMessageDialog(this, string, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
        }
        catch (Exception exception) {
            String string = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("data_bridge_unknown_reason_to_save");
            string = string + "\n";
            string = string + exception.getMessage();
            JOptionPane.showMessageDialog(this, string, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 2);
        }
    }
}

