/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core;

import com.dbrecover.gui.core.NonBootstrapDataViewPanel;
import com.dbrecover.gui.core.UnloadDataViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

public class DBRMainContentPanel
extends JPanel {
    private Component currentComponent = null;
    private JPanel infoPanel;
    private JTextArea infoTextArea;
    private JSplitPane mainSplitPane;
    private JPanel contentPanel;

    public DBRMainContentPanel() {
        this.setLayout(new BorderLayout());
        this.initInfoPanel();
    }

    private void initInfoPanel() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setMinimumSize(new Dimension(400, 300));
        this.contentPanel.setPreferredSize(new Dimension(800, 500));
        this.contentPanel.setBackground(new Color(245, 246, 248));
        JPanel jPanel = this.createWelcomePanel();
        this.contentPanel.add((Component)jPanel, "Center");
        this.currentComponent = jPanel;
        this.infoPanel = new JPanel(new BorderLayout());
        this.infoPanel.setPreferredSize(new Dimension(100, 180));
        this.infoPanel.setMinimumSize(new Dimension(100, 120));
        this.infoPanel.setBackground(new Color(250, 250, 250));
        this.infoTextArea = new JTextArea();
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setBackground(new Color(252, 252, 252));
        this.infoTextArea.setForeground(new Color(50, 50, 50));
        this.infoTextArea.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        this.infoTextArea.setText("Info / \u4fe1\u606f\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\u9009\u62e9\u4e00\u5f20\u8868\u6765\u67e5\u770b\u8be6\u60c5 | Select a table to view details");
        JScrollPane jScrollPane = new JScrollPane(this.infoTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)), "Info / \u4fe1\u606f", 1, 2, new Font("Microsoft YaHei UI", 1, 11), new Color(80, 80, 80)));
        jScrollPane.getViewport().setBackground(new Color(252, 252, 252));
        this.infoPanel.add((Component)jScrollPane, "Center");
        this.mainSplitPane = new JSplitPane(0, this.contentPanel, this.infoPanel);
        this.mainSplitPane.setResizeWeight(0.75);
        this.mainSplitPane.setDividerSize(6);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setContinuousLayout(true);
        this.add((Component)this.mainSplitPane, "Center");
    }

    private JPanel createWelcomePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(250, 251, 252));
        String string = "<html><body style='font-family: Microsoft YaHei UI, Segoe UI, sans-serif; padding: 40px;'><div style='text-align: center;'><h1 style='color: #2c3e50; font-size: 22px; margin: 0;'>DBRecover for Oracle</h1><p style='color: #7f8c8d; font-size: 13px; margin-top: 8px;'>Professional Database Disaster Recovery</p><p style='color: #aaa; font-size: 11px; margin-top: 20px;'>www.dbrecover.com | liu.maclean@gmail.com</p></div></body></html>";
        JLabel jLabel = new JLabel(string);
        jLabel.setVerticalAlignment(0);
        jLabel.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    public void updateInfoPanel(String string) {
        if (this.infoTextArea != null) {
            this.infoTextArea.setText(string);
            this.infoTextArea.setCaretPosition(0);
        }
    }

    public void appendInfoPanel(String string) {
        if (this.infoTextArea != null) {
            this.infoTextArea.append(string);
        }
    }

    public void setInfoPanelStyle(boolean bl) {
        if (this.infoTextArea != null) {
            if (bl) {
                this.infoTextArea.setForeground(new Color(200, 50, 50));
                this.infoTextArea.setBackground(new Color(255, 245, 245));
            } else {
                this.infoTextArea.setForeground(new Color(50, 50, 50));
                this.infoTextArea.setBackground(new Color(252, 252, 252));
            }
        }
    }

    public void clearInfoPanel() {
        if (this.infoTextArea != null) {
            this.infoTextArea.setText("");
            this.setInfoPanelStyle(false);
        }
    }

    void showUnloadDataViewer(String string, String[] stringArray, String string2, String string3) {
        UnloadDataViewPanel unloadDataViewPanel = new UnloadDataViewPanel(string, stringArray, string2, string3);
        if (this.currentComponent != null) {
            this.currentComponent.setVisible(false);
            this.contentPanel.remove(this.currentComponent);
            this.currentComponent = null;
        }
        this.currentComponent = unloadDataViewPanel;
        this.contentPanel.add((Component)unloadDataViewPanel, "Center");
        this.contentPanel.validate();
        this.contentPanel.repaint();
        this.currentComponent.validate();
        this.currentComponent.repaint();
        this.currentComponent.setVisible(true);
    }

    void showAnalysisDataAfterScanTables(long l2, int n2) {
        NonBootstrapDataViewPanel nonBootstrapDataViewPanel = new NonBootstrapDataViewPanel(l2, n2);
        nonBootstrapDataViewPanel.fetchAnalysisData();
        if (this.currentComponent != null) {
            this.currentComponent.setVisible(false);
            this.contentPanel.remove(this.currentComponent);
            this.currentComponent = null;
        }
        this.currentComponent = nonBootstrapDataViewPanel;
        this.contentPanel.add((Component)nonBootstrapDataViewPanel, "Center");
        this.contentPanel.validate();
        this.contentPanel.repaint();
        this.currentComponent.validate();
        this.currentComponent.repaint();
        this.currentComponent.setVisible(true);
    }

    public void showMissingDataFileError(String string, String string2, String string3, long l2, long l3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TABLE / \u8868\u540d: ").append(string).append(".").append(string2);
        stringBuilder.append("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
        if (string3 != null && !string3.isEmpty()) {
            String[] stringArray;
            stringBuilder.append("Statistics / \u7edf\u8ba1\u4fe1\u606f:  ");
            for (String string4 : stringArray = string3.split(" ")) {
                if (string4.contains(":")) {
                    stringBuilder.append(string4).append("  |  ");
                    continue;
                }
                if (string4.matches("\\d{4}-\\d{2}-\\d{2}")) {
                    stringBuilder.append("  Analyze Time: ").append(string4);
                    continue;
                }
                if (!string4.matches("\\d{2}:\\d{2}:\\d{2}")) continue;
                stringBuilder.append(" ").append(string4);
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
        stringBuilder.append("[ERROR / \u9519\u8bef]  Missing Data File / \u7f3a\u5c11\u6570\u636e\u6587\u4ef6  |  ");
        stringBuilder.append("File# / \u6587\u4ef6\u53f7: ").append(l2).append("  |  ");
        stringBuilder.append("TS# / \u8868\u7a7a\u95f4\u53f7: ").append(l3);
        stringBuilder.append("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
        stringBuilder.append("SOLUTION / \u89e3\u51b3\u65b9\u6848:  Please load data file with TS#=").append(l3);
        stringBuilder.append(", File#=").append(l2);
        stringBuilder.append("  |  \u8bf7\u52a0\u8f7d\u6570\u636e\u6587\u4ef6\uff1a\u8868\u7a7a\u95f4\u53f7=").append(l3);
        stringBuilder.append(", \u6587\u4ef6\u53f7=").append(l2);
        this.setInfoPanelStyle(true);
        this.updateInfoPanel(stringBuilder.toString());
    }

    public void showDefaultInfo() {
        this.setInfoPanelStyle(false);
        this.updateInfoPanel("Info / \u4fe1\u606f\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\u9009\u62e9\u4e00\u5f20\u8868\u6765\u67e5\u770b\u8be6\u60c5 | Select a table to view details");
    }

    public void showNoDataAvailable(String string, String string2, String[] stringArray) {
        if (this.currentComponent != null) {
            this.currentComponent.setVisible(false);
            this.contentPanel.remove(this.currentComponent);
            this.currentComponent = null;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(252, 252, 252));
        JLabel jLabel = new JLabel("TABLE: " + string + "." + string2 + "  (Data file not loaded / \u6570\u636e\u6587\u4ef6\u672a\u52a0\u8f7d)");
        jLabel.setFont(new Font("Microsoft YaHei UI", 1, 16));
        jLabel.setForeground(new Color(180, 50, 50));
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)jLabel, "North");
        if (stringArray != null && stringArray.length > 0) {
            DefaultTableModel defaultTableModel = new DefaultTableModel(stringArray, 0){

                @Override
                public boolean isCellEditable(int n2, int n3) {
                    return false;
                }
            };
            JTable jTable = new JTable(defaultTableModel);
            jTable.setAutoResizeMode(0);
            jTable.getTableHeader().setReorderingAllowed(false);
            jTable.setRowHeight(24);
            jTable.getTableHeader().setFont(new Font("Microsoft YaHei UI", 1, 12));
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                jTable.getColumnModel().getColumn(i2).setPreferredWidth(Math.max(100, stringArray[i2].length() * 10));
            }
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            jPanel.add((Component)jScrollPane, "Center");
            JLabel jLabel2 = new JLabel("<html><div style='padding:10px;color:#666;'>No data available. Please check the Info panel on the right.<br/>\u65e0\u6570\u636e\u53ef\u663e\u793a\uff0c\u8bf7\u67e5\u770b\u53f3\u4fa7\u4fe1\u606f\u9762\u677f\u4e86\u89e3\u8be6\u60c5\u3002</div></html>");
            jLabel2.setFont(new Font("Microsoft YaHei UI", 0, 12));
            jPanel.add((Component)jLabel2, "South");
        } else {
            JLabel jLabel3 = new JLabel("<html><div style='text-align:center;padding:50px;'><p style='color:#cc0000;font-size:14px;'>Data file not loaded / \u6570\u636e\u6587\u4ef6\u672a\u52a0\u8f7d</p><br/><p style='color:#666;font-size:12px;'>Please check the Info panel on the right for details.<br/>\u8bf7\u67e5\u770b\u53f3\u4fa7\u4fe1\u606f\u9762\u677f\u4e86\u89e3\u8be6\u60c5\u3002</p></div></html>", 0);
            jLabel3.setFont(new Font("Microsoft YaHei UI", 0, 14));
            jPanel.add((Component)jLabel3, "Center");
        }
        this.currentComponent = jPanel;
        this.contentPanel.add((Component)jPanel, "Center");
        this.contentPanel.validate();
        this.contentPanel.repaint();
    }

    public void showTableStatistics(String string, String string2, String string3, int n2) {
        this.showTableStatistics(string, string2, string3, n2, null);
    }

    public void showTableStatistics(String string, String string2, String string3, int n2, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TABLE / \u8868\u540d: ").append(string).append(".").append(string2);
        stringBuilder.append("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
        stringBuilder.append("Statistics / \u7edf\u8ba1\u4fe1\u606f:  ");
        if (string3 != null && !string3.isEmpty()) {
            String[] stringArray = string3.split(" ");
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            for (String string5 : stringArray) {
                if (string5.contains(":")) {
                    stringBuilder2.append(string5).append("  |  ");
                    continue;
                }
                if (string5.matches("\\d{4}-\\d{2}-\\d{2}")) {
                    stringBuilder3.append("Analyze Time / \u5206\u6790\u65f6\u95f4: ").append(string5);
                    continue;
                }
                if (!string5.matches("\\d{2}:\\d{2}:\\d{2}")) continue;
                stringBuilder3.append(" ").append(string5);
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("\n").append((CharSequence)stringBuilder3);
        } else {
            stringBuilder.append("(No statistics available / \u65e0\u7edf\u8ba1\u4fe1\u606f)");
        }
        stringBuilder.append("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
        stringBuilder.append("Display / \u663e\u793a\u8bbe\u7f6e:  Max rows / \u6700\u5927\u884c\u6570: ").append(n2);
        if (string4 != null && !string4.isEmpty()) {
            stringBuilder.append("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
            stringBuilder.append("DDL / \u5efa\u8868\u8bed\u53e5:\n");
            stringBuilder.append("CREATE TABLE ").append(string).append(".").append(string4);
        }
        this.setInfoPanelStyle(false);
        this.updateInfoPanel(stringBuilder.toString());
    }

    private void initComponents() {
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 949, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 483, Short.MAX_VALUE));
    }
}

