/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import o._a_;
import o._l0;
import o.lIl;

public class DataFiles_viewer
extends JPanel {
    private JTable fileTable;
    private DefaultTableModel tableModel;
    private JTextArea detailArea;
    private JSplitPane splitPane;

    public DataFiles_viewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(45, 45, 48));
        Object[] objectArray = new String[]{"#", "File Path", "TS#", "File#"};
        this.tableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.fileTable = new JTable(this.tableModel);
        this.fileTable.setBackground(new Color(37, 37, 38));
        this.fileTable.setForeground(new Color(212, 212, 212));
        this.fileTable.setSelectionBackground(new Color(0, 122, 204));
        this.fileTable.setSelectionForeground(Color.WHITE);
        this.fileTable.setGridColor(new Color(60, 60, 60));
        this.fileTable.setRowHeight(24);
        this.fileTable.getTableHeader().setBackground(new Color(45, 45, 48));
        this.fileTable.getTableHeader().setForeground(new Color(200, 200, 200));
        this.fileTable.setFont(new Font("Dialog", 0, 12));
        this.fileTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.fileTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.fileTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.fileTable.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.fileTable.getColumnModel().getColumn(2).setMaxWidth(60);
        this.fileTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.fileTable.getColumnModel().getColumn(3).setMaxWidth(60);
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    DataFiles_viewer.this.showFileDetails();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.fileTable);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getViewport().setBackground(new Color(37, 37, 38));
        this.detailArea = new JTextArea();
        this.detailArea.setEditable(false);
        this.detailArea.setBackground(new Color(30, 30, 30));
        this.detailArea.setForeground(new Color(78, 201, 176));
        this.detailArea.setFont(new Font("Consolas", 0, 12));
        this.detailArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.detailArea.setText("Select a data file to view details...");
        JScrollPane jScrollPane2 = new JScrollPane(this.detailArea);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(60, 60, 60)), "File Details", 1, 2, new Font("Dialog", 1, 11), new Color(150, 150, 150)));
        jScrollPane2.getViewport().setBackground(new Color(30, 30, 30));
        this.splitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        this.splitPane.setResizeWeight(0.6);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.splitPane, "Center");
        JButton jButton = new JButton("Refresh");
        jButton.setBackground(new Color(0, 122, 204));
        jButton.setForeground(Color.WHITE);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setFont(new Font("Dialog", 0, 11));
        jButton.addActionListener(actionEvent -> this.refreshFileList());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(new Color(45, 45, 48));
        jPanel.add(jButton);
        JLabel jLabel = new JLabel("  Loaded Data Files");
        jLabel.setForeground(new Color(200, 200, 200));
        jLabel.setFont(new Font("Dialog", 1, 12));
        jPanel.add(jLabel);
        this.add((Component)jPanel, "North");
    }

    public void refreshFileList() {
        this.tableModel.setRowCount(0);
        lIl lIl2 = _l0.I1;
        if (lIl2 == null) {
            this.detailArea.setText("No database loaded.\nPlease load data files first.");
            return;
        }
        ArrayList arrayList = lIl2.lI();
        if (arrayList == null || arrayList.isEmpty()) {
            this.detailArea.setText("No data files loaded.\nPlease load data files first.");
            return;
        }
        int n2 = 1;
        for (Object e2 : arrayList) {
            if (!(e2 instanceof _a_)) continue;
            _a_ _a_2 = (_a_)e2;
            String string = _a_2.\u03b7;
            if (string != null && string.length() > 50) {
                string = "..." + string.substring(string.length() - 47);
            }
            this.tableModel.addRow(new Object[]{n2++, string, _a_2.O, _a_2.IIl});
        }
        this.detailArea.setText("Total " + (n2 - 1) + " data files loaded.\nSelect a file to view details.");
    }

    private void showFileDetails() {
        int n2 = this.fileTable.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        lIl lIl2 = _l0.I1;
        if (lIl2 == null) {
            return;
        }
        ArrayList arrayList = lIl2.lI();
        if (arrayList == null || n2 >= arrayList.size()) {
            return;
        }
        Object e2 = arrayList.get(n2);
        if (!(e2 instanceof _a_)) {
            return;
        }
        _a_ _a_2 = (_a_)e2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n");
        stringBuilder.append("\u2551                    DATA FILE INFORMATION                     \u2551\n");
        stringBuilder.append("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n\n");
        stringBuilder.append("\u250c\u2500\u2500\u2500 File Path \u2500\u2500\u2500\n");
        stringBuilder.append("\u2502  ").append(_a_2.\u03b7).append("\n\n");
        stringBuilder.append("\u250c\u2500\u2500\u2500 Storage Information \u2500\u2500\u2500\n");
        stringBuilder.append("\u2502  Tablespace #     : ").append(_a_2.O).append("\n");
        stringBuilder.append("\u2502  Absolute File #  : ").append(_a_2.cS).append("\n");
        stringBuilder.append("\u2502  Relative File #  : ").append(_a_2.IIl).append("\n\n");
        stringBuilder.append("\u250c\u2500\u2500\u2500 Block Configuration \u2500\u2500\u2500\n");
        stringBuilder.append("\u2502  Block Size       : ").append(String.format("%,d", _a_2.blockSize)).append(" bytes\n");
        stringBuilder.append("\u2502  Header Offset    : ").append(_a_2.cT).append(" bytes\n\n");
        try {
            File file = new File(_a_2.\u03b7);
            if (file.exists()) {
                long l2 = file.length();
                long l3 = l2 / (long)_a_2.blockSize;
                stringBuilder.append("\u250c\u2500\u2500\u2500 File Statistics \u2500\u2500\u2500\n");
                stringBuilder.append("\u2502  File Size        : ").append(this.formatFileSize(l2)).append("\n");
                stringBuilder.append("\u2502  Estimated Blocks : ").append(String.format("%,d", l3)).append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.detailArea.setText(stringBuilder.toString());
        this.detailArea.setCaretPosition(0);
    }

    private String formatFileSize(long l2) {
        if (l2 < 1024L) {
            return l2 + " B";
        }
        if (l2 < 0x100000L) {
            return String.format("%.2f KB", (double)l2 / 1024.0);
        }
        if (l2 < 0x40000000L) {
            return String.format("%.2f MB", (double)l2 / 1048576.0);
        }
        return String.format("%.2f GB", (double)l2 / 1.073741824E9);
    }
}

