/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core;

import com.dbrecover.gui.core.I1;
import com.dbrecover.gui.core.lI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import o._l0;
import o.a_a;

public class UnloadDataProgressDialog
extends JDialog {
    private static final Color BG_COLOR = new Color(30, 36, 48);
    private static final Color PANEL_BG = new Color(42, 50, 66);
    private static final Color PRIMARY_COLOR = new Color(66, 165, 245);
    private static final Color SUCCESS_COLOR = new Color(102, 187, 106);
    private static final Color DANGER_COLOR = new Color(239, 83, 80);
    private static final Color WARNING_COLOR = new Color(255, 167, 38);
    private static final Color TEXT_PRIMARY = new Color(236, 239, 244);
    private static final Color TEXT_SECONDARY = new Color(160, 170, 185);
    private static final Color BORDER_COLOR = new Color(60, 70, 90);
    private static final Color PROGRESS_BG = new Color(50, 60, 80);
    private String schemaName = null;
    private String objName = null;
    private File unloadFile = null;
    private boolean workDone = false;
    private final int workStatus;
    private boolean isPartition = false;
    private String partitionName = null;
    private String nonBtsUnloadStatement = null;
    private lI nonbtsWithExtent = null;
    private boolean pressedCancelButton = false;
    private long tableRowCount = 0L;
    private ArrayList seqidList = null;
    private ArrayList truncatedObjList = null;
    private int tabno = -1;
    private boolean isClusterTable = false;
    private String columnTemplateFilePath = null;
    private boolean isTableCountExamine = false;
    private boolean isPartitionTable4CountExamineOnly = false;
    private JLabel lblTitle;
    private JLabel lblTableName;
    private JLabel lblStatus;
    private JLabel lblFileSize;
    private JLabel lblRowCount;
    private JLabel lblElapsedTime;
    private JProgressBar progressBar;
    private JButton btnCancel;
    private final DecimalFormat sizeFormatter = new DecimalFormat("#,##0.00");
    private final DecimalFormat rowFormatter = new DecimalFormat("#,###");
    private final DecimalFormat timeFormatter = new DecimalFormat("#,##0.000");

    public UnloadDataProgressDialog(Frame frame, int n2) {
        super(frame, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), true);
        this.workStatus = n2;
        this.initModernComponents();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(_l0.O0);
    }

    private void initModernComponents() {
        this.getContentPane().setBackground(BG_COLOR);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(BG_COLOR);
        jPanel.setBorder(new EmptyBorder(35, 45, 35, 45));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setOpaque(false);
        this.lblTitle = new JLabel("Unload Table Data");
        this.lblTitle.setFont(new Font("Segoe UI", 1, 24));
        this.lblTitle.setForeground(TEXT_PRIMARY);
        this.lblTitle.setAlignmentX(0.0f);
        this.lblTableName = new JLabel("");
        this.lblTableName.setFont(new Font("Segoe UI", 0, 13));
        this.lblTableName.setForeground(TEXT_SECONDARY);
        this.lblTableName.setAlignmentX(0.0f);
        jPanel3.add(this.lblTitle);
        jPanel3.add(Box.createVerticalStrut(6));
        jPanel3.add(this.lblTableName);
        this.lblStatus = new JLabel("Processing...");
        this.lblStatus.setFont(new Font("Segoe UI", 1, 14));
        this.lblStatus.setForeground(SUCCESS_COLOR);
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)this.lblStatus, "East");
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(30));
        JPanel jPanel4 = this.createCard();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 110));
        JLabel jLabel = new JLabel("File Size");
        jLabel.setFont(new Font("Segoe UI", 0, 13));
        jLabel.setForeground(TEXT_SECONDARY);
        jLabel.setAlignmentX(0.0f);
        this.lblFileSize = new JLabel("0.00 MB");
        this.lblFileSize.setFont(new Font("Consolas", 1, 42));
        this.lblFileSize.setForeground(PRIMARY_COLOR);
        this.lblFileSize.setAlignmentX(0.0f);
        jPanel4.add(jLabel);
        jPanel4.add(Box.createVerticalStrut(10));
        jPanel4.add(this.lblFileSize);
        jPanel.add(jPanel4);
        jPanel.add(Box.createVerticalStrut(20));
        JPanel jPanel5 = this.createCard();
        jPanel5.setLayout(new GridLayout(1, 2, 40, 0));
        jPanel5.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setOpaque(false);
        JLabel jLabel2 = new JLabel("Row Count");
        jLabel2.setFont(new Font("Segoe UI", 0, 13));
        jLabel2.setForeground(TEXT_SECONDARY);
        jLabel2.setAlignmentX(0.0f);
        this.lblRowCount = new JLabel("0");
        this.lblRowCount.setFont(new Font("Consolas", 1, 32));
        this.lblRowCount.setForeground(SUCCESS_COLOR);
        this.lblRowCount.setAlignmentX(0.0f);
        jPanel6.add(jLabel2);
        jPanel6.add(Box.createVerticalStrut(8));
        jPanel6.add(this.lblRowCount);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.setOpaque(false);
        JLabel jLabel3 = new JLabel("Elapsed Time (seconds)");
        jLabel3.setFont(new Font("Segoe UI", 0, 13));
        jLabel3.setForeground(TEXT_SECONDARY);
        jLabel3.setAlignmentX(0.0f);
        this.lblElapsedTime = new JLabel("0.000");
        this.lblElapsedTime.setFont(new Font("Consolas", 1, 32));
        this.lblElapsedTime.setForeground(WARNING_COLOR);
        this.lblElapsedTime.setAlignmentX(0.0f);
        jPanel7.add(jLabel3);
        jPanel7.add(Box.createVerticalStrut(8));
        jPanel7.add(this.lblElapsedTime);
        jPanel5.add(jPanel6);
        jPanel5.add(jPanel7);
        jPanel.add(jPanel5);
        jPanel.add(Box.createVerticalStrut(30));
        this.progressBar = new JProgressBar(){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(PROGRESS_BG);
                graphics2D.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 12, 12);
                if (this.isIndeterminate()) {
                    long l2 = System.currentTimeMillis();
                    int n2 = 180;
                    int n3 = (int)(l2 / 10L % (long)(this.getWidth() + n2)) - n2;
                    GradientPaint gradientPaint = new GradientPaint(n3, 0.0f, new Color(PRIMARY_COLOR.getRed(), PRIMARY_COLOR.getGreen(), PRIMARY_COLOR.getBlue(), 50), n3 + n2 / 2, 0.0f, PRIMARY_COLOR, true);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRoundRect(Math.max(0, n3), 3, n2, this.getHeight() - 6, 10, 10);
                }
                graphics2D.dispose();
            }
        };
        this.progressBar.setIndeterminate(true);
        this.progressBar.setPreferredSize(new Dimension(500, 18));
        this.progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.progressBar.setBorderPainted(false);
        this.progressBar.setOpaque(false);
        this.progressBar.setAlignmentX(0.5f);
        Timer timer = new Timer(30, actionEvent -> this.progressBar.repaint());
        timer.start();
        jPanel.add(this.progressBar);
        jPanel.add(Box.createVerticalStrut(35));
        this.btnCancel = this.createStyledButton("CANCEL", DANGER_COLOR);
        this.btnCancel.addActionListener(this::handleCancelClick);
        this.btnCancel.setAlignmentX(0.5f);
        jPanel.add(this.btnCancel);
        this.getContentPane().add(jPanel);
        this.setPreferredSize(new Dimension(580, 560));
    }

    private JPanel createCard() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(PANEL_BG);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1, true), new EmptyBorder(18, 24, 18, 24)));
        return jPanel;
    }

    private JButton createStyledButton(String string, final Color color) {
        JButton jButton = new JButton(string){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color2 = this.isEnabled() ? (this.getModel().isPressed() ? color.darker() : (this.getModel().isRollover() ? color.brighter() : color)) : new Color(80, 80, 80);
                graphics2D.setColor(color2);
                graphics2D.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
                graphics2D.setColor(this.isEnabled() ? Color.WHITE : new Color(150, 150, 150));
                graphics2D.setFont(this.getFont());
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n2 = (this.getWidth() - fontMetrics.stringWidth(this.getText())) / 2;
                int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                graphics2D.drawString(this.getText(), n2, n3);
                graphics2D.dispose();
            }
        };
        jButton.setFont(new Font("Segoe UI", 1, 15));
        jButton.setPreferredSize(new Dimension(180, 48));
        jButton.setMaximumSize(new Dimension(180, 48));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void handleCancelClick(ActionEvent actionEvent) {
        int n2 = JOptionPane.showConfirmDialog(this, "Are you sure you want to cancel the unload operation?", "Confirm Cancel", 0, 2);
        if (n2 == 0) {
            this.pressedCancelButton = true;
            this.btnCancel.setEnabled(false);
            this.btnCancel.setText("Cancelling...");
            this.lblStatus.setText("Cancelling...");
            this.lblStatus.setForeground(WARNING_COLOR);
            _l0.I1.\u03ba();
        }
    }

    void setUnloadTableInfo(String string, String string2) {
        this.schemaName = string;
        this.objName = string2;
        SwingUtilities.invokeLater(() -> {
            if (string != null && string2 != null) {
                this.lblTableName.setText("Table: " + string + "." + string2);
            }
        });
    }

    void setUnloadStatementWithNonBootstrap(String string) {
        this.nonBtsUnloadStatement = string;
    }

    void setInfoForUnloadTruncatedDataUnderBootstrapMode(ArrayList arrayList, ArrayList arrayList2, int n2, boolean bl, String string) {
        this.seqidList = arrayList;
        this.truncatedObjList = arrayList2;
        this.tabno = n2;
        this.isClusterTable = bl;
        this.columnTemplateFilePath = string;
        SwingUtilities.invokeLater(() -> this.lblTitle.setText("Unload Truncated Data"));
    }

    void seToOnlyLoadPartitionData(String string) {
        this.isPartition = true;
        this.partitionName = string;
        SwingUtilities.invokeLater(() -> {
            if (this.schemaName != null && this.objName != null) {
                this.lblTableName.setText("Table: " + this.schemaName + "." + this.objName + " (Partition: " + string + ")");
            }
        });
    }

    void unloadDataUnderNonBootstrapWithExtentsModePreSetup(long l2, long l3, int n2, String string, String string2, boolean bl) {
        this.nonbtsWithExtent = new lI();
        this.nonbtsWithExtent.s0_ = l2;
        this.nonbtsWithExtent.t0_ = l3;
        this.nonbtsWithExtent.tabno = n2;
        this.nonbtsWithExtent.aw = string;
        this.nonbtsWithExtent.ca = string2;
        this.nonbtsWithExtent.isClusterTable = bl;
    }

    void setIsTableCountExamine() {
        this.isTableCountExamine = true;
        SwingUtilities.invokeLater(() -> {
            this.lblTitle.setText("Examine Table Rows");
            this.lblFileSize.setVisible(false);
        });
    }

    void setIsPartitionTable4CountExamineOnly() {
        if (this.isTableCountExamine) {
            this.isPartitionTable4CountExamineOnly = true;
        }
    }

    void startWork(String string, boolean bl) {
        _l0.I1.I1I1();
        this.unloadFile = new File(string);
        boolean[] blArray = new boolean[]{false};
        new Thread(() -> {
            long l2 = System.currentTimeMillis();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
            String string = resourceBundle.getString("unload_data_file_elapsed_time");
            while (!this.workDone) {
                long l3 = System.currentTimeMillis();
                double d2 = (double)(l3 - l2) / 1000.0;
                float f2 = !this.isTableCountExamine ? (this.unloadFile.exists() && this.unloadFile.isFile() && this.unloadFile.canRead() ? (float)this.unloadFile.length() / 1048576.0f : 0.0f) : 0.0f;
                long l4 = !this.isPartitionTable4CountExamineOnly ? _l0.I1.S5() : _l0.I1.B8();
                float f3 = f2;
                long l5 = l4;
                double d3 = d2;
                SwingUtilities.invokeLater(() -> {
                    if (!this.isTableCountExamine) {
                        this.lblFileSize.setText(this.sizeFormatter.format(f3) + " MB");
                    }
                    this.lblRowCount.setText(this.rowFormatter.format(l5));
                    this.lblElapsedTime.setText(this.timeFormatter.format(d3));
                });
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    break;
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(false);
            if (!this.pressedCancelButton) {
                long l6 = System.currentTimeMillis();
                double d4 = (double)(l6 - l2) / 1000.0;
                StringBuilder stringBuilder = new StringBuilder(512);
                stringBuilder.append("<html><h4>");
                if (!this.isTableCountExamine) {
                    stringBuilder.append(resourceBundle.getString("unload_data_file_saved_path"));
                    stringBuilder.append("<br><font color='#42A5F5'>");
                    try {
                        stringBuilder.append(this.unloadFile.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        stringBuilder.append(this.unloadFile.getAbsolutePath());
                    }
                    stringBuilder.append("</font><br><br>");
                    stringBuilder.append(resourceBundle.getString("unload_table_row_count"));
                    stringBuilder.append("&nbsp;<font color='#66BB6A'>");
                } else {
                    stringBuilder.append(resourceBundle.getString("text_examine_done"));
                    stringBuilder.append("<br><br>");
                    stringBuilder.append(resourceBundle.getString("text_examine_rows_total"));
                    stringBuilder.append("&nbsp;&nbsp;<font color='#66BB6A'>");
                }
                stringBuilder.append(this.rowFormatter.format(this.tableRowCount));
                stringBuilder.append("</font>");
                stringBuilder.append("<br><br>");
                stringBuilder.append(string);
                stringBuilder.append("&nbsp;&nbsp;");
                stringBuilder.append(this.timeFormatter.format(d4));
                if (!this.isTableCountExamine) {
                    String string2 = I1.O0(blArray[0]);
                    stringBuilder.append("</h4><br><h3>");
                    stringBuilder.append(string2);
                    stringBuilder.append("</h3></html>");
                } else {
                    stringBuilder.append("</h4></html>");
                }
                JOptionPane.showMessageDialog(_l0.O0, stringBuilder.toString(), resourceBundle.getString("production_name"), 1);
            }
            this.dispose();
        }).start();
        new Thread(() -> {
            if (!bl) {
                _l0.I1.lI(this.unloadFile.getAbsolutePath());
            }
            if (_l0.I1.B8()) {
                blArray[0] = true;
            }
            if (this.workStatus == 0 && this.seqidList == null) {
                int n2;
                if (!this.isTableCountExamine) {
                    _l0.I1.S5(a_a.O0O());
                } else {
                    _l0.I1.S5(a_a.llI());
                }
                if (_l0.I1.B8() && (n2 = a_a.O0O()) > 0) {
                    _l0.I1.S5(a_a.lll());
                }
                if (this.isPartition && this.partitionName != null) {
                    _l0.I1.O(this.partitionName);
                }
                _l0.I1.l1(this.schemaName, this.objName);
                this.tableRowCount = _l0.I1.S5();
            } else if (this.workStatus == 0 && this.seqidList != null) {
                int n3 = this.seqidList.size();
                _l0.I1.S5(a_a.O0O());
                for (int i2 = 0; i2 < n3; ++i2) {
                    _l0.I1.O0((Long)this.seqidList.get(i2), (Long)this.truncatedObjList.get(i2), this.tabno, string, null, this.isClusterTable, null, null, this.columnTemplateFilePath);
                    this.tableRowCount += _l0.I1.S5();
                }
            } else if (this.workStatus == 1 && _l0.bW == 1) {
                if (!this.isTableCountExamine) {
                    _l0.I1.S5(a_a.O0O());
                } else {
                    _l0.I1.S5(a_a.llI());
                }
                _l0.I1.OO(this.nonBtsUnloadStatement);
                this.tableRowCount = _l0.I1.S5();
            } else if (this.workStatus == 1 && _l0.bW == 2 && this.nonbtsWithExtent != null) {
                if (!this.isTableCountExamine) {
                    _l0.I1.S5(a_a.O0O());
                } else {
                    _l0.I1.S5(a_a.llI());
                }
                _l0.I1.O0(this.nonbtsWithExtent.s0_, this.nonbtsWithExtent.t0_, this.nonbtsWithExtent.tabno, this.nonbtsWithExtent.aw, this.nonbtsWithExtent.ca, this.nonbtsWithExtent.isClusterTable, null, null, null);
                this.tableRowCount = _l0.I1.S5();
            }
            this.workDone = true;
        }).start();
    }
}

