/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXid
implements Serializable,
Xid {
    private int formatId;
    private byte[] gtrid = null;
    private byte[] bqual = null;
    private byte[] txctx = null;
    private int m_hashCode = 0;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private int state;

    public OracleXid(int n2, byte[] byArray, byte[] byArray2) throws XAException {
        this(n2, byArray, byArray2, null);
    }

    public OracleXid(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws XAException {
        this.formatId = n2;
        if (byArray != null && byArray.length > 64) {
            throw (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
        }
        this.gtrid = byArray;
        if (byArray2 != null && byArray2.length > 64) {
            throw (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
        }
        this.bqual = byArray2;
        this.txctx = byArray3;
        this.state = 0;
        this.m_hashCode = this.computeHashCode();
    }

    public void setState(int n2) {
        this.state = n2;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public byte[] getTxContext() {
        return this.txctx;
    }

    public void setTxContext(byte[] byArray) {
        this.txctx = byArray;
    }

    public static final boolean isLocalTransaction(Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        if (byArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == 0) continue;
            return false;
        }
        return true;
    }

    @DefaultLevel(value=Logging.FINEST)
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Xid)) {
            return false;
        }
        Xid xid = (Xid)object;
        return this.getFormatId() == xid.getFormatId() && Arrays.equals(this.getGlobalTransactionId(), xid.getGlobalTransactionId()) && Arrays.equals(this.getBranchQualifier(), xid.getBranchQualifier());
    }

    @DisableTrace
    public int hashCode() {
        return this.m_hashCode;
    }

    private int computeHashCode() {
        int n2;
        int n3 = 0;
        byte[] byArray = this.getGlobalTransactionId();
        byte[] byArray2 = this.getBranchQualifier();
        n3 += this.getFormatId();
        if (byArray == null) {
            n3 += 0;
        } else {
            for (n2 = 0; n2 < byArray.length; ++n2) {
                n3 += byArray[n2];
            }
        }
        if (byArray2 == null) {
            n3 += 0;
        } else {
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                n3 += byArray2[n2];
            }
        }
        return n3;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

