/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.ANYDATA;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_DATUM})
class AnyDataFactory
implements OracleDataFactory,
ORADataFactory {
    AnyDataFactory() {
    }

    @Override
    public ORAData create(Datum datum, int n2) throws SQLException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof OPAQUE) {
            return new ANYDATA((OPAQUE)datum);
        }
        String string = "expected oracle.sql.OPAQUE got: " + datum.getClass().getName();
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, string).fillInStackTrace();
    }

    @Override
    public OracleData create(Object object, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof OPAQUE) {
            return new ANYDATA((OPAQUE)object);
        }
        String string = "expected oracle.sql.OPAQUE got: " + object.getClass().getName();
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, string).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

