/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Stream;
import org.sqlite.FileException;
import org.sqlite.NativeLibraryNotFoundException;
import org.sqlite.util.LibraryLoaderUtil;
import org.sqlite.util.Logger;
import org.sqlite.util.LoggerFactory;
import org.sqlite.util.OSInfo;
import org.sqlite.util.StringUtils;

public class SQLiteJDBCLoader {
    private static final Logger logger = LoggerFactory.getLogger(SQLiteJDBCLoader.class);
    private static final String LOCK_EXT = ".lck";
    private static boolean extracted = false;

    public static synchronized boolean initialize() throws Exception {
        if (!extracted) {
            SQLiteJDBCLoader.cleanup();
        }
        SQLiteJDBCLoader.loadSQLiteNativeLibrary();
        return extracted;
    }

    private static File getTempDir() {
        return new File(System.getProperty("org.sqlite.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    static void cleanup() {
        String string = "sqlite-" + SQLiteJDBCLoader.getVersion();
        try (Stream<Path> stream = Files.list(SQLiteJDBCLoader.getTempDir().toPath());){
            stream.filter(path -> !path.getFileName().toString().endsWith(LOCK_EXT) && path.getFileName().toString().startsWith(string)).forEach(path -> {
                Path path2 = Paths.get(path + LOCK_EXT, new String[0]);
                if (Files.notExists(path2, new LinkOption[0])) {
                    try {
                        Files.delete(path);
                    }
                    catch (Exception exception) {
                        logger.error("Failed to delete old native lib", exception);
                    }
                }
            });
        }
        catch (IOException iOException) {
            logger.error("Failed to open directory", iOException);
        }
    }

    public static boolean isNativeMode() throws Exception {
        SQLiteJDBCLoader.initialize();
        return extracted;
    }

    static String md5sum(InputStream inputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(bufferedInputStream, messageDigest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(messageDigest.digest());
            String string = byteArrayOutputStream.toString();
            return string;
        }
    }

    private static boolean contentsEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n3 = inputStream.read();
        while (n3 != -1) {
            n2 = inputStream2.read();
            if (n3 != n2) {
                return false;
            }
            n3 = inputStream.read();
        }
        n2 = inputStream2.read();
        return n2 == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractAndLoadLibraryFile(String string, String string2, String string3) throws FileException {
        String string4 = string + "/" + string2;
        String string5 = UUID.randomUUID().toString();
        String string6 = String.format("sqlite-%s-%s-%s", SQLiteJDBCLoader.getVersion(), string5, string2);
        String string7 = string6 + LOCK_EXT;
        Path path = Paths.get(string3, string6);
        Path path2 = Paths.get(string3, string7);
        try {
            InputStream inputStream;
            try {
                inputStream = SQLiteJDBCLoader.getResourceAsStream(string4);
                try {
                    if (Files.notExists(path2, new LinkOption[0])) {
                        Files.createFile(path2, new FileAttribute[0]);
                    }
                    Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            finally {
                path.toFile().deleteOnExit();
                path2.toFile().deleteOnExit();
            }
            path.toFile().setReadable(true);
            path.toFile().setWritable(true, true);
            path.toFile().setExecutable(true);
            inputStream = SQLiteJDBCLoader.getResourceAsStream(string4);
            try (InputStream inputStream2 = Files.newInputStream(path, new OpenOption[0]);){
                if (!SQLiteJDBCLoader.contentsEquals(inputStream, inputStream2)) {
                    throw new FileException(String.format("Failed to write a native library file at %s", path));
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            return SQLiteJDBCLoader.loadNativeLibrary(string3, string6);
        }
        catch (IOException iOException) {
            logger.error("Unexpected IOException", iOException);
            return false;
        }
    }

    private static InputStream getResourceAsStream(String string) {
        String string2 = string.substring(1);
        ClassLoader classLoader = SQLiteJDBCLoader.class.getClassLoader();
        URL uRL = classLoader.getResource(string2);
        if (uRL == null) {
            return null;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            logger.error("Could not connect", iOException);
            return null;
        }
    }

    private static boolean loadNativeLibrary(String string, String string2) {
        File file = new File(string, string2);
        if (file.exists()) {
            try {
                System.load(new File(string, string2).getAbsolutePath());
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                logger.error("Failed to load native library: {}. osinfo: {}", string2, OSInfo.getNativeLibFolderPathForCurrentOS(), unsatisfiedLinkError);
                return false;
            }
        }
        return false;
    }

    private static boolean loadNativeLibraryJdk() {
        try {
            System.loadLibrary("sqlitejdbc");
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.error("Failed to load native library through System.loadLibrary", unsatisfiedLinkError);
            return false;
        }
    }

    private static void loadSQLiteNativeLibrary() throws Exception {
        String string;
        boolean bl;
        if (extracted) {
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = System.getProperty("org.sqlite.lib.path");
        String string3 = System.getProperty("org.sqlite.lib.name");
        if (string3 == null) {
            string3 = LibraryLoaderUtil.getNativeLibName();
        }
        if (string2 != null) {
            if (SQLiteJDBCLoader.loadNativeLibrary(string2, string3)) {
                extracted = true;
                return;
            }
            linkedList.add(string2);
        }
        if (bl = LibraryLoaderUtil.hasNativeLib(string2 = LibraryLoaderUtil.getNativeLibResourcePath(), string3)) {
            string = SQLiteJDBCLoader.getTempDir().getAbsolutePath();
            if (SQLiteJDBCLoader.extractAndLoadLibraryFile(string2, string3, string)) {
                extracted = true;
                return;
            }
            linkedList.add(string2);
        }
        string = System.getProperty("java.library.path", "");
        for (String string4 : string.split(File.pathSeparator)) {
            if (string4.isEmpty()) continue;
            if (SQLiteJDBCLoader.loadNativeLibrary(string4, string3)) {
                extracted = true;
                return;
            }
            linkedList.add(string4);
        }
        if (SQLiteJDBCLoader.loadNativeLibraryJdk()) {
            extracted = true;
            return;
        }
        extracted = false;
        throw new NativeLibraryNotFoundException(String.format("No native library found for os.name=%s, os.arch=%s, paths=[%s]", OSInfo.getOSName(), OSInfo.getArchName(), StringUtils.join(linkedList, File.pathSeparator)));
    }

    private static void getNativeLibraryFolderForTheCurrentOS() {
        String string = OSInfo.getOSName();
        String string2 = OSInfo.getArchName();
    }

    public static int getMajorVersion() {
        String[] stringArray = SQLiteJDBCLoader.getVersion().split("\\.");
        return stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 1;
    }

    public static int getMinorVersion() {
        String[] stringArray = SQLiteJDBCLoader.getVersion().split("\\.");
        return stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 0;
    }

    public static String getVersion() {
        return VersionHolder.VERSION;
    }

    public static final class VersionHolder {
        private static final String VERSION;

        static {
            URL uRL = VersionHolder.class.getResource("/META-INF/maven/org.xerial/sqlite-jdbc/pom.properties");
            if (uRL == null) {
                uRL = VersionHolder.class.getResource("/META-INF/maven/org.xerial/sqlite-jdbc/VERSION");
            }
            String string = "unknown";
            try {
                if (uRL != null) {
                    Properties properties = new Properties();
                    properties.load(uRL.openStream());
                    string = properties.getProperty("version", string);
                    string = string.trim().replaceAll("[^0-9\\.]", "");
                }
            }
            catch (IOException iOException) {
                LoggerFactory.getLogger(VersionHolder.class).error("Could not read version from file: {}", uRL, iOException);
            }
            VERSION = string;
        }
    }
}

