/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class CoreResultSet
implements Codes {
    protected final CoreStatement stmt;
    public boolean emptyResultSet = false;
    public boolean open = false;
    public long maxRows;
    public String[] cols = null;
    public String[] colsMeta = null;
    protected boolean[][] meta = null;
    protected int limitRows;
    protected int row = 0;
    protected boolean pastLastRow = false;
    protected int lastCol;
    public boolean closeStmt;
    protected Map<String, Integer> columnNameToIndex = null;

    protected CoreResultSet(CoreStatement coreStatement) {
        this.stmt = coreStatement;
    }

    protected DB getDatabase() {
        return this.stmt.getDatabase();
    }

    protected SQLiteConnectionConfig getConnectionConfig() {
        return this.stmt.getConnectionConfig();
    }

    public boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() throws SQLException {
        if (!this.open) {
            throw new SQLException("ResultSet closed");
        }
    }

    public int checkCol(int n2) throws SQLException {
        if (this.colsMeta == null) {
            throw new SQLException("SQLite JDBC: inconsistent internal state");
        }
        if (n2 < 1 || n2 > this.colsMeta.length) {
            throw new SQLException("column " + n2 + " out of bounds [1," + this.colsMeta.length + "]");
        }
        return --n2;
    }

    protected int markCol(int n2) throws SQLException {
        this.checkCol(n2);
        this.lastCol = n2--;
        return n2;
    }

    public void checkMeta() throws SQLException {
        this.checkCol(1);
        if (this.meta == null) {
            this.meta = this.stmt.pointer.safeRun(DB::column_metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        DB dB;
        this.cols = null;
        this.colsMeta = null;
        this.meta = null;
        this.limitRows = 0;
        this.row = 0;
        this.pastLastRow = false;
        this.lastCol = -1;
        this.columnNameToIndex = null;
        this.emptyResultSet = false;
        if (this.stmt.pointer.isClosed() || !this.open && !this.closeStmt) {
            return;
        }
        DB dB2 = dB = this.stmt.getDatabase();
        synchronized (dB2) {
            if (!this.stmt.pointer.isClosed()) {
                this.stmt.pointer.safeRunInt(DB::reset);
                if (this.closeStmt) {
                    this.closeStmt = false;
                    ((Statement)((Object)this.stmt)).close();
                }
            }
        }
        this.open = false;
    }

    protected Integer findColumnIndexInCache(String string) {
        if (this.columnNameToIndex == null) {
            return null;
        }
        return this.columnNameToIndex.get(string);
    }

    protected int addColumnIndexInCache(String string, int n2) {
        if (this.columnNameToIndex == null) {
            this.columnNameToIndex = new HashMap<String, Integer>(this.cols.length);
        }
        this.columnNameToIndex.put(string, n2);
        return n2;
    }
}

