/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.bridge;

import com.dbrecover.gui.bridge.S5;
import com.dbrecover.gui.bridge.l;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MultiThreadDataBridgeDialog
extends JDialog
implements l.O0 {
    private l executor;
    private final String schemaName;
    private final int threadCount;
    private final ArrayList<String> tableList;
    private JLabel lblOverallProgress;
    private JLabel lblTotalRows;
    private JLabel lblElapsedTime;
    private JLabel lblGlobalStatus;
    private JProgressBar progressBarOverall;
    private JPanel workersPanel;
    private WorkerPanel[] workerPanels;
    private DefaultTableModel tableStatusModel;
    private JTable statusTable;
    private JButton btnPauseAll;
    private JButton btnStopAll;
    private final DecimalFormat rowFormatter = new DecimalFormat("#,###");
    private final DecimalFormat timeFormatter = new DecimalFormat("#,##0.000");
    private Timer uiUpdateTimer;

    public MultiThreadDataBridgeDialog(JDialog jDialog, String string, String string2, String string3, String string4, ArrayList<String> arrayList, int n2) {
        super(jDialog, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), true);
        this.schemaName = string;
        this.threadCount = n2;
        this.tableList = arrayList;
        this.initComponents();
        try {
            this.executor = new l(string, string2, string3, string4, arrayList, n2);
            this.executor.O0(this);
            this.executor.initialize();
            this.updateWorkerPanelsFromExecutor();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to initialize executor: " + exception.getMessage(), "Error", 0);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultiThreadDataBridgeDialog.this.handleWindowClose();
            }
        });
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(jDialog);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 12));
        jPanel.setBorder(new EmptyBorder(15, 20, 15, 20));
        JPanel jPanel2 = this.createHeaderPanel();
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = this.createGlobalStatsCard();
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(10));
        JPanel jPanel5 = this.createWorkersSection();
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createVerticalStrut(10));
        JPanel jPanel6 = this.createTableListPanel();
        jPanel3.add(jPanel6);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel7 = this.createButtonPanel();
        jPanel.add((Component)jPanel7, "South");
        this.getContentPane().add(jPanel);
        this.setPreferredSize(new Dimension(1100, 750));
    }

    private JPanel createHeaderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel = new JLabel("Multi-Thread Schema Data Bridge");
        jLabel.setFont(new Font("Segoe UI", 1, 20));
        jLabel.putClientProperty("FlatLaf.styleClass", "h1");
        JLabel jLabel2 = new JLabel("Schema: " + this.schemaName + " | Threads: " + this.threadCount);
        jLabel2.setFont(new Font("Segoe UI", 0, 12));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(jLabel2);
        this.lblGlobalStatus = new JLabel("Ready");
        this.lblGlobalStatus.setFont(new Font("Segoe UI", 1, 14));
        this.lblGlobalStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.lblGlobalStatus, "East");
        return jPanel;
    }

    private JPanel createGlobalStatsCard() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Overall Progress"));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 5));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Progress");
        jLabel.setFont(new Font("Segoe UI", 1, 13));
        this.lblOverallProgress = new JLabel("0 / " + this.tableList.size() + " tables");
        this.lblOverallProgress.setFont(new Font("Consolas", 1, 13));
        this.lblOverallProgress.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        jPanel3.add((Component)jLabel, "West");
        jPanel3.add((Component)this.lblOverallProgress, "East");
        this.progressBarOverall = new JProgressBar();
        this.progressBarOverall.setMaximum(this.tableList.size());
        this.progressBarOverall.setValue(0);
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)this.progressBarOverall, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 20, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JLabel jLabel2 = new JLabel("Total Inserted Rows");
        jLabel2.setFont(new Font("Segoe UI", 0, 11));
        this.lblTotalRows = new JLabel("0");
        this.lblTotalRows.setFont(new Font("Consolas", 1, 20));
        this.lblTotalRows.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        jPanel5.add(jLabel2);
        jPanel5.add(Box.createVerticalStrut(2));
        jPanel5.add(this.lblTotalRows);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JLabel jLabel3 = new JLabel("Elapsed Time (seconds)");
        jLabel3.setFont(new Font("Segoe UI", 0, 11));
        this.lblElapsedTime = new JLabel("0.000");
        this.lblElapsedTime.setFont(new Font("Consolas", 1, 20));
        this.lblElapsedTime.putClientProperty("FlatLaf.style", "foreground: $Component.warningColor");
        jPanel6.add(jLabel3);
        jPanel6.add(Box.createVerticalStrut(2));
        jPanel6.add(this.lblElapsedTime);
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel6);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    private JPanel createWorkersSection() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        JLabel jLabel = new JLabel("Worker Threads");
        jLabel.putClientProperty("FlatLaf.styleClass", "h3");
        this.workersPanel = new JPanel(new FlowLayout(0, 10, 10));
        this.workerPanels = new WorkerPanel[this.threadCount];
        for (int i2 = 0; i2 < this.threadCount; ++i2) {
            this.workerPanels[i2] = new WorkerPanel(i2);
            this.workersPanel.add(this.workerPanels[i2]);
        }
        JScrollPane jScrollPane = new JScrollPane(this.workersPanel);
        jScrollPane.setBorder(null);
        jScrollPane.setPreferredSize(new Dimension(0, 140));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createTableListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        JLabel jLabel = new JLabel("Table Processing Status");
        jLabel.putClientProperty("FlatLaf.styleClass", "h3");
        Object[] objectArray = new String[]{"Table Name", "Worker", "Status", "Rows", "Time(s)"};
        this.tableStatusModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        for (String string : this.tableList) {
            this.tableStatusModel.addRow(new Object[]{string, "-", "Pending", "-", "-"});
        }
        this.statusTable = new JTable(this.tableStatusModel);
        this.statusTable.setFont(new Font("Segoe UI", 0, 12));
        this.statusTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.statusTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.statusTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.statusTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.statusTable.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.statusTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                if (n3 == 2) {
                    String string;
                    switch (string = (String)object) {
                        case "Processing": {
                            this.setForeground(UIManager.getColor("Component.warningColor"));
                            break;
                        }
                        case "Completed": {
                            this.setForeground(UIManager.getColor("Component.accentColor"));
                            break;
                        }
                        case "Skipped": {
                            this.setForeground(new Color(156, 39, 176));
                            break;
                        }
                        case "Failed": 
                        case "Stopped": {
                            this.setForeground(UIManager.getColor("Component.errorColor"));
                            break;
                        }
                        default: {
                            this.setForeground(Color.GRAY);
                            break;
                        }
                    }
                } else if (!bl2) {
                    this.setForeground(jTable.getForeground());
                }
                return component;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.statusTable);
        jScrollPane.setPreferredSize(new Dimension(0, 220));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 10));
        this.btnPauseAll = new JButton("|| PAUSE ALL");
        this.btnPauseAll.putClientProperty("JButton.buttonType", "roundRect");
        this.btnPauseAll.addActionListener(this::handlePauseAllClick);
        this.btnStopAll = new JButton("[] STOP ALL");
        this.btnStopAll.putClientProperty("JButton.buttonType", "roundRect");
        this.btnStopAll.putClientProperty("FlatLaf.style", "background: #EF5350; foreground: #FFFFFF");
        this.btnStopAll.addActionListener(this::handleStopAllClick);
        jPanel.add(this.btnPauseAll);
        jPanel.add(this.btnStopAll);
        return jPanel;
    }

    private void updateWorkerPanelsFromExecutor() {
        if (this.executor == null) {
            return;
        }
        int n2 = this.executor.I1I1();
        for (int i2 = 0; i2 < this.workerPanels.length; ++i2) {
            if (i2 < n2) {
                S5 s5 = this.executor.O0(i2);
                if (s5 == null) continue;
                this.workerPanels[i2].updateProgress(0, s5.a0());
                continue;
            }
            this.workerPanels[i2].updateStatus("No Tasks");
            this.workerPanels[i2].setEnabled(false);
        }
        for (S5 s5 : this.executor.l()) {
            int n3 = s5.g0();
            for (String string : s5.lll()) {
                this.updateTableWorker(string, "W" + (n3 + 1));
            }
        }
    }

    private void updateTableWorker(String string, String string2) {
        SwingUtilities.invokeLater(() -> {
            for (int i2 = 0; i2 < this.tableStatusModel.getRowCount(); ++i2) {
                if (!string.equals(this.tableStatusModel.getValueAt(i2, 0))) continue;
                this.tableStatusModel.setValueAt(string2, i2, 1);
                break;
            }
        });
    }

    private void updateTableStatus(String string, String string2, String string3, String string4) {
        SwingUtilities.invokeLater(() -> {
            for (int i2 = 0; i2 < this.tableStatusModel.getRowCount(); ++i2) {
                if (!string.equals(this.tableStatusModel.getValueAt(i2, 0))) continue;
                this.tableStatusModel.setValueAt(string2, i2, 2);
                this.tableStatusModel.setValueAt(string3, i2, 3);
                this.tableStatusModel.setValueAt(string4, i2, 4);
                this.statusTable.scrollRectToVisible(this.statusTable.getCellRect(i2, 0, true));
                break;
            }
        });
    }

    private void handlePauseAllClick(ActionEvent actionEvent) {
        if (this.executor == null) {
            return;
        }
        if (this.executor.\u03bc()) {
            this.executor.y0_();
            this.btnPauseAll.setText("|| PAUSE ALL");
            this.lblGlobalStatus.setText("Running");
            this.lblGlobalStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        } else {
            this.executor.x0_();
            this.btnPauseAll.setText("> RESUME ALL");
            this.lblGlobalStatus.setText("Paused");
            this.lblGlobalStatus.putClientProperty("FlatLaf.style", "foreground: $Component.warningColor");
        }
    }

    private void handleStopAllClick(ActionEvent actionEvent) {
        if (this.executor == null) {
            return;
        }
        if (this.executor.\u03be()) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Stop all workers? Completed tables and data already inserted will be preserved.", "Confirm Stop", 0, 2);
        if (n2 == 0) {
            this.executor.z0_();
            this.btnStopAll.setEnabled(false);
            this.btnPauseAll.setEnabled(false);
            this.lblGlobalStatus.setText("Stopping...");
            this.lblGlobalStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
        }
    }

    private void handleWindowClose() {
        if (this.executor == null || this.executor.\u03be()) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Stop all workers and close?", "Confirm Close", 0, 2);
        if (n2 == 0) {
            if (this.executor != null) {
                this.executor.z0_();
            }
            if (this.uiUpdateTimer != null) {
                this.uiUpdateTimer.stop();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void startDataBridge() {
        if (this.executor == null) {
            return;
        }
        this.lblGlobalStatus.setText("Running");
        this.lblGlobalStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        this.startUIUpdateTimer();
        this.executor.start();
    }

    private void startUIUpdateTimer() {
        this.uiUpdateTimer = new Timer(100, actionEvent -> {
            if (this.executor == null) {
                return;
            }
            long l2 = System.currentTimeMillis() - this.executor.getStartTime();
            if (this.executor.getStartTime() > 0L) {
                this.lblElapsedTime.setText(this.timeFormatter.format((double)l2 / 1000.0));
            }
            this.lblTotalRows.setText(this.rowFormatter.format(this.executor.l1l1()));
            int n2 = this.executor.e0();
            this.lblOverallProgress.setText(n2 + " / " + this.tableList.size() + " tables");
            this.progressBarOverall.setValue(n2);
            for (int i2 = 0; i2 < this.executor.I1I1(); ++i2) {
                S5 s5 = this.executor.O0(i2);
                if (s5 == null || i2 >= this.workerPanels.length) continue;
                this.workerPanels[i2].updateCurrentTable(s5.e0());
                this.workerPanels[i2].updateRows(s5.I1I1());
                this.workerPanels[i2].updateProgress(s5.k0(), s5.a0());
            }
        });
        this.uiUpdateTimer.start();
    }

    @Override
    public void onWorkerTableStarted(int n2, String string) {
        SwingUtilities.invokeLater(() -> {
            if (n2 < this.workerPanels.length) {
                this.workerPanels[n2].updateCurrentTable(string);
            }
            this.updateTableStatus(string, "Processing", "0", "-");
        });
    }

    @Override
    public void onWorkerTableCompleted(int n2, String string, long l2, double d2) {
        SwingUtilities.invokeLater(() -> this.updateTableStatus(string, "Completed", this.rowFormatter.format(l2), this.timeFormatter.format(d2)));
    }

    @Override
    public void onWorkerTableFailed(int n2, String string, String string2) {
        SwingUtilities.invokeLater(() -> this.updateTableStatus(string, "Failed", "-", "-"));
    }

    @Override
    public void onWorkerTableSkipped(int n2, String string, long l2, double d2) {
        SwingUtilities.invokeLater(() -> this.updateTableStatus(string, "Skipped", this.rowFormatter.format(l2), this.timeFormatter.format(d2)));
    }

    @Override
    public void onWorkerStatusChanged(int n2, String string) {
        SwingUtilities.invokeLater(() -> {
            if (n2 < this.workerPanels.length) {
                this.workerPanels[n2].updateStatus(string);
            }
        });
    }

    @Override
    public void onWorkerRowCountUpdated(int n2, long l2) {
    }

    @Override
    public void onAllWorkersCompleted() {
        SwingUtilities.invokeLater(() -> {
            if (this.uiUpdateTimer != null) {
                this.uiUpdateTimer.stop();
            }
            this.lblGlobalStatus.setText(this.executor.\u03bd() ? "Stopped" : "Completed");
            if (this.executor.\u03bd()) {
                this.lblGlobalStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
            } else {
                this.lblGlobalStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
            }
            this.btnPauseAll.setEnabled(false);
            this.btnStopAll.setText("CLOSE");
            this.btnStopAll.setEnabled(true);
            this.lblTotalRows.setText(this.rowFormatter.format(this.executor.l1l1()));
            int n2 = this.executor.e0();
            this.lblOverallProgress.setText(n2 + " / " + this.tableList.size() + " tables");
            this.progressBarOverall.setValue(n2);
            this.showCompletionDialog();
        });
    }

    @Override
    public void onGlobalStatsUpdated(int n2, int n3, int n4, long l2) {
    }

    private void showCompletionDialog() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><div style='font-family: Segoe UI; padding: 10px;'>");
        if (this.executor.\u03bd()) {
            stringBuilder.append("<h3 style='color: #EF5350;'>Operation stopped by user</h3>");
        } else {
            stringBuilder.append("<h3 style='color: #66BB6A;'>Data Bridge Completed</h3>");
        }
        stringBuilder.append("<table style='margin-top: 10px;'>");
        stringBuilder.append("<tr><td>Completed tables:</td><td style='padding-left: 20px; color: #66BB6A;'><b>").append(this.executor.b0()).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Failed tables:</td><td style='padding-left: 20px; color: #EF5350;'><b>").append(this.executor.c0()).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Skipped tables:</td><td style='padding-left: 20px; color: #9C27B0;'><b>").append(this.executor.d0()).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Total rows inserted:</td><td style='padding-left: 20px; color: #42A5F5;'><b>").append(this.rowFormatter.format(this.executor.l1l1())).append("</b></td></tr>");
        stringBuilder.append("<tr><td>Total time:</td><td style='padding-left: 20px; color: #FFA726;'><b>").append(this.timeFormatter.format((double)(System.currentTimeMillis() - this.executor.getStartTime()) / 1000.0)).append(" seconds</b></td></tr>");
        stringBuilder.append("</table>");
        stringBuilder.append("<p style='margin-top: 15px; color: #888;'>Log file: ").append(this.executor.b0()).append("</p>");
        stringBuilder.append("</div></html>");
        JOptionPane.showMessageDialog(this, stringBuilder.toString(), resourceBundle.getString("production_name"), 1);
    }

    private class WorkerPanel
    extends JPanel {
        private final int workerId;
        private JLabel lblStatus;
        private JLabel lblCurrentTable;
        private JLabel lblProgress;
        private JLabel lblRows;
        private JProgressBar progressBar;
        private JButton btnPause;
        private JButton btnSkip;

        public WorkerPanel(int n2) {
            this.workerId = n2;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout(8, 8));
            this.setBorder(BorderFactory.createTitledBorder("Worker " + (this.workerId + 1)));
            JPanel jPanel = new JPanel(new BorderLayout(8, 0));
            this.lblStatus = new JLabel("Idle");
            this.lblStatus.putClientProperty("FlatLaf.styleClass", "small");
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 0));
            this.btnPause = new JButton("||");
            this.btnPause.putClientProperty("JButton.buttonType", "roundRect");
            this.btnPause.setToolTipText("Pause/Resume this worker");
            this.btnPause.setMargin(new Insets(1, 4, 1, 4));
            this.btnPause.addActionListener(actionEvent -> this.togglePause());
            this.btnSkip = new JButton(">>");
            this.btnSkip.putClientProperty("JButton.buttonType", "roundRect");
            this.btnSkip.setToolTipText("Skip current table");
            this.btnSkip.setMargin(new Insets(1, 4, 1, 4));
            this.btnSkip.addActionListener(actionEvent -> this.skipCurrent());
            jPanel2.add(this.btnPause);
            jPanel2.add(this.btnSkip);
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel3.add(this.lblStatus);
            jPanel.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel2, "East");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            this.lblCurrentTable = new JLabel("-");
            this.lblCurrentTable.setFont(new Font("Consolas", 1, 12));
            this.lblCurrentTable.setAlignmentX(0.0f);
            this.lblRows = new JLabel("0 rows");
            this.lblRows.setFont(new Font("Consolas", 0, 11));
            this.lblRows.setAlignmentX(0.0f);
            jPanel4.add(this.lblCurrentTable);
            jPanel4.add(Box.createVerticalStrut(4));
            jPanel4.add(this.lblRows);
            JPanel jPanel5 = new JPanel(new BorderLayout(8, 0));
            this.lblProgress = new JLabel("0 / 0");
            this.lblProgress.setFont(new Font("Consolas", 1, 11));
            this.progressBar = new JProgressBar();
            jPanel5.add((Component)this.progressBar, "Center");
            jPanel5.add((Component)this.lblProgress, "East");
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel4, "Center");
            this.add((Component)jPanel5, "South");
            this.setMinimumSize(new Dimension(240, 110));
        }

        private void togglePause() {
            if (MultiThreadDataBridgeDialog.this.executor == null) {
                return;
            }
            S5 s5 = MultiThreadDataBridgeDialog.this.executor.O0(this.workerId);
            if (s5 == null) {
                return;
            }
            if (s5.\u03bf()) {
                MultiThreadDataBridgeDialog.this.executor.\u03b4(this.workerId);
                this.btnPause.setText("||");
            } else {
                MultiThreadDataBridgeDialog.this.executor.\u03b3(this.workerId);
                this.btnPause.setText(">");
            }
        }

        private void skipCurrent() {
            if (MultiThreadDataBridgeDialog.this.executor == null) {
                return;
            }
            MultiThreadDataBridgeDialog.this.executor.\u03b5(this.workerId);
        }

        public void updateStatus(String string) {
            this.lblStatus.setText(string);
            switch (string) {
                case "Running": {
                    this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
                    break;
                }
                case "Paused": {
                    this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.warningColor");
                    this.btnPause.setText(">");
                    break;
                }
                case "Completed": {
                    this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
                    this.btnPause.setEnabled(false);
                    this.btnSkip.setEnabled(false);
                    break;
                }
                case "Stopped": {
                    this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
                    this.btnPause.setEnabled(false);
                    this.btnSkip.setEnabled(false);
                    break;
                }
                default: {
                    this.lblStatus.putClientProperty("FlatLaf.style", "foreground: default");
                }
            }
        }

        public void updateCurrentTable(String string) {
            this.lblCurrentTable.setText(string.isEmpty() ? "-" : string);
        }

        public void updateRows(long l2) {
            this.lblRows.setText(MultiThreadDataBridgeDialog.this.rowFormatter.format(l2) + " rows");
        }

        public void updateProgress(int n2, int n3) {
            this.lblProgress.setText(n2 + "/" + n3);
            if (n3 > 0) {
                this.progressBar.setMaximum(n3);
                this.progressBar.setValue(n2);
            }
        }

        @Override
        public void setEnabled(boolean bl2) {
            this.btnPause.setEnabled(bl2);
            this.btnSkip.setEnabled(bl2);
        }
    }
}

