/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.bridge;

import com.dbrecover.gui.bridge.O0;
import com.dbrecover.gui.bridge.lI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import o._f0;
import o._l0;
import o.a_a;
import o.lIl;
import o.y0;

public class SchemaDataBridgeProgressDialog
extends JDialog {
    private final AtomicBoolean isPaused = new AtomicBoolean(false);
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final AtomicBoolean isSkipCurrent = new AtomicBoolean(false);
    private final AtomicBoolean isWorkDone = new AtomicBoolean(false);
    private final AtomicBoolean isCurrentTableDone = new AtomicBoolean(false);
    private final String schemaName;
    private final String connectionName;
    private final String tableSuffix;
    private final String tablespaceName;
    private final ArrayList<String> tableList;
    private final DefaultTableModel tableStatusModel;
    private final AtomicInteger processedTableCount = new AtomicInteger(0);
    private long totalInsertedRows = 0L;
    private long startTime;
    private String currentTableName = "";
    private JLabel lblOverallProgress;
    private JLabel lblCurrentTable;
    private JLabel lblCurrentRowCount;
    private JLabel lblTotalRowCount;
    private JLabel lblElapsedTime;
    private JLabel lblStatus;
    private JLabel lblLobHint;
    private JProgressBar progressBarOverall;
    private JProgressBar progressBarCurrent;
    private JButton btnPause;
    private JButton btnStop;
    private JButton btnSkip;
    private JTable statusTable;
    private BufferedWriter logWriter;
    private final DecimalFormat rowFormatter = new DecimalFormat("#,###");
    private final DecimalFormat timeFormatter = new DecimalFormat("#,##0.000");

    public SchemaDataBridgeProgressDialog(JDialog jDialog, String string, String string2, String string3, String string4, ArrayList<String> arrayList) {
        super(jDialog, ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), true);
        this.schemaName = string;
        this.connectionName = string2;
        this.tableSuffix = string3;
        this.tablespaceName = string4;
        this.tableList = arrayList;
        Object[] objectArray = new String[]{"Table Name", "Status", "Rows", "Time(s)"};
        this.tableStatusModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.initComponents();
        this.initTableData();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SchemaDataBridgeProgressDialog.this.handleWindowClose();
            }
        });
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(jDialog);
    }

    private void initTableData() {
        for (String string : this.tableList) {
            this.tableStatusModel.addRow(new Object[]{string, "Pending", "-", "-"});
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 15));
        jPanel.setBorder(new EmptyBorder(20, 25, 20, 25));
        JPanel jPanel2 = this.createHeaderPanel();
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = this.createOverallProgressCard();
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(12));
        JPanel jPanel5 = this.createCurrentProgressCard();
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createVerticalStrut(12));
        JPanel jPanel6 = this.createStatsCard();
        jPanel3.add(jPanel6);
        jPanel3.add(Box.createVerticalStrut(12));
        JPanel jPanel7 = this.createTableListPanel();
        jPanel3.add(jPanel7);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel8 = this.createButtonPanel();
        jPanel.add((Component)jPanel8, "South");
        this.getContentPane().add(jPanel);
        this.setPreferredSize(new Dimension(700, 720));
    }

    private JPanel createHeaderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("Schema Data Bridge");
        jLabel.setFont(new Font("Segoe UI", 1, 22));
        jLabel.putClientProperty("FlatLaf.styleClass", "h2");
        this.lblStatus = new JLabel("Ready");
        this.lblStatus.setFont(new Font("Segoe UI", 1, 13));
        this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        JLabel jLabel2 = new JLabel("Schema: " + this.schemaName);
        jLabel2.setFont(new Font("Segoe UI", 0, 12));
        jLabel2.putClientProperty("FlatLaf.styleClass", "small");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(jLabel2);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.lblStatus, "East");
        return jPanel;
    }

    private JPanel createOverallProgressCard() {
        JPanel jPanel = this.createCard();
        jPanel.setLayout(new BorderLayout(10, 8));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel("Overall Progress");
        jLabel.setFont(new Font("Segoe UI", 1, 14));
        this.lblOverallProgress = new JLabel("0 / " + this.tableList.size() + " tables");
        this.lblOverallProgress.setFont(new Font("Consolas", 1, 14));
        this.lblOverallProgress.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.lblOverallProgress, "East");
        this.progressBarOverall = new JProgressBar();
        this.progressBarOverall.setMaximum(this.tableList.size());
        this.progressBarOverall.setValue(0);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.progressBarOverall, "Center");
        return jPanel;
    }

    private JPanel createCurrentProgressCard() {
        JPanel jPanel = this.createCard();
        jPanel.setLayout(new BorderLayout(10, 8));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel("Current Table");
        jLabel.setFont(new Font("Segoe UI", 1, 14));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 0));
        jPanel3.setOpaque(false);
        this.lblLobHint = new JLabel("");
        this.lblLobHint.setFont(new Font("Segoe UI Symbol", 1, 12));
        this.lblLobHint.setForeground(new Color(255, 152, 0));
        this.lblLobHint.setVisible(false);
        this.lblCurrentTable = new JLabel("-");
        this.lblCurrentTable.setFont(new Font("Consolas", 1, 14));
        this.lblCurrentTable.putClientProperty("FlatLaf.style", "foreground: $Component.warningColor");
        jPanel3.add(this.lblLobHint);
        jPanel3.add(this.lblCurrentTable);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setOpaque(false);
        this.lblCurrentRowCount = new JLabel("Rows: 0");
        this.lblCurrentRowCount.setFont(new Font("Segoe UI", 0, 12));
        this.lblCurrentRowCount.putClientProperty("FlatLaf.styleClass", "small");
        jPanel4.add((Component)this.lblCurrentRowCount, "West");
        this.progressBarCurrent = new JProgressBar();
        this.progressBarCurrent.setIndeterminate(true);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.progressBarCurrent, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private JPanel createStatsCard() {
        JPanel jPanel = this.createCard();
        jPanel.setLayout(new GridLayout(1, 2, 20, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel("Total Inserted Rows");
        jLabel.setFont(new Font("Segoe UI", 0, 11));
        jLabel.putClientProperty("FlatLaf.styleClass", "small");
        jLabel.setAlignmentX(0.0f);
        this.lblTotalRowCount = new JLabel("0");
        this.lblTotalRowCount.setFont(new Font("Consolas", 1, 24));
        this.lblTotalRowCount.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        this.lblTotalRowCount.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(this.lblTotalRowCount);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setOpaque(false);
        JLabel jLabel2 = new JLabel("Elapsed Time (seconds)");
        jLabel2.setFont(new Font("Segoe UI", 0, 11));
        jLabel2.putClientProperty("FlatLaf.styleClass", "small");
        jLabel2.setAlignmentX(0.0f);
        this.lblElapsedTime = new JLabel("0.000");
        this.lblElapsedTime.setFont(new Font("Consolas", 1, 24));
        this.lblElapsedTime.putClientProperty("FlatLaf.style", "foreground: $Component.warningColor");
        this.lblElapsedTime.setAlignmentX(0.0f);
        jPanel3.add(jLabel2);
        jPanel3.add(Box.createVerticalStrut(4));
        jPanel3.add(this.lblElapsedTime);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createTableListPanel() {
        JPanel jPanel = this.createCard();
        jPanel.setLayout(new BorderLayout(0, 8));
        JLabel jLabel = new JLabel("Table Processing Status");
        jLabel.setFont(new Font("Segoe UI", 1, 14));
        this.statusTable = new JTable(this.tableStatusModel);
        this.statusTable.setRowHeight(28);
        this.statusTable.setFont(new Font("Segoe UI", 0, 12));
        this.statusTable.getTableHeader().setFont(new Font("Segoe UI", 1, 12));
        this.statusTable.setShowVerticalLines(false);
        this.statusTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.statusTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.statusTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.statusTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.statusTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                if (n3 == 1) {
                    String string;
                    switch (string = (String)object) {
                        case "Processing": {
                            component.setForeground(Color.ORANGE.darker());
                            break;
                        }
                        case "Completed": {
                            component.setForeground(Color.GREEN.darker());
                            break;
                        }
                        case "Skipped": {
                            component.setForeground(Color.MAGENTA.darker());
                            break;
                        }
                        case "Failed": {
                            component.setForeground(Color.RED);
                            break;
                        }
                        case "Stopped": {
                            component.setForeground(Color.RED);
                            break;
                        }
                        default: {
                            if (bl2) break;
                            component.setForeground(UIManager.getColor("Table.foreground"));
                        }
                    }
                }
                return component;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.statusTable);
        jScrollPane.setPreferredSize(new Dimension(650, 180));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 10));
        jPanel.setOpaque(false);
        this.btnPause = new JButton("|| PAUSE");
        this.btnPause.addActionListener(this::handlePauseClick);
        this.btnSkip = new JButton(">> SKIP");
        this.btnSkip.addActionListener(this::handleSkipClick);
        this.btnStop = new JButton("[] STOP");
        this.btnStop.addActionListener(this::handleStopClick);
        jPanel.add(this.btnPause);
        jPanel.add(this.btnSkip);
        jPanel.add(this.btnStop);
        return jPanel;
    }

    private JPanel createCard() {
        JPanel jPanel = new JPanel();
        jPanel.putClientProperty("FlatLaf.style", "background: $Panel.background; border: 1,1,1,1, $Component.borderColor,,10");
        jPanel.setBorder(new EmptyBorder(12, 16, 12, 16));
        return jPanel;
    }

    private void handlePauseClick(ActionEvent actionEvent) {
        if (this.isPaused.get()) {
            this.isPaused.set(false);
            this.btnPause.setText("|| PAUSE");
            this.lblStatus.setText("Processing...");
            this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        } else {
            this.isPaused.set(true);
            this.btnPause.setText("> RESUME");
            this.lblStatus.setText("Paused");
            this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.warningColor");
        }
    }

    private void handleSkipClick(ActionEvent actionEvent) {
        if (this.currentTableName.isEmpty()) {
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Skip current table: " + this.currentTableName + "?\nAny data already inserted will be preserved.", "Confirm Skip", 0, 2);
        if (n2 == 0) {
            this.isSkipCurrent.set(true);
            this.lblStatus.setText("Skipping...");
            this.lblStatus.setForeground(Color.MAGENTA.darker());
            _l0.l1.\u03bc();
        }
    }

    private void handleStopClick(ActionEvent actionEvent) {
        int n2 = JOptionPane.showConfirmDialog(this, "Stop the entire Schema Data Bridge operation?\nCompleted tables and any data already inserted will be preserved.", "Confirm Stop", 0, 2);
        if (n2 == 0) {
            this.isStopped.set(true);
            this.isPaused.set(false);
            this.btnStop.setEnabled(false);
            this.btnPause.setEnabled(false);
            this.btnSkip.setEnabled(false);
            this.lblStatus.setText("Stopping...");
            this.lblStatus.setForeground(Color.RED);
            _l0.l1.\u03bc();
        }
    }

    private boolean checkForLobColumns(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            String string2;
            if (string == null || !(string2 = string.toUpperCase()).contains("BLOB") && !string2.contains("CLOB") && !string2.contains("NCLOB") && !string2.contains("BFILE") && !string2.contains("LONG") && !string2.contains("XMLTYPE")) continue;
            return true;
        }
        return false;
    }

    private void waitWhilePaused() {
        while (this.isPaused.get() && !this.isStopped.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private void handleWindowClose() {
        if (!this.isWorkDone.get()) {
            int n2 = JOptionPane.showConfirmDialog(this, "Stop the Schema Data Bridge and close this window?", "Confirm Close", 0, 2);
            if (n2 == 0) {
                this.isStopped.set(true);
                this.isPaused.set(false);
                _l0.l1.\u03bc();
            }
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void startDataBridge() {
        this.startTime = System.currentTimeMillis();
        this.startUIUpdateThread();
        this.startProgressAnimationThread();
        this.startWorkerThread();
    }

    private void startUIUpdateThread() {
        new Thread(() -> {
            while (!this.isWorkDone.get()) {
                long l2 = System.currentTimeMillis();
                double d2 = (double)(l2 - this.startTime) / 1000.0;
                long l3 = _l0.l1.I();
                SwingUtilities.invokeLater(() -> {
                    this.lblElapsedTime.setText(this.timeFormatter.format(d2));
                    this.lblTotalRowCount.setText(this.rowFormatter.format(this.totalInsertedRows + l3));
                    this.lblCurrentRowCount.setText("Rows: " + this.rowFormatter.format(l3));
                    int n2 = this.processedTableCount.get();
                    this.lblOverallProgress.setText(n2 + " / " + this.tableList.size() + " tables");
                    this.progressBarOverall.setValue(n2);
                });
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }).start();
    }

    private void startProgressAnimationThread() {
        Timer timer = new Timer(30, actionEvent -> {
            if (!this.isWorkDone.get()) {
                this.progressBarCurrent.repaint();
            }
        });
        timer.start();
    }

    private void startWorkerThread() {
        new Thread(() -> {
            try {
                this.initLogFile();
                this.processAllTables();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.finalizeWork();
            }
        }).start();
    }

    private void initLogFile() throws IOException {
        File file = new File("./log");
        if (!file.exists()) {
            file.mkdir();
        }
        String string = "./log/PRM_SchemaDataBridge_" + _f0.llll() + ".log";
        this.logWriter = new BufferedWriter(new FileWriter(new File(string)), 8192);
        this.logWriter.write("DBRecover for Oracle Schema DataBridge on ");
        this.logWriter.write(_f0.IlIl());
        this.logWriter.newLine();
        this.logWriter.write("Copyright (c) 2009 - 2026 DBRECOVER.COM  All rights reserved.");
        this.logWriter.newLine();
        this.logWriter.newLine();
        this.logWriter.write("Start to process selected table(s) in schema: " + this.schemaName);
        this.logWriter.newLine();
        this.logWriter.newLine();
        System.err.println("Schema DataBridge log: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllTables() {
        PrintStream printStream = System.err;
        System.setErr(new PrintStream(new OutputStream(){

            @Override
            public void write(int n2) throws IOException {
                SchemaDataBridgeProgressDialog.this.logWriter.write(String.valueOf((char)n2));
                SchemaDataBridgeProgressDialog.this.logWriter.flush();
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                SchemaDataBridgeProgressDialog.this.logWriter.write(new String(byArray));
                SchemaDataBridgeProgressDialog.this.logWriter.flush();
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                SchemaDataBridgeProgressDialog.this.logWriter.write(new String(byArray, n2, n3));
                SchemaDataBridgeProgressDialog.this.logWriter.flush();
            }
        }, true));
        try {
            for (int i2 = 0; i2 < this.tableList.size(); ++i2) {
                if (this.isStopped.get()) {
                    for (int i3 = i2; i3 < this.tableList.size(); ++i3) {
                        this.updateTableStatus(i3, "Stopped", "-", "-");
                    }
                    break;
                }
                this.waitWhilePaused();
                if (this.isStopped.get()) {
                    for (int i4 = i2; i4 < this.tableList.size(); ++i4) {
                        this.updateTableStatus(i4, "Stopped", "-", "-");
                    }
                    break;
                }
                String string = this.tableList.get(i2);
                this.processTable(i2, string);
            }
        }
        finally {
            System.setErr(printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTable(int n2, String string) {
        this.currentTableName = string;
        this.isSkipCurrent.set(false);
        this.isCurrentTableDone.set(false);
        long l2 = System.currentTimeMillis();
        this.waitWhilePaused();
        if (this.isStopped.get()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.lblCurrentTable.setText(string);
            this.lblStatus.setText("Processing...");
            this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
            this.lblLobHint.setVisible(false);
        });
        this.updateTableStatus(n2, "Processing", "0", "-");
        try {
            this.logWriter.write("Start to process table: " + string);
            this.logWriter.newLine();
            this.waitWhilePaused();
            if (this.isStopped.get()) {
                this.updateTableStatus(n2, "Stopped", "-", "-");
                return;
            }
            y0 y02 = this.getColumnTemplate(string);
            if (y02 == null) {
                this.logWriter.write("Couldn't fetch column info. Skip it.");
                this.logWriter.newLine();
                this.logWriter.newLine();
                this.updateTableStatus(n2, "Failed", "-", "-");
                this.processedTableCount.incrementAndGet();
                SwingUtilities.invokeLater(() -> this.lblLobHint.setVisible(false));
                return;
            }
            boolean bl2 = this.checkForLobColumns(y02.S5());
            SwingUtilities.invokeLater(() -> {
                if (bl2) {
                    this.lblLobHint.setText("\u26a0 Contains LOB");
                    this.lblLobHint.setVisible(true);
                } else {
                    this.lblLobHint.setVisible(false);
                }
            });
            this.waitWhilePaused();
            if (this.isStopped.get()) {
                this.updateTableStatus(n2, "Stopped", "-", "-");
                return;
            }
            String string2 = this.tableSuffix != null ? string + this.tableSuffix : string;
            String[] stringArray = y02.l();
            String[] stringArray2 = y02.S5();
            lIl.O0().O0(string2, this.tablespaceName, stringArray, stringArray2);
            lIl.O0().setUnloadTableInfo(this.schemaName, string);
            lI lI2 = (lI)O0.lO0.get(this.connectionName);
            lIl.O0().l1(lI2.getUserName(), lI2.getPassword(), lI2._1());
            long l3 = this.executeDataBridge();
            long l4 = System.currentTimeMillis();
            double d2 = (double)(l4 - l2) / 1000.0;
            if (this.isStopped.get()) {
                this.updateTableStatus(n2, "Stopped", this.rowFormatter.format(l3), this.timeFormatter.format(d2));
                this.logWriter.write("Table stopped by user. Rows inserted: " + l3);
            } else if (this.isSkipCurrent.get()) {
                this.updateTableStatus(n2, "Skipped", this.rowFormatter.format(l3), this.timeFormatter.format(d2));
                this.logWriter.write("Table skipped by user. Rows inserted: " + l3);
            } else {
                if (this.isPaused.get()) {
                    this.updateTableStatus(n2, "Paused", this.rowFormatter.format(l3), this.timeFormatter.format(d2));
                    this.logWriter.write("Table paused by user. Rows inserted so far: " + l3);
                    this.totalInsertedRows += l3;
                    this.waitWhilePaused();
                    if (!this.isStopped.get()) {
                        this.updateTableStatus(n2, "Interrupted", this.rowFormatter.format(l3), this.timeFormatter.format(d2));
                        this.logWriter.write("Table was interrupted by pause. Partial data inserted.");
                    }
                    this.logWriter.newLine();
                    this.logWriter.flush();
                    this.processedTableCount.incrementAndGet();
                    this.isCurrentTableDone.set(true);
                    this.currentTableName = "";
                    return;
                }
                this.updateTableStatus(n2, "Completed", this.rowFormatter.format(l3), this.timeFormatter.format(d2));
                this.logWriter.write("Totally inserted rows: " + l3);
            }
            this.logWriter.newLine();
            this.logWriter.write("Elapsed time(seconds): " + this.timeFormatter.format(d2));
            this.logWriter.newLine();
            this.logWriter.newLine();
            this.logWriter.flush();
            this.totalInsertedRows += l3;
        }
        catch (Exception exception) {
            this.updateTableStatus(n2, "Failed", "-", "-");
            try {
                this.logWriter.write("Error processing table: " + exception.getMessage());
                this.logWriter.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.processedTableCount.incrementAndGet();
            this.isCurrentTableDone.set(true);
            this.currentTableName = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeDataBridge() {
        int n2;
        a_a.m0m = 0;
        String string = lIl.O0()._0();
        if (string != null) {
            _l0.l1.O(string);
        }
        _l0.l1.startDataBridge();
        _l0.l1.S5(a_a.O0O());
        if (_l0.l1.B8() && (n2 = a_a.O0O()) > 0) {
            _l0.l1.S5(a_a.lll());
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Thread thread = new Thread(() -> {
            block4: while (!atomicBoolean.get()) {
                if (this.isSkipCurrent.get() || this.isStopped.get()) {
                    _l0.l1.\u03bc();
                    break;
                }
                if (this.isPaused.get()) {
                    _l0.l1.\u03bc();
                    while (this.isPaused.get() && !this.isStopped.get() && !this.isSkipCurrent.get()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            break block4;
                        }
                    }
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        try {
            _l0.l1.l1(lIl.O0().__(), lIl.O0().___());
        }
        finally {
            atomicBoolean.set(true);
        }
        long l2 = _l0.l1.S5();
        _l0.l1.\u03c0();
        return l2;
    }

    private y0 getColumnTemplate(String string) {
        try {
            lIl.O0().O(null);
            lIl.O0().setDataBridgeWorkMode(0);
            lIl.O0().B8(false);
            lIl.O0().setUnloadTableInfo(this.schemaName, string);
            _l0.l1.\u03bd();
            _l0.l1.l1(this.schemaName, string);
            y0 y02 = _l0.l1.O0();
            _l0.l1.\u03be();
            return y02;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void updateTableStatus(int n2, String string, String string2, String string3) {
        SwingUtilities.invokeLater(() -> {
            this.tableStatusModel.setValueAt(string, n2, 1);
            this.tableStatusModel.setValueAt(string2, n2, 2);
            this.tableStatusModel.setValueAt(string3, n2, 3);
            this.statusTable.scrollRectToVisible(this.statusTable.getCellRect(n2, 0, true));
        });
    }

    private void finalizeWork() {
        try {
            if (this.logWriter != null) {
                this.logWriter.write("End to process selected table(s) for the schema.");
                this.logWriter.newLine();
                this.logWriter.flush();
                this.logWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isWorkDone.set(true);
        SwingUtilities.invokeLater(() -> {
            this.lblCurrentTable.setText("-");
            this.progressBarCurrent.setIndeterminate(false);
            this.progressBarCurrent.setValue(0);
            this.btnPause.setEnabled(false);
            this.btnSkip.setEnabled(false);
            this.btnStop.setText("CLOSE");
            this.btnStop.setEnabled(true);
            for (ActionListener actionListener : this.btnStop.getActionListeners()) {
                this.btnStop.removeActionListener(actionListener);
            }
            this.btnStop.addActionListener(actionEvent -> {
                this.setVisible(false);
                this.dispose();
            });
            if (this.isStopped.get()) {
                this.lblStatus.setText("Stopped");
                this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
            } else {
                this.lblStatus.setText("Completed");
                this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><h4>");
            if (this.isStopped.get()) {
                stringBuilder.append("<font color='#EF5350'>Operation stopped by user</font><br><br>");
            }
            stringBuilder.append(this.processedTableCount.get()).append(" ");
            stringBuilder.append(resourceBundle.getString("data_bridge_schema_bridge_done"));
            stringBuilder.append("<br><br>");
            stringBuilder.append("Total rows inserted: <font color='#42A5F5'>");
            stringBuilder.append(this.rowFormatter.format(this.totalInsertedRows));
            stringBuilder.append("</font><br>");
            stringBuilder.append("Total time: ");
            stringBuilder.append(this.timeFormatter.format((double)(System.currentTimeMillis() - this.startTime) / 1000.0));
            stringBuilder.append(" seconds");
            stringBuilder.append("</h4></html>");
            JOptionPane.showMessageDialog(this, stringBuilder.toString(), resourceBundle.getString("production_name"), 1);
        });
    }
}

