/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.bridge;

import com.dbrecover.gui.bridge.S5;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import o._f0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class l
implements S5.l1 {
    public static final int cJ = 4;
    public static final int cK = 1;
    public static final int cL = 16;
    private final int cM;
    private final String en;
    private final String eo;
    private final String ep;
    private final String eq;
    private final ArrayList<String> _l;
    private final List<S5> I1I = new ArrayList<S5>();
    private ExecutorService O0;
    private final List<Future<?>> O0l = new ArrayList();
    private final AtomicBoolean l1;
    private final AtomicBoolean I1;
    private final AtomicBoolean Il;
    private final AtomicInteger O0;
    private final AtomicInteger l1 = new AtomicBoolean(false);
    private final AtomicInteger I1 = new AtomicBoolean(false);
    private final AtomicLong O0;
    private final AtomicInteger Il = new AtomicBoolean(false);
    private volatile long startTime = 0L;
    private BufferedWriter logWriter;
    private String er;
    private O0 O0 = new AtomicInteger(0);

    public l(String string, String string2, String string3, String string4, ArrayList<String> arrayList, int n2) {
        this.l1 = new AtomicInteger(0);
        this.I1 = new AtomicInteger(0);
        this.O0 = new AtomicLong(0L);
        this.Il = new AtomicInteger(0);
        this.en = string;
        this.eo = string2;
        this.ep = string3;
        this.eq = string4;
        this._l = arrayList;
        this.cM = Math.max(1, Math.min(16, n2));
    }

    public void O0(O0 o02) {
        this.O0 = o02;
    }

    public void initialize() throws IOException {
        this.initLogFile();
        this.u0_();
        this.O0 = Executors.newFixedThreadPool(this.cM, new ThreadFactory(this){
            private int counter = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "DataBridgeWorker-" + ++this.counter);
                thread.setDaemon(false);
                return thread;
            }
        });
        this.\u03c4("Schema DataBridge Executor initialized with " + this.cM + " workers");
        this.\u03c4("Total tables to process: " + this._l.size());
        for (int i2 = 0; i2 < this.I1I.size(); ++i2) {
            this.\u03c4("Worker-" + (i2 + 1) + " assigned " + this.I1I.get(i2).a0() + " tables");
        }
    }

    private void u0_() {
        int n2;
        ArrayList arrayList = new ArrayList();
        for (n2 = 0; n2 < this.cM; ++n2) {
            arrayList.add(new ArrayList());
        }
        for (n2 = 0; n2 < this._l.size(); ++n2) {
            int n3 = n2 % this.cM;
            ((ArrayList)arrayList.get(n3)).add(this._l.get(n2));
        }
        for (n2 = 0; n2 < this.cM; ++n2) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(n2);
            if (arrayList2.isEmpty()) continue;
            S5 s5 = new S5(n2, this.en, this.eo, this.ep, this.eq, arrayList2);
            s5.O0(this);
            s5.lll(this.logWriter);
            this.I1I.add(s5);
        }
    }

    private void initLogFile() throws IOException {
        File file = new File("./log");
        if (!file.exists()) {
            file.mkdir();
        }
        this.er = "./log/PRM_SchemaDataBridge_MT_" + _f0.llll() + ".log";
        this.logWriter = new BufferedWriter(new FileWriter(new File(this.er)), 8192);
        this.logWriter.write("DBRecover for Oracle Schema DataBridge (Multi-threaded) on ");
        this.logWriter.write(_f0.IlIl());
        this.logWriter.newLine();
        this.logWriter.write("Copyright (c) 2009 - 2026 DBRECOVER.COM  All rights reserved.");
        this.logWriter.newLine();
        this.logWriter.newLine();
        this.logWriter.write("Schema: " + this.en);
        this.logWriter.newLine();
        this.logWriter.write("Thread count: " + this.cM);
        this.logWriter.newLine();
        this.logWriter.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u03c4(String string) {
        if (this.logWriter != null) {
            try {
                BufferedWriter bufferedWriter = this.logWriter;
                synchronized (bufferedWriter) {
                    this.logWriter.write("[" + _f0.IlIl() + "] " + string);
                    this.logWriter.newLine();
                    this.logWriter.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.Il.set(false);
        this.Il.set(0);
        this.\u03c4("Starting all workers...");
        for (S5 s5 : this.I1I) {
            Future<?> future = this.O0.submit(s5);
            this.O0l.add(future);
        }
        new Thread(this::v0_).start();
    }

    private void v0_() {
        for (Future<?> future : this.O0l) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                this.\u03c4("Worker execution error: " + exception.getMessage());
            }
        }
        this.Il.set(true);
        this.w0_();
        if (this.O0 != null) {
            this.O0.onAllWorkersCompleted();
        }
    }

    private void w0_() {
        if (this.logWriter != null) {
            try {
                this.\u03c4("All workers completed");
                this.\u03c4("Total completed tables: " + this.O0.get());
                this.\u03c4("Total failed tables: " + this.l1.get());
                this.\u03c4("Total skipped tables: " + this.I1.get());
                this.\u03c4("Total inserted rows: " + this.O0.get());
                this.\u03c4("Total time: " + (double)(System.currentTimeMillis() - this.startTime) / 1000.0 + " seconds");
                this.logWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void x0_() {
        this.l1.set(true);
        for (S5 s5 : this.I1I) {
            s5.b0b();
        }
        this.\u03c4("All workers paused");
    }

    public void y0_() {
        this.l1.set(false);
        for (S5 s5 : this.I1I) {
            s5.resume();
        }
        this.\u03c4("All workers resumed");
    }

    public void z0_() {
        this.I1.set(true);
        this.l1.set(false);
        for (S5 s5 : this.I1I) {
            s5.stop();
        }
        this.\u03c4("All workers stop requested");
        if (this.O0 != null) {
            this.O0.shutdown();
        }
    }

    public void \u03b3(int n2) {
        if (n2 >= 0 && n2 < this.I1I.size()) {
            this.I1I.get(n2).b0b();
            this.\u03c4("Worker-" + (n2 + 1) + " paused");
        }
    }

    public void \u03b4(int n2) {
        if (n2 >= 0 && n2 < this.I1I.size()) {
            this.I1I.get(n2).resume();
            this.\u03c4("Worker-" + (n2 + 1) + " resumed");
        }
    }

    public void \u03b5(int n2) {
        if (n2 >= 0 && n2 < this.I1I.size()) {
            S5 s5 = this.I1I.get(n2);
            String string = s5.e0();
            s5.c0c();
            this.\u03c4("Worker-" + (n2 + 1) + " skip requested for table: " + string);
        }
    }

    @Override
    public void I1(int n2, String string) {
        if (this.O0 != null) {
            this.O0.onWorkerTableStarted(n2, string);
        }
    }

    @Override
    public void O0(int n2, String string, long l2, double d2) {
        this.O0.incrementAndGet();
        this.O0.addAndGet(l2);
        if (this.O0 != null) {
            this.O0.onWorkerTableCompleted(n2, string, l2, d2);
            this.O0.onGlobalStatsUpdated(this.O0.get(), this.l1.get(), this.I1.get(), this.O0.get());
        }
    }

    @Override
    public void O0(int n2, String string, String string2) {
        this.l1.incrementAndGet();
        if (this.O0 != null) {
            this.O0.onWorkerTableFailed(n2, string, string2);
            this.O0.onGlobalStatsUpdated(this.O0.get(), this.l1.get(), this.I1.get(), this.O0.get());
        }
    }

    @Override
    public void l1(int n2, String string, long l2, double d2) {
        this.I1.incrementAndGet();
        this.O0.addAndGet(l2);
        if (this.O0 != null) {
            this.O0.onWorkerTableSkipped(n2, string, l2, d2);
            this.O0.onGlobalStatsUpdated(this.O0.get(), this.l1.get(), this.I1.get(), this.O0.get());
        }
    }

    @Override
    public void onWorkerStatusChanged(int n2, String string) {
        if (this.O0 != null) {
            this.O0.onWorkerStatusChanged(n2, string);
        }
    }

    @Override
    public void \u03b6(int n2) {
        this.Il.incrementAndGet();
        this.\u03c4("Worker-" + (n2 + 1) + " completed");
    }

    @Override
    public void l1(int n2, long l2) {
        if (this.O0 != null) {
            this.O0.onWorkerRowCountUpdated(n2, l2);
        }
    }

    public int l1l1() {
        return this.cM;
    }

    public int I1I1() {
        return this.I1I.size();
    }

    public List<S5> l() {
        return this.I1I;
    }

    public S5 O0(int n2) {
        if (n2 >= 0 && n2 < this.I1I.size()) {
            return this.I1I.get(n2);
        }
        return null;
    }

    public boolean \u03bc() {
        return this.l1.get();
    }

    public boolean \u03bd() {
        return this.I1.get();
    }

    public boolean \u03be() {
        return this.Il.get();
    }

    public int a0() {
        return this._l.size();
    }

    public int b0() {
        return this.O0.get();
    }

    public int c0() {
        return this.l1.get();
    }

    public int d0() {
        return this.I1.get();
    }

    public int e0() {
        return this.O0.get() + this.l1.get() + this.I1.get();
    }

    public long l1l1() {
        return this.O0.get();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String b0() {
        return this.er;
    }

    public int f0() {
        return this.Il.get();
    }

    public static interface O0 {
        public void onWorkerTableStarted(int var1, String var2);

        public void onWorkerTableCompleted(int var1, String var2, long var3, double var5);

        public void onWorkerTableFailed(int var1, String var2, String var3);

        public void onWorkerTableSkipped(int var1, String var2, long var3, double var5);

        public void onWorkerStatusChanged(int var1, String var2);

        public void onWorkerRowCountUpdated(int var1, long var2);

        public void onAllWorkersCompleted();

        public void onGlobalStatsUpdated(int var1, int var2, int var3, long var4);
    }
}

