/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core;

import com.dbrecover.gui.core.Database_tree_viewer;
import com.dbrecover.gui.core.I1;
import com.dbrecover.gui.core.Navigator_panel1_world;
import com.dbrecover.gui.core.Navigator_panel2_choices;
import com.dbrecover.gui.core.Navigator_panel3_setup;
import com.dbrecover.gui.core.Navigator_panel4_files;
import com.dbrecover.gui.core.Navigator_panel5_bootstrap;
import com.dbrecover.gui.core.asm.ASMFileCloneDialog;
import com.formdev.flatlaf.extras.FlatSVGUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import o._l0;

public class MainFrame
extends JFrame {
    private final ResourceBundle bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
    private final CardLayout cardLayout = new CardLayout();
    private JFrame parentFrame = null;
    private Navigator_panel1_world panel1_world = null;
    private Navigator_panel2_choices panel2_choices = null;
    private Navigator_panel3_setup panel3_setup = null;
    private Navigator_panel4_files panel4_files = null;
    private Navigator_panel5_bootstrap panel5_launcher_display = null;
    private I1 dbrData = null;
    private String currentCardLayoutPanelName;
    private boolean isLastCardPanel = false;
    private JButton jButton_cancel;
    private JButton jButton_help;
    private JButton jButton_next;
    private JButton jButton_prev;
    private JPanel jPanel_cardLayoutController;
    private JSeparator jSeparator1;

    public MainFrame() {
        super(ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("recovery_wizard_name"));
        this.initComponents();
        try {
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
            URL uRL = this.getClass().getResource("/com/dbrecover/gui/resources/svg/app_icon.svg");
            if (uRL != null) {
                arrayList.add(FlatSVGUtils.svg2image(uRL, 16, 16));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 32, 32));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 64, 64));
                this.setIconImages(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MainFrame.this.isLastCardPanel) {
                    return;
                }
                int n2 = JOptionPane.showConfirmDialog((Component)windowEvent.getSource(), ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("navigator_quit"), ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle").getString("production_name"), 0, 2);
                if (n2 == 0) {
                    if (MainFrame.this.parentFrame != null) {
                        MainFrame.this.parentFrame.setEnabled(true);
                    }
                    MainFrame.this.setVisible(false);
                    MainFrame.this.dbrData = null;
                    MainFrame.this.panel1_world = null;
                    MainFrame.this.panel2_choices = null;
                    MainFrame.this.panel3_setup = null;
                    MainFrame.this.panel4_files = null;
                    MainFrame.this.panel5_launcher_display = null;
                    MainFrame.this.dispose();
                }
            }
        });
        this.displayNavigatorGUI();
    }

    public void setParentFrame(JFrame jFrame) {
        this.parentFrame = jFrame;
    }

    void restoreProgramMainFrame() {
        if (this.parentFrame != null) {
            _l0.dM = 0;
            ((Database_tree_viewer)_l0.O0).treeToRefresh();
            if (_l0.O0 != null) {
                _l0.O0.refreshDataFilesList();
            }
            this.showFileAccessErrors();
            this.parentFrame.setEnabled(true);
        }
        this.setVisible(false);
        System.out.print('\n');
        System.out.println(I1.g0());
        System.out.print('\n');
        this.dbrData = null;
        this.panel1_world = null;
        this.panel2_choices = null;
        this.panel3_setup = null;
        this.panel4_files = null;
        this.panel5_launcher_display = null;
        this.dispose();
    }

    void restoreProgramMainFrameUnderNonBootstrap() {
        if (this.parentFrame != null) {
            _l0.dM = 1;
            ((Database_tree_viewer)_l0.O0).treeToRefreshUnderNonBootstrap();
            int n2 = _l0.l1.O();
            if (n2 > 0) {
                if ((n2 & 1) != 0) {
                    ((Database_tree_viewer)_l0.O0).generateObjNodesAfterScanTablesWithSQLite(false);
                }
                if ((n2 & 2) != 0) {
                    ((Database_tree_viewer)_l0.O0).generateObjNodesAfterScanTablesWithSQLite(true);
                }
            }
            if (_l0.O0 != null) {
                _l0.O0.refreshDataFilesList();
            }
            this.showFileAccessErrors();
            this.parentFrame.setEnabled(true);
        }
        this.setVisible(false);
        System.out.print('\n');
        System.out.println(I1.g0());
        System.out.print('\n');
        this.dbrData = null;
        this.panel1_world = null;
        this.panel2_choices = null;
        this.panel3_setup = null;
        this.panel4_files = null;
        this.panel5_launcher_display = null;
        this.dispose();
    }

    void restoreProgramMainFrameUnderNonBootstrapWithSqliteMode() {
        if (this.parentFrame != null) {
            _l0.dM = 1;
            ((Database_tree_viewer)_l0.O0).treeToRefreshUnderNonBootstrap();
            switch (_l0.l1.O()) {
                case 1: {
                    ((Database_tree_viewer)_l0.O0).generateObjNodesAfterScanTablesWithSQLite(false);
                    break;
                }
                case 2: {
                    ((Database_tree_viewer)_l0.O0).generateObjNodesAfterScanTablesWithSQLite(true);
                    break;
                }
                case 3: {
                    ((Database_tree_viewer)_l0.O0).generateObjNodesAfterScanTablesWithSQLite(false);
                    ((Database_tree_viewer)_l0.O0).generateObjNodesAfterScanTablesWithSQLite(true);
                    break;
                }
            }
            if (_l0.O0 != null) {
                _l0.O0.refreshDataFilesList();
            }
            this.showFileAccessErrors();
            this.parentFrame.setEnabled(true);
        }
        this.setVisible(false);
        System.out.print('\n');
        System.out.println(I1.g0());
        System.out.print('\n');
        this.dbrData = null;
        this.panel1_world = null;
        this.panel2_choices = null;
        this.panel3_setup = null;
        this.panel4_files = null;
        this.panel5_launcher_display = null;
        this.dispose();
    }

    private void showFileAccessErrors() {
        if (_l0.l1 == null || !_l0.l1.IlI()) {
            return;
        }
        ArrayList<String> arrayList = _l0.l1.O();
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Warning: Some data files could not be accessed!\n");
        stringBuilder.append("\u8b66\u544a\uff1a\u90e8\u5206\u6570\u636e\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee\uff01\n\n");
        int n2 = 0;
        for (String string : arrayList) {
            if (n2 >= 5) {
                stringBuilder.append("\n... and ").append(arrayList.size() - 5).append(" more errors.\n");
                stringBuilder.append("... \u8fd8\u6709 ").append(arrayList.size() - 5).append(" \u4e2a\u9519\u8bef\u672a\u663e\u793a\u3002\n");
                break;
            }
            stringBuilder.append("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
            stringBuilder.append(string).append("\n");
            ++n2;
        }
        stringBuilder.append("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
        stringBuilder.append("Tip: On Windows, run as Administrator.\n");
        stringBuilder.append("     On Linux, use sudo or check file permissions.\n");
        stringBuilder.append("\u63d0\u793a\uff1aWindows \u7cfb\u7edf\u8bf7\u4ee5\u7ba1\u7406\u5458\u8eab\u4efd\u8fd0\u884c\u3002\n");
        stringBuilder.append("     Linux \u7cfb\u7edf\u8bf7\u4f7f\u7528 sudo \u6216\u68c0\u67e5\u6587\u4ef6\u6743\u9650\u3002");
        JOptionPane.showMessageDialog(this.parentFrame, stringBuilder.toString(), "File Access Error / \u6587\u4ef6\u8bbf\u95ee\u9519\u8bef", 2);
    }

    private void displayNavigatorGUI() {
        this.dbrData = new I1();
        this.panel1_world = new Navigator_panel1_world();
        this.panel2_choices = new Navigator_panel2_choices();
        this.panel3_setup = new Navigator_panel3_setup();
        this.panel5_launcher_display = new Navigator_panel5_bootstrap();
        this.panel4_files = new Navigator_panel4_files(this.panel5_launcher_display);
        this.panel2_choices.setParentContainer(this);
        this.panel2_choices.setDBRData(this.dbrData);
        this.panel3_setup.setDBRData(this.dbrData);
        this.panel4_files.setParentContainer(this);
        this.panel4_files.setDBRData(this.dbrData);
        this.jPanel_cardLayoutController.add((Component)this.panel1_world, "1");
        this.jPanel_cardLayoutController.add((Component)this.panel2_choices, "2");
        this.jPanel_cardLayoutController.add((Component)this.panel3_setup, "3");
        this.jPanel_cardLayoutController.add((Component)this.panel4_files, "4");
        this.jPanel_cardLayoutController.add((Component)this.panel5_launcher_display, "5");
        this.cardLayout.show(this.jPanel_cardLayoutController, "1");
        this.currentCardLayoutPanelName = "1";
        this.jButton_prev.setEnabled(false);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel_cardLayoutController = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jButton_cancel = new JButton();
        this.jButton_help = new JButton();
        this.jButton_prev = new JButton();
        this.jButton_next = new JButton();
        this.setDefaultCloseOperation(0);
        this.jPanel_cardLayoutController.setLayout(this.cardLayout);
        this.jButton_cancel.setText(this.bundle.getString("navigator_panel1_world_cancel"));
        this.jButton_cancel.setPreferredSize(new Dimension(81, 18));
        this.jButton_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.jButton_cancelActionPerformed(actionEvent);
            }
        });
        this.jButton_help.setText(this.bundle.getString("navigator_panel1_world_help"));
        this.jButton_help.setPreferredSize(new Dimension(81, 18));
        this.jButton_help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.jButton_helpActionPerformed(actionEvent);
            }
        });
        this.jButton_prev.setText(this.bundle.getString("navigator_panel1_world_back"));
        this.jButton_prev.setPreferredSize(new Dimension(81, 18));
        this.jButton_prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.jButton_prevActionPerformed(actionEvent);
            }
        });
        this.jButton_next.setText(this.bundle.getString("navigator_panel1_world_next"));
        this.jButton_next.setPreferredSize(new Dimension(81, 18));
        this.jButton_next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.jButton_nextActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(groupLayout.createSequentialGroup().addComponent(this.jButton_cancel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_help, -1, -1, Short.MAX_VALUE).addGap(580, 580, 580).addComponent(this.jButton_prev, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_next, -1, -1, Short.MAX_VALUE).addGap(22, 22, 22)).addComponent(this.jPanel_cardLayoutController, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel_cardLayoutController, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_cancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_help, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_prev, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_next, -1, -1, Short.MAX_VALUE)).addGap(13, 13, 13)));
    }

    private void jButton_cancelActionPerformed(ActionEvent actionEvent) {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowEvent);
    }

    private void jButton_helpActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "Visit user English guide\uff1a https://zcdn.parnassusdata.com/prm04.pdf\n\u4e2d\u6587\u7528\u6237\u624b\u518c\u5730\u5740\uff1a https://zcdn.parnassusdata.com/prm03.pdf", this.bundle.getString("production_name"), 1);
    }

    private void jButton_prevActionPerformed(ActionEvent actionEvent) {
        switch (this.currentCardLayoutPanelName) {
            case "2": {
                this.currentCardLayoutPanelName = "1";
                this.jButton_prev.setEnabled(false);
                this.cardLayout.show(this.jPanel_cardLayoutController, this.currentCardLayoutPanelName);
                break;
            }
            case "3": {
                this.currentCardLayoutPanelName = "2";
                this.cardLayout.show(this.jPanel_cardLayoutController, this.currentCardLayoutPanelName);
                break;
            }
            case "4": {
                this.currentCardLayoutPanelName = "3";
                this.jButton_next.setEnabled(true);
                this.cardLayout.show(this.jPanel_cardLayoutController, this.currentCardLayoutPanelName);
                break;
            }
        }
    }

    private void jButton_nextActionPerformed(ActionEvent actionEvent) {
        switch (this.currentCardLayoutPanelName) {
            case "1": {
                this.currentCardLayoutPanelName = "2";
                this.jButton_prev.setEnabled(true);
                this.cardLayout.show(this.jPanel_cardLayoutController, this.currentCardLayoutPanelName);
                break;
            }
            case "2": {
                if (!this.jButton_nextActionPerformed_Panel2()) break;
                this.currentCardLayoutPanelName = "3";
                this.cardLayout.show(this.jPanel_cardLayoutController, this.currentCardLayoutPanelName);
                break;
            }
            case "3": {
                if (!this.jButton_nextActionPerformed_Panel3()) break;
                this.currentCardLayoutPanelName = "4";
                this.jButton_next.setEnabled(false);
                this.cardLayout.show(this.jPanel_cardLayoutController, this.currentCardLayoutPanelName);
                break;
            }
        }
    }

    private boolean jButton_nextActionPerformed_Panel2() {
        if (!this.panel2_choices.isAlreadySelected()) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("navigator_panel2_not_selected"), this.bundle.getString("production_name"), 2);
            return false;
        }
        if (this.dbrData.l0() == 3 || this.dbrData.l0() == 4) {
            I1.I1I1 = false;
            ASMFileCloneDialog aSMFileCloneDialog = new ASMFileCloneDialog(this);
            aSMFileCloneDialog.setBackButtonVisible();
            aSMFileCloneDialog.setVisible(true);
            if (!I1.I1I1) {
                this.panel2_choices.resetAllRadioButton();
                return false;
            }
        }
        this.panel3_setup.setupCharacterEncoding();
        return true;
    }

    private boolean jButton_nextActionPerformed_Panel3() {
        this.dbrData.d0d();
        if (_l0.l1.contains(this.dbrData.lll())) {
            String string = this.bundle.getString("navigator_panel3_dbname_duplicate_check");
            JOptionPane.showMessageDialog(this, string, this.bundle.getString("production_name"), 2);
            return false;
        }
        if (this.dbrData.l0() == 1 || this.dbrData.l0() == 4) {
            this.panel4_files.setLoadButtonTextAsNonBootstrap();
        } else if (this.dbrData.l0() == 0 || this.dbrData.l0() == 3) {
            this.panel4_files.setLoadButtonTextAsBootstrap();
        }
        if (this.dbrData.l0() == 3 || this.dbrData.l0() == 4) {
            this.panel4_files.setChooseFileButtonTextAsASMMode();
            this.panel4_files.initAsASMMode();
        } else {
            this.panel4_files.setChooseFileButtonTextAsDBFMode();
            this.panel4_files.initAsDBFMode();
        }
        this.panel4_files.setDefaultBlockSize((Integer)this.panel3_setup.getComboBox_blockSize().getSelectedItem());
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.panel3_setup.getTextField_offset().getText().trim());
        }
        catch (Exception exception) {
            n2 = 0;
        }
        this.panel4_files.setDefaultOffset(n2);
        this.panel4_files.setScanBaseTablesCheckboxStatus(this.dbrData.l0() == 0 || this.dbrData.l0() == 3);
        return true;
    }

    void showLauncherDisplay() {
        this.jButton_cancel.setVisible(false);
        this.jButton_help.setVisible(false);
        this.jButton_prev.setVisible(false);
        this.jButton_next.setVisible(false);
        this.jSeparator1.setVisible(false);
        this.isLastCardPanel = true;
        this.cardLayout.show(this.jPanel_cardLayoutController, "5");
    }
}

