/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core.general;

import com.dbrecover.DBRConfig;
import com.dbrecover.Version;
import com.dbrecover.gui.core.general.O0;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import o._l0;
import o.a_a;

public class DBROptions
extends JDialog {
    private JPanel optionPanel;
    private JButton jButton_confirm;
    private JComboBox jComboBox_charset;
    private JLabel jLabel_charset;
    private JLabel jLabel_ncharset;
    private JLabel jLabel_restrictedMode;
    private JLabel jlabel_view_row_limit;
    private JLabel jlabel_scan_row_limit;
    private JLabel jLabel_language;
    private JLabel jLabel_lob_batch_size;
    private JComboBox jComboBox_ncharset;
    private JComboBox jComboBox_restrictedMode;
    private JComboBox jComboBox_view_row_limit;
    private JComboBox jComboBox_scan_row_limit;
    private JComboBox jComboBox_language;
    private JComboBox jComboBox_lob_batch_size;
    private JLabel jLabel_info;
    private final Properties prop = new Properties();
    private final String propFile = "./config/dbrecover-oracle.conf";
    private final O0 charEncodingMap = new O0();

    public DBROptions(JFrame jFrame) {
        this.Init(jFrame);
        Iterator<String> iterator = this.charEncodingMap.O0().iterator();
        Object[] objectArray = new String[this.charEncodingMap.O0().size()];
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray[n2++] = iterator.next();
        }
        Arrays.sort(objectArray);
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.jComboBox_charset.addItem(objectArray[i2]);
        }
        this.jComboBox_charset.removeItem("AL16UTF16");
        this.jComboBox_ncharset.addItem("AL16UTF16");
        this.jComboBox_ncharset.addItem("UTF8");
        Version.ensureConfigFileExists();
        try {
            Object object;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream("./config/dbrecover-oracle.conf"), 8192);
            this.prop.load(bufferedInputStream);
            bufferedInputStream.close();
            if (this.prop.getProperty("IsRestrictMode", "yes").equalsIgnoreCase("yes")) {
                this.jComboBox_restrictedMode.setSelectedItem("Restricted");
            } else {
                this.jComboBox_restrictedMode.setSelectedItem("Normal");
            }
            if (this.prop.getProperty("view_row_limit", "1000").equalsIgnoreCase("1000")) {
                this.jComboBox_view_row_limit.setSelectedItem("1000");
            } else if (this.prop.getProperty("view_row_limit", "1000").equalsIgnoreCase("10000")) {
                this.jComboBox_view_row_limit.setSelectedItem("10000");
            } else if (this.prop.getProperty("view_row_limit", "1000").equalsIgnoreCase("100000")) {
                this.jComboBox_view_row_limit.setSelectedItem("100000");
            } else if (this.prop.getProperty("view_row_limit", "1000").equalsIgnoreCase("1000000")) {
                this.jComboBox_view_row_limit.setSelectedItem("1000000");
            }
            if (this.prop.getProperty("scan_row_limit", "1000").equalsIgnoreCase("1000")) {
                this.jComboBox_scan_row_limit.setSelectedItem("1000");
            } else if (this.prop.getProperty("scan_row_limit", "1000").equalsIgnoreCase("10000")) {
                this.jComboBox_scan_row_limit.setSelectedItem("10000");
            } else if (this.prop.getProperty("scan_row_limit", "1000").equalsIgnoreCase("100000")) {
                this.jComboBox_scan_row_limit.setSelectedItem("100000");
            } else if (this.prop.getProperty("scan_row_limit", "1000").equalsIgnoreCase("1000000")) {
                this.jComboBox_scan_row_limit.setSelectedItem("1000000");
            }
            String string = this.prop.getProperty("lang");
            if (string != null && string.equalsIgnoreCase("zh_cn")) {
                this.jComboBox_language.setSelectedItem("\u4e2d\u6587 (Chinese)");
            } else if (string != null && string.equalsIgnoreCase("en_us")) {
                this.jComboBox_language.setSelectedItem("English");
            } else {
                object = Locale.getDefault();
                if (((Locale)object).getLanguage().equals(Locale.CHINESE.getLanguage())) {
                    this.jComboBox_language.setSelectedItem("\u4e2d\u6587 (Chinese)");
                } else {
                    this.jComboBox_language.setSelectedItem("English");
                }
            }
            object = this.prop.getProperty("lob_batch_size", "500");
            this.jComboBox_lob_batch_size.setSelectedItem(object);
            if (_l0.l1 != null) {
                String string2 = this.charEncodingMap._0(_l0.l1.lIl());
                String string3 = _l0.l1.Ill().equalsIgnoreCase("utf8") ? "UTF8" : this.charEncodingMap._0(_l0.l1.Ill());
                this.jComboBox_charset.setSelectedItem(string2);
                this.jComboBox_ncharset.setSelectedItem(string3);
            } else {
                this.jComboBox_charset.setEnabled(false);
                this.jComboBox_ncharset.setEnabled(false);
            }
        }
        catch (Exception exception) {
            if (DBRConfig.isRestrictCreateTableMode) {
                this.jComboBox_restrictedMode.setSelectedItem("Restricted");
            } else {
                this.jComboBox_restrictedMode.setSelectedItem("Normal");
            }
            this.jComboBox_view_row_limit.setSelectedItem(DBRConfig.UNLOAD_ROW_COUNT_FOR_VIEW_ONLY);
            this.jComboBox_scan_row_limit.setSelectedItem(DBRConfig.ROW_COUNT_FOR_SCAN_TABLES);
            Locale locale = Locale.getDefault();
            if (locale.getLanguage().equals(Locale.CHINESE.getLanguage())) {
                this.jComboBox_language.setSelectedItem("\u4e2d\u6587 (Chinese)");
            } else {
                this.jComboBox_language.setSelectedItem("English");
            }
            this.jComboBox_lob_batch_size.setSelectedItem(String.valueOf(DBRConfig.LOB_BATCH_SIZE_FOR_DATA_BRIDGE));
            this.jComboBox_charset.setEnabled(false);
            this.jComboBox_ncharset.setEnabled(false);
        }
    }

    private void jComboBox_charsetActionPerformed(ActionEvent actionEvent) {
    }

    private void jButton_confirmActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jComboBox_charset.getSelectedItem();
        String string2 = (String)this.jComboBox_ncharset.getSelectedItem();
        boolean bl2 = ((String)this.jComboBox_restrictedMode.getSelectedItem()).equalsIgnoreCase("Restricted");
        int n2 = Integer.parseInt((String)this.jComboBox_view_row_limit.getSelectedItem());
        int n3 = Integer.parseInt((String)this.jComboBox_scan_row_limit.getSelectedItem());
        try {
            int n4 = Integer.parseInt((String)this.jComboBox_lob_batch_size.getSelectedItem());
            System.err.println("Now change restrict mode to " + bl2);
            System.err.println("Now change view row limit to " + n2);
            System.err.println("Now change scan row limit to " + n3);
            System.err.println("Now change LOB batch size to " + n4);
            DBRConfig.isRestrictCreateTableMode = bl2;
            DBRConfig.UNLOAD_ROW_COUNT_FOR_VIEW_ONLY = n2;
            DBRConfig.ROW_COUNT_FOR_SCAN_TABLES = n3;
            DBRConfig.LOB_BATCH_SIZE_FOR_DATA_BRIDGE = n4;
            a_a.h0h = n4;
            Version.ensureConfigDirExists();
            FileOutputStream fileOutputStream = new FileOutputStream("./config/dbrecover-oracle.conf");
            String string3 = ((String)this.jComboBox_restrictedMode.getSelectedItem()).equalsIgnoreCase("Restricted") ? "yes" : "no";
            this.prop.setProperty("IsRestrictMode", string3);
            this.prop.setProperty("view_row_limit", (String)this.jComboBox_view_row_limit.getSelectedItem());
            this.prop.setProperty("scan_row_limit", (String)this.jComboBox_scan_row_limit.getSelectedItem());
            String string4 = (String)this.jComboBox_language.getSelectedItem();
            String string5 = string4.contains("Chinese") ? "zh_cn" : "en_us";
            this.prop.setProperty("lang", string5);
            this.prop.setProperty("lob_batch_size", (String)this.jComboBox_lob_batch_size.getSelectedItem());
            this.prop.store(fileOutputStream, "config by DBRECOVER");
            fileOutputStream.close();
            if (_l0.l1 != null) {
                _l0.l1.l(this.charEncodingMap._1(string));
                _l0.l1.I(this.charEncodingMap._1(string2));
                System.err.println("Now will temporarily set character set to " + string + ":" + this.charEncodingMap._1(string) + ", national character set to " + string2 + ":" + this.charEncodingMap._1(string2));
                System.err.println("But this will reset to default after restart");
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to save configuration: " + exception.getMessage());
        }
        this.setVisible(false);
        this.dispose();
    }

    private void jComboBox_restrictedModeActionPerformed(ActionEvent actionEvent) {
    }

    private void Init(JFrame jFrame) {
        this.optionPanel = new JPanel();
        this.jButton_confirm = new JButton();
        this.jComboBox_charset = new JComboBox();
        this.jComboBox_ncharset = new JComboBox();
        this.jComboBox_restrictedMode = new JComboBox();
        this.jComboBox_view_row_limit = new JComboBox();
        this.jComboBox_scan_row_limit = new JComboBox();
        this.jComboBox_language = new JComboBox();
        this.jComboBox_lob_batch_size = new JComboBox();
        this.jLabel_charset = new JLabel();
        this.jLabel_ncharset = new JLabel();
        this.jLabel_restrictedMode = new JLabel();
        this.jlabel_view_row_limit = new JLabel();
        this.jlabel_scan_row_limit = new JLabel();
        this.jLabel_language = new JLabel();
        this.jLabel_lob_batch_size = new JLabel();
        this.jLabel_info = new JLabel();
        this.setTitle("DBRecover Options");
        Font font = new Font("Dialog", 0, 13);
        Font font2 = new Font("Dialog", 0, 13);
        Font font3 = new Font("Dialog", 1, 12);
        Color color = new Color(0, 120, 215);
        this.optionPanel.setLayout(new BorderLayout(0, 15));
        this.optionPanel.setBorder(BorderFactory.createEmptyBorder(20, 25, 20, 25));
        this.optionPanel.setBackground(Color.WHITE);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(200, 200, 200), 1, true), " Character Encoding ", 1, 2, font3, new Color(80, 80, 80)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 15, 12, 15);
        gridBagConstraints.anchor = 17;
        this.jLabel_charset.setText("NLS_CHARACTERSET");
        this.jLabel_charset.setFont(font);
        this.jLabel_ncharset.setText("NLS_NCHAR_CHARACTERSET");
        this.jLabel_ncharset.setFont(font);
        this.jComboBox_charset.setFont(font2);
        this.jComboBox_charset.setPreferredSize(new Dimension(180, 32));
        this.jComboBox_ncharset.setFont(font2);
        this.jComboBox_ncharset.setPreferredSize(new Dimension(180, 32));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.4;
        jPanel.add((Component)this.jLabel_charset, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.jComboBox_charset, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.jLabel_ncharset, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.jComboBox_ncharset, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(200, 200, 200), 1, true), " Runtime Settings ", 1, 2, font3, new Color(80, 80, 80)));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(10, 15, 10, 15);
        gridBagConstraints2.anchor = 17;
        this.jLabel_restrictedMode.setText("Create Table Mode");
        this.jLabel_restrictedMode.setFont(font);
        this.jlabel_view_row_limit.setText("View Row Limit");
        this.jlabel_view_row_limit.setFont(font);
        this.jlabel_scan_row_limit.setText("Scan Row Limit");
        this.jlabel_scan_row_limit.setFont(font);
        this.jLabel_language.setText("Display Language / \u663e\u793a\u8bed\u8a00");
        this.jLabel_language.setFont(font);
        this.jLabel_lob_batch_size.setText("LOB Batch Size / LOB\u6279\u5904\u7406\u5927\u5c0f");
        this.jLabel_lob_batch_size.setFont(font);
        this.jComboBox_restrictedMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal", "Restricted"}));
        this.jComboBox_restrictedMode.setFont(font2);
        this.jComboBox_restrictedMode.setPreferredSize(new Dimension(180, 32));
        this.jComboBox_view_row_limit.setModel(new DefaultComboBoxModel<String>(new String[]{"1000", "10000", "100000", "1000000"}));
        this.jComboBox_view_row_limit.setFont(font2);
        this.jComboBox_view_row_limit.setPreferredSize(new Dimension(180, 32));
        this.jComboBox_scan_row_limit.setModel(new DefaultComboBoxModel<String>(new String[]{"1000", "10000", "100000", "1000000"}));
        this.jComboBox_scan_row_limit.setFont(font2);
        this.jComboBox_scan_row_limit.setPreferredSize(new Dimension(180, 32));
        this.jComboBox_language.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "\u4e2d\u6587 (Chinese)"}));
        this.jComboBox_language.setFont(font2);
        this.jComboBox_language.setPreferredSize(new Dimension(180, 32));
        this.jComboBox_lob_batch_size.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "200", "500", "1000", "2000", "5000"}));
        this.jComboBox_lob_batch_size.setFont(font2);
        this.jComboBox_lob_batch_size.setPreferredSize(new Dimension(180, 32));
        this.jComboBox_lob_batch_size.setEditable(true);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.4;
        gridBagConstraints2.fill = 0;
        jPanel2.add((Component)this.jLabel_restrictedMode, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.6;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)this.jComboBox_restrictedMode, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.4;
        gridBagConstraints2.fill = 0;
        jPanel2.add((Component)this.jlabel_view_row_limit, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.6;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)this.jComboBox_view_row_limit, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 0.4;
        gridBagConstraints2.fill = 0;
        jPanel2.add((Component)this.jlabel_scan_row_limit, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.6;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)this.jComboBox_scan_row_limit, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.weightx = 0.4;
        gridBagConstraints2.fill = 0;
        jPanel2.add((Component)this.jLabel_language, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.6;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)this.jComboBox_language, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.weightx = 0.4;
        gridBagConstraints2.fill = 0;
        jPanel2.add((Component)this.jLabel_lob_batch_size, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.6;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)this.jComboBox_lob_batch_size, gridBagConstraints2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBackground(Color.WHITE);
        jPanel3.add(jPanel);
        jPanel3.add(Box.createVerticalStrut(15));
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 0, 10));
        jPanel4.setBackground(Color.WHITE);
        this.jLabel_info.setText("<html><i style='color:#666'>Language change requires restart / \u8bed\u8a00\u66f4\u6539\u9700\u8981\u91cd\u542f\u751f\u6548</i></html>");
        this.jLabel_info.setFont(new Font("Dialog", 2, 11));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        this.jButton_confirm.setText("  " + resourceBundle.getString("text_confirm") + "  ");
        this.jButton_confirm.setFont(new Font("Dialog", 1, 13));
        this.jButton_confirm.setPreferredSize(new Dimension(120, 36));
        this.jButton_confirm.setBackground(color);
        this.jButton_confirm.setForeground(Color.WHITE);
        this.jButton_confirm.setFocusPainted(false);
        this.jButton_confirm.setBorderPainted(false);
        this.jButton_confirm.setCursor(new Cursor(12));
        JPanel jPanel5 = new JPanel(new FlowLayout(1));
        jPanel5.setBackground(Color.WHITE);
        jPanel5.add(this.jLabel_info);
        jPanel5.add(Box.createHorizontalStrut(20));
        jPanel5.add(this.jButton_confirm);
        jPanel4.add(jPanel5);
        this.optionPanel.add((Component)jPanel3, "Center");
        this.optionPanel.add((Component)jPanel4, "South");
        this.jComboBox_charset.addActionListener(actionEvent -> this.jComboBox_charsetActionPerformed(actionEvent));
        this.jComboBox_restrictedMode.addActionListener(actionEvent -> this.jComboBox_restrictedModeActionPerformed(actionEvent));
        this.jButton_confirm.addActionListener(actionEvent -> this.jButton_confirmActionPerformed(actionEvent));
        this.setContentPane(this.optionPanel);
        this.setSize(540, 590);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(jFrame);
        this.setModal(true);
    }
}

