/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core.oracle;

import com.formdev.flatlaf.extras.FlatSVGUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class OracleQueryDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle bundle;
    private final Preferences prefs;
    private Connection connection;
    private JTextField txtHost;
    private JTextField txtPort;
    private JTextField txtServiceName;
    private JTextField txtUsername;
    private JPasswordField txtPassword;
    private JCheckBox chkSysDBA;
    private JButton btnConnect;
    private JButton btnDisconnect;
    private JLabel lblConnectionStatus;
    private JTree treeDatabase;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTextArea txtSql;
    private JButton btnExecute;
    private JButton btnClear;
    private JButton btnExportCsv;
    private JComboBox<String> cmbHistory;
    private JTabbedPane resultTabs;
    private JTable tableResult;
    private DefaultTableModel tableModel;
    private JTextArea txtMessages;
    private JLabel lblStatus;
    private JLabel lblRowCount;
    private JLabel lblExecTime;
    private List<String> sqlHistory = new ArrayList<String>();
    private static final int MAX_HISTORY = 50;
    private static final String PREF_HOST = "oracle_query_host";
    private static final String PREF_PORT = "oracle_query_port";
    private static final String PREF_SERVICE = "oracle_query_service";
    private static final String PREF_USERNAME = "oracle_query_username";

    public OracleQueryDialog() {
        this.bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        this.prefs = Preferences.userNodeForPackage(OracleQueryDialog.class);
        this.initComponents();
        this.initLayout();
        this.initListeners();
        this.loadPreferences();
        this.setTitle(this.bundle.getString("oracle_query_title"));
        this.setSize(1300, 900);
        this.setMinimumSize(new Dimension(1000, 700));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        try {
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
            URL uRL = this.getClass().getResource("/com/dbrecover/gui/resources/svg/database.svg");
            if (uRL != null) {
                arrayList.add(FlatSVGUtils.svg2image(uRL, 16, 16));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 32, 32));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 64, 64));
                this.setIconImages(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.txtHost = new JTextField(15);
        this.txtHost.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.txtHost.setText("localhost");
        this.txtPort = new JTextField(6);
        this.txtPort.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.txtPort.setText("1521");
        this.txtServiceName = new JTextField(12);
        this.txtServiceName.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.txtServiceName.setText("orcl");
        this.txtUsername = new JTextField(12);
        this.txtUsername.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.txtUsername.setText("sys");
        this.txtPassword = new JPasswordField(12);
        this.txtPassword.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.chkSysDBA = new JCheckBox("SYSDBA");
        this.chkSysDBA.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.chkSysDBA.setSelected(false);
        this.btnConnect = new JButton(this.bundle.getString("oracle_query_connect"));
        this.btnConnect.putClientProperty("FlatLaf.style", "background: #28a745; foreground: #ffffff");
        this.btnDisconnect = new JButton(this.bundle.getString("oracle_query_disconnect"));
        this.btnDisconnect.setEnabled(false);
        this.lblConnectionStatus = new JLabel(this.bundle.getString("oracle_query_status_disconnected"));
        this.lblConnectionStatus.setFont(new Font("Microsoft YaHei UI", 1, 12));
        this.rootNode = new DefaultMutableTreeNode(this.bundle.getString("oracle_query_no_connection"));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeDatabase = new JTree(this.treeModel);
        this.treeDatabase.setCellRenderer(new DatabaseTreeCellRenderer());
        this.treeDatabase.setRowHeight(24);
        this.txtSql = new JTextArea(8, 80);
        this.txtSql.setFont(new Font("Microsoft YaHei UI", 0, 14));
        this.txtSql.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.txtSql.setTabSize(4);
        this.txtSql.setText("-- " + this.bundle.getString("oracle_query_sql_hint"));
        this.btnExecute = new JButton(this.bundle.getString("oracle_query_execute"));
        this.btnExecute.putClientProperty("FlatLaf.style", "background: #28a745; foreground: #ffffff");
        this.btnClear = new JButton(this.bundle.getString("oracle_query_clear"));
        this.btnExportCsv = new JButton(this.bundle.getString("oracle_query_export_csv"));
        this.btnExportCsv.setEnabled(false);
        this.cmbHistory = new JComboBox();
        this.cmbHistory.setPreferredSize(new Dimension(350, 28));
        this.cmbHistory.setFont(new Font("Microsoft YaHei UI", 0, 12));
        ((JLabel)((Object)this.cmbHistory.getRenderer())).setHorizontalAlignment(2);
        this.cmbHistory.addItem("-- " + this.bundle.getString("oracle_query_history") + " --");
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.tableResult = new JTable(this.tableModel);
        this.tableResult.setAutoResizeMode(0);
        this.tableResult.setRowHeight(26);
        this.tableResult.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.tableResult.setShowHorizontalLines(true);
        this.tableResult.setShowVerticalLines(true);
        this.tableResult.setIntercellSpacing(new Dimension(1, 1));
        this.tableResult.getTableHeader().setFont(new Font("Microsoft YaHei UI", 1, 13));
        this.tableResult.getTableHeader().setPreferredSize(new Dimension(0, 32));
        this.txtMessages = new JTextArea();
        this.txtMessages.setEditable(false);
        this.txtMessages.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.txtMessages.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.lblStatus = new JLabel(this.bundle.getString("oracle_query_ready"));
        this.lblStatus.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.lblRowCount = new JLabel(this.bundle.getString("oracle_query_rows") + ": 0");
        this.lblRowCount.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.lblExecTime = new JLabel(this.bundle.getString("oracle_query_time") + ": 0ms");
        this.lblExecTime.setFont(new Font("Microsoft YaHei UI", 0, 12));
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createConnectionPanel();
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerSize(6);
        jSplitPane.setDividerLocation(280);
        jSplitPane.setContinuousLayout(true);
        JPanel jPanel2 = this.createDatabaseTreePanel();
        jSplitPane.setLeftComponent(jPanel2);
        JPanel jPanel3 = this.createRightPanel();
        jSplitPane.setRightComponent(jPanel3);
        JPanel jPanel4 = this.createStatusBar();
        this.add((Component)jPanel, "North");
        this.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel4, "South");
    }

    private JPanel createConnectionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1), " " + this.bundle.getString("oracle_query_connection") + " ", 1, 2, new Font("Microsoft YaHei", 1, 12)));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 8, 8));
        jPanel2.add(new JLabel(this.bundle.getString(PREF_HOST) + ":"));
        jPanel2.add(this.txtHost);
        jPanel2.add(new JLabel(this.bundle.getString(PREF_PORT) + ":"));
        jPanel2.add(this.txtPort);
        jPanel2.add(new JLabel(this.bundle.getString(PREF_SERVICE) + ":"));
        jPanel2.add(this.txtServiceName);
        jPanel2.add(new JLabel(this.bundle.getString(PREF_USERNAME) + ":"));
        jPanel2.add(this.txtUsername);
        jPanel2.add(new JLabel(this.bundle.getString("oracle_query_password") + ":"));
        jPanel2.add(this.txtPassword);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.chkSysDBA);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.btnConnect);
        jPanel2.add(this.btnDisconnect);
        jPanel2.add(Box.createHorizontalStrut(20));
        jPanel2.add(this.lblConnectionStatus);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private JPanel createDatabaseTreePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1), " " + this.bundle.getString("oracle_query_structure") + " ", 1, 2, new Font("Microsoft YaHei", 1, 12)));
        JScrollPane jScrollPane = new JScrollPane(this.treeDatabase);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JButton jButton = new JButton(this.bundle.getString("oracle_query_refresh"));
        jButton.addActionListener(actionEvent -> this.refreshDatabaseStructure());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jButton);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerSize(6);
        jSplitPane.setDividerLocation(220);
        jSplitPane.setContinuousLayout(true);
        JPanel jPanel2 = this.createSqlEditorPanel();
        jSplitPane.setTopComponent(jPanel2);
        JPanel jPanel3 = this.createResultPanel();
        jSplitPane.setBottomComponent(jPanel3);
        jPanel.add((Component)jSplitPane, "Center");
        return jPanel;
    }

    private JPanel createSqlEditorPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1), " " + this.bundle.getString("oracle_query_sql_editor") + " ", 1, 2, new Font("Microsoft YaHei", 1, 12)));
        JScrollPane jScrollPane = new JScrollPane(this.txtSql);
        jScrollPane.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 8, 8));
        jPanel2.add(this.btnExecute);
        jPanel2.add(this.btnClear);
        jPanel2.add(Box.createHorizontalStrut(20));
        jPanel2.add(new JLabel(this.bundle.getString("oracle_query_history") + ":"){
            {
                this.putClientProperty("FlatLaf.styleClass", "small");
            }
        });
        jPanel2.add(this.cmbHistory);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createResultPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1), " " + this.bundle.getString("oracle_query_result") + " ", 1, 2, new Font("Microsoft YaHei", 1, 12)));
        this.resultTabs = new JTabbedPane();
        JScrollPane jScrollPane = new JScrollPane(this.tableResult);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.resultTabs.addTab(this.bundle.getString("oracle_query_data"), jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane(this.txtMessages);
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder());
        this.resultTabs.addTab(this.bundle.getString("oracle_query_messages"), jScrollPane2);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 8, 4));
        jPanel2.add(this.btnExportCsv);
        jPanel.add((Component)this.resultTabs, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createStatusBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Component.borderColor")));
        jPanel.setPreferredSize(new Dimension(0, 28));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 12, 4));
        jPanel2.add(this.lblStatus);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 20, 4));
        jPanel3.add(this.lblRowCount);
        jPanel3.add(this.lblExecTime);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private void initListeners() {
        this.btnConnect.addActionListener(actionEvent -> this.connectToDatabase());
        this.btnDisconnect.addActionListener(actionEvent -> this.disconnectFromDatabase());
        this.btnExecute.addActionListener(actionEvent -> this.executeSql());
        this.btnClear.addActionListener(actionEvent -> {
            this.txtSql.setText("");
            this.txtSql.requestFocus();
        });
        this.btnExportCsv.addActionListener(actionEvent -> this.exportToCsv());
        this.cmbHistory.addActionListener(actionEvent -> {
            int n2 = this.cmbHistory.getSelectedIndex();
            if (n2 > 0 && n2 <= this.sqlHistory.size()) {
                this.txtSql.setText(this.sqlHistory.get(n2 - 1));
            }
        });
        this.treeDatabase.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    OracleQueryDialog.this.onTreeDoubleClick();
                }
            }
        });
        this.txtSql.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 116 || keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                    OracleQueryDialog.this.executeSql();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                OracleQueryDialog.this.savePreferences();
                OracleQueryDialog.this.disconnectFromDatabase();
            }
        });
    }

    private void connectToDatabase() {
        final String string = this.txtHost.getText().trim();
        final String string2 = this.txtPort.getText().trim();
        final String string3 = this.txtServiceName.getText().trim();
        final String string4 = this.txtUsername.getText().trim();
        final String string5 = new String(this.txtPassword.getPassword());
        if (string.isEmpty() || string2.isEmpty() || string3.isEmpty() || string4.isEmpty()) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("oracle_query_fill_all"), this.bundle.getString("oracle_query_error"), 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.lblStatus.setText(this.bundle.getString("oracle_query_connecting"));
        final boolean bl2 = this.chkSysDBA.isSelected();
        SwingWorker<Connection, Void> swingWorker = new SwingWorker<Connection, Void>(){

            protected Connection l1() throws Exception {
                String string6 = String.format("jdbc:oracle:thin:@//%s:%s/%s", string, string2, string3);
                Class.forName("oracle.jdbc.driver.OracleDriver");
                Properties properties = new Properties();
                properties.setProperty("user", string4);
                properties.setProperty("password", string5);
                if (bl2) {
                    properties.setProperty("internal_logon", "SYSDBA");
                }
                return DriverManager.getConnection(string6, properties);
            }

            @Override
            protected void done() {
                OracleQueryDialog.this.setCursor(Cursor.getDefaultCursor());
                try {
                    OracleQueryDialog.this.connection = (Connection)this.get();
                    OracleQueryDialog.this.btnConnect.setEnabled(false);
                    OracleQueryDialog.this.btnDisconnect.setEnabled(true);
                    OracleQueryDialog.this.txtHost.setEnabled(false);
                    OracleQueryDialog.this.txtPort.setEnabled(false);
                    OracleQueryDialog.this.txtServiceName.setEnabled(false);
                    OracleQueryDialog.this.txtUsername.setEnabled(false);
                    OracleQueryDialog.this.txtPassword.setEnabled(false);
                    OracleQueryDialog.this.chkSysDBA.setEnabled(false);
                    OracleQueryDialog.this.lblConnectionStatus.setText(OracleQueryDialog.this.bundle.getString("oracle_query_status_connected"));
                    OracleQueryDialog.this.lblConnectionStatus.setForeground(new Color(40, 167, 69));
                    OracleQueryDialog.this.lblStatus.setText(OracleQueryDialog.this.bundle.getString("oracle_query_connected_to") + " " + string + ":" + string2 + "/" + string3);
                    OracleQueryDialog.this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
                    OracleQueryDialog.this.appendMessage("[OK] " + OracleQueryDialog.this.bundle.getString("oracle_query_connected_to") + " " + string + ":" + string2 + "/" + string3);
                    OracleQueryDialog.this.appendMessage("  " + OracleQueryDialog.this.bundle.getString(OracleQueryDialog.PREF_USERNAME) + ": " + string4);
                    try {
                        DatabaseMetaData databaseMetaData = OracleQueryDialog.this.connection.getMetaData();
                        OracleQueryDialog.this.appendMessage("  " + OracleQueryDialog.this.bundle.getString("oracle_query_db_version") + ": " + databaseMetaData.getDatabaseProductVersion());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    OracleQueryDialog.this.refreshDatabaseStructure();
                }
                catch (Exception exception) {
                    OracleQueryDialog.this.lblStatus.setText(OracleQueryDialog.this.bundle.getString("oracle_query_connect_failed"));
                    OracleQueryDialog.this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
                    OracleQueryDialog.this.lblConnectionStatus.setText(OracleQueryDialog.this.bundle.getString("oracle_query_status_disconnected"));
                    OracleQueryDialog.this.lblConnectionStatus.setForeground(Color.RED);
                    OracleQueryDialog.this.appendMessage("[ERROR] " + OracleQueryDialog.this.bundle.getString("oracle_query_connect_failed") + ": " + exception.getMessage());
                    JOptionPane.showMessageDialog(OracleQueryDialog.this, OracleQueryDialog.this.bundle.getString("oracle_query_connect_failed") + "\n" + exception.getMessage(), OracleQueryDialog.this.bundle.getString("oracle_query_error"), 0);
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.l1();
            }
        };
        swingWorker.execute();
    }

    private void disconnectFromDatabase() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.btnConnect.setEnabled(true);
                this.btnDisconnect.setEnabled(false);
                this.txtHost.setEnabled(true);
                this.txtPort.setEnabled(true);
                this.txtServiceName.setEnabled(true);
                this.txtUsername.setEnabled(true);
                this.txtPassword.setEnabled(true);
                this.chkSysDBA.setEnabled(true);
                this.lblConnectionStatus.setText(this.bundle.getString("oracle_query_status_disconnected"));
                this.lblConnectionStatus.setForeground(UIManager.getColor("Label.foreground"));
                this.rootNode.removeAllChildren();
                this.rootNode.setUserObject(this.bundle.getString("oracle_query_no_connection"));
                this.treeModel.reload();
                this.tableModel.setRowCount(0);
                this.tableModel.setColumnCount(0);
                this.lblStatus.setText(this.bundle.getString("oracle_query_disconnected"));
                this.lblRowCount.setText(this.bundle.getString("oracle_query_rows") + ": 0");
                this.appendMessage("[X] " + this.bundle.getString("oracle_query_disconnected"));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                this.appendMessage("[ERROR] " + sQLException.getMessage());
            }
        }
    }

    private void refreshDatabaseStructure() {
        if (this.connection == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            protected Void O0() throws Exception {
                OracleQueryDialog.this.rootNode.removeAllChildren();
                try {
                    AutoCloseable autoCloseable;
                    String string = "";
                    try (Object object = OracleQueryDialog.this.connection.createStatement();){
                        autoCloseable = object.executeQuery("SELECT USER FROM DUAL");
                        try {
                            if (autoCloseable.next()) {
                                string = autoCloseable.getString(1);
                            }
                        }
                        finally {
                            if (autoCloseable != null) {
                                autoCloseable.close();
                            }
                        }
                    }
                    OracleQueryDialog.this.rootNode.setUserObject("Oracle - " + string);
                    object = new DefaultMutableTreeNode(OracleQueryDialog.this.bundle.getString("oracle_query_users"));
                    autoCloseable = OracleQueryDialog.this.connection.createStatement();
                    try (ResultSet resultSet = autoCloseable.executeQuery("SELECT DISTINCT OWNER FROM ALL_TABLES ORDER BY OWNER");){
                        while (resultSet.next()) {
                            AutoCloseable autoCloseable2;
                            String string2 = resultSet.getString("OWNER");
                            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
                            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(OracleQueryDialog.this.bundle.getString("oracle_query_tables"));
                            try (Object object = OracleQueryDialog.this.connection.createStatement();){
                                autoCloseable2 = object.executeQuery("SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER = '" + string2 + "' ORDER BY TABLE_NAME");
                                try {
                                    int n2;
                                    for (n2 = 0; autoCloseable2.next() && n2 < 100; ++n2) {
                                        String string3 = autoCloseable2.getString("TABLE_NAME");
                                        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(string3));
                                    }
                                    if (n2 >= 100) {
                                        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("... (" + OracleQueryDialog.this.bundle.getString("oracle_query_more") + ")"));
                                    }
                                }
                                finally {
                                    if (autoCloseable2 != null) {
                                        autoCloseable2.close();
                                    }
                                }
                            }
                            object = new DefaultMutableTreeNode(OracleQueryDialog.this.bundle.getString("oracle_query_views"));
                            autoCloseable2 = OracleQueryDialog.this.connection.createStatement();
                            try (ResultSet resultSet2 = autoCloseable2.executeQuery("SELECT VIEW_NAME FROM ALL_VIEWS WHERE OWNER = '" + string2 + "' ORDER BY VIEW_NAME");){
                                for (int i2 = 0; resultSet2.next() && i2 < 50; ++i2) {
                                    String string4 = resultSet2.getString("VIEW_NAME");
                                    ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(string4));
                                }
                            }
                            finally {
                                if (autoCloseable2 != null) {
                                    autoCloseable2.close();
                                }
                            }
                            if (defaultMutableTreeNode2.getChildCount() > 0) {
                                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                            }
                            if (((DefaultMutableTreeNode)object).getChildCount() > 0) {
                                defaultMutableTreeNode.add((MutableTreeNode)object);
                            }
                            if (defaultMutableTreeNode.getChildCount() <= 0) continue;
                            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
                        }
                    }
                    finally {
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    OracleQueryDialog.this.rootNode.add((MutableTreeNode)object);
                }
                catch (SQLException sQLException) {
                    OracleQueryDialog.this.appendMessage("[ERROR] " + OracleQueryDialog.this.bundle.getString("oracle_query_load_structure_failed") + ": " + sQLException.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                OracleQueryDialog.this.setCursor(Cursor.getDefaultCursor());
                OracleQueryDialog.this.treeModel.reload();
                OracleQueryDialog.this.treeDatabase.expandRow(0);
                if (OracleQueryDialog.this.treeDatabase.getRowCount() > 1) {
                    OracleQueryDialog.this.treeDatabase.expandRow(1);
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void executeSql() {
        boolean bl2;
        if (this.connection == null) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("oracle_query_no_connection_msg"), this.bundle.getString("oracle_query_error"), 2);
            return;
        }
        String string = this.txtSql.getSelectedText();
        if (string == null || string.trim().isEmpty()) {
            string = this.txtSql.getText().trim();
        }
        if (string.isEmpty() || string.startsWith("--")) {
            return;
        }
        String string2 = string.toUpperCase().trim();
        boolean bl3 = bl2 = string2.startsWith("BEGIN") || string2.startsWith("DECLARE");
        if (!bl2 && string.endsWith(";")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        this.addToHistory(string);
        final String string3 = string;
        final long l2 = System.currentTimeMillis();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.lblStatus.setText(this.bundle.getString("oracle_query_executing"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private boolean g0 = false;
            private boolean h0 = false;
            private int dX = 0;
            private String eeea = null;
            private Exception O0 = null;

            protected Void O0() {
                try {
                    Statement statement = OracleQueryDialog.this.connection.createStatement();
                    statement.setFetchSize(1000);
                    String string = string3.toUpperCase().trim();
                    if (string.startsWith("BEGIN") || string.startsWith("DECLARE")) {
                        this.h0 = true;
                        this.g0 = false;
                        statement.execute(string3);
                        this.eeea = OracleQueryDialog.this.bundle.getString("oracle_query_plsql_success");
                    } else if (string.startsWith("SELECT") || string.startsWith("WITH") || string.startsWith("EXPLAIN") || string.startsWith("SHOW")) {
                        this.g0 = true;
                        ResultSet resultSet = statement.executeQuery(string3);
                        OracleQueryDialog.this.displayResultSet(resultSet);
                        resultSet.close();
                    } else if (string.startsWith("CALL") || string.startsWith("EXEC")) {
                        this.h0 = true;
                        this.g0 = false;
                        statement.execute(string3);
                        this.eeea = OracleQueryDialog.this.bundle.getString("oracle_query_plsql_success");
                    } else {
                        this.g0 = false;
                        this.dX = statement.executeUpdate(string3);
                    }
                    statement.close();
                }
                catch (Exception exception) {
                    this.O0 = exception;
                }
                return null;
            }

            @Override
            protected void done() {
                OracleQueryDialog.this.setCursor(Cursor.getDefaultCursor());
                long l22 = System.currentTimeMillis() - l2;
                OracleQueryDialog.this.lblExecTime.setText(OracleQueryDialog.this.bundle.getString("oracle_query_time") + ": " + l22 + "ms");
                if (this.O0 != null) {
                    OracleQueryDialog.this.lblStatus.setText(OracleQueryDialog.this.bundle.getString("oracle_query_error"));
                    OracleQueryDialog.this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
                    String string = this.O0.getMessage();
                    if (string != null) {
                        string = string.replace("\n", "\n       ");
                    }
                    OracleQueryDialog.this.appendMessage("[ERROR] " + string);
                    OracleQueryDialog.this.resultTabs.setSelectedIndex(1);
                } else {
                    if (this.g0) {
                        OracleQueryDialog.this.resultTabs.setSelectedIndex(0);
                    } else if (this.h0) {
                        OracleQueryDialog.this.appendMessage("[OK] " + this.eeea);
                        OracleQueryDialog.this.lblRowCount.setText(OracleQueryDialog.this.bundle.getString("oracle_query_plsql_success"));
                        OracleQueryDialog.this.resultTabs.setSelectedIndex(1);
                    } else {
                        OracleQueryDialog.this.appendMessage("[OK] " + OracleQueryDialog.this.bundle.getString("oracle_query_rows_affected") + ": " + this.dX);
                        OracleQueryDialog.this.lblRowCount.setText(OracleQueryDialog.this.bundle.getString("oracle_query_rows_affected") + ": " + this.dX);
                        OracleQueryDialog.this.resultTabs.setSelectedIndex(1);
                    }
                    OracleQueryDialog.this.lblStatus.setText(OracleQueryDialog.this.bundle.getString("oracle_query_success"));
                    OracleQueryDialog.this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void displayResultSet(ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        Vector<String> vector = new Vector<String>();
        for (n2 = 1; n2 <= n3; ++n2) {
            vector.add(resultSetMetaData.getColumnName(n2));
        }
        SwingUtilities.invokeLater(() -> {
            this.tableModel.setRowCount(0);
            this.tableModel.setColumnCount(0);
            this.tableModel.setColumnIdentifiers(vector);
        });
        int n4 = 10000;
        ArrayList arrayList = new ArrayList();
        for (n2 = 0; resultSet.next() && n2 < n4; ++n2) {
            Vector<Object> vector2 = new Vector<Object>();
            for (int i2 = 1; i2 <= n3; ++i2) {
                Object object;
                Object object2 = resultSet.getObject(i2);
                if (object2 instanceof Clob) {
                    object = (Clob)object2;
                    try {
                        String string = object.getSubString(1L, Math.min(1000, (int)object.length()));
                        vector2.add(object.length() > 1000L ? string + "..." : string);
                    }
                    catch (Exception exception) {
                        vector2.add("[CLOB]");
                    }
                    continue;
                }
                if (object2 instanceof Blob) {
                    object = (Blob)object2;
                    vector2.add("[BLOB: " + object.length() + " bytes]");
                    continue;
                }
                if (object2 instanceof byte[]) {
                    object = (byte[])object2;
                    if (((Object)object).length > 100) {
                        vector2.add("[BYTES: " + ((Object)object).length + " bytes]");
                        continue;
                    }
                    vector2.add(this.bytesToHex((byte[])object));
                    continue;
                }
                vector2.add(object2);
            }
            arrayList.add(vector2);
        }
        int n5 = n2;
        SwingUtilities.invokeLater(() -> {
            for (Vector vector : arrayList) {
                this.tableModel.addRow(vector);
            }
            this.autoResizeColumns();
            this.lblRowCount.setText(this.bundle.getString("oracle_query_rows") + ": " + n5 + (String)(n5 >= n4 ? " (" + this.bundle.getString("oracle_query_limited") + ")" : ""));
            this.btnExportCsv.setEnabled(n5 > 0);
            this.appendMessage("[OK] " + this.bundle.getString("oracle_query_query_result") + ": " + n5 + " " + this.bundle.getString("oracle_query_rows"));
        });
    }

    private void autoResizeColumns() {
        for (int i2 = 0; i2 < this.tableResult.getColumnCount(); ++i2) {
            int n2 = 100;
            n2 = Math.max(n2, this.tableResult.getColumnModel().getColumn(i2).getHeaderValue().toString().length() * 10 + 20);
            for (int i3 = 0; i3 < Math.min(100, this.tableResult.getRowCount()); ++i3) {
                Object object = this.tableResult.getValueAt(i3, i2);
                if (object == null) continue;
                n2 = Math.max(n2, Math.min(400, object.toString().length() * 8 + 20));
            }
            this.tableResult.getColumnModel().getColumn(i2).setPreferredWidth(n2);
        }
    }

    private void exportToCsv() {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.bundle.getString("oracle_query_export_csv"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter("CSV Files (*.csv)", "csv"));
        jFileChooser.setSelectedFile(new File("oracle_query_result.csv"));
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            try (PrintWriter printWriter = new PrintWriter(file, "UTF-8");){
                int n2;
                printWriter.write(65279);
                StringBuilder stringBuilder = new StringBuilder();
                for (n2 = 0; n2 < this.tableModel.getColumnCount(); ++n2) {
                    if (n2 > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\"").append(this.tableModel.getColumnName(n2)).append("\"");
                }
                printWriter.println(stringBuilder);
                for (n2 = 0; n2 < this.tableModel.getRowCount(); ++n2) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int i2 = 0; i2 < this.tableModel.getColumnCount(); ++i2) {
                        Object object;
                        if (i2 > 0) {
                            stringBuilder2.append(",");
                        }
                        if ((object = this.tableModel.getValueAt(n2, i2)) == null) continue;
                        String string = object.toString().replace("\"", "\"\"");
                        stringBuilder2.append("\"").append(string).append("\"");
                    }
                    printWriter.println(stringBuilder2);
                }
                JOptionPane.showMessageDialog(this, this.bundle.getString("oracle_query_export_success") + "\n" + file.getAbsolutePath(), this.bundle.getString("oracle_query_title"), 1);
                this.appendMessage("[OK] " + this.bundle.getString("oracle_query_export_success") + ": " + file.getAbsolutePath());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("oracle_query_export_failed") + "\n" + exception.getMessage(), this.bundle.getString("oracle_query_error"), 0);
            }
        }
    }

    private void onTreeDoubleClick() {
        String string;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeDatabase.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getParent() == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        String string2 = defaultMutableTreeNode2.getUserObject().toString();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
        if (defaultMutableTreeNode3 == null) {
            return;
        }
        String string3 = defaultMutableTreeNode3.getUserObject().toString();
        if ((string2.contains(this.bundle.getString("oracle_query_tables")) || string2.contains(this.bundle.getString("oracle_query_views"))) && !(string = defaultMutableTreeNode.getUserObject().toString()).startsWith("...")) {
            this.txtSql.setText("SELECT * FROM " + string3 + "." + string + " WHERE ROWNUM <= 1000");
            this.executeSql();
        }
    }

    private void addToHistory(String string) {
        if ((string = string.trim()).isEmpty()) {
            return;
        }
        this.sqlHistory.remove(string);
        this.sqlHistory.add(0, string);
        while (this.sqlHistory.size() > 50) {
            this.sqlHistory.remove(this.sqlHistory.size() - 1);
        }
        this.cmbHistory.removeAllItems();
        this.cmbHistory.addItem("-- " + this.bundle.getString("oracle_query_history") + " --");
        for (String string2 : this.sqlHistory) {
            String string3 = string2.length() > 80 ? string2.substring(0, 80) + "..." : string2;
            this.cmbHistory.addItem(string3);
        }
    }

    private void appendMessage(String string) {
        SwingUtilities.invokeLater(() -> {
            this.txtMessages.append(string + "\n");
            this.txtMessages.setCaretPosition(this.txtMessages.getDocument().getLength());
        });
    }

    private void loadPreferences() {
        this.txtHost.setText(this.prefs.get(PREF_HOST, "localhost"));
        this.txtPort.setText(this.prefs.get(PREF_PORT, "1521"));
        this.txtServiceName.setText(this.prefs.get(PREF_SERVICE, "orcl"));
        this.txtUsername.setText(this.prefs.get(PREF_USERNAME, "sys"));
    }

    private void savePreferences() {
        this.prefs.put(PREF_HOST, this.txtHost.getText().trim());
        this.prefs.put(PREF_PORT, this.txtPort.getText().trim());
        this.prefs.put(PREF_SERVICE, this.txtServiceName.getText().trim());
        this.prefs.put(PREF_USERNAME, this.txtUsername.getText().trim());
    }

    private String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("0x");
        for (byte by2 : byArray) {
            stringBuilder.append(String.format("%02X", by2));
        }
        return stringBuilder.toString();
    }

    public static void showDialog() {
        OracleQueryDialog oracleQueryDialog = new OracleQueryDialog();
        oracleQueryDialog.setVisible(true);
    }

    private class DatabaseTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private DatabaseTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            this.setIcon(null);
            return this;
        }
    }
}

