/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core.sqlite;

import com.formdev.flatlaf.extras.FlatSVGUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class SQLiteBrowserDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle bundle;
    private Connection connection;
    private String currentDbPath;
    private JTextField txtDbPath;
    private JButton btnOpen;
    private JButton btnRefresh;
    private JButton btnClose;
    private JTree treeDatabase;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTextArea txtSql;
    private JButton btnExecute;
    private JButton btnClear;
    private JButton btnExportCsv;
    private JComboBox<String> cmbHistory;
    private JTabbedPane resultTabs;
    private JTable tableResult;
    private DefaultTableModel tableModel;
    private JTextArea txtMessages;
    private JLabel lblStatus;
    private JLabel lblRowCount;
    private JLabel lblExecTime;
    private List<String> sqlHistory = new ArrayList<String>();
    private static final int MAX_HISTORY = 50;

    public SQLiteBrowserDialog() {
        this.bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        this.initComponents();
        this.initLayout();
        this.initListeners();
        this.setTitle(this.bundle.getString("sqlite_browser_title"));
        this.setSize(1200, 800);
        this.setMinimumSize(new Dimension(900, 600));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        try {
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
            URL uRL = this.getClass().getResource("/com/dbrecover/gui/resources/svg/database.svg");
            if (uRL != null) {
                arrayList.add(FlatSVGUtils.svg2image(uRL, 16, 16));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 32, 32));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 64, 64));
                this.setIconImages(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.loadRecentDbDirectory();
    }

    private void initComponents() {
        this.txtDbPath = new JTextField(50);
        this.txtDbPath.setEditable(false);
        this.txtDbPath.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.btnOpen = new JButton(this.bundle.getString("sqlite_browser_open"));
        this.btnRefresh = new JButton(this.bundle.getString("sqlite_browser_refresh"));
        this.btnRefresh.setEnabled(false);
        this.btnClose = new JButton(this.bundle.getString("sqlite_browser_close_db"));
        this.btnClose.setEnabled(false);
        this.rootNode = new DefaultMutableTreeNode(this.bundle.getString("sqlite_browser_no_database"));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeDatabase = new JTree(this.treeModel);
        this.treeDatabase.setCellRenderer(new DatabaseTreeCellRenderer());
        this.treeDatabase.setRowHeight(24);
        this.txtSql = new JTextArea(6, 80);
        this.txtSql.setFont(new Font("Microsoft YaHei UI", 1, 14));
        this.txtSql.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.txtSql.setTabSize(4);
        this.txtSql.setText("-- " + this.bundle.getString("sqlite_browser_sql_hint"));
        this.btnExecute = new JButton(this.bundle.getString("sqlite_browser_execute"));
        this.btnExecute.putClientProperty("FlatLaf.style", "background: #28a745; foreground: #ffffff");
        this.btnClear = new JButton(this.bundle.getString("sqlite_browser_clear"));
        this.btnExportCsv = new JButton(this.bundle.getString("sqlite_browser_export_csv"));
        this.btnExportCsv.setEnabled(false);
        this.cmbHistory = new JComboBox();
        this.cmbHistory.setPreferredSize(new Dimension(300, 28));
        this.cmbHistory.setFont(new Font("Microsoft YaHei UI", 0, 12));
        ((JLabel)((Object)this.cmbHistory.getRenderer())).setHorizontalAlignment(2);
        this.cmbHistory.addItem("-- " + this.bundle.getString("sqlite_browser_history") + " --");
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.tableResult = new JTable(this.tableModel);
        this.tableResult.setAutoResizeMode(0);
        this.tableResult.setRowHeight(26);
        this.tableResult.setFont(new Font("Microsoft YaHei UI", 0, 13));
        this.tableResult.setShowHorizontalLines(true);
        this.tableResult.setShowVerticalLines(true);
        this.tableResult.setIntercellSpacing(new Dimension(1, 1));
        this.tableResult.getTableHeader().setFont(new Font("Microsoft YaHei UI", 1, 13));
        this.tableResult.getTableHeader().setPreferredSize(new Dimension(0, 32));
        this.txtMessages = new JTextArea();
        this.txtMessages.setEditable(false);
        this.txtMessages.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.txtMessages.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.lblStatus = new JLabel(this.bundle.getString("sqlite_browser_ready"));
        this.lblStatus.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.lblRowCount = new JLabel(this.bundle.getString("sqlite_browser_rows") + ": 0");
        this.lblRowCount.setFont(new Font("Microsoft YaHei UI", 0, 12));
        this.lblExecTime = new JLabel(this.bundle.getString("sqlite_browser_time") + ": 0ms");
        this.lblExecTime.setFont(new Font("Microsoft YaHei UI", 0, 12));
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createToolbarPanel();
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerSize(6);
        jSplitPane.setDividerLocation(280);
        jSplitPane.setContinuousLayout(true);
        JPanel jPanel2 = this.createDatabaseTreePanel();
        jSplitPane.setLeftComponent(jPanel2);
        JPanel jPanel3 = this.createRightPanel();
        jSplitPane.setRightComponent(jPanel3);
        JPanel jPanel4 = this.createStatusBar();
        this.add((Component)jPanel, "North");
        this.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel4, "South");
    }

    private JPanel createToolbarPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Component.borderColor")));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 8, 8));
        JLabel jLabel = new JLabel(this.bundle.getString("sqlite_browser_database") + ":");
        jLabel.setFont(new Font("Microsoft YaHei", 0, 12));
        jPanel2.add(jLabel);
        jPanel2.add(this.txtDbPath);
        jPanel2.add(this.btnOpen);
        jPanel2.add(this.btnRefresh);
        jPanel2.add(this.btnClose);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private JPanel createDatabaseTreePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1), " " + this.bundle.getString("sqlite_browser_structure") + " ", 1, 2, new Font("Microsoft YaHei", 1, 12)));
        JScrollPane jScrollPane = new JScrollPane(this.treeDatabase);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerSize(6);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setContinuousLayout(true);
        JPanel jPanel2 = this.createSqlEditorPanel();
        jSplitPane.setTopComponent(jPanel2);
        JPanel jPanel3 = this.createResultPanel();
        jSplitPane.setBottomComponent(jPanel3);
        jPanel.add((Component)jSplitPane, "Center");
        return jPanel;
    }

    private JPanel createSqlEditorPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1), " " + this.bundle.getString("sqlite_browser_sql_editor") + " ", 1, 2, new Font("Microsoft YaHei", 1, 12)));
        JScrollPane jScrollPane = new JScrollPane(this.txtSql);
        jScrollPane.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 8, 8));
        jPanel2.add(this.btnExecute);
        jPanel2.add(this.btnClear);
        jPanel2.add(Box.createHorizontalStrut(20));
        jPanel2.add(new JLabel(this.bundle.getString("sqlite_browser_history") + ":"){
            {
                this.putClientProperty("FlatLaf.styleClass", "small");
            }
        });
        jPanel2.add(this.cmbHistory);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createResultPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getColor("Component.borderColor"), 1), " " + this.bundle.getString("sqlite_browser_result") + " ", 1, 2, new Font("Microsoft YaHei", 1, 12)));
        this.resultTabs = new JTabbedPane();
        JScrollPane jScrollPane = new JScrollPane(this.tableResult);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.resultTabs.addTab(this.bundle.getString("sqlite_browser_data"), jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane(this.txtMessages);
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder());
        this.resultTabs.addTab(this.bundle.getString("sqlite_browser_messages"), jScrollPane2);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 8, 4));
        jPanel2.add(this.btnExportCsv);
        jPanel.add((Component)this.resultTabs, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createStatusBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Component.borderColor")));
        jPanel.setPreferredSize(new Dimension(0, 28));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 12, 4));
        jPanel2.add(this.lblStatus);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 20, 4));
        jPanel3.add(this.lblRowCount);
        jPanel3.add(this.lblExecTime);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private void initListeners() {
        this.btnOpen.addActionListener(actionEvent -> this.openDatabase());
        this.btnRefresh.addActionListener(actionEvent -> this.refreshDatabase());
        this.btnClose.addActionListener(actionEvent -> this.closeDatabase());
        this.btnExecute.addActionListener(actionEvent -> this.executeSql());
        this.btnClear.addActionListener(actionEvent -> {
            this.txtSql.setText("");
            this.txtSql.requestFocus();
        });
        this.btnExportCsv.addActionListener(actionEvent -> this.exportToCsv());
        this.cmbHistory.addActionListener(actionEvent -> {
            int n2 = this.cmbHistory.getSelectedIndex();
            if (n2 > 0 && n2 <= this.sqlHistory.size()) {
                this.txtSql.setText(this.sqlHistory.get(n2 - 1));
            }
        });
        this.treeDatabase.addTreeSelectionListener(this::onTreeSelectionChanged);
        this.treeDatabase.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SQLiteBrowserDialog.this.onTreeDoubleClick();
                }
            }
        });
        this.txtSql.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                    SQLiteBrowserDialog.this.executeSql();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SQLiteBrowserDialog.this.closeDatabase();
            }
        });
    }

    private void openDatabase() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.bundle.getString("sqlite_browser_select_db"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter("SQLite Database (*.db, *.sqlite, *.sqlite3)", "db", "sqlite", "sqlite3"));
        File file = new File("./db");
        if (file.exists() && file.isDirectory()) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.loadDatabase(file2.getAbsolutePath());
        }
    }

    private void loadDatabase(String string) {
        this.closeDatabase();
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + string);
            this.currentDbPath = string;
            this.txtDbPath.setText(string);
            this.btnRefresh.setEnabled(true);
            this.btnClose.setEnabled(true);
            this.loadDatabaseStructure();
            File file = new File(string);
            this.lblStatus.setText(this.bundle.getString("sqlite_browser_connected") + ": " + file.getName());
            this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
            this.appendMessage("[OK] " + this.bundle.getString("sqlite_browser_connected") + ": " + string);
            this.appendMessage("  " + this.bundle.getString("sqlite_browser_file_size") + ": " + this.formatFileSize(file.length()));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("sqlite_browser_open_failed") + "\n" + exception.getMessage(), this.bundle.getString("sqlite_browser_error"), 0);
            this.lblStatus.setText(this.bundle.getString("sqlite_browser_open_failed"));
            this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
        }
    }

    private void loadDatabaseStructure() throws SQLException {
        Object object;
        Object object2;
        ResultSet resultSet;
        Object object3;
        Object object4;
        this.rootNode.removeAllChildren();
        if (this.connection == null) {
            this.rootNode.setUserObject(this.bundle.getString("sqlite_browser_no_database"));
            this.treeModel.reload();
            return;
        }
        File file = new File(this.currentDbPath);
        this.rootNode.setUserObject(file.getName());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.bundle.getString("sqlite_browser_tables"));
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet2 = databaseMetaData.getTables(null, null, "%", new String[]{"TABLE"});
        while (resultSet2.next()) {
            object4 = resultSet2.getString("TABLE_NAME");
            if (((String)object4).startsWith("sqlite_")) continue;
            object3 = new DefaultMutableTreeNode(object4);
            resultSet = databaseMetaData.getColumns(null, null, (String)object4, "%");
            while (resultSet.next()) {
                object2 = resultSet.getString("COLUMN_NAME");
                object = resultSet.getString("TYPE_NAME");
                int n2 = resultSet.getInt("NULLABLE");
                String string = n2 == 1 ? "NULL" : "NOT NULL";
                ((DefaultMutableTreeNode)object3).add(new DefaultMutableTreeNode("  " + (String)object2 + " (" + (String)object + ", " + string + ")"));
            }
            resultSet.close();
            defaultMutableTreeNode.add((MutableTreeNode)object3);
        }
        resultSet2.close();
        object4 = new DefaultMutableTreeNode(this.bundle.getString("sqlite_browser_indexes"));
        object3 = this.connection.createStatement();
        resultSet = object3.executeQuery("SELECT name, tbl_name FROM sqlite_master WHERE type='index' AND name NOT LIKE 'sqlite_%'");
        while (resultSet.next()) {
            object2 = resultSet.getString("name");
            object = resultSet.getString("tbl_name");
            ((DefaultMutableTreeNode)object4).add(new DefaultMutableTreeNode("  " + (String)object2 + " (" + (String)object + ")"));
        }
        resultSet.close();
        object3.close();
        object2 = new DefaultMutableTreeNode(this.bundle.getString("sqlite_browser_views"));
        object = databaseMetaData.getTables(null, null, "%", new String[]{"VIEW"});
        while (object.next()) {
            String string = object.getString("TABLE_NAME");
            ((DefaultMutableTreeNode)object2).add(new DefaultMutableTreeNode("  " + string));
        }
        object.close();
        this.rootNode.add(defaultMutableTreeNode);
        this.rootNode.add((MutableTreeNode)object4);
        this.rootNode.add((MutableTreeNode)object2);
        this.treeModel.reload();
        this.treeDatabase.expandRow(0);
        this.treeDatabase.expandRow(1);
    }

    private void refreshDatabase() {
        if (this.currentDbPath != null) {
            this.loadDatabase(this.currentDbPath);
        }
    }

    private void closeDatabase() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.currentDbPath = null;
                this.txtDbPath.setText("");
                this.btnRefresh.setEnabled(false);
                this.btnClose.setEnabled(false);
                this.rootNode.removeAllChildren();
                this.rootNode.setUserObject(this.bundle.getString("sqlite_browser_no_database"));
                this.treeModel.reload();
                this.tableModel.setRowCount(0);
                this.tableModel.setColumnCount(0);
                this.lblStatus.setText(this.bundle.getString("sqlite_browser_disconnected"));
                this.lblStatus.putClientProperty("FlatLaf.styleClass", "small");
                this.lblRowCount.setText(this.bundle.getString("sqlite_browser_rows") + ": 0");
                this.appendMessage("[X] " + this.bundle.getString("sqlite_browser_disconnected"));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private void executeSql() {
        if (this.connection == null) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("sqlite_browser_no_connection"), this.bundle.getString("sqlite_browser_error"), 2);
            return;
        }
        String string = this.txtSql.getSelectedText();
        if (string == null || string.trim().isEmpty()) {
            string = this.txtSql.getText().trim();
        }
        if (string.isEmpty() || string.startsWith("--")) {
            return;
        }
        this.addToHistory(string);
        long l2 = System.currentTimeMillis();
        try {
            Statement statement = this.connection.createStatement();
            String string2 = string.toUpperCase().trim();
            if (string2.startsWith("SELECT") || string2.startsWith("PRAGMA") || string2.startsWith("EXPLAIN")) {
                ResultSet resultSet = statement.executeQuery(string);
                this.displayResultSet(resultSet);
                resultSet.close();
                this.resultTabs.setSelectedIndex(0);
            } else {
                int n2 = statement.executeUpdate(string);
                this.appendMessage("[OK] " + this.bundle.getString("sqlite_browser_rows_affected") + ": " + n2);
                this.lblRowCount.setText(this.bundle.getString("sqlite_browser_rows_affected") + ": " + n2);
                if (string2.startsWith("CREATE") || string2.startsWith("DROP") || string2.startsWith("ALTER")) {
                    this.loadDatabaseStructure();
                }
                this.resultTabs.setSelectedIndex(1);
            }
            statement.close();
            long l3 = System.currentTimeMillis() - l2;
            this.lblExecTime.setText(this.bundle.getString("sqlite_browser_time") + ": " + l3 + "ms");
            this.lblStatus.setText(this.bundle.getString("sqlite_browser_success"));
            this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.accentColor");
        }
        catch (SQLException sQLException) {
            long l4 = System.currentTimeMillis() - l2;
            this.lblExecTime.setText(this.bundle.getString("sqlite_browser_time") + ": " + l4 + "ms");
            this.lblStatus.setText(this.bundle.getString("sqlite_browser_error"));
            this.lblStatus.putClientProperty("FlatLaf.style", "foreground: $Component.errorColor");
            this.appendMessage("[ERROR] " + this.bundle.getString("sqlite_browser_error") + ": " + sQLException.getMessage());
            this.resultTabs.setSelectedIndex(1);
        }
    }

    private void displayResultSet(ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        this.tableModel.setRowCount(0);
        this.tableModel.setColumnCount(0);
        Vector<String> vector = new Vector<String>();
        for (n2 = 1; n2 <= n3; ++n2) {
            vector.add(resultSetMetaData.getColumnName(n2));
        }
        this.tableModel.setColumnIdentifiers(vector);
        n2 = 0;
        while (resultSet.next()) {
            Vector<Object> vector2 = new Vector<Object>();
            for (int i2 = 1; i2 <= n3; ++i2) {
                Object object = resultSet.getObject(i2);
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if (byArray.length > 100) {
                        vector2.add("[BLOB: " + byArray.length + " bytes]");
                        continue;
                    }
                    vector2.add(this.bytesToHex(byArray));
                    continue;
                }
                vector2.add(object);
            }
            this.tableModel.addRow(vector2);
            ++n2;
        }
        this.autoResizeColumns();
        this.lblRowCount.setText(this.bundle.getString("sqlite_browser_rows") + ": " + n2);
        this.btnExportCsv.setEnabled(n2 > 0);
        this.appendMessage("[OK] " + this.bundle.getString("sqlite_browser_query_result") + ": " + n2 + " " + this.bundle.getString("sqlite_browser_rows"));
    }

    private void autoResizeColumns() {
        for (int i2 = 0; i2 < this.tableResult.getColumnCount(); ++i2) {
            int n2 = 100;
            n2 = Math.max(n2, this.tableResult.getColumnModel().getColumn(i2).getHeaderValue().toString().length() * 10 + 20);
            for (int i3 = 0; i3 < Math.min(100, this.tableResult.getRowCount()); ++i3) {
                Object object = this.tableResult.getValueAt(i3, i2);
                if (object == null) continue;
                n2 = Math.max(n2, Math.min(400, object.toString().length() * 8 + 20));
            }
            this.tableResult.getColumnModel().getColumn(i2).setPreferredWidth(n2);
        }
    }

    private void exportToCsv() {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.bundle.getString("sqlite_browser_export_csv"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter("CSV Files (*.csv)", "csv"));
        jFileChooser.setSelectedFile(new File("export.csv"));
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            try (PrintWriter printWriter = new PrintWriter(file, "UTF-8");){
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                for (n2 = 0; n2 < this.tableModel.getColumnCount(); ++n2) {
                    if (n2 > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\"").append(this.tableModel.getColumnName(n2)).append("\"");
                }
                printWriter.println(stringBuilder);
                for (n2 = 0; n2 < this.tableModel.getRowCount(); ++n2) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int i2 = 0; i2 < this.tableModel.getColumnCount(); ++i2) {
                        Object object;
                        if (i2 > 0) {
                            stringBuilder2.append(",");
                        }
                        if ((object = this.tableModel.getValueAt(n2, i2)) == null) continue;
                        String string = object.toString().replace("\"", "\"\"");
                        stringBuilder2.append("\"").append(string).append("\"");
                    }
                    printWriter.println(stringBuilder2);
                }
                JOptionPane.showMessageDialog(this, this.bundle.getString("sqlite_browser_export_success") + "\n" + file.getAbsolutePath(), this.bundle.getString("sqlite_browser_title"), 1);
                this.appendMessage("[OK] " + this.bundle.getString("sqlite_browser_export_success") + ": " + file.getAbsolutePath());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("sqlite_browser_export_failed") + "\n" + exception.getMessage(), this.bundle.getString("sqlite_browser_error"), 0);
            }
        }
    }

    private void onTreeSelectionChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    private void onTreeDoubleClick() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeDatabase.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getParent() == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        String string = defaultMutableTreeNode2.getUserObject().toString();
        if (string.contains(this.bundle.getString("sqlite_browser_tables"))) {
            String string2 = defaultMutableTreeNode.getUserObject().toString();
            this.txtSql.setText("SELECT * FROM \"" + string2 + "\" LIMIT 1000;");
            this.executeSql();
        }
    }

    private void addToHistory(String string) {
        if ((string = string.trim()).isEmpty()) {
            return;
        }
        this.sqlHistory.remove(string);
        this.sqlHistory.add(0, string);
        while (this.sqlHistory.size() > 50) {
            this.sqlHistory.remove(this.sqlHistory.size() - 1);
        }
        this.cmbHistory.removeAllItems();
        this.cmbHistory.addItem("-- " + this.bundle.getString("sqlite_browser_history") + " --");
        for (String string2 : this.sqlHistory) {
            String string3 = string2.length() > 80 ? string2.substring(0, 80) + "..." : string2;
            this.cmbHistory.addItem(string3);
        }
    }

    private void appendMessage(String string) {
        this.txtMessages.append(string + "\n");
        this.txtMessages.setCaretPosition(this.txtMessages.getDocument().getLength());
    }

    private void loadRecentDbDirectory() {
        File[] fileArray;
        File file2 = new File("./db");
        if (file2.exists() && file2.isDirectory() && (fileArray = file2.listFiles((file, string) -> string.endsWith(".db") || string.endsWith(".sqlite") || string.endsWith(".sqlite3"))) != null && fileArray.length > 0) {
            this.appendMessage(this.bundle.getString("sqlite_browser_available_dbs") + ":");
            for (File file3 : fileArray) {
                this.appendMessage("  \u2022 " + file3.getName() + " (" + this.formatFileSize(file3.length()) + ")");
            }
        }
    }

    private String formatFileSize(long l2) {
        if (l2 < 1024L) {
            return l2 + " B";
        }
        if (l2 < 0x100000L) {
            return String.format("%.2f KB", (double)l2 / 1024.0);
        }
        if (l2 < 0x40000000L) {
            return String.format("%.2f MB", (double)l2 / 1048576.0);
        }
        return String.format("%.2f GB", (double)l2 / 1.073741824E9);
    }

    private String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("0x");
        for (byte by2 : byArray) {
            stringBuilder.append(String.format("%02X", by2));
        }
        return stringBuilder.toString();
    }

    private class DatabaseTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private DatabaseTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            this.setIcon(null);
            return this;
        }
    }
}

