/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.core.testgen;

import com.formdev.flatlaf.extras.FlatSVGUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import o._3_;
import o._5_;
import o._8_;
import o.__1;

public class TestGenDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Color PRIMARY_COLOR = new Color(41, 128, 185);
    private static final Color SUCCESS_COLOR = new Color(39, 174, 96);
    private static final Color DANGER_COLOR = new Color(192, 57, 43);
    private static final Color WARNING_COLOR = new Color(243, 156, 18);
    private static final Color BG_COLOR = new Color(248, 249, 250);
    private static final Color PANEL_BG = Color.WHITE;
    private static final Color BORDER_COLOR = new Color(222, 226, 230);
    private static final Color TEXT_SECONDARY = new Color(108, 117, 125);
    private final ResourceBundle bundle;
    private JTextField txtJdbcUrl;
    private JTextField txtUsername;
    private JPasswordField txtPassword;
    private JTextField txtSchema;
    private JButton btnTestConnection;
    private JSpinner spnDataScale;
    private JLabel lblDataScaleInfo;
    private JSpinner spnBatchSize;
    private JSpinner spnThreads;
    private JCheckBox chkResumeMode;
    private JPanel pnlFeatures;
    private JCheckBox[] featureCheckboxes;
    private JToggleButton btnToggleFeatures;
    private boolean featuresExpanded = false;
    private JLabel lblStatus;
    private JLabel lblCurrentTable;
    private JLabel lblRowsGenerated;
    private JLabel lblElapsedTime;
    private JProgressBar progressBar;
    private JTextArea txtLog;
    private JButton btnStart;
    private JButton btnStop;
    private JButton btnViewReport;
    private JButton btnDropTables;
    private JButton btnClose;
    private _8_ generator;
    private Thread generatorThread;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private long startTime;
    private Timer updateTimer;

    public TestGenDialog() {
        this.bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
        this.initComponents();
        this.initLayout();
        this.initListeners();
        this.setTitle(this.bundle.getString("testgen_dialog_title"));
        this.setSize(850, 720);
        this.setMinimumSize(new Dimension(750, 600));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setBackground(BG_COLOR);
        try {
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
            URL uRL = this.getClass().getResource("/com/dbrecover/gui/resources/svg/app_icon.svg");
            if (uRL != null) {
                arrayList.add(FlatSVGUtils.svg2image(uRL, 16, 16));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 32, 32));
                arrayList.add(FlatSVGUtils.svg2image(uRL, 64, 64));
                this.setIconImages(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateTimer = new Timer(500, actionEvent -> this.updateProgress());
    }

    private void initComponents() {
        this.txtJdbcUrl = this.createTextField("jdbc:oracle:thin:@localhost:1521:ORCL", 35);
        this.txtUsername = this.createTextField("testgen", 18);
        this.txtPassword = this.createPasswordField("testgen", 18);
        this.txtSchema = this.createTextField("", 18);
        this.txtSchema.setToolTipText("\u7559\u7a7a\u5219\u4f7f\u7528\u7528\u6237\u540d\u4f5c\u4e3aSchema");
        this.btnTestConnection = this.createSecondaryButton(this.bundle.getString("testgen_test_connection"));
        this.spnDataScale = this.createSpinner(new SpinnerNumberModel(10, 1, 100, 1), 6);
        this.spnDataScale.addChangeListener(changeEvent -> this.updateDataScaleInfo());
        this.lblDataScaleInfo = new JLabel();
        this.lblDataScaleInfo.setFont(new Font("Microsoft YaHei", 0, 11));
        this.lblDataScaleInfo.setForeground(TEXT_SECONDARY);
        this.updateDataScaleInfo();
        this.spnBatchSize = this.createSpinner(new SpinnerNumberModel(1000, 100, 10000, 100), 6);
        this.spnThreads = this.createSpinner(new SpinnerNumberModel(4, 1, 32, 1), 6);
        this.chkResumeMode = new JCheckBox("Resume Mode (continue from existing data)");
        this.chkResumeMode.setSelected(true);
        this.chkResumeMode.setBackground(PANEL_BG);
        this.chkResumeMode.setFont(new Font("Microsoft YaHei", 0, 12));
        this.chkResumeMode.setToolTipText("When enabled, generator will check existing data and continue from where it left off");
        _5_[] _5_Array = _5_.values();
        this.featureCheckboxes = new JCheckBox[_5_Array.length];
        int n2 = 0;
        for (int i2 = 0; i2 < _5_Array.length; ++i2) {
            _5_ _5_2 = _5_Array[i2];
            Object object = _5_2.getDisplayName();
            if (!_5_2.isSupported()) {
                object = (String)object + " *";
            }
            this.featureCheckboxes[i2] = new JCheckBox((String)object);
            this.featureCheckboxes[i2].setSelected(_5_2.isSupported());
            this.featureCheckboxes[i2].setToolTipText(_5_2.getDescription());
            this.featureCheckboxes[i2].setBackground(PANEL_BG);
            this.featureCheckboxes[i2].setFont(new Font("Microsoft YaHei", 0, 12));
            if (!_5_2.isSupported()) {
                this.featureCheckboxes[i2].setForeground(TEXT_SECONDARY);
            }
            if (!_5_2.isSupported()) continue;
            ++n2;
        }
        this.btnToggleFeatures = new JToggleButton("\u25b6 Oracle\u7279\u6027 (\u5df2\u542f\u7528 " + n2 + "/" + _5_Array.length + ")");
        this.btnToggleFeatures.setFont(new Font("Microsoft YaHei", 1, 12));
        this.btnToggleFeatures.setHorizontalAlignment(2);
        this.btnToggleFeatures.setBorderPainted(false);
        this.btnToggleFeatures.setContentAreaFilled(false);
        this.btnToggleFeatures.setFocusPainted(false);
        this.btnToggleFeatures.setCursor(new Cursor(12));
        this.btnToggleFeatures.setForeground(PRIMARY_COLOR);
        this.lblStatus = this.createValueLabel(this.bundle.getString("testgen_status_idle"));
        this.lblCurrentTable = this.createValueLabel("-");
        this.lblRowsGenerated = this.createValueLabel("0");
        this.lblElapsedTime = this.createValueLabel("00:00:00");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(0, 24));
        this.progressBar.setForeground(PRIMARY_COLOR);
        this.progressBar.setBackground(new Color(233, 236, 239));
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.txtLog = new JTextArea(8, 60);
        this.txtLog.setEditable(false);
        this.txtLog.setFont(new Font("Microsoft YaHei", 0, 12));
        this.txtLog.setBackground(new Color(44, 62, 80));
        this.txtLog.setForeground(new Color(236, 240, 241));
        this.txtLog.setCaretColor(Color.WHITE);
        this.txtLog.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.btnStart = this.createPrimaryButton(this.bundle.getString("testgen_start"));
        this.btnStart.setBackground(SUCCESS_COLOR);
        this.btnStop = this.createPrimaryButton(this.bundle.getString("testgen_stop"));
        this.btnStop.setBackground(DANGER_COLOR);
        this.btnStop.setEnabled(false);
        this.btnViewReport = this.createSecondaryButton(this.bundle.getString("testgen_view_report"));
        this.btnDropTables = this.createSecondaryButton(this.bundle.getString("testgen_drop_tables"));
        this.btnDropTables.setForeground(DANGER_COLOR);
        this.btnClose = this.createSecondaryButton(this.bundle.getString("testgen_close"));
    }

    private JTextField createTextField(String string, int n2) {
        JTextField jTextField = new JTextField(string, n2);
        jTextField.setFont(new Font("Segoe UI", 0, 13));
        jTextField.setBorder(this.createInputBorder());
        return jTextField;
    }

    private JPasswordField createPasswordField(String string, int n2) {
        JPasswordField jPasswordField = new JPasswordField(string, n2);
        jPasswordField.setFont(new Font("Segoe UI", 0, 13));
        jPasswordField.setBorder(this.createInputBorder());
        return jPasswordField;
    }

    private Border createInputBorder() {
        return new CompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), BorderFactory.createEmptyBorder(6, 8, 6, 8));
    }

    private JSpinner createSpinner(SpinnerNumberModel spinnerNumberModel, int n2) {
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jSpinner.getEditor();
        defaultEditor.getTextField().setColumns(n2);
        defaultEditor.getTextField().setFont(new Font("Segoe UI", 0, 13));
        defaultEditor.getTextField().setHorizontalAlignment(4);
        return jSpinner;
    }

    private JLabel createValueLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Segoe UI", 1, 13));
        jLabel.setForeground(new Color(52, 73, 94));
        return jLabel;
    }

    private JButton createPrimaryButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font("Microsoft YaHei", 1, 12));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setBorder(BorderFactory.createEmptyBorder(8, 20, 8, 20));
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setOpaque(true);
        return jButton;
    }

    private JButton createSecondaryButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font("Microsoft YaHei", 0, 12));
        jButton.setForeground(new Color(52, 73, 94));
        jButton.setBackground(PANEL_BG);
        jButton.setBorder(new CompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), BorderFactory.createEmptyBorder(6, 16, 6, 16)));
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(0, 12));
        jPanel.setBackground(BG_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 12, 0));
        jPanel2.setOpaque(false);
        jPanel2.add(this.createConnectionPanel());
        jPanel2.add(this.createSettingsPanel());
        JPanel jPanel3 = this.createFeaturesPanel();
        JPanel jPanel4 = this.createProgressPanel();
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 12));
        jPanel5.setOpaque(false);
        jPanel5.add((Component)jPanel3, "North");
        jPanel5.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel5, "Center");
        jPanel.add((Component)this.createButtonPanel(), "South");
        this.add((Component)jPanel, "Center");
    }

    private JPanel createConnectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(PANEL_BG);
        jPanel.setBorder(this.createPanelBorder(this.bundle.getString("testgen_db_connection")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 8, 6, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.createFieldLabel(this.bundle.getString("testgen_jdbc_url")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.txtJdbcUrl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.createFieldLabel(this.bundle.getString("testgen_username")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.txtUsername, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.createFieldLabel(this.bundle.getString("testgen_password")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.txtPassword, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.createFieldLabel(this.bundle.getString("testgen_schema")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.txtSchema, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 8, 6, 8);
        jPanel.add((Component)this.btnTestConnection, gridBagConstraints);
        return jPanel;
    }

    private JLabel createFieldLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Microsoft YaHei", 0, 12));
        jLabel.setForeground(TEXT_SECONDARY);
        return jLabel;
    }

    private JPanel createSettingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(PANEL_BG);
        jPanel.setBorder(this.createPanelBorder(this.bundle.getString("testgen_generation_settings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 8, 6, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.createFieldLabel("Data Scale (1-100):"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.setOpaque(false);
        jPanel2.add(this.spnDataScale);
        jPanel2.add(this.lblDataScaleInfo);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.createFieldLabel(this.bundle.getString("testgen_batch_size")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.spnBatchSize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.createFieldLabel(this.bundle.getString("testgen_threads")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.spnThreads, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        jPanel.add((Component)this.chkResumeMode, gridBagConstraints);
        return jPanel;
    }

    private Border createPanelBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), " " + string + " ", 1, 2, new Font("Microsoft YaHei", 1, 12), new Color(52, 73, 94));
        return new CompoundBorder(titledBorder, BorderFactory.createEmptyBorder(8, 8, 12, 8));
    }

    private JPanel createFeaturesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PANEL_BG);
        jPanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(PANEL_BG);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        jPanel2.add((Component)this.btnToggleFeatures, "West");
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 8, 0));
        jPanel3.setOpaque(false);
        JButton jButton = this.createSmallButton("\u542f\u7528\u5df2\u652f\u6301");
        JButton jButton2 = this.createSmallButton(this.bundle.getString("testgen_enable_all"));
        JButton jButton3 = this.createSmallButton(this.bundle.getString("testgen_disable_all"));
        jButton.setToolTipText("\u53ea\u542f\u7528DBRecover\u76ee\u524d\u5df2\u652f\u6301\u7684\u7279\u6027");
        jButton.addActionListener(actionEvent -> {
            _5_[] _5_Array = _5_.values();
            for (int i2 = 0; i2 < _5_Array.length; ++i2) {
                this.featureCheckboxes[i2].setSelected(_5_Array[i2].isSupported());
            }
            this.updateFeatureToggleText();
        });
        jButton2.addActionListener(actionEvent -> {
            for (JCheckBox jCheckBox : this.featureCheckboxes) {
                jCheckBox.setSelected(true);
            }
            this.updateFeatureToggleText();
        });
        jButton3.addActionListener(actionEvent -> {
            for (JCheckBox jCheckBox : this.featureCheckboxes) {
                jCheckBox.setSelected(false);
            }
            this.updateFeatureToggleText();
        });
        JLabel jLabel = new JLabel("(\u5e26 * \u4e3a\u5c1a\u672a\u652f\u6301)");
        jLabel.setFont(new Font("Microsoft YaHei", 0, 11));
        jLabel.setForeground(TEXT_SECONDARY);
        jPanel3.add(jLabel);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel2.add((Component)jPanel3, "East");
        this.pnlFeatures = new JPanel(new GridLayout(0, 6, 8, 4));
        this.pnlFeatures.setBackground(PANEL_BG);
        this.pnlFeatures.setBorder(BorderFactory.createEmptyBorder(8, 12, 12, 12));
        for (JCheckBox jCheckBox : this.featureCheckboxes) {
            jCheckBox.addActionListener(actionEvent -> this.updateFeatureToggleText());
            this.pnlFeatures.add(jCheckBox);
        }
        this.pnlFeatures.setVisible(false);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.pnlFeatures, "Center");
        return jPanel;
    }

    private JButton createSmallButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font("Microsoft YaHei", 0, 11));
        jButton.setMargin(new Insets(2, 8, 2, 8));
        jButton.setFocusPainted(false);
        return jButton;
    }

    private void updateFeatureToggleText() {
        int n2 = 0;
        for (JCheckBox jCheckBox : this.featureCheckboxes) {
            if (!jCheckBox.isSelected()) continue;
            ++n2;
        }
        String string = this.featuresExpanded ? "\u25bc" : "\u25b6";
        this.btnToggleFeatures.setText(string + " Oracle\u7279\u6027 (\u5df2\u542f\u7528 " + n2 + "/" + this.featureCheckboxes.length + ")");
    }

    private JPanel createProgressPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        jPanel.setBackground(PANEL_BG);
        jPanel.setBorder(this.createPanelBorder(this.bundle.getString("testgen_progress")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 0, 2, 20);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.createFieldLabel(this.bundle.getString("testgen_status")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.lblStatus, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)this.createFieldLabel(this.bundle.getString("testgen_current_table")), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.lblCurrentTable, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.createFieldLabel(this.bundle.getString("testgen_rows_generated")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.lblRowsGenerated, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)this.createFieldLabel(this.bundle.getString("testgen_elapsed_time")), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel2.add((Component)this.lblElapsedTime, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        jPanel3.add((Component)this.progressBar, "Center");
        JScrollPane jScrollPane = new JScrollPane(this.txtLog);
        jScrollPane.setBorder(BorderFactory.createLineBorder(new Color(44, 62, 80), 1));
        jScrollPane.setPreferredSize(new Dimension(0, 140));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setOpaque(false);
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "South");
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 8, 0));
        jPanel2.setOpaque(false);
        jPanel2.add(this.btnViewReport);
        jPanel2.add(this.btnDropTables);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 8, 0));
        jPanel3.setOpaque(false);
        jPanel3.add(this.btnStart);
        jPanel3.add(this.btnStop);
        jPanel3.add(Box.createHorizontalStrut(12));
        jPanel3.add(this.btnClose);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private void initListeners() {
        this.btnTestConnection.addActionListener(actionEvent -> this.testConnection());
        this.btnStart.addActionListener(actionEvent -> this.startGeneration());
        this.btnStop.addActionListener(actionEvent -> this.stopGeneration());
        this.btnViewReport.addActionListener(actionEvent -> this.viewSchemaReport());
        this.btnDropTables.addActionListener(actionEvent -> this.dropAllTables());
        this.btnClose.addActionListener(actionEvent -> this.dispose());
        this.btnToggleFeatures.addActionListener(actionEvent -> {
            this.featuresExpanded = !this.featuresExpanded;
            this.pnlFeatures.setVisible(this.featuresExpanded);
            this.updateFeatureToggleText();
            this.revalidate();
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n2;
                if (TestGenDialog.this.isRunning.get() && (n2 = JOptionPane.showConfirmDialog(TestGenDialog.this, TestGenDialog.this.bundle.getString("testgen_confirm_stop"), TestGenDialog.this.bundle.getString("testgen_dialog_title"), 0)) == 0) {
                    TestGenDialog.this.stopGeneration();
                }
            }
        });
    }

    private void testConnection() {
        final String string = this.txtJdbcUrl.getText().trim();
        final String string2 = this.txtUsername.getText().trim();
        final String string3 = new String(this.txtPassword.getPassword());
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.btnTestConnection.setEnabled(false);
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){
            private String aaab;

            protected Boolean O0() {
                try {
                    Class.forName("oracle.jdbc.OracleDriver");
                    Connection connection = DriverManager.getConnection(string, string2, string3);
                    connection.close();
                    return true;
                }
                catch (Exception exception) {
                    this.aaab = exception.getMessage();
                    return false;
                }
            }

            @Override
            protected void done() {
                TestGenDialog.this.setCursor(Cursor.getDefaultCursor());
                TestGenDialog.this.btnTestConnection.setEnabled(true);
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        JOptionPane.showMessageDialog(TestGenDialog.this, TestGenDialog.this.bundle.getString("testgen_connection_success"), TestGenDialog.this.bundle.getString("testgen_dialog_title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(TestGenDialog.this, TestGenDialog.this.bundle.getString("testgen_connection_failed") + "\n" + this.aaab, TestGenDialog.this.bundle.getString("testgen_dialog_title"), 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void startGeneration() {
        int n2 = JOptionPane.showConfirmDialog(this, this.bundle.getString("testgen_confirm_start"), this.bundle.getString("testgen_dialog_title"), 0);
        if (n2 != 0) {
            return;
        }
        String string = this.txtJdbcUrl.getText().trim();
        String string2 = this.txtUsername.getText().trim();
        String string3 = new String(this.txtPassword.getPassword());
        String string4 = this.txtSchema.getText().trim();
        if (string4.isEmpty()) {
            string4 = string2;
        }
        int n3 = (Integer)this.spnDataScale.getValue();
        double d2 = (double)n3 * 5.0;
        int n4 = (Integer)this.spnBatchSize.getValue();
        int n5 = (Integer)this.spnThreads.getValue();
        try {
            _3_ _3_2 = new _3_.O0().O0(string).l1(string2).I1(string3).Il(string4).O0(d2).l1(n4).I1(n5).O0().O0();
            this.generator = new _8_(_3_2);
            this.generator.O0(new O0());
            this.generator._a(true);
            this.generator._l(this.chkResumeMode.isSelected());
            final AtomicLong atomicLong = new AtomicLong(0L);
            final ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            final int n6 = new __1().getTableCount();
            this.generator.O0(new _8_.O0(){

                @Override
                public void O0(String string, long l2) {
                    concurrentHashMap.put(string, 0L);
                    SwingUtilities.invokeLater(() -> {
                        if (concurrentHashMap.size() == 1) {
                            TestGenDialog.this.lblCurrentTable.setText(string);
                        } else {
                            TestGenDialog.this.lblCurrentTable.setText(concurrentHashMap.size() + " tables (parallel)");
                        }
                        TestGenDialog.this.appendLog(">>> " + string + " (target: " + TestGenDialog.this.formatNumber(l2) + " rows)");
                    });
                }

                @Override
                public void O0(String string, long l2, long l3) {
                    concurrentHashMap.put(string, l2);
                    long l4 = concurrentHashMap.values().stream().mapToLong(Long::longValue).sum() + atomicLong.get();
                    SwingUtilities.invokeLater(() -> {
                        TestGenDialog.this.lblRowsGenerated.setText(TestGenDialog.this.formatNumber(l4));
                        int n3 = atomicInteger.get() * 100 / n6;
                        TestGenDialog.this.progressBar.setValue(Math.min(n3, 99));
                    });
                }

                @Override
                public void l1(String string, long l2, long l3) {
                    Long l4 = (Long)concurrentHashMap.remove(string);
                    if (l4 != null) {
                        atomicLong.addAndGet(l2);
                    }
                    int n2 = atomicInteger.incrementAndGet();
                    SwingUtilities.invokeLater(() -> {
                        TestGenDialog.this.appendLog("    Done: " + TestGenDialog.this.formatNumber(l2) + " rows in " + TestGenDialog.this.formatDuration(l3));
                        TestGenDialog.this.lblRowsGenerated.setText(TestGenDialog.this.formatNumber(atomicLong.get()));
                        int n4 = n2 * 100 / n6;
                        TestGenDialog.this.progressBar.setValue(Math.min(n4, 99));
                        if (concurrentHashMap.isEmpty()) {
                            TestGenDialog.this.lblCurrentTable.setText("-");
                        } else if (concurrentHashMap.size() == 1) {
                            TestGenDialog.this.lblCurrentTable.setText((String)((ConcurrentHashMap.KeySetView)concurrentHashMap.keySet()).iterator().next());
                        } else {
                            TestGenDialog.this.lblCurrentTable.setText(concurrentHashMap.size() + " tables (parallel)");
                        }
                    });
                }

                @Override
                public void I1(String string, Exception exception) {
                    concurrentHashMap.remove(string);
                    SwingUtilities.invokeLater(() -> TestGenDialog.this.appendLog("[ERROR] " + string + ": " + exception.getMessage()));
                }
            });
            this.isRunning.set(true);
            this.startTime = System.currentTimeMillis();
            this.generatorThread = new Thread(() -> {
                try {
                    this.generator._6b();
                    SwingUtilities.invokeLater(() -> {
                        this.lblStatus.setText(this.bundle.getString("testgen_status_completed"));
                        this.lblStatus.setForeground(SUCCESS_COLOR);
                        this.progressBar.setValue(100);
                        this.appendLog("\n========== Generation Completed ==========");
                    });
                }
                catch (Exception exception) {
                    SwingUtilities.invokeLater(() -> {
                        this.lblStatus.setText("\u9519\u8bef: " + exception.getMessage());
                        this.lblStatus.setForeground(DANGER_COLOR);
                        this.appendLog("[ERROR] " + exception.getMessage());
                    });
                }
                finally {
                    this.isRunning.set(false);
                    SwingUtilities.invokeLater(() -> {
                        this.btnStart.setEnabled(true);
                        this.btnStop.setEnabled(false);
                        this.updateTimer.stop();
                    });
                }
            });
            this.btnStart.setEnabled(false);
            this.btnStop.setEnabled(true);
            this.lblStatus.setText(this.bundle.getString("testgen_status_running"));
            this.lblStatus.setForeground(PRIMARY_COLOR);
            this.progressBar.setValue(0);
            this.txtLog.setText("");
            this.appendLog("========== Start Generating Test Data ==========\n");
            this.updateTimer.start();
            this.generatorThread.start();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Start failed: " + exception.getMessage(), this.bundle.getString("testgen_dialog_title"), 0);
        }
    }

    private void stopGeneration() {
        if (!this.isRunning.get()) {
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, this.bundle.getString("testgen_confirm_stop"), this.bundle.getString("testgen_dialog_title"), 0);
        if (n2 == 0) {
            this.isRunning.set(false);
            if (this.generatorThread != null) {
                this.generatorThread.interrupt();
            }
            this.lblStatus.setText(this.bundle.getString("testgen_status_stopped"));
            this.lblStatus.setForeground(WARNING_COLOR);
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.updateTimer.stop();
            this.appendLog("\n========== Generation Stopped ==========");
        }
    }

    private void viewSchemaReport() {
        __1 __12 = new __1();
        String string = __12._3a();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setFont(new Font("Microsoft YaHei", 0, 12));
        jTextArea.setEditable(false);
        jTextArea.setBackground(new Color(44, 62, 80));
        jTextArea.setForeground(new Color(236, 240, 241));
        jTextArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(700, 500));
        jScrollPane.setBorder(BorderFactory.createLineBorder(new Color(44, 62, 80), 1));
        JOptionPane.showMessageDialog(this, jScrollPane, "Schema Report", -1);
    }

    private void dropAllTables() {
        int n2 = JOptionPane.showConfirmDialog(this, this.bundle.getString("testgen_confirm_drop"), this.bundle.getString("testgen_dialog_title"), 0, 2);
        if (n2 != 0) {
            return;
        }
        final String string = this.txtJdbcUrl.getText().trim();
        final String string2 = this.txtUsername.getText().trim();
        final String string3 = new String(this.txtPassword.getPassword());
        String string4 = this.txtSchema.getText().trim();
        if (string4.isEmpty()) {
            string4 = string2;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        final String string5 = string4;
        this.appendLog(">>> Dropping all tables");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){
            private String aaab;

            protected Boolean O0() {
                try {
                    _3_ _3_2 = new _3_.O0().O0(string).l1(string2).I1(string3).Il(string5).O0();
                    _8_ _8_2 = new _8_(_3_2);
                    _8_2.O0(new O0());
                    _8_2.dropAllTables();
                    return true;
                }
                catch (Exception exception) {
                    this.aaab = exception.getClass().getSimpleName() + ": " + (exception.getMessage() != null ? exception.getMessage() : "Unknown error");
                    if (exception.getCause() != null) {
                        this.aaab = this.aaab + "\nCause: " + exception.getCause().getMessage();
                    }
                    exception.printStackTrace();
                    return false;
                }
            }

            @Override
            protected void done() {
                TestGenDialog.this.setCursor(Cursor.getDefaultCursor());
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        TestGenDialog.this.appendLog("All tables dropped successfully");
                        JOptionPane.showMessageDialog(TestGenDialog.this, TestGenDialog.this.bundle.getString("testgen_drop_success"), TestGenDialog.this.bundle.getString("testgen_dialog_title"), 1);
                    } else {
                        TestGenDialog.this.appendLog("[ERROR] " + this.aaab);
                        JOptionPane.showMessageDialog(TestGenDialog.this, TestGenDialog.this.bundle.getString("testgen_drop_failed") + "\n" + this.aaab, TestGenDialog.this.bundle.getString("testgen_dialog_title"), 0);
                    }
                }
                catch (Exception exception) {
                    TestGenDialog.this.appendLog("[ERROR] " + exception.getMessage());
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void updateDataScaleInfo() {
        int n2 = (Integer)this.spnDataScale.getValue();
        int n3 = n2 * 5;
        this.lblDataScaleInfo.setText(String.format("(~%d GB)", n3));
    }

    private void updateProgress() {
        if (this.isRunning.get()) {
            long l2 = System.currentTimeMillis() - this.startTime;
            this.lblElapsedTime.setText(this.formatDuration(l2));
        }
    }

    private void appendLog(String string) {
        this.txtLog.append(string + "\n");
        this.txtLog.setCaretPosition(this.txtLog.getDocument().getLength());
    }

    private String formatNumber(long l2) {
        return new DecimalFormat("#,###").format(l2);
    }

    private String formatDuration(long l2) {
        long l3 = l2 / 1000L;
        long l4 = l3 / 3600L;
        long l5 = l3 % 3600L / 60L;
        long l6 = l3 % 60L;
        return String.format("%02d:%02d:%02d", l4, l5, l6);
    }

    private class O0
    extends PrintStream {
        public O0() {
            super(System.out);
        }

        @Override
        public void println(String string) {
            SwingUtilities.invokeLater(() -> TestGenDialog.this.appendLog(string));
        }

        @Override
        public void print(String string) {
        }
    }
}

