/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.healthcheck;

import com.dbrecover.gui.healthcheck.FileHeaderDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import o.O0O0;
import o.lIlI;
import o.\u03c6;
import o.\u03c8;
import o.\u03c9;

public class DataFileHealthCheckerDialog
extends JDialog {
    private final ResourceBundle bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
    private static final Color COLOR_BAD = new Color(255, 204, 204);
    private static final Color COLOR_WARN = new Color(255, 255, 204);
    private static final Color COLOR_ENCRYPTED = new Color(243, 229, 245);
    private static final Color COLOR_ZEROED = new Color(236, 239, 241);
    private static final Color COLOR_OK = new Color(232, 245, 233);
    private static final Color COLOR_DEFAULT = Color.WHITE;
    private \u03c9 healthCheckService;
    private lIlI reportGenerator;
    private List<O0O0> fileHealthInfoList;
    private O0O0 currentHealthInfo;
    private JTable fileListTable;
    private DefaultTableModel fileListModel;
    private JTable blockTable;
    private DefaultTableModel blockModel;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private JButton btnAddFile;
    private JButton btnRemoveFile;
    private JButton btnStartScan;
    private JButton btnStopScan;
    private JButton btnExportReport;
    private JButton btnViewHeader;
    private JButton btnClearResults;
    private JTextField pageInputField;
    private JLabel pageInfoLabel;
    private JLabel totalBlocksLabel;
    private JButton btnFirstPage;
    private JButton btnPrevPage;
    private JButton btnNextPage;
    private JButton btnLastPage;
    private JButton btnGotoPage;
    private JComboBox<String> pageSizeCombo;
    private JLabel lblDiagnosis;
    private JLabel lblFileSize;
    private JLabel lblBlockSize;
    private JLabel lblTotalBlocks;
    private JLabel lblBadBlocks;
    private JLabel lblCorruptionRate;
    private JLabel lblMaxScn;
    private JLabel lblMaxConsecutiveBad;
    private JLabel lblDbName;
    private JLabel lblTsName;
    private int currentPage = 0;
    private int pageSize = 100;
    private long totalBlocks = 0L;
    private int totalPages = 0;

    public DataFileHealthCheckerDialog(Frame frame) {
        super(frame, "", true);
        this.setTitle(this.bundle.getString("health_checker_title"));
        this.healthCheckService = new \u03c9();
        this.reportGenerator = new lIlI();
        this.fileHealthInfoList = new ArrayList<O0O0>();
        this.initComponents();
        this.setupLayout();
        this.setupListeners();
        this.setSize(1300, 750);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
    }

    private void initComponents() {
        Object[] objectArray = new String[]{this.bundle.getString("health_checker_col_file_status"), this.bundle.getString("health_checker_col_file_name"), this.bundle.getString("health_checker_col_total_blocks"), this.bundle.getString("health_checker_col_scanned"), this.bundle.getString("health_checker_col_bad_blocks")};
        this.fileListModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.fileListTable = new JTable(this.fileListModel);
        this.fileListTable.setSelectionMode(0);
        this.fileListTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.fileListTable.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.fileListTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.fileListTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.fileListTable.getColumnModel().getColumn(4).setPreferredWidth(70);
        this.fileListTable.setRowHeight(24);
        Object[] objectArray2 = new String[]{this.bundle.getString("health_checker_col_block_no"), this.bundle.getString("health_checker_col_block_id"), this.bundle.getString("health_checker_col_rdba"), this.bundle.getString("health_checker_col_block_type"), this.bundle.getString("health_checker_col_error_type"), this.bundle.getString("health_checker_col_status"), this.bundle.getString("health_checker_col_entropy")};
        this.blockModel = new DefaultTableModel(objectArray2, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.blockTable = new JTable(this.blockModel);
        this.blockTable.setRowHeight(22);
        this.blockTable.setDefaultRenderer(Object.class, new BlockTableCellRenderer());
        this.blockTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.blockTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.blockTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.blockTable.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.blockTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.blockTable.getColumnModel().getColumn(5).setPreferredWidth(80);
        this.blockTable.getColumnModel().getColumn(6).setPreferredWidth(60);
        this.btnAddFile = new JButton(this.bundle.getString("health_checker_add_file"));
        this.btnRemoveFile = new JButton(this.bundle.getString("health_checker_remove_file"));
        this.btnStartScan = new JButton(this.bundle.getString("health_checker_start_scan"));
        this.btnStopScan = new JButton(this.bundle.getString("health_checker_stop_scan"));
        this.btnExportReport = new JButton(this.bundle.getString("health_checker_export_report"));
        this.btnViewHeader = new JButton(this.bundle.getString("health_checker_view_header"));
        this.btnClearResults = new JButton(this.bundle.getString("health_checker_clear"));
        this.btnStopScan.setEnabled(false);
        this.btnExportReport.setEnabled(false);
        this.btnViewHeader.setEnabled(false);
        String[] stringArray = new String[]{"50", "100", "200", "500"};
        this.pageSizeCombo = new JComboBox<String>(stringArray);
        this.pageSizeCombo.setSelectedItem("100");
        this.pageInputField = new JTextField(6);
        this.pageInputField.setText("1");
        this.pageInputField.setHorizontalAlignment(0);
        this.btnFirstPage = new JButton(this.bundle.getString("health_checker_first_page"));
        this.btnPrevPage = new JButton(this.bundle.getString("health_checker_prev"));
        this.btnNextPage = new JButton(this.bundle.getString("health_checker_next"));
        this.btnLastPage = new JButton(this.bundle.getString("health_checker_last_page"));
        this.btnGotoPage = new JButton(this.bundle.getString("health_checker_jump"));
        this.pageInfoLabel = new JLabel(MessageFormat.format(this.bundle.getString("health_checker_page_info"), 0, 0));
        this.totalBlocksLabel = new JLabel(MessageFormat.format(this.bundle.getString("health_checker_total_blocks_info"), 0));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(this.bundle.getString("health_checker_status_idle"));
        this.statusLabel = new JLabel(this.bundle.getString("health_checker_add_data_file"));
        this.lblDiagnosis = new JLabel("-");
        this.lblFileSize = new JLabel("-");
        this.lblBlockSize = new JLabel("-");
        this.lblTotalBlocks = new JLabel("-");
        this.lblBadBlocks = new JLabel("-");
        this.lblCorruptionRate = new JLabel("-");
        this.lblMaxScn = new JLabel("-");
        this.lblMaxConsecutiveBad = new JLabel("-");
        this.lblDbName = new JLabel("-");
        this.lblTsName = new JLabel("-");
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(5, 5));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.btnAddFile);
        jToolBar.add(this.btnRemoveFile);
        jToolBar.addSeparator();
        jToolBar.add(this.btnStartScan);
        jToolBar.add(this.btnStopScan);
        jToolBar.addSeparator();
        jToolBar.add(this.btnViewHeader);
        jToolBar.add(this.btnExportReport);
        jToolBar.add(this.btnClearResults);
        this.add((Component)jToolBar, "North");
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setDividerLocation(320);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("health_checker_data_file_list")));
        jPanel.add((Component)new JScrollPane(this.fileListTable), "Center");
        JPanel jPanel2 = this.createFileInfoPanel();
        jPanel.add((Component)jPanel2, "South");
        jSplitPane.setLeftComponent(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("health_checker_block_browser")));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 2));
        jPanel4.add(new JLabel(this.bundle.getString("health_checker_per_page")));
        jPanel4.add(this.pageSizeCombo);
        jPanel4.add(new JLabel(this.bundle.getString("health_checker_blocks")));
        jPanel4.add(Box.createHorizontalStrut(10));
        jPanel4.add(this.btnFirstPage);
        jPanel4.add(this.btnPrevPage);
        jPanel4.add(new JLabel(" " + this.bundle.getString("health_checker_page")));
        jPanel4.add(this.pageInputField);
        jPanel4.add(new JLabel(" "));
        jPanel4.add(this.btnGotoPage);
        jPanel4.add(this.btnNextPage);
        jPanel4.add(this.btnLastPage);
        jPanel4.add(Box.createHorizontalStrut(10));
        jPanel4.add(this.pageInfoLabel);
        jPanel4.add(Box.createHorizontalStrut(10));
        jPanel4.add(this.totalBlocksLabel);
        jPanel3.add((Component)jPanel4, "North");
        jPanel3.add((Component)new JScrollPane(this.blockTable), "Center");
        JPanel jPanel5 = this.createLegendPanel();
        jPanel3.add((Component)jPanel5, "South");
        jSplitPane.setRightComponent(jPanel3);
        this.add((Component)jSplitPane, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel6.add((Component)this.statusLabel, "West");
        jPanel6.add((Component)this.progressBar, "Center");
        this.add((Component)jPanel6, "South");
    }

    private JPanel createFileInfoPanel() {
        JPanel jPanel = new JPanel(new GridLayout(10, 2, 5, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("health_checker_file_info")));
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_diagnosis")));
        jPanel.add(this.lblDiagnosis);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_db_name")));
        jPanel.add(this.lblDbName);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_ts_name")));
        jPanel.add(this.lblTsName);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_file_size")));
        jPanel.add(this.lblFileSize);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_block_size")));
        jPanel.add(this.lblBlockSize);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_total_blocks")));
        jPanel.add(this.lblTotalBlocks);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_bad_blocks")));
        jPanel.add(this.lblBadBlocks);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_corruption_rate")));
        jPanel.add(this.lblCorruptionRate);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_max_scn")));
        jPanel.add(this.lblMaxScn);
        jPanel.add(new JLabel(this.bundle.getString("health_checker_lbl_max_consecutive_bad")));
        jPanel.add(this.lblMaxConsecutiveBad);
        return jPanel;
    }

    private JPanel createLegendPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 15, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("health_checker_status_legend")));
        this.addLegendItem(jPanel, COLOR_OK, this.bundle.getString("health_checker_legend_ok"));
        this.addLegendItem(jPanel, COLOR_BAD, this.bundle.getString("health_checker_legend_bad"));
        this.addLegendItem(jPanel, COLOR_WARN, this.bundle.getString("health_checker_legend_warn"));
        this.addLegendItem(jPanel, COLOR_ENCRYPTED, this.bundle.getString("health_checker_legend_encrypted"));
        this.addLegendItem(jPanel, COLOR_ZEROED, this.bundle.getString("health_checker_legend_zeroed"));
        return jPanel;
    }

    private void addLegendItem(JPanel jPanel, Color color, String string) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 3, 0));
        JLabel jLabel = new JLabel("    ");
        jLabel.setOpaque(true);
        jLabel.setBackground(color);
        jLabel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        jPanel2.add(jLabel);
        jPanel2.add(new JLabel(string));
        jPanel.add(jPanel2);
    }

    private void setupListeners() {
        this.btnAddFile.addActionListener(actionEvent -> this.addFiles());
        this.btnRemoveFile.addActionListener(actionEvent -> this.removeSelectedFile());
        this.btnStartScan.addActionListener(actionEvent -> this.startFullScan());
        this.btnStopScan.addActionListener(actionEvent -> this.stopScan());
        this.btnExportReport.addActionListener(actionEvent -> this.exportReport());
        this.btnClearResults.addActionListener(actionEvent -> this.clearResults());
        this.btnViewHeader.addActionListener(actionEvent -> this.showFileHeaderDialog());
        this.fileListTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.onFileSelected();
            }
        });
        this.pageSizeCombo.addActionListener(actionEvent -> {
            this.pageSize = Integer.parseInt((String)this.pageSizeCombo.getSelectedItem());
            this.currentPage = 0;
            this.pageInputField.setText("1");
            this.loadCurrentPageBlocks();
        });
        this.btnFirstPage.addActionListener(actionEvent -> {
            this.currentPage = 0;
            this.pageInputField.setText("1");
            this.loadCurrentPageBlocks();
        });
        this.btnPrevPage.addActionListener(actionEvent -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.pageInputField.setText(String.valueOf(this.currentPage + 1));
                this.loadCurrentPageBlocks();
            }
        });
        this.btnNextPage.addActionListener(actionEvent -> {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.pageInputField.setText(String.valueOf(this.currentPage + 1));
                this.loadCurrentPageBlocks();
            }
        });
        this.btnLastPage.addActionListener(actionEvent -> {
            this.currentPage = Math.max(0, this.totalPages - 1);
            this.pageInputField.setText(String.valueOf(this.currentPage + 1));
            this.loadCurrentPageBlocks();
        });
        this.btnGotoPage.addActionListener(actionEvent -> this.gotoPage());
        this.pageInputField.addActionListener(actionEvent -> this.gotoPage());
        this.blockTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DataFileHealthCheckerDialog.this.showBlockDetail();
                }
            }
        });
    }

    private void gotoPage() {
        try {
            int n2 = Integer.parseInt(this.pageInputField.getText().trim());
            if (n2 >= 1 && n2 <= this.totalPages) {
                this.currentPage = n2 - 1;
                this.loadCurrentPageBlocks();
            } else {
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.bundle.getString("health_checker_page_invalid"), this.totalPages), this.bundle.getString("health_checker_page_invalid_title"), 2);
                this.pageInputField.setText(String.valueOf(this.currentPage + 1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("health_checker_page_number_error"), this.bundle.getString("health_checker_page_number_error_title"), 2);
            this.pageInputField.setText(String.valueOf(this.currentPage + 1));
        }
    }

    private void addFiles() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(this.bundle.getString("health_checker_file_filter_dbf"), "dbf", "DBF");
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            for (File file : jFileChooser.getSelectedFiles()) {
                this.addFileToList(file.getAbsolutePath());
            }
        }
    }

    private void addFileToList(String string) {
        for (O0O0 o0O0 : this.fileHealthInfoList) {
            if (!o0O0.\u03bd().equals(string)) continue;
            return;
        }
        this.statusLabel.setText(this.bundle.getString("health_checker_loading_file"));
        O0O0 o0O0 = this.healthCheckService.O0(string);
        this.fileHealthInfoList.add(o0O0);
        this.fileListModel.addRow(new Object[]{"-", o0O0.getFileName(), String.format("%,d", o0O0.\u03b6()), "-", "-"});
        this.statusLabel.setText(MessageFormat.format(this.bundle.getString("health_checker_file_loaded"), o0O0.getFileName()));
        int n2 = this.fileListModel.getRowCount() - 1;
        SwingUtilities.invokeLater(() -> {
            this.fileListTable.setRowSelectionInterval(n2, n2);
            SwingUtilities.invokeLater(() -> this.loadCurrentPageBlocks());
        });
    }

    private void removeSelectedFile() {
        int n2 = this.fileListTable.getSelectedRow();
        if (n2 >= 0 && n2 < this.fileHealthInfoList.size()) {
            this.fileHealthInfoList.remove(n2);
            this.fileListModel.removeRow(n2);
            if (this.fileListTable.getRowCount() == 0) {
                this.currentHealthInfo = null;
                this.clearBlockTable();
                this.resetFileInfoPanel();
            }
        }
    }

    private void onFileSelected() {
        int n2 = this.fileListTable.getSelectedRow();
        if (n2 >= 0 && n2 < this.fileHealthInfoList.size()) {
            this.currentHealthInfo = this.fileHealthInfoList.get(n2);
            this.totalBlocks = this.currentHealthInfo.\u03b6();
            this.totalPages = (int)Math.ceil((double)this.totalBlocks / (double)this.pageSize);
            this.currentPage = 0;
            this.pageInputField.setText("1");
            this.updateFileInfoPanel();
            this.loadCurrentPageBlocks();
            this.btnExportReport.setEnabled(this.currentHealthInfo._I() == 2);
            this.btnViewHeader.setEnabled(this.currentHealthInfo.O0() != null);
        }
    }

    private void loadCurrentPageBlocks() {
        if (this.currentHealthInfo == null) {
            return;
        }
        this.blockModel.setRowCount(0);
        long l2 = (long)this.currentPage * (long)this.pageSize;
        final int n2 = (int)Math.min((long)this.pageSize, this.totalBlocks - l2);
        if (n2 <= 0) {
            this.updatePageInfo();
            return;
        }
        this.statusLabel.setText(MessageFormat.format(this.bundle.getString("health_checker_loading_blocks"), l2, l2 + (long)n2 - 1L));
        final long l3 = l2;
        SwingWorker<List<\u03c6>, Void> swingWorker = new SwingWorker<List<\u03c6>, Void>(){

            protected List<\u03c6> I() {
                ByteOrder byteOrder = DataFileHealthCheckerDialog.this.currentHealthInfo.l1l() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                return DataFileHealthCheckerDialog.this.healthCheckService.O0(DataFileHealthCheckerDialog.this.currentHealthInfo.\u03bd(), l3, n2, DataFileHealthCheckerDialog.this.currentHealthInfo.getBlockSize(), DataFileHealthCheckerDialog.this.currentHealthInfo._l(), byteOrder);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    for (\u03c6 \u03c62 : list) {
                        DataFileHealthCheckerDialog.this.blockModel.addRow(new Object[]{\u03c62.a_(), \u03c62._a(), \u03c62.\u03b6() != null ? \u03c62.\u03b6() : "-", DataFileHealthCheckerDialog.this.getLocalizedBlockTypeName(\u03c62.\u03b5()), \u03c62.\u03b7(), \u03c62.getStatus(), String.format("%.2f", \u03c62.O0())});
                    }
                    DataFileHealthCheckerDialog.this.updatePageInfo();
                    DataFileHealthCheckerDialog.this.statusLabel.setText(MessageFormat.format(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_loaded_blocks"), l3, l3 + (long)list.size() - 1L));
                }
                catch (Exception exception) {
                    DataFileHealthCheckerDialog.this.statusLabel.setText(MessageFormat.format(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_scan_error"), exception.getMessage()));
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.I();
            }
        };
        swingWorker.execute();
    }

    private void updatePageInfo() {
        this.totalPages = (int)Math.ceil((double)this.totalBlocks / (double)this.pageSize);
        if (this.totalPages == 0) {
            this.totalPages = 1;
        }
        this.pageInfoLabel.setText(MessageFormat.format(this.bundle.getString("health_checker_page_info"), this.currentPage + 1, this.totalPages));
        this.totalBlocksLabel.setText(MessageFormat.format(this.bundle.getString("health_checker_total_blocks_info"), String.format("%,d", this.totalBlocks)));
        this.btnFirstPage.setEnabled(this.currentPage > 0);
        this.btnPrevPage.setEnabled(this.currentPage > 0);
        this.btnNextPage.setEnabled(this.currentPage < this.totalPages - 1);
        this.btnLastPage.setEnabled(this.currentPage < this.totalPages - 1);
    }

    private void startFullScan() {
        int n2 = this.fileListTable.getSelectedRow();
        if (n2 < 0) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("health_checker_select_file_first"), this.bundle.getString("health_checker_info"), 1);
            return;
        }
        O0O0 o0O0 = this.fileHealthInfoList.get(n2);
        this.setUIScanning(true);
        this.fileListModel.setValueAt("\u25cf", n2, 0);
        final int n3 = n2;
        this.healthCheckService.O0(o0O0.\u03bd(), new \u03c9.O0(){

            @Override
            public void O0(long l2, long l3, \u03c6 \u03c62) {
                SwingUtilities.invokeLater(() -> {
                    int n32 = (int)(l2 * 100L / l3);
                    DataFileHealthCheckerDialog.this.progressBar.setValue(n32);
                    DataFileHealthCheckerDialog.this.progressBar.setString(MessageFormat.format(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_status_scanning"), "", String.format("%,d", l2), String.format("%,d", l3)));
                    DataFileHealthCheckerDialog.this.fileListModel.setValueAt(String.format("%,d", l2), n3, 3);
                });
            }

            @Override
            public void O0(\u03c6 \u03c62) {
                SwingUtilities.invokeLater(() -> {
                    O0O0 o0O0 = DataFileHealthCheckerDialog.this.fileHealthInfoList.get(n3);
                    DataFileHealthCheckerDialog.this.fileListModel.setValueAt(String.format("%,d", o0O0.O0().size()), n3, 4);
                });
            }

            @Override
            public void O0(O0O0 o0O0) {
                SwingUtilities.invokeLater(() -> {
                    DataFileHealthCheckerDialog.this.fileHealthInfoList.set(n3, o0O0);
                    String string = o0O0.\u03ba() > 0L ? "X" : "OK";
                    DataFileHealthCheckerDialog.this.fileListModel.setValueAt(string, n3, 0);
                    DataFileHealthCheckerDialog.this.fileListModel.setValueAt(String.format("%,d", o0O0.\u03b7()), n3, 3);
                    DataFileHealthCheckerDialog.this.fileListModel.setValueAt(String.format("%,d", o0O0.\u03ba()), n3, 4);
                    if (DataFileHealthCheckerDialog.this.fileListTable.getSelectedRow() == n3) {
                        DataFileHealthCheckerDialog.this.currentHealthInfo = o0O0;
                        DataFileHealthCheckerDialog.this.updateFileInfoPanel();
                    }
                    DataFileHealthCheckerDialog.this.setUIScanning(false);
                    DataFileHealthCheckerDialog.this.progressBar.setValue(100);
                    DataFileHealthCheckerDialog.this.progressBar.setString(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_scan_complete"));
                    DataFileHealthCheckerDialog.this.statusLabel.setText(MessageFormat.format(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_status_completed"), o0O0.\u03ba(), o0O0.\u03bb()));
                    DataFileHealthCheckerDialog.this.btnExportReport.setEnabled(true);
                });
            }

            @Override
            public void aa_(String string) {
                SwingUtilities.invokeLater(() -> {
                    DataFileHealthCheckerDialog.this.fileListModel.setValueAt("!", n3, 0);
                    DataFileHealthCheckerDialog.this.setUIScanning(false);
                    DataFileHealthCheckerDialog.this.progressBar.setValue(0);
                    DataFileHealthCheckerDialog.this.progressBar.setString(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_status_error"));
                    DataFileHealthCheckerDialog.this.statusLabel.setText(MessageFormat.format(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_scan_error"), string));
                    JOptionPane.showMessageDialog(DataFileHealthCheckerDialog.this, MessageFormat.format(DataFileHealthCheckerDialog.this.bundle.getString("health_checker_scan_error"), string), DataFileHealthCheckerDialog.this.bundle.getString("health_checker_status_error"), 0);
                });
            }
        });
    }

    private void stopScan() {
        this.healthCheckService.stopScan();
        this.statusLabel.setText(this.bundle.getString("health_checker_status_stopped"));
        this.progressBar.setString(this.bundle.getString("health_checker_status_stopped"));
        this.setUIScanning(false);
    }

    private void exportReport() {
        String string;
        String string2;
        if (this.currentHealthInfo == null || this.currentHealthInfo._I() != 2) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("health_checker_no_file_selected"), this.bundle.getString("health_checker_info"), 1);
            return;
        }
        Object[] objectArray = new String[]{this.bundle.getString("health_checker_export_format_txt"), this.bundle.getString("health_checker_export_format_csv"), this.bundle.getString("health_checker_export_format_html"), this.bundle.getString("health_checker_export_format_json")};
        String string3 = (String)JOptionPane.showInputDialog(this, this.bundle.getString("health_checker_export_choose_format"), this.bundle.getString("health_checker_export_title"), 3, null, objectArray, objectArray[0]);
        if (string3 == null) {
            return;
        }
        if (string3.equals(objectArray[0])) {
            string2 = "TXT";
            string = ".txt";
        } else if (string3.equals(objectArray[1])) {
            string2 = "CSV";
            string = ".csv";
        } else if (string3.equals(objectArray[2])) {
            string2 = "HTML";
            string = ".html";
        } else {
            string2 = "JSON";
            string = ".json";
        }
        JFileChooser jFileChooser = new JFileChooser();
        String string4 = this.currentHealthInfo.getFileName().replaceAll("\\.[^.]+$", "") + "_health_report" + string;
        jFileChooser.setSelectedFile(new File(string4));
        if (jFileChooser.showSaveDialog(this) == 0) {
            try {
                Object object = jFileChooser.getSelectedFile().getAbsolutePath();
                if (!((String)object).toLowerCase().endsWith(string)) {
                    object = (String)object + string;
                }
                this.reportGenerator.O0(this.currentHealthInfo, string2, (String)object);
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.bundle.getString("health_checker_export_success"), object), this.bundle.getString("health_checker_export_success_title"), 1);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(this.bundle.getString("health_checker_export_error"), exception.getMessage()), this.bundle.getString("health_checker_export_error_title"), 0);
            }
        }
    }

    private void clearResults() {
        this.fileHealthInfoList.clear();
        this.fileListModel.setRowCount(0);
        this.blockModel.setRowCount(0);
        this.currentHealthInfo = null;
        this.progressBar.setValue(0);
        this.progressBar.setString(this.bundle.getString("health_checker_status_idle"));
        this.statusLabel.setText(this.bundle.getString("health_checker_add_data_file"));
        this.btnExportReport.setEnabled(false);
        this.resetFileInfoPanel();
        this.totalBlocks = 0L;
        this.totalPages = 0;
        this.currentPage = 0;
        this.updatePageInfo();
    }

    private void updateFileInfoPanel() {
        if (this.currentHealthInfo != null) {
            \u03c8 \u03c82 = this.currentHealthInfo.O0();
            if (\u03c82 != null) {
                this.lblDbName.setText(\u03c82.\u03bb() != null ? \u03c82.\u03bb() : "-");
                this.lblTsName.setText(\u03c82.\u03bc() != null ? \u03c82.\u03bc() : "-");
            } else {
                this.lblDbName.setText("-");
                this.lblTsName.setText("-");
            }
            if (this.currentHealthInfo._I() == 2) {
                this.lblDiagnosis.setText(this.getLocalizedDiagnosis(this.currentHealthInfo));
                this.lblBadBlocks.setText(String.format("%,d", this.currentHealthInfo.\u03ba()));
                this.lblCorruptionRate.setText(this.currentHealthInfo.\u03c3());
                this.lblMaxScn.setText(String.format("%,d", this.currentHealthInfo.\u03bf()));
                if (this.currentHealthInfo.aa_() > 0) {
                    this.lblMaxConsecutiveBad.setText(MessageFormat.format(this.bundle.getString("health_checker_consecutive_bad_info"), this.currentHealthInfo.aa_(), this.currentHealthInfo.\u03c4()));
                } else {
                    this.lblMaxConsecutiveBad.setText(this.bundle.getString("health_checker_no_consecutive_bad"));
                }
            } else {
                String string = this.getLocalizedQuickDiagnosis(this.currentHealthInfo);
                this.lblDiagnosis.setText(string);
                if (this.currentHealthInfo.__a() > 0 || this.currentHealthInfo._a_() > 0) {
                    int n2 = this.currentHealthInfo.__a() + this.currentHealthInfo._a_() + this.currentHealthInfo.a_a() + this.currentHealthInfo._aa();
                    int n3 = this.currentHealthInfo._a_() + this.currentHealthInfo.a_a() + this.currentHealthInfo._aa();
                    this.lblBadBlocks.setText(MessageFormat.format(this.bundle.getString("health_checker_sample_stats"), n3, n2));
                } else {
                    this.lblBadBlocks.setText("-");
                }
                this.lblCorruptionRate.setText("-");
                this.lblMaxScn.setText("-");
                this.lblMaxConsecutiveBad.setText("-");
            }
            this.lblFileSize.setText(this.currentHealthInfo.\u03c1());
            this.lblBlockSize.setText(this.currentHealthInfo.getBlockSize() + " bytes");
            this.lblTotalBlocks.setText(String.format("%,d", this.currentHealthInfo.\u03b6()));
        }
    }

    private void resetFileInfoPanel() {
        this.lblDiagnosis.setText("-");
        this.lblFileSize.setText("-");
        this.lblBlockSize.setText("-");
        this.lblTotalBlocks.setText("-");
        this.lblBadBlocks.setText("-");
        this.lblCorruptionRate.setText("-");
        this.lblDbName.setText("-");
        this.lblTsName.setText("-");
        this.lblMaxScn.setText("-");
        this.lblMaxConsecutiveBad.setText("-");
    }

    private String getLocalizedQuickDiagnosis(O0O0 o0O0) {
        int n2 = o0O0.a__();
        int n3 = o0O0._a_() + o0O0.a_a() + o0O0._aa();
        switch (n2) {
            case 1: {
                if (n3 == 0) {
                    return this.bundle.getString("health_checker_quick_diag_normal");
                }
                return MessageFormat.format(this.bundle.getString("health_checker_quick_diag_normal_minor"), n3);
            }
            case 2: {
                if (o0O0.a_a() > o0O0._aa()) {
                    return this.bundle.getString("health_checker_quick_diag_header_missing_zeroed");
                }
                return this.bundle.getString("health_checker_quick_diag_header_missing_encrypted");
            }
            case 3: {
                return this.bundle.getString("health_checker_quick_diag_header_corrupted");
            }
            case 4: {
                int n4 = o0O0.__a() + o0O0._a_() + o0O0.a_a() + o0O0._aa();
                String string = n4 > 0 ? String.format("%.0f%%", (double)o0O0._aa() / (double)n4 * 100.0) : "?%";
                return MessageFormat.format(this.bundle.getString("health_checker_quick_diag_ransomware"), string);
            }
            case 5: {
                int n5 = o0O0.__a() + o0O0._a_() + o0O0.a_a() + o0O0._aa();
                String string = n5 > 0 ? String.format("%.0f%%", (double)o0O0.a_a() / (double)n5 * 100.0) : "?%";
                return MessageFormat.format(this.bundle.getString("health_checker_quick_diag_zeroed"), string);
            }
            case 6: {
                return MessageFormat.format(this.bundle.getString("health_checker_quick_diag_partial_damage"), n3);
            }
        }
        return this.bundle.getString("health_checker_diag_not_scanned");
    }

    private String getLocalizedDiagnosis(O0O0 o0O0) {
        int n2 = o0O0._O();
        switch (n2) {
            case 0: {
                return this.bundle.getString("health_checker_diag_healthy");
            }
            case 1: {
                return MessageFormat.format(this.bundle.getString("health_checker_diag_minor"), o0O0.\u03c3(), o0O0.\u03ba());
            }
            case 6: {
                return MessageFormat.format(this.bundle.getString("health_checker_diag_corrupted"), o0O0.\u03c3(), o0O0.\u03ba());
            }
            case 2: {
                return MessageFormat.format(this.bundle.getString("health_checker_diag_partial_encrypted"), String.format("%.1f%%", o0O0.I1() * 100.0));
            }
            case 3: {
                return this.bundle.getString("health_checker_diag_full_encrypted");
            }
            case 4: {
                return MessageFormat.format(this.bundle.getString("health_checker_diag_partial_zeroed"), String.format("%.1f%%", o0O0.Il() * 100.0));
            }
            case 5: {
                return this.bundle.getString("health_checker_diag_full_zeroed");
            }
        }
        return this.bundle.getString("health_checker_diag_not_scanned");
    }

    private void showFileHeaderDialog() {
        if (this.currentHealthInfo == null || this.currentHealthInfo.O0() == null) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("health_checker_header_unavailable"), this.bundle.getString("health_checker_info"), 1);
            return;
        }
        FileHeaderDialog fileHeaderDialog = new FileHeaderDialog((Window)this, this.currentHealthInfo);
        fileHeaderDialog.setVisible(true);
    }

    private String getLocalizedBlockTypeName(String string) {
        if (string == null) {
            return this.bundle.getString("health_checker_block_type_unknown");
        }
        switch (string) {
            case "\u672a\u521d\u59cb\u5316": {
                return this.bundle.getString("health_checker_block_type_uninit");
            }
            case "\u56de\u6eda\u6bb5\u5934": {
                return this.bundle.getString("health_checker_block_type_undo_header");
            }
            case "\u56de\u6eda\u6570\u636e": {
                return this.bundle.getString("health_checker_block_type_undo_data");
            }
            case "\u4fdd\u5b58\u56de\u6eda\u5934": {
                return this.bundle.getString("health_checker_block_type_save_undo_header");
            }
            case "\u4fdd\u5b58\u56de\u6eda\u6570\u636e": {
                return this.bundle.getString("health_checker_block_type_save_undo_data");
            }
            case "\u6bb5\u5934(MSSM)": {
                return this.bundle.getString("health_checker_block_type_seg_header_mssm");
            }
            case "\u8868\u6570\u636e": {
                return this.bundle.getString("health_checker_block_type_table_data");
            }
            case "\u4e34\u65f6\u8868\u6570\u636e": {
                return this.bundle.getString("health_checker_block_type_temp_table_data");
            }
            case "\u6bb5\u7a7a\u95f2\u5217\u8868": {
                return this.bundle.getString("health_checker_block_type_seg_freelist");
            }
            case "\u6587\u4ef6\u5934": {
                return this.bundle.getString("health_checker_block_type_file_header");
            }
            case "\u6bb5\u5934(MSSM)\u6269\u5c55": {
                return this.bundle.getString("health_checker_block_type_seg_header_mssm_ext");
            }
            case "\u6bb5\u5934(ASSM)": {
                return this.bundle.getString("health_checker_block_type_seg_header_assm");
            }
            case "\u6bb5\u5934(ASSM)\u6269\u5c55": {
                return this.bundle.getString("health_checker_block_type_seg_header_assm_ext");
            }
            case "\u533a\u6620\u5c04": {
                return this.bundle.getString("health_checker_block_type_extent_map");
            }
            case "\u63a7\u5236\u6587\u4ef6": {
                return this.bundle.getString("health_checker_block_type_control_file");
            }
            case "\u4f4d\u56fe\u6bb5\u5934": {
                return this.bundle.getString("health_checker_block_type_bitmap_seg_header");
            }
            case "\u4f4d\u56fe\u7a7a\u95f2\u5217\u8868": {
                return this.bundle.getString("health_checker_block_type_bitmap_freelist");
            }
            case "\u4f4d\u56fe\u7d22\u5f15": {
                return this.bundle.getString("health_checker_block_type_bitmap_index");
            }
            case "\u4f4d\u56fe": {
                return this.bundle.getString("health_checker_block_type_bitmap");
            }
            case "LOB\u6570\u636e": {
                return this.bundle.getString("health_checker_block_type_lob_data");
            }
            case "\u7a7a\u95f4\u7ba1\u7406\u5934": {
                return this.bundle.getString("health_checker_block_type_space_mgmt_header");
            }
            case "\u7a7a\u95f4\u7ba1\u7406\u4f4d\u56fe": {
                return this.bundle.getString("health_checker_block_type_space_mgmt_bitmap");
            }
            case "\u4e34\u65f6\u7d22\u5f15": {
                return this.bundle.getString("health_checker_block_type_temp_index");
            }
            case "\u4e00\u7ea7\u4f4d\u56fe": {
                return this.bundle.getString("health_checker_block_type_bitmap_l1");
            }
            case "\u4e8c\u7ea7\u4f4d\u56fe": {
                return this.bundle.getString("health_checker_block_type_bitmap_l2");
            }
            case "\u4e09\u7ea7\u4f4d\u56fe": {
                return this.bundle.getString("health_checker_block_type_bitmap_l3");
            }
            case "\u9875\u8868\u5934": {
                return this.bundle.getString("health_checker_block_type_pagetable_header");
            }
            case "\u9875\u8868\u533a": {
                return this.bundle.getString("health_checker_block_type_pagetable_extent");
            }
            case "\u56de\u6eda\u533a\u6620\u5c04": {
                return this.bundle.getString("health_checker_block_type_undo_extent_map");
            }
            case "\u56de\u6eda\u6bb5\u7ba1\u7406\u5934": {
                return this.bundle.getString("health_checker_block_type_undo_seg_mgmt_header");
            }
            case "SPFILE\u5907\u4efd": {
                return this.bundle.getString("health_checker_block_type_spfile_backup");
            }
            case "\u9875\u8868LOB": {
                return this.bundle.getString("health_checker_block_type_pagetable_lob");
            }
            case "\u6e05\u96f6": 
            case "\u6e05\u96f6\u5757": {
                return this.bundle.getString("health_checker_legend_zeroed").split(" - ")[0];
            }
            case "\u52a0\u5bc6": 
            case "\u52a0\u5bc6\u5757": {
                return this.bundle.getString("health_checker_legend_encrypted").split(" - ")[0];
            }
            case "\u65e0\u6548\u7c7b\u578b": {
                return this.bundle.getString("health_checker_block_type_invalid");
            }
        }
        if (string.startsWith("\u7c7b\u578b")) {
            return "Type" + string.substring(2);
        }
        return string;
    }

    private void clearBlockTable() {
        this.blockModel.setRowCount(0);
        this.pageInfoLabel.setText(MessageFormat.format(this.bundle.getString("health_checker_page_info"), 0, 0));
        this.totalBlocksLabel.setText(MessageFormat.format(this.bundle.getString("health_checker_total_blocks_info"), 0));
    }

    private void showBlockDetail() {
        int n2 = this.blockTable.getSelectedRow();
        if (n2 < 0 || this.currentHealthInfo == null) {
            return;
        }
        long l2 = (Long)this.blockModel.getValueAt(n2, 0);
        ByteOrder byteOrder = this.currentHealthInfo.l1l() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        List<\u03c6> list = this.healthCheckService.O0(this.currentHealthInfo.\u03bd(), l2, 1, this.currentHealthInfo.getBlockSize(), this.currentHealthInfo._l(), byteOrder);
        if (list.isEmpty()) {
            return;
        }
        \u03c6 \u03c62 = list.get(0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_block_no")).append(" ").append(\u03c62.a_()).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_block_id")).append(" ").append(\u03c62._a()).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_rdba")).append(" ").append(\u03c62.\u03b6()).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_type")).append(" ").append(this.getLocalizedBlockTypeName(\u03c62.\u03b5())).append(" (").append(\u03c62.Ill()).append(")\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_status")).append(" ").append(\u03c62.getStatus()).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_error_type")).append(" ").append(\u03c62.\u03b7()).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_entropy")).append(" ").append(String.format("%.2f", \u03c62.O0())).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_stored_chksum")).append(" ").append(String.format("0x%04X", \u03c62.IlI())).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_computed_chksum")).append(" ").append(String.format("0x%04X", \u03c62.IIl())).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_stored_tail")).append(" ").append(String.format("0x%08X", \u03c62.__())).append("\n");
        stringBuilder.append(this.bundle.getString("health_checker_block_detail_computed_tail")).append(" ").append(String.format("0x%08X", \u03c62.___())).append("\n");
        stringBuilder.append("\n").append(this.bundle.getString("health_checker_block_detail_error_detail")).append("\n").append(\u03c62.\u03b8() != null ? \u03c62.\u03b8() : this.bundle.getString("health_checker_block_detail_none"));
        if (\u03c62.\u03b9() != null) {
            stringBuilder.append("\n\nRaw Data (first 64 bytes):\n").append(\u03c62.\u03b9());
        }
        JTextArea jTextArea = new JTextArea(stringBuilder.toString());
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(550, 450));
        JOptionPane.showMessageDialog(this, jScrollPane, MessageFormat.format(this.bundle.getString("health_checker_block_detail_title"), \u03c62.a_()), 1);
    }

    private void setUIScanning(boolean bl2) {
        this.btnAddFile.setEnabled(!bl2);
        this.btnRemoveFile.setEnabled(!bl2);
        this.btnStartScan.setEnabled(!bl2);
        this.btnStopScan.setEnabled(bl2);
        this.btnExportReport.setEnabled(!bl2 && this.currentHealthInfo != null && this.currentHealthInfo._I() == 2);
        this.btnClearResults.setEnabled(!bl2);
        this.fileListTable.setEnabled(!bl2);
    }

    public static void showDialog(Frame frame) {
        DataFileHealthCheckerDialog dataFileHealthCheckerDialog = new DataFileHealthCheckerDialog(frame);
        dataFileHealthCheckerDialog.setVisible(true);
    }

    private class BlockTableCellRenderer
    extends DefaultTableCellRenderer {
        private BlockTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (!bl2) {
                String string;
                Object object2 = jTable.getValueAt(n2, 5);
                switch (string = object2 != null ? object2.toString() : "") {
                    case "OK": {
                        component.setBackground(COLOR_OK);
                        break;
                    }
                    case "BAD": {
                        component.setBackground(COLOR_BAD);
                        break;
                    }
                    case "WARN": {
                        component.setBackground(COLOR_WARN);
                        break;
                    }
                    case "ENCRYPTED": {
                        component.setBackground(COLOR_ENCRYPTED);
                        break;
                    }
                    case "ZEROED": {
                        component.setBackground(COLOR_ZEROED);
                        break;
                    }
                    default: {
                        component.setBackground(COLOR_DEFAULT);
                    }
                }
            }
            return component;
        }
    }
}

