/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.healthcheck;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import o.O0O0;
import o.\u03c8;

public class FileHeaderDialog
extends JDialog {
    private final ResourceBundle bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
    private O0O0 healthInfo;
    private \u03c8 header;
    private JTextArea summaryArea;
    private JButton copyButton;
    private JButton closeButton;
    private JLabel lblDbName;
    private JLabel lblDbId;
    private JLabel lblTsName;
    private JLabel lblTsn;
    private JLabel lblFno;
    private JLabel lblRfn;
    private JLabel lblCkpScn;
    private JLabel lblRlsScn;
    private JLabel lblCrsScn;
    private JLabel lblMaxScn;
    private JLabel lblCkpTime;
    private JLabel lblCrtTime;
    private JLabel lblChecksum;
    private JLabel lblTailChk;
    private JLabel lblHeaderValid;

    public FileHeaderDialog(Window window, O0O0 o0O0) {
        super(window, Dialog.ModalityType.APPLICATION_MODAL);
        this.healthInfo = o0O0;
        this.header = o0O0.O0();
        this.setTitle(this.bundle.getString("health_checker_file_header_title") + " - " + o0O0.getFileName());
        this.initComponents();
        this.populateData();
        this.setSize(800, 700);
        this.setLocationRelativeTo(window);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = this.createStatusPanel();
        jPanel.add((Component)jPanel2, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel3 = this.createSummaryPanel();
        jTabbedPane.addTab(this.bundle.getString("health_checker_tab_summary"), jPanel3);
        JPanel jPanel4 = this.createDetailPanel();
        jTabbedPane.addTab(this.bundle.getString("health_checker_tab_detail"), jPanel4);
        JPanel jPanel5 = this.createRawOutputPanel();
        jTabbedPane.addTab(this.bundle.getString("health_checker_tab_raw"), jPanel5);
        jPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel6 = new JPanel(new FlowLayout(2));
        this.copyButton = new JButton(this.bundle.getString("health_checker_btn_copy"));
        this.closeButton = new JButton(this.bundle.getString("health_checker_btn_close"));
        this.copyButton.addActionListener(actionEvent -> this.copyToClipboard());
        this.closeButton.addActionListener(actionEvent -> this.dispose());
        jPanel6.add(this.copyButton);
        jPanel6.add(this.closeButton);
        jPanel.add((Component)jPanel6, "South");
        this.add(jPanel);
    }

    private JPanel createStatusPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 20, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("health_checker_header_status")));
        this.lblHeaderValid = new JLabel();
        this.lblChecksum = new JLabel();
        this.lblTailChk = new JLabel();
        jPanel.add(this.lblHeaderValid);
        jPanel.add(new JSeparator(1));
        jPanel.add(this.lblChecksum);
        jPanel.add(new JSeparator(1));
        jPanel.add(this.lblTailChk);
        return jPanel;
    }

    private JPanel createSummaryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        JPanel jPanel2 = new JPanel(new GridLayout(3, 4, 10, 5));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("health_checker_db_info")));
        jPanel2.add(new JLabel(this.bundle.getString("health_checker_db_name") + ":"));
        this.lblDbName = new JLabel();
        jPanel2.add(this.lblDbName);
        jPanel2.add(new JLabel(this.bundle.getString("health_checker_dbid") + ":"));
        this.lblDbId = new JLabel();
        jPanel2.add(this.lblDbId);
        jPanel2.add(new JLabel(this.bundle.getString("health_checker_ts_name") + ":"));
        this.lblTsName = new JLabel();
        jPanel2.add(this.lblTsName);
        jPanel2.add(new JLabel(this.bundle.getString("health_checker_tsn") + ":"));
        this.lblTsn = new JLabel();
        jPanel2.add(this.lblTsn);
        jPanel2.add(new JLabel(this.bundle.getString("health_checker_fno") + ":"));
        this.lblFno = new JLabel();
        jPanel2.add(this.lblFno);
        jPanel2.add(new JLabel(this.bundle.getString("health_checker_rfn") + ":"));
        this.lblRfn = new JLabel();
        jPanel2.add(this.lblRfn);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 4, 10, 5));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("health_checker_scn_info")));
        jPanel3.add(new JLabel(this.bundle.getString("health_checker_ckp_scn") + ":"));
        this.lblCkpScn = new JLabel();
        jPanel3.add(this.lblCkpScn);
        jPanel3.add(new JLabel(this.bundle.getString("health_checker_rls_scn") + ":"));
        this.lblRlsScn = new JLabel();
        jPanel3.add(this.lblRlsScn);
        jPanel3.add(new JLabel(this.bundle.getString("health_checker_crs_scn") + ":"));
        this.lblCrsScn = new JLabel();
        jPanel3.add(this.lblCrsScn);
        jPanel3.add(new JLabel(this.bundle.getString("health_checker_max_scn") + ":"));
        this.lblMaxScn = new JLabel();
        jPanel3.add(this.lblMaxScn);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 4, 10, 5));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("health_checker_time_info")));
        jPanel4.add(new JLabel(this.bundle.getString("health_checker_ckp_time") + ":"));
        this.lblCkpTime = new JLabel();
        jPanel4.add(this.lblCkpTime);
        jPanel4.add(new JLabel(this.bundle.getString("health_checker_crt_time") + ":"));
        this.lblCrtTime = new JLabel();
        jPanel4.add(this.lblCrtTime);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JLabel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel createDetailPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Object[] objectArray = new String[]{this.bundle.getString("health_checker_field"), this.bundle.getString("health_checker_value"), this.bundle.getString("health_checker_hex"), this.bundle.getString("health_checker_description")};
        Object[][] objectArray2 = new Object[0][4];
        if (this.header != null) {
            objectArray2 = new Object[][]{{"type_kcbh", this.header.O0l(), String.format("0x%02X", this.header.O0l()), "Block type (0x0B = File Header)"}, {"frmt_kcbh", this.header.lO0(), String.format("0x%02X", this.header.lO0()), "Block format"}, {"rdba_kcbh", this.header._l(), String.format("0x%08X", this.header._l()), "Relative Data Block Address"}, {"chkval_kcbh", this.header.a_(), String.format("0x%04X", this.header.a_()), "Stored checksum"}, {"computed_chkval", this.header.IIl(), String.format("0x%04X", this.header.IIl()), "Computed checksum"}, {"stored_tailchk", this.header.__(), String.format("0x%08X", this.header.__()), "Stored tail check"}, {"computed_tailchk", this.header.___(), String.format("0x%08X", this.header.___()), "Computed tail check"}, {"kccfhdbi", this.header._O(), String.format("0x%08X", this.header._O()), "Database ID (DBID)"}, {"kccfhdbn", this.header.\u03bb(), "-", "Database name"}, {"kccfhcvn", this.header._I(), String.format("0x%08X", this.header._I()), "Compatibility version"}, {"kccfhfsz", this.header.a__(), String.format("0x%08X", this.header.a__()), "File size in blocks"}, {"kccfhfno", this.header._a(), String.format("0x%04X", this.header._a()), "Absolute file number"}, {"kcvfhtsn", this.header.___(), String.format("0x%04X", this.header.___()), "Tablespace number"}, {"kcvfhtnm", this.header.\u03bc(), "-", "Tablespace name"}, {"kcvfhrfn", this.header.\u03b1(), String.format("0x%08X", this.header.\u03b1()), "Relative file number"}, {"kcvfhsta", this.header.__(), String.format("0x%04X", this.header.__()), "Status/Fuzz flags"}, {"kcvfhcrt", this.header._aa(), String.format("0x%08X", this.header._aa()), "Creation timestamp"}, {"kcvfhrlc", this.header.aa_(), String.format("0x%08X", this.header.aa_()), "Resetlogs counter"}, {"ckp_scn", this.header.__a(), "-", "Checkpoint SCN"}, {"rls_scn", this.header._a_(), "-", "Resetlogs SCN"}, {"crs_scn", this.header.a_a(), "-", "Creation SCN"}, {"ckp_time", this.header.\u03b2(), String.format("0x%08X", this.header.\u03b2()), "Checkpoint time"}, {"redo_seq", this.header.\u03b3(), String.format("0x%08X", this.header.\u03b3()), "Redo log sequence"}, {"block0_blocksize", this.header._1(), "-", "Block 0 indicated block size"}, {"block0_blockcount", this.header.\u03b4(), "-", "Block 0 indicated block count"}};
        }
        JTable jTable = new JTable(objectArray2, objectArray);
        jTable.setAutoCreateRowSorter(true);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        jTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        jTable.getColumnModel().getColumn(3).setPreferredWidth(250);
        jPanel.add((Component)new JScrollPane(jTable), "Center");
        return jPanel;
    }

    private JPanel createRawOutputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.summaryArea = new JTextArea();
        this.summaryArea.setEditable(false);
        this.summaryArea.setFont(new Font("Consolas", 0, 12));
        this.summaryArea.setBackground(new Color(30, 30, 30));
        this.summaryArea.setForeground(new Color(0, 255, 0));
        this.summaryArea.setCaretColor(Color.WHITE);
        if (this.header != null) {
            this.summaryArea.setText(this.header.\u03ba());
        } else {
            this.summaryArea.setText("File header information not available");
        }
        jPanel.add((Component)new JScrollPane(this.summaryArea), "Center");
        return jPanel;
    }

    private void populateData() {
        if (this.header == null) {
            this.lblHeaderValid.setText("\u26a0 " + this.bundle.getString("health_checker_header_unavailable"));
            this.lblHeaderValid.setForeground(Color.ORANGE);
            return;
        }
        if (this.header.isValid()) {
            this.lblHeaderValid.setText("\u2713 " + this.bundle.getString("health_checker_header_valid"));
            this.lblHeaderValid.setForeground(new Color(0, 150, 0));
        } else {
            this.lblHeaderValid.setText("\u2717 " + this.bundle.getString("health_checker_header_invalid"));
            this.lblHeaderValid.setForeground(Color.RED);
        }
        if (this.header._a_()) {
            this.lblChecksum.setText("\u2713 Checksum OK");
            this.lblChecksum.setForeground(new Color(0, 150, 0));
        } else {
            this.lblChecksum.setText("\u2717 Checksum Mismatch");
            this.lblChecksum.setForeground(Color.RED);
        }
        if (this.header.a_a()) {
            this.lblTailChk.setText("\u2713 TailChk OK");
            this.lblTailChk.setForeground(new Color(0, 150, 0));
        } else {
            this.lblTailChk.setText("\u2717 TailChk Mismatch");
            this.lblTailChk.setForeground(Color.RED);
        }
        this.lblDbName.setText(this.header.\u03bb());
        this.lblDbId.setText(String.format("%d (0x%08X)", this.header._O(), this.header._O()));
        this.lblTsName.setText(this.header.\u03bc());
        this.lblTsn.setText(String.valueOf(this.header.___()));
        this.lblFno.setText(String.valueOf(this.header._a()));
        this.lblRfn.setText(String.valueOf(this.header.\u03b1()));
        this.lblCkpScn.setText(String.format("%,d", this.header.__a()));
        this.lblRlsScn.setText(String.format("%,d", this.header._a_()));
        this.lblCrsScn.setText(String.format("%,d", this.header.a_a()));
        this.lblMaxScn.setText(String.format("%,d", this.healthInfo.\u03bf()));
        this.lblCkpTime.setText(this.formatTimestamp(this.header.\u03b2()));
        this.lblCrtTime.setText(this.formatTimestamp(this.header._aa()));
    }

    private String formatTimestamp(long l2) {
        if (l2 == 0L) {
            return "N/A";
        }
        try {
            Date date = new Date(l2 * 1000L);
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        }
        catch (Exception exception) {
            return String.valueOf(l2);
        }
    }

    private void copyToClipboard() {
        String string = this.summaryArea.getText();
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        JOptionPane.showMessageDialog(this, this.bundle.getString("health_checker_copied_to_clipboard"), this.bundle.getString("health_checker_info"), 1);
    }
}

