/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.logreader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import o._m0;
import o._t0;
import o.a0a;
import o.f0_;
import o.j0_;

public class LogReaderDialog
extends JDialog {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
    private JTextField tfFilePath;
    private JButton btnSelectFile;
    private JButton btnAnalyze;
    private JTextArea taFileInfo;
    private JTextArea taSql;
    private JComboBox<String> cbPresetQueries;
    private JButton btnExecute;
    private JTable tableResults;
    private DefaultTableModel resultModel;
    private JLabel lblResultStatus;
    private JProgressBar progressBar;
    private JLabel lblStatus;
    private _m0 logReader;
    private List<a0a> transactions = new ArrayList<a0a>();
    private File currentFile;
    private j0_ logMinerRepository;
    private File dbFile;
    private static final String DB_DIR = "db";
    private static final String[][] PRESET_QUERIES = new String[][]{{"-- \u9009\u62e9\u9884\u8bbe\u67e5\u8be2 --", ""}, {"\u6240\u6709\u53d8\u66f4 (\u524d100\u6761)", "SELECT SCN, OPERATION, TABLE_NAME, XID, SQL_REDO\nFROM REDO_CONTENTS\nORDER BY SCN\nLIMIT 100"}, {"\u4ec5 DML \u64cd\u4f5c", "SELECT SCN, OPERATION, TABLE_NAME, XID, SQL_REDO, SQL_UNDO\nFROM REDO_CONTENTS\nWHERE OPERATION IN ('INSERT', 'UPDATE', 'DELETE')\nORDER BY SCN"}, {"\u4e8b\u52a1\u6c47\u603b", "SELECT XID, \n       MIN(SCN) as START_SCN,\n       MAX(COMMIT_SCN) as COMMIT_SCN,\n       COUNT(*) as OPERATIONS,\n       SUM(CASE WHEN OPERATION='INSERT' THEN 1 ELSE 0 END) as INSERTS,\n       SUM(CASE WHEN OPERATION='UPDATE' THEN 1 ELSE 0 END) as UPDATES,\n       SUM(CASE WHEN OPERATION='DELETE' THEN 1 ELSE 0 END) as DELETES\nFROM REDO_CONTENTS\nGROUP BY XID\nORDER BY START_SCN"}, {"\u6309\u8868\u7edf\u8ba1", "SELECT TABLE_NAME, \n       COUNT(*) as TOTAL_CHANGES,\n       SUM(CASE WHEN OPERATION='INSERT' THEN 1 ELSE 0 END) as INSERTS,\n       SUM(CASE WHEN OPERATION='UPDATE' THEN 1 ELSE 0 END) as UPDATES,\n       SUM(CASE WHEN OPERATION='DELETE' THEN 1 ELSE 0 END) as DELETES\nFROM REDO_CONTENTS\nWHERE TABLE_NAME IS NOT NULL\nGROUP BY TABLE_NAME\nORDER BY TOTAL_CHANGES DESC"}, {"\u6309 SCN \u8303\u56f4\u67e5\u8be2", "SELECT SCN, OPERATION, TABLE_NAME, SQL_REDO\nFROM REDO_CONTENTS\nWHERE SCN BETWEEN 0 AND 999999999\nORDER BY SCN"}, {"\u4ec5\u63d0\u4ea4\u8bb0\u5f55", "SELECT SCN, XID, COMMIT_SCN, TIMESTAMP\nFROM REDO_CONTENTS\nWHERE OPERATION = 'COMMIT'\nORDER BY SCN"}, {"\u67e5\u770b\u6240\u6709\u8868", "SELECT name, type FROM sqlite_master \nWHERE type IN ('table', 'view') \nORDER BY type, name"}};

    public LogReaderDialog(Frame frame) {
        super(frame, LogReaderDialog.getTitle_i18n(), true);
        this.initComponents();
        this.layoutComponents();
        this.setSize(1300, 850);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
    }

    private static String getTitle_i18n() {
        try {
            return bundle.getString("logreader_title");
        }
        catch (Exception exception) {
            return "Redo Log \u8bfb\u53d6\u5668";
        }
    }

    private void initComponents() {
        this.tfFilePath = new JTextField(50);
        this.tfFilePath.setEditable(false);
        this.btnSelectFile = new JButton(this.getString("logreader_select_file", "\u9009\u62e9\u6587\u4ef6..."));
        this.btnSelectFile.addActionListener(this::selectFile);
        this.btnAnalyze = new JButton(this.getString("logreader_analyze", "\u5206\u6790"));
        this.btnAnalyze.setEnabled(false);
        this.btnAnalyze.addActionListener(this::analyzeFile);
        this.taFileInfo = new JTextArea(3, 60);
        this.taFileInfo.setEditable(false);
        this.taFileInfo.setFont(new Font("Monospaced", 0, 12));
        this.cbPresetQueries = new JComboBox();
        for (String[] stringArray : PRESET_QUERIES) {
            this.cbPresetQueries.addItem(stringArray[0]);
        }
        this.cbPresetQueries.addActionListener(actionEvent -> {
            int n2 = this.cbPresetQueries.getSelectedIndex();
            if (n2 > 0 && n2 < PRESET_QUERIES.length) {
                this.taSql.setText(PRESET_QUERIES[n2][1]);
            }
        });
        this.taSql = new JTextArea(5, 60);
        this.taSql.setFont(new Font("Monospaced", 0, 12));
        this.taSql.setText(PRESET_QUERIES[1][1]);
        this.taSql.getInputMap().put(KeyStroke.getKeyStroke(116, 0), "execute");
        this.taSql.getActionMap().put("execute", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogReaderDialog.this.executeQuery(actionEvent);
            }
        });
        this.btnExecute = new JButton(this.getString("logreader_execute", "\u6267\u884c (F5)"));
        this.btnExecute.setEnabled(false);
        this.btnExecute.addActionListener(this::executeQuery);
        this.resultModel = new DefaultTableModel();
        this.tableResults = new JTable(this.resultModel);
        this.tableResults.setAutoResizeMode(0);
        this.tableResults.setFont(new Font("Monospaced", 0, 12));
        this.lblResultStatus = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.lblStatus = new JLabel(this.getString("logreader_status_ready", "\u5c31\u7eea"));
    }

    private void layoutComponents() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setBorder(new TitledBorder(this.getString("logreader_file_selection", "\u6587\u4ef6\u9009\u62e9")));
        jPanel3.add(new JLabel(this.getString("logreader_file_path", "\u6587\u4ef6:")));
        jPanel3.add(this.tfFilePath);
        jPanel3.add(this.btnSelectFile);
        jPanel3.add(this.btnAnalyze);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new TitledBorder(this.getString("logreader_file_info", "\u6587\u4ef6\u4fe1\u606f")));
        jPanel4.add((Component)new JScrollPane(this.taFileInfo), "Center");
        jPanel4.setPreferredSize(new Dimension(0, 100));
        jPanel2.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        jPanel6.setBorder(new TitledBorder("SQL \u67e5\u8be2"));
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(new JLabel("\u9884\u8bbe\u67e5\u8be2:"));
        jPanel7.add(this.cbPresetQueries);
        jPanel7.add(Box.createHorizontalStrut(20));
        jPanel7.add(this.btnExecute);
        jPanel6.add((Component)jPanel7, "North");
        JScrollPane jScrollPane = new JScrollPane(this.taSql);
        jScrollPane.setPreferredSize(new Dimension(0, 120));
        jPanel6.add((Component)jScrollPane, "Center");
        jPanel5.add((Component)jPanel6, "North");
        JPanel jPanel8 = new JPanel(new BorderLayout(5, 5));
        jPanel8.setBorder(new TitledBorder("\u67e5\u8be2\u7ed3\u679c"));
        jPanel8.add((Component)new JScrollPane(this.tableResults), "Center");
        jPanel8.add((Component)this.lblResultStatus, "South");
        jPanel5.add((Component)jPanel8, "Center");
        jPanel.add((Component)jPanel5, "Center");
        JPanel jPanel9 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel10 = new JPanel(new BorderLayout(5, 5));
        jPanel10.add((Component)this.progressBar, "Center");
        jPanel10.add((Component)this.lblStatus, "South");
        jPanel9.add((Component)jPanel10, "Center");
        JPanel jPanel11 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("\u5bfc\u51fa\u7ed3\u679c...");
        jButton.addActionListener(this::exportResults);
        jPanel11.add(jButton);
        JButton jButton2 = new JButton(this.getString("logreader_close", "\u5173\u95ed"));
        jButton2.addActionListener(actionEvent -> this.dispose());
        jPanel11.add(jButton2);
        jPanel9.add((Component)jPanel11, "East");
        jPanel.add((Component)jPanel9, "South");
        this.setContentPane(jPanel);
    }

    private String getString(String string, String string2) {
        try {
            return bundle.getString(string);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    private void selectFile(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.getString("logreader_select_redo", "\u9009\u62e9 Redo Log \u6587\u4ef6"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter("Oracle Redo/Archive Log (*.log, *.arc, *.dbf)", "log", "arc", "dbf"));
        jFileChooser.setFileSelectionMode(0);
        if (this.currentFile != null) {
            jFileChooser.setCurrentDirectory(this.currentFile.getParentFile());
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.currentFile = jFileChooser.getSelectedFile();
            this.tfFilePath.setText(this.currentFile.getAbsolutePath());
            this.btnAnalyze.setEnabled(true);
            this.showFileInfo();
        }
    }

    private void showFileInfo() {
        if (this.currentFile == null) {
            return;
        }
        try {
            _t0 _t02 = _m0.O0(this.currentFile);
            this.taFileInfo.setText(_t02.\u03ba());
        }
        catch (Exception exception) {
            this.taFileInfo.setText("Error reading file: " + exception.getMessage());
        }
    }

    private void analyzeFile(ActionEvent actionEvent) {
        if (this.currentFile == null) {
            return;
        }
        this.transactions.clear();
        this.resultModel.setRowCount(0);
        this.resultModel.setColumnCount(0);
        this.btnExecute.setEnabled(false);
        this.lblResultStatus.setText(" ");
        if (this.logMinerRepository != null) {
            this.logMinerRepository.close();
            this.logMinerRepository = null;
        }
        this.btnAnalyze.setEnabled(false);
        this.btnSelectFile.setEnabled(false);
        this.progressBar.setValue(0);
        this.lblStatus.setText(this.getString("logreader_status_parsing", "\u89e3\u6790\u4e2d..."));
        File file = new File(DB_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string = this.currentFile.getName().replaceAll("\\.[^.]+$", "");
        String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        this.dbFile = new File(file, string + "_" + string2 + ".db");
        SwingWorker<Void, Integer> swingWorker = new SwingWorker<Void, Integer>(){
            private int eB = 0;
            private long c0c = 0L;
            private int eC = 0;
            private int eD = 0;

            protected Void O0() throws Exception {
                LogReaderDialog.this.logMinerRepository = new j0_(LogReaderDialog.this.dbFile.getAbsolutePath());
                LogReaderDialog.this.logMinerRepository.setAutoCommit(false);
                String string = String.format("{\"file\":\"%s\"}", LogReaderDialog.this.currentFile.getName());
                LogReaderDialog.this.logMinerRepository.lI(string);
                LogReaderDialog.this.logReader = new _m0();
                LogReaderDialog.this.logReader.l1(LogReaderDialog.this.currentFile);
                _t0 _t02 = LogReaderDialog.this.logReader.O0();
                this.c0c = LogReaderDialog.this.logMinerRepository.O0(LogReaderDialog.this.currentFile.getAbsolutePath(), LogReaderDialog.this.currentFile.length(), _t02.O0() != null ? _t02.O0().y0() : 0L, _t02.l1() != null ? _t02.l1().y0() : 0L, null, _t02.O0() != null ? (int)_t02.O0().x0() : 0, _t02.x0());
                long l2 = _t02.h0();
                LogReaderDialog.this.logReader.O0(new _m0.O0(){

                    @Override
                    public void l1(a0a a0a2) {
                        LogReaderDialog.this.transactions.add(a0a2);
                        ++eC;
                        try {
                            this.O0(a0a2);
                        }
                        catch (SQLException sQLException) {
                            System.err.println("Error saving transaction: " + sQLException.getMessage());
                        }
                    }

                    @Override
                    public void Il(long l2, long l3) {
                        int n2 = (int)(l2 * 100L / l3);
                        this.publish(new Integer[]{n2});
                    }

                    @Override
                    public void O0(Exception exception, long l2) {
                        System.err.println("Error at block " + l2 + ": " + exception.getMessage());
                    }
                });
                LogReaderDialog.this.logMinerRepository.lI(this.eB, this.eC);
                LogReaderDialog.this.logMinerRepository.commit();
                this.eD = this.eB;
                return null;
            }

            private void O0(a0a a0a2) throws SQLException {
                LogReaderDialog.this.logMinerRepository.O0(a0a2.O0(), a0a2.O0(), null);
                long l2 = a0a2.O0() != null ? a0a2.O0().y0() : 0L;
                long l3 = a0a2.l() != null ? a0a2.l().y0() : 0L;
                String string = null;
                String string2 = null;
                if (a0a2.s0() > 0L) {
                    string2 = string = _t0.I1(a0a2.s0());
                }
                for (a0a.O0 object : a0a2.lll()) {
                    f0_ f0_2 = new f0_();
                    f0_2.scn = object.I() != null ? object.I().y0() : 0L;
                    f0_2.O0 = l2;
                    f0_2.l1 = l3;
                    f0_2.pppa = a0a2.O0().toString();
                    f0_2.hC = a0a2.O0()._u0();
                    f0_2.hD = a0a2.O0()._v0();
                    f0_2.t0t = a0a2.O0()._c0();
                    f0_2.oooo = string;
                    f0_2.oooa = string;
                    f0_2.pppp = string2;
                    switch (object.O0()) {
                        case INSERT: {
                            f0_2._$ = "INSERT";
                            f0_2.hE = 1;
                            break;
                        }
                        case UPDATE: {
                            f0_2._$ = "UPDATE";
                            f0_2.hE = 3;
                            break;
                        }
                        case DELETE: {
                            f0_2._$ = "DELETE";
                            f0_2.hE = 2;
                            break;
                        }
                        default: {
                            f0_2._$ = "OTHER";
                            f0_2.hE = 0;
                        }
                    }
                    f0_2.hG = object._j0();
                    f0_2.tableName = "OBJ$" + object._i0();
                    f0_2.segName = f0_2.tableName;
                    f0_2.hF = 2;
                    f0_2.$$ = "TABLE";
                    f0_2.n0n = object.v0();
                    f0_2.u0u = this.c0c;
                    f0_2.hJ = ++this.eB;
                    f0_2.$$$ = object._g0() != null ? object._g0() : "-- " + f0_2._$ + " on " + f0_2.tableName;
                    f0_2._$_ = object._h0();
                    LogReaderDialog.this.logMinerRepository.O0(f0_2);
                }
                String string3 = a0a2.O0() == a0a.I1.COMMITTED ? "COMMITTED" : (a0a2.O0() == a0a.I1.ROLLED_BACK ? "ROLLED_BACK" : "ACTIVE");
                LogReaderDialog.this.logMinerRepository.O0(a0a2.O0(), a0a2.l(), null, string3, a0a2.lll().size(), a0a2.u0());
                if (a0a2.O0() == a0a.I1.COMMITTED) {
                    f0_ f0_3 = new f0_();
                    f0_3.scn = l3;
                    f0_3.O0 = l2;
                    f0_3.l1 = l3;
                    f0_3.pppa = a0a2.O0().toString();
                    f0_3.hC = a0a2.O0()._u0();
                    f0_3.hD = a0a2.O0()._v0();
                    f0_3.t0t = a0a2.O0()._c0();
                    f0_3.oooo = string2;
                    f0_3.oooa = string;
                    f0_3.pppp = string2;
                    f0_3._$ = "COMMIT";
                    f0_3.hE = 7;
                    f0_3.$$$ = "COMMIT;";
                    f0_3.hJ = ++this.eB;
                    f0_3.u0u = this.c0c;
                    LogReaderDialog.this.logMinerRepository.O0(f0_3);
                }
            }

            @Override
            protected void process(List<Integer> list) {
                if (!list.isEmpty()) {
                    LogReaderDialog.this.progressBar.setValue(list.get(list.size() - 1));
                }
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    LogReaderDialog.this.lblStatus.setText(String.format("\u5b8c\u6210: %d \u4e2a\u4e8b\u52a1, %d \u6761\u8bb0\u5f55  |  SQLite: %s", this.eC, this.eD, LogReaderDialog.this.dbFile.getName()));
                    LogReaderDialog.this.btnExecute.setEnabled(true);
                    LogReaderDialog.this.executeQuery(null);
                }
                catch (Exception exception) {
                    LogReaderDialog.this.lblStatus.setText("\u9519\u8bef: " + exception.getMessage());
                    JOptionPane.showMessageDialog(LogReaderDialog.this, "\u89e3\u6790\u9519\u8bef: " + exception.getMessage(), "\u9519\u8bef", 0);
                    exception.printStackTrace();
                }
                LogReaderDialog.this.progressBar.setValue(100);
                LogReaderDialog.this.btnAnalyze.setEnabled(true);
                LogReaderDialog.this.btnSelectFile.setEnabled(true);
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void executeQuery(ActionEvent actionEvent) {
        if (this.logMinerRepository == null) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u5148\u5206\u6790 Redo \u65e5\u5fd7\u6587\u4ef6", "\u63d0\u793a", 2);
            return;
        }
        final String string = this.taSql.getText().trim();
        if (string.isEmpty()) {
            this.lblResultStatus.setText("\u8bf7\u8f93\u5165 SQL \u67e5\u8be2");
            return;
        }
        this.resultModel.setRowCount(0);
        this.resultModel.setColumnCount(0);
        this.lblResultStatus.setText("\u6267\u884c\u4e2d...");
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private int rowCount = 0;
            private String error = null;

            protected Void O0() {
                try (ResultSet resultSet = LogReaderDialog.this.logMinerRepository.executeQuery(string);){
                    Vector<Object> vector;
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n2 = resultSetMetaData.getColumnCount();
                    Vector<Object> vector2 = new Vector<Object>();
                    for (int i2 = 1; i2 <= n2; ++i2) {
                        vector2.add(resultSetMetaData.getColumnName(i2));
                    }
                    Vector<Vector<Object>> vector3 = new Vector<Vector<Object>>();
                    while (resultSet.next() && this.rowCount < 10000) {
                        vector = new Vector();
                        for (int i3 = 1; i3 <= n2; ++i3) {
                            Object object = resultSet.getObject(i3);
                            if (object instanceof String && ((String)object).length() > 500) {
                                object = ((String)object).substring(0, 500) + "...";
                            }
                            vector.add(object);
                        }
                        vector3.add(vector);
                        ++this.rowCount;
                    }
                    vector = vector2;
                    Vector<Vector<Object>> vector4 = vector3;
                    SwingUtilities.invokeLater(() -> {
                        LogReaderDialog.this.resultModel.setDataVector(vector4, vector);
                        for (int i2 = 0; i2 < LogReaderDialog.this.tableResults.getColumnCount(); ++i2) {
                            int n2 = Math.max(80, ((String)vector.get(i2)).length() * 10);
                            if (((String)vector.get(i2)).contains("SQL")) {
                                n2 = 400;
                            }
                            LogReaderDialog.this.tableResults.getColumnModel().getColumn(i2).setPreferredWidth(n2);
                        }
                    });
                }
                catch (SQLException sQLException) {
                    this.error = sQLException.getMessage();
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.error != null) {
                    LogReaderDialog.this.lblResultStatus.setText("\u9519\u8bef: " + this.error);
                } else {
                    String string2 = this.rowCount >= 10000 ? " (\u5df2\u9650\u5236\u4e3a10000\u6761)" : "";
                    LogReaderDialog.this.lblResultStatus.setText("\u8fd4\u56de " + this.rowCount + " \u884c" + string2);
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void exportResults(ActionEvent actionEvent) {
        if (this.resultModel.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "\u6ca1\u6709\u7ed3\u679c\u53ef\u5bfc\u51fa", "\u5bfc\u51fa", 2);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("\u5bfc\u51fa\u67e5\u8be2\u7ed3\u679c");
        jFileChooser.setSelectedFile(new File("redo_query_results.csv"));
        if (jFileChooser.showSaveDialog(this) == 0) {
            try (PrintWriter printWriter = new PrintWriter(jFileChooser.getSelectedFile());){
                int n2;
                for (n2 = 0; n2 < this.resultModel.getColumnCount(); ++n2) {
                    if (n2 > 0) {
                        printWriter.print(",");
                    }
                    printWriter.print("\"" + this.resultModel.getColumnName(n2) + "\"");
                }
                printWriter.println();
                for (n2 = 0; n2 < this.resultModel.getRowCount(); ++n2) {
                    for (int i2 = 0; i2 < this.resultModel.getColumnCount(); ++i2) {
                        Object object;
                        if (i2 > 0) {
                            printWriter.print(",");
                        }
                        if ((object = this.resultModel.getValueAt(n2, i2)) == null) continue;
                        String string = object.toString().replace("\"", "\"\"");
                        printWriter.print("\"" + string + "\"");
                    }
                    printWriter.println();
                }
                JOptionPane.showMessageDialog(this, "\u7ed3\u679c\u5df2\u5bfc\u51fa\u5230:\n" + jFileChooser.getSelectedFile().getAbsolutePath(), "\u5bfc\u51fa\u5b8c\u6210", 1);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "\u5bfc\u51fa\u9519\u8bef: " + exception.getMessage(), "\u5bfc\u51fa\u9519\u8bef", 0);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.logReader != null) {
            try {
                this.logReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.logMinerRepository != null) {
            this.logMinerRepository.close();
        }
        super.dispose();
    }

    public static void showDialog(Frame frame) {
        LogReaderDialog logReaderDialog = new LogReaderDialog(frame);
        logReaderDialog.setVisible(true);
    }
}

