/*
 * Decompiled with CFR 0.152.
 */
package com.dbrecover.gui.logreader;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;
import o._m0;
import o._t0;
import o.a0a;
import o.f0_;
import o.j0_;

public class LogReaderFrame
extends JFrame {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/dbrecover/gui/locales/Bundle");
    private JToolBar toolBar;
    private JButton btnOpen;
    private JButton btnAnalyze;
    private JButton btnExport;
    private JButton btnClear;
    private JTextField tfFilePath;
    private JTextArea taFileInfo;
    private JTextArea taSql;
    private JComboBox<String> cbPresetQueries;
    private JButton btnExecute;
    private JTable tableResults;
    private DefaultTableModel resultModel;
    private JLabel lblResultStatus;
    private JPopupMenu tablePopup;
    private JProgressBar progressBar;
    private JLabel lblStatus;
    private JSplitPane mainSplit;
    private JSplitPane topSplit;
    private _m0 logReader;
    private List<a0a> transactions = new ArrayList<a0a>();
    private File currentFile;
    private j0_ logMinerRepository;
    private File dbFile;
    private static final String DB_DIR = "db";
    private static final String[][] PRESET_QUERIES = new String[][]{{"-- \u9009\u62e9\u9884\u8bbe\u67e5\u8be2 --", ""}, {"\u6240\u6709\u53d8\u66f4 (\u524d100\u6761)", "SELECT SCN, OPERATION, TABLE_NAME, XID, SQL_REDO\nFROM REDO_CONTENTS\nORDER BY SCN\nLIMIT 100"}, {"\u4ec5 INSERT \u64cd\u4f5c", "SELECT SCN, TABLE_NAME, XID, SQL_REDO\nFROM REDO_CONTENTS\nWHERE OPERATION = 'INSERT'\nORDER BY SCN"}, {"\u4ec5 UPDATE \u64cd\u4f5c", "SELECT SCN, TABLE_NAME, XID, SQL_REDO\nFROM REDO_CONTENTS\nWHERE OPERATION = 'UPDATE'\nORDER BY SCN"}, {"\u4ec5 DELETE \u64cd\u4f5c", "SELECT SCN, TABLE_NAME, XID, SQL_REDO\nFROM REDO_CONTENTS\nWHERE OPERATION = 'DELETE'\nORDER BY SCN"}, {"\u4e8b\u52a1\u6c47\u603b", "SELECT XID, \n       MIN(SCN) as START_SCN,\n       MAX(COMMIT_SCN) as COMMIT_SCN,\n       COUNT(*) as OPERATIONS,\n       SUM(CASE WHEN OPERATION='INSERT' THEN 1 ELSE 0 END) as INSERTS,\n       SUM(CASE WHEN OPERATION='UPDATE' THEN 1 ELSE 0 END) as UPDATES,\n       SUM(CASE WHEN OPERATION='DELETE' THEN 1 ELSE 0 END) as DELETES\nFROM REDO_CONTENTS\nGROUP BY XID\nORDER BY START_SCN"}, {"\u6309\u8868\u7edf\u8ba1", "SELECT TABLE_NAME, \n       COUNT(*) as TOTAL_CHANGES,\n       SUM(CASE WHEN OPERATION='INSERT' THEN 1 ELSE 0 END) as INSERTS,\n       SUM(CASE WHEN OPERATION='UPDATE' THEN 1 ELSE 0 END) as UPDATES,\n       SUM(CASE WHEN OPERATION='DELETE' THEN 1 ELSE 0 END) as DELETES\nFROM REDO_CONTENTS\nWHERE TABLE_NAME IS NOT NULL\nGROUP BY TABLE_NAME\nORDER BY TOTAL_CHANGES DESC"}, {"\u6309 SCN \u8303\u56f4\u67e5\u8be2", "SELECT SCN, OPERATION, TABLE_NAME, SQL_REDO\nFROM REDO_CONTENTS\nWHERE SCN BETWEEN 0 AND 999999999\nORDER BY SCN"}, {"\u67e5\u8be2\u6307\u5b9a\u8868", "SELECT SCN, OPERATION, XID, SQL_REDO\nFROM REDO_CONTENTS\nWHERE TABLE_NAME = 'OBJ$80273'\nORDER BY SCN"}, {"\u4ec5\u63d0\u4ea4\u8bb0\u5f55", "SELECT SCN, XID, COMMIT_SCN, TIMESTAMP\nFROM REDO_CONTENTS\nWHERE OPERATION = 'COMMIT'\nORDER BY SCN"}, {"\u6570\u636e\u5e93\u67b6\u6784", "SELECT name, type FROM sqlite_master \nWHERE type IN ('table', 'view') \nORDER BY type, name"}};

    public LogReaderFrame(Frame frame) {
        super(LogReaderFrame.getString("logreader_title", "Redo Log \u8bfb\u53d6\u5668"));
        this.initComponents();
        this.layoutComponents();
        this.setupKeyboardShortcuts();
        this.setupDragAndDrop();
        this.setSize(1400, 900);
        this.setMinimumSize(new Dimension(800, 600));
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        if (frame != null && frame.getIconImage() != null) {
            this.setIconImage(frame.getIconImage());
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LogReaderFrame.this.cleanup();
            }
        });
    }

    private static String getString(String string, String string2) {
        try {
            return bundle.getString(string);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.btnOpen = this.createToolButton("\ud83d\udcc2", "\u6253\u5f00\u65e5\u5fd7\u6587\u4ef6 (Ctrl+O)", this::selectFile);
        this.btnAnalyze = this.createToolButton("\u25b6", "\u5206\u6790\u65e5\u5fd7 (Ctrl+Enter)", this::analyzeFile);
        this.btnAnalyze.setEnabled(false);
        this.btnExport = this.createToolButton("\ud83d\udcbe", "\u5bfc\u51fa\u7ed3\u679c (Ctrl+S)", this::exportResults);
        this.btnExport.setEnabled(false);
        this.btnClear = this.createToolButton("\ud83d\uddd1", "\u6e05\u7a7a\u7ed3\u679c", actionEvent -> this.clearResults());
        this.toolBar.add(this.btnOpen);
        this.toolBar.add(this.btnAnalyze);
        this.toolBar.addSeparator();
        this.toolBar.add(this.btnExport);
        this.toolBar.add(this.btnClear);
        this.tfFilePath = new JTextField();
        this.tfFilePath.setEditable(false);
        this.taFileInfo = new JTextArea(3, 60);
        this.taFileInfo.setEditable(false);
        this.taFileInfo.setBackground(new Color(245, 245, 245));
        this.taSql = new JTextArea(5, 60);
        this.taSql.setTabSize(4);
        this.taSql.setText(PRESET_QUERIES[1][1]);
        this.cbPresetQueries = new JComboBox();
        for (String[] stringArray : PRESET_QUERIES) {
            this.cbPresetQueries.addItem(stringArray[0]);
        }
        this.cbPresetQueries.addActionListener(actionEvent -> {
            int n2 = this.cbPresetQueries.getSelectedIndex();
            if (n2 > 0 && n2 < PRESET_QUERIES.length) {
                this.taSql.setText(PRESET_QUERIES[n2][1]);
            }
        });
        this.btnExecute = new JButton("\u6267\u884c (F5)");
        this.btnExecute.setEnabled(false);
        this.btnExecute.addActionListener(this::executeQuery);
        this.resultModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.tableResults = new JTable(this.resultModel);
        this.tableResults.setAutoResizeMode(0);
        this.tableResults.getTableHeader().setReorderingAllowed(true);
        this.tableResults.setRowHeight(22);
        TableRowSorter<DefaultTableModel> tableRowSorter = new TableRowSorter<DefaultTableModel>(this.resultModel);
        this.tableResults.setRowSorter(tableRowSorter);
        this.setupTablePopupMenu();
        this.lblResultStatus = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        this.lblStatus = new JLabel("\u5c31\u7eea");
    }

    private JButton createToolButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setToolTipText(string2);
        jButton.setFocusPainted(false);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel2.setBorder(new TitledBorder("\u6587\u4ef6\u9009\u62e9"));
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 0));
        jPanel3.add((Component)new JLabel("\u6587\u4ef6: "), "West");
        jPanel3.add((Component)this.tfFilePath, "Center");
        JButton jButton = new JButton("\u9009\u62e9\u6587\u4ef6...");
        jButton.addActionListener(this::selectFile);
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 5, 0));
        jPanel4.add(jButton);
        JButton jButton2 = new JButton("\u5206\u6790");
        jButton2.addActionListener(this::analyzeFile);
        jPanel4.add(jButton2);
        jPanel3.add((Component)jPanel4, "East");
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(new TitledBorder("\u6587\u4ef6\u4fe1\u606f"));
        jPanel5.add((Component)new JScrollPane(this.taFileInfo), "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel5, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        jPanel6.setBorder(new TitledBorder("SQL \u67e5\u8be2"));
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel7.add(new JLabel("\u9884\u8bbe\u67e5\u8be2:"));
        jPanel7.add(this.cbPresetQueries);
        jPanel7.add(Box.createHorizontalStrut(20));
        jPanel7.add(this.btnExecute);
        jPanel6.add((Component)jPanel7, "North");
        jPanel6.add((Component)new JScrollPane(this.taSql), "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout(5, 5));
        jPanel8.setBorder(new TitledBorder("\u67e5\u8be2\u7ed3\u679c"));
        JScrollPane jScrollPane = new JScrollPane(this.tableResults);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel8.add((Component)jScrollPane, "Center");
        jPanel8.add((Component)this.lblResultStatus, "South");
        this.topSplit = new JSplitPane(0, jPanel, jPanel6);
        this.topSplit.setResizeWeight(0.3);
        this.topSplit.setDividerLocation(150);
        this.mainSplit = new JSplitPane(0, this.topSplit, jPanel8);
        this.mainSplit.setResizeWeight(0.35);
        this.mainSplit.setDividerLocation(320);
        JPanel jPanel9 = new JPanel(new BorderLayout(10, 0));
        jPanel9.setBorder(new EmptyBorder(2, 5, 2, 5));
        jPanel9.add((Component)this.lblStatus, "West");
        jPanel9.add((Component)this.progressBar, "East");
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)jPanel9, "South");
    }

    private void setupKeyboardShortcuts() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(79, 128), "openFile");
        this.getRootPane().getActionMap().put("openFile", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogReaderFrame.this.selectFile(actionEvent);
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), "executeQuery");
        this.getRootPane().getActionMap().put("executeQuery", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LogReaderFrame.this.btnExecute.isEnabled()) {
                    LogReaderFrame.this.executeQuery(actionEvent);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(83, 128), "export");
        this.getRootPane().getActionMap().put("export", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LogReaderFrame.this.btnExport.isEnabled()) {
                    LogReaderFrame.this.exportResults(actionEvent);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "analyze");
        this.getRootPane().getActionMap().put("analyze", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LogReaderFrame.this.btnAnalyze.isEnabled()) {
                    LogReaderFrame.this.analyzeFile(actionEvent);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogReaderFrame.this.dispose();
            }
        });
    }

    private void setupDragAndDrop() {
        new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    dropTargetDropEvent.acceptDrop(1);
                    List list = (List)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (!list.isEmpty()) {
                        File file = (File)list.get(0);
                        if (file.getName().toLowerCase().endsWith(".log") || file.getName().toLowerCase().contains("redo")) {
                            LogReaderFrame.this.loadFile(file);
                        } else {
                            JOptionPane.showMessageDialog(LogReaderFrame.this, "\u8bf7\u62d6\u653e Oracle Redo Log \u6587\u4ef6 (.log)", "\u6587\u4ef6\u7c7b\u578b\u9519\u8bef", 2);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void setupTablePopupMenu() {
        this.tablePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("\u590d\u5236\u5355\u5143\u683c");
        jMenuItem.addActionListener(actionEvent -> this.copySelectedCell());
        JMenuItem jMenuItem2 = new JMenuItem("\u590d\u5236\u6574\u884c");
        jMenuItem2.addActionListener(actionEvent -> this.copySelectedRow());
        JMenuItem jMenuItem3 = new JMenuItem("\u590d\u5236\u5168\u90e8");
        jMenuItem3.addActionListener(actionEvent -> this.copyAllResults());
        JMenuItem jMenuItem4 = new JMenuItem("\u67e5\u770b\u5b8c\u6574 SQL");
        jMenuItem4.addActionListener(actionEvent -> this.viewFullSql());
        this.tablePopup.add(jMenuItem);
        this.tablePopup.add(jMenuItem2);
        this.tablePopup.add(jMenuItem3);
        this.tablePopup.addSeparator();
        this.tablePopup.add(jMenuItem4);
        this.tableResults.setComponentPopupMenu(this.tablePopup);
        this.tableResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    LogReaderFrame.this.viewFullSql();
                }
            }
        });
    }

    private void selectFile(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileNameExtensionFilter("Oracle Redo Log (*.log)", "log"));
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.loadFile(jFileChooser.getSelectedFile());
        }
    }

    private void loadFile(File file) {
        this.currentFile = file;
        this.tfFilePath.setText(file.getAbsolutePath());
        try {
            _m0 _m02 = new _m0();
            _m02.l1(file);
            _t0 _t02 = _m02.O0();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Database: ").append(_t02.getDatabaseName());
            stringBuilder.append(", Version: ").append(_t02.j0());
            stringBuilder.append(", Sequence: ").append(_t02.O0());
            stringBuilder.append("\nFirst SCN: ").append(_t02.O0());
            stringBuilder.append(", Next SCN: ").append(_t02.l1());
            stringBuilder.append("\nFile Size: ").append(String.format("%.2f MB", (double)file.length() / 1024.0 / 1024.0));
            stringBuilder.append(", Blocks: ").append(_t02.h0());
            this.taFileInfo.setText(stringBuilder.toString());
            _m02.close();
            this.btnAnalyze.setEnabled(true);
            this.lblStatus.setText("\u5df2\u52a0\u8f7d: " + file.getName());
        }
        catch (Exception exception) {
            this.taFileInfo.setText("\u9519\u8bef: " + exception.getMessage());
            this.btnAnalyze.setEnabled(false);
        }
    }

    private void analyzeFile(ActionEvent actionEvent) {
        File file;
        if (this.currentFile == null) {
            return;
        }
        this.btnAnalyze.setEnabled(false);
        this.btnExecute.setEnabled(false);
        this.progressBar.setValue(0);
        this.lblStatus.setText("\u89e3\u6790\u4e2d...");
        this.resultModel.setRowCount(0);
        this.resultModel.setColumnCount(0);
        if (this.logMinerRepository != null) {
            this.logMinerRepository.close();
            this.logMinerRepository = null;
        }
        if (!(file = new File(DB_DIR)).exists()) {
            file.mkdirs();
        }
        String string = this.currentFile.getName().replaceAll("\\.[^.]+$", "");
        String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        this.dbFile = new File(file, string + "_" + string2 + ".db");
        SwingWorker<Void, Integer> swingWorker = new SwingWorker<Void, Integer>(){
            private int eB = 0;
            private long c0c = 0L;
            private int eC = 0;
            private int eD = 0;
            private Exception O0 = null;

            protected Void O0() {
                try {
                    LogReaderFrame.this.logMinerRepository = new j0_(LogReaderFrame.this.dbFile.getAbsolutePath());
                    LogReaderFrame.this.logMinerRepository.setAutoCommit(false);
                    String string = String.format("{\"file\":\"%s\"}", LogReaderFrame.this.currentFile.getName());
                    LogReaderFrame.this.logMinerRepository.lI(string);
                    LogReaderFrame.this.logReader = new _m0();
                    LogReaderFrame.this.logReader.l1(LogReaderFrame.this.currentFile);
                    _t0 _t02 = LogReaderFrame.this.logReader.O0();
                    this.c0c = LogReaderFrame.this.logMinerRepository.O0(LogReaderFrame.this.currentFile.getAbsolutePath(), LogReaderFrame.this.currentFile.length(), _t02.O0() != null ? _t02.O0().y0() : 0L, _t02.l1() != null ? _t02.l1().y0() : 0L, null, _t02.O0() != null ? (int)_t02.O0().x0() : 0, _t02.x0());
                    long l2 = _t02.h0();
                    LogReaderFrame.this.transactions.clear();
                    LogReaderFrame.this.logReader.O0(new _m0.O0(){

                        @Override
                        public void l1(a0a a0a2) {
                            LogReaderFrame.this.transactions.add(a0a2);
                            ++eC;
                            try {
                                this.I1(a0a2);
                            }
                            catch (SQLException sQLException) {
                                System.err.println("Error saving transaction: " + sQLException.getMessage());
                            }
                        }

                        @Override
                        public void Il(long l2, long l3) {
                            int n2 = (int)(l2 * 100L / l3);
                            this.publish(new Integer[]{n2});
                        }
                    });
                    LogReaderFrame.this.logMinerRepository.lI(this.eB, this.eC);
                    LogReaderFrame.this.logMinerRepository.commit();
                    this.eD = this.eB;
                }
                catch (Exception exception) {
                    this.O0 = exception;
                }
                return null;
            }

            private void I1(a0a a0a2) throws SQLException {
                LogReaderFrame.this.logMinerRepository.O0(a0a2.O0(), a0a2.O0(), null);
                long l2 = a0a2.O0() != null ? a0a2.O0().y0() : 0L;
                long l3 = a0a2.l() != null ? a0a2.l().y0() : 0L;
                String string = null;
                String string2 = null;
                if (a0a2.s0() > 0L) {
                    string2 = string = _t0.I1(a0a2.s0());
                }
                for (a0a.O0 object : a0a2.lll()) {
                    f0_ f0_2 = new f0_();
                    f0_2.scn = object.I() != null ? object.I().y0() : 0L;
                    f0_2.O0 = l2;
                    f0_2.l1 = l3;
                    f0_2.pppa = a0a2.O0().toString();
                    f0_2.hC = a0a2.O0()._u0();
                    f0_2.hD = a0a2.O0()._v0();
                    f0_2.t0t = a0a2.O0()._c0();
                    f0_2.oooo = string;
                    f0_2.oooa = string;
                    f0_2.pppp = string2;
                    switch (object.O0()) {
                        case INSERT: {
                            f0_2._$ = "INSERT";
                            f0_2.hE = 1;
                            break;
                        }
                        case UPDATE: {
                            f0_2._$ = "UPDATE";
                            f0_2.hE = 3;
                            break;
                        }
                        case DELETE: {
                            f0_2._$ = "DELETE";
                            f0_2.hE = 2;
                            break;
                        }
                        default: {
                            f0_2._$ = "OTHER";
                            f0_2.hE = 0;
                        }
                    }
                    f0_2.hG = object._j0();
                    f0_2.tableName = "OBJ$" + object._i0();
                    f0_2.segName = f0_2.tableName;
                    f0_2.hF = 2;
                    f0_2.$$ = "TABLE";
                    f0_2.n0n = object.v0();
                    f0_2.u0u = this.c0c;
                    f0_2.hJ = ++this.eB;
                    f0_2.$$$ = object._g0() != null ? object._g0() : f0_2._$ + " on " + f0_2.tableName;
                    f0_2._$_ = object._h0();
                    LogReaderFrame.this.logMinerRepository.O0(f0_2);
                }
                String string3 = a0a2.O0() == a0a.I1.COMMITTED ? "COMMITTED" : (a0a2.O0() == a0a.I1.ROLLED_BACK ? "ROLLED_BACK" : "ACTIVE");
                LogReaderFrame.this.logMinerRepository.O0(a0a2.O0(), a0a2.l(), null, string3, a0a2.lll().size(), a0a2.u0());
                if (a0a2.O0() == a0a.I1.COMMITTED) {
                    f0_ f0_3 = new f0_();
                    f0_3.scn = l3;
                    f0_3.O0 = l2;
                    f0_3.l1 = l3;
                    f0_3.pppa = a0a2.O0().toString();
                    f0_3.hC = a0a2.O0()._u0();
                    f0_3.hD = a0a2.O0()._v0();
                    f0_3.t0t = a0a2.O0()._c0();
                    f0_3.oooo = string2;
                    f0_3.oooa = string;
                    f0_3.pppp = string2;
                    f0_3._$ = "COMMIT";
                    f0_3.hE = 7;
                    f0_3.$$$ = "COMMIT;";
                    f0_3.hJ = ++this.eB;
                    f0_3.u0u = this.c0c;
                    LogReaderFrame.this.logMinerRepository.O0(f0_3);
                }
            }

            @Override
            protected void process(List<Integer> list) {
                if (!list.isEmpty()) {
                    int n2 = list.get(list.size() - 1);
                    LogReaderFrame.this.progressBar.setValue(n2);
                    LogReaderFrame.this.lblStatus.setText("\u89e3\u6790\u4e2d... " + n2 + "%");
                }
            }

            @Override
            protected void done() {
                LogReaderFrame.this.progressBar.setValue(100);
                LogReaderFrame.this.btnAnalyze.setEnabled(true);
                if (this.O0 != null) {
                    LogReaderFrame.this.lblStatus.setText("\u89e3\u6790\u5931\u8d25: " + this.O0.getMessage());
                    JOptionPane.showMessageDialog(LogReaderFrame.this, "\u89e3\u6790\u9519\u8bef: " + this.O0.getMessage(), "\u9519\u8bef", 0);
                } else {
                    LogReaderFrame.this.lblStatus.setText(String.format("\u5b8c\u6210: %d \u4e2a\u4e8b\u52a1, %d \u6761\u8bb0\u5f55 | SQLite: %s", this.eC, this.eD, LogReaderFrame.this.dbFile.getName()));
                    LogReaderFrame.this.btnExecute.setEnabled(true);
                    LogReaderFrame.this.btnExport.setEnabled(true);
                    LogReaderFrame.this.executeQuery(null);
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void executeQuery(ActionEvent actionEvent) {
        if (this.logMinerRepository == null) {
            return;
        }
        final String string = this.taSql.getText().trim();
        if (string.isEmpty()) {
            return;
        }
        this.lblStatus.setText("\u6267\u884c\u67e5\u8be2...");
        this.resultModel.setRowCount(0);
        this.resultModel.setColumnCount(0);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private Vector<String> O0 = new Vector();
            private Vector<Vector<Object>> l1 = new Vector();
            private String error = null;

            protected Void O0() {
                try {
                    ResultSet resultSet = LogReaderFrame.this.logMinerRepository.executeQuery(string);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n2 = resultSetMetaData.getColumnCount();
                    for (int i2 = 1; i2 <= n2; ++i2) {
                        this.O0.add(resultSetMetaData.getColumnName(i2));
                    }
                    while (resultSet.next()) {
                        Vector<Object> vector = new Vector<Object>();
                        for (int i3 = 1; i3 <= n2; ++i3) {
                            Object object = resultSet.getObject(i3);
                            vector.add(object != null ? object : "");
                        }
                        this.l1.add(vector);
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    this.error = sQLException.getMessage();
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.error != null) {
                    LogReaderFrame.this.lblStatus.setText("\u67e5\u8be2\u9519\u8bef: " + this.error);
                    LogReaderFrame.this.lblResultStatus.setText("\u9519\u8bef: " + this.error);
                } else {
                    LogReaderFrame.this.resultModel.setDataVector(this.l1, this.O0);
                    LogReaderFrame.this.adjustColumnWidths();
                    LogReaderFrame.this.lblStatus.setText("\u5c31\u7eea");
                    LogReaderFrame.this.lblResultStatus.setText("\u8fd4\u56de " + this.l1.size() + " \u884c");
                }
            }

            @Override
            protected /* synthetic */ Object doInBackground() throws Exception {
                return this.O0();
            }
        };
        swingWorker.execute();
    }

    private void adjustColumnWidths() {
        for (int i2 = 0; i2 < this.tableResults.getColumnCount(); ++i2) {
            int n2 = 80;
            String string = this.tableResults.getColumnName(i2);
            n2 = Math.max(n2, string.length() * 10);
            for (int i3 = 0; i3 < Math.min(20, this.tableResults.getRowCount()); ++i3) {
                Object object = this.tableResults.getValueAt(i3, i2);
                if (object == null) continue;
                int n3 = object.toString().length() * 8;
                n2 = Math.max(n2, Math.min(n3, 500));
            }
            this.tableResults.getColumnModel().getColumn(i2).setPreferredWidth(n2);
        }
    }

    private void exportResults(ActionEvent actionEvent) {
        if (this.resultModel.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", "\u63d0\u793a", 1);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File("redo_results.csv"));
        if (jFileChooser.showSaveDialog(this) == 0) {
            try (PrintWriter printWriter = new PrintWriter(jFileChooser.getSelectedFile());){
                int n2;
                for (n2 = 0; n2 < this.resultModel.getColumnCount(); ++n2) {
                    if (n2 > 0) {
                        printWriter.print(",");
                    }
                    printWriter.print("\"" + this.resultModel.getColumnName(n2) + "\"");
                }
                printWriter.println();
                for (n2 = 0; n2 < this.resultModel.getRowCount(); ++n2) {
                    for (int i2 = 0; i2 < this.resultModel.getColumnCount(); ++i2) {
                        Object object;
                        if (i2 > 0) {
                            printWriter.print(",");
                        }
                        String string = (object = this.resultModel.getValueAt(n2, i2)) != null ? object.toString().replace("\"", "\"\"") : "";
                        printWriter.print("\"" + string + "\"");
                    }
                    printWriter.println();
                }
                this.lblStatus.setText("\u5df2\u5bfc\u51fa: " + jFileChooser.getSelectedFile().getName());
                JOptionPane.showMessageDialog(this, "\u5df2\u5bfc\u51fa " + this.resultModel.getRowCount() + " \u884c\u5230:\n" + jFileChooser.getSelectedFile().getAbsolutePath(), "\u5bfc\u51fa\u6210\u529f", 1);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "\u5bfc\u51fa\u5931\u8d25: " + exception.getMessage(), "\u9519\u8bef", 0);
            }
        }
    }

    private void clearResults() {
        this.resultModel.setRowCount(0);
        this.resultModel.setColumnCount(0);
        this.lblResultStatus.setText(" ");
    }

    private void copySelectedCell() {
        Object object;
        int n2 = this.tableResults.getSelectedRow();
        int n3 = this.tableResults.getSelectedColumn();
        if (n2 >= 0 && n3 >= 0 && (object = this.tableResults.getValueAt(n2, n3)) != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(object.toString()), null);
        }
    }

    private void copySelectedRow() {
        int n2 = this.tableResults.getSelectedRow();
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.tableResults.getColumnCount(); ++i2) {
                Object object;
                if (i2 > 0) {
                    stringBuilder.append("\t");
                }
                stringBuilder.append((object = this.tableResults.getValueAt(n2, i2)) != null ? object.toString() : "");
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
        }
    }

    private void copyAllResults() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < this.tableResults.getColumnCount(); ++n2) {
            if (n2 > 0) {
                stringBuilder.append("\t");
            }
            stringBuilder.append(this.tableResults.getColumnName(n2));
        }
        stringBuilder.append("\n");
        for (n2 = 0; n2 < this.tableResults.getRowCount(); ++n2) {
            for (int i2 = 0; i2 < this.tableResults.getColumnCount(); ++i2) {
                Object object;
                if (i2 > 0) {
                    stringBuilder.append("\t");
                }
                stringBuilder.append((object = this.tableResults.getValueAt(n2, i2)) != null ? object.toString() : "");
            }
            stringBuilder.append("\n");
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
        this.lblStatus.setText("\u5df2\u590d\u5236 " + this.tableResults.getRowCount() + " \u884c\u5230\u526a\u8d34\u677f");
    }

    private void viewFullSql() {
        Object object;
        Object object2;
        int n2 = this.tableResults.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        int n3 = -1;
        for (int i2 = 0; i2 < this.tableResults.getColumnCount(); ++i2) {
            object2 = this.tableResults.getColumnName(i2).toUpperCase();
            if (!((String)object2).contains("SQL") && !((String)object2).contains("REDO")) continue;
            n3 = i2;
            break;
        }
        if (n3 >= 0 && (object = this.tableResults.getValueAt(n2, n3)) != null) {
            object2 = new JTextArea(object.toString());
            ((JTextComponent)object2).setEditable(false);
            ((JTextArea)object2).setLineWrap(true);
            ((JTextArea)object2).setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)object2);
            jScrollPane.setPreferredSize(new Dimension(800, 400));
            JOptionPane.showMessageDialog(this, jScrollPane, "\u5b8c\u6574 SQL", -1);
        }
    }

    private void cleanup() {
        if (this.logMinerRepository != null) {
            this.logMinerRepository.close();
            this.logMinerRepository = null;
        }
        if (this.logReader != null) {
            try {
                this.logReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logReader = null;
        }
    }

    public static void showFrame(Frame frame) {
        LogReaderFrame logReaderFrame = new LogReaderFrame(frame);
        logReaderFrame.setVisible(true);
    }
}

