/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDefaultsAddon;
import com.formdev.flatlaf.FlatIconColors;
import com.formdev.flatlaf.FlatInputMaps;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.LinuxFontPolicy;
import com.formdev.flatlaf.MnemonicHandler;
import com.formdev.flatlaf.SubMenuUsabilityHelper;
import com.formdev.flatlaf.UIDefaultsLoader;
import com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import com.formdev.flatlaf.ui.FlatPopupFactory;
import com.formdev.flatlaf.ui.FlatRootPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.JavaCompatibility2;
import com.formdev.flatlaf.util.FontUtils;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;

public abstract class FlatLaf
extends BasicLookAndFeel {
    private static final String DESKTOPFONTHINTS = "awt.font.desktophints";
    private static List<Object> customDefaultsSources;
    private static Map<String, String> globalExtraDefaults;
    private Map<String, String> extraDefaults;
    private static Function<String, Color> systemColorGetter;
    private String desktopPropertyName;
    private String desktopPropertyName2;
    private PropertyChangeListener desktopPropertyListener;
    private static boolean aquaLoaded;
    private static boolean updateUIPending;
    private PopupFactory oldPopupFactory;
    private MnemonicHandler mnemonicHandler;
    private boolean subMenuUsabilityHelperInstalled;
    private Consumer<UIDefaults> postInitialization;
    private List<Function<Object, Object>> uiDefaultsGetters;
    private static String preferredFontFamily;
    private static String preferredLightFontFamily;
    private static String preferredSemiboldFontFamily;
    private static String preferredMonospacedFontFamily;
    public static final Object NULL_VALUE;

    public static boolean setup(LookAndFeel lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            return true;
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to setup look and feel '" + lookAndFeel.getClass().getName() + "'.", exception);
            return false;
        }
    }

    @Deprecated
    public static boolean install(LookAndFeel lookAndFeel) {
        return FlatLaf.setup(lookAndFeel);
    }

    public static void installLafInfo(String string, Class<? extends LookAndFeel> clazz) {
        UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo(string, clazz.getName()));
    }

    @Override
    public String getID() {
        return "FlatLaf - " + this.getName();
    }

    public abstract boolean isDark();

    public static boolean isLafDark() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel instanceof FlatLaf && ((FlatLaf)lookAndFeel).isDark();
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        if (SystemInfo.isProjector || SystemInfo.isWebswing || SystemInfo.isWinPE) {
            return false;
        }
        if (SystemInfo.isWindows_10_orLater && FlatNativeWindowBorder.isSupported()) {
            return false;
        }
        return SystemInfo.isWindows_10_orLater || SystemInfo.isLinux;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        if (icon instanceof DisabledIconProvider) {
            Icon icon2 = ((DisabledIconProvider)((Object)icon)).getDisabledIcon();
            return !(icon2 instanceof UIResource) ? new IconUIResource(icon2) : icon2;
        }
        if (icon instanceof ImageIcon) {
            Object object = UIManager.get("Component.grayFilter");
            ImageFilter imageFilter = object instanceof ImageFilter ? (ImageFilter)object : GrayFilter.createDisabledIconFilter(this.isDark());
            Function<Image, Image> function = image -> {
                FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
                return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            };
            Image image2 = ((ImageIcon)icon).getImage();
            return new ImageIconUIResource(MultiResolutionImageSupport.map(image2, function));
        }
        return null;
    }

    @Override
    public void initialize() {
        if (UIManager.getLookAndFeel() != this) {
            return;
        }
        if (SystemInfo.isMacOS) {
            this.initializeAqua();
        }
        super.initialize();
        this.oldPopupFactory = PopupFactory.getSharedInstance();
        PopupFactory.setSharedInstance(new FlatPopupFactory());
        this.mnemonicHandler = new MnemonicHandler();
        this.mnemonicHandler.install();
        this.subMenuUsabilityHelperInstalled = SubMenuUsabilityHelper.install();
        if (SystemInfo.isWindows) {
            this.desktopPropertyName = "win.messagebox.font";
        } else if (SystemInfo.isLinux) {
            this.desktopPropertyName = "gnome.Gtk/FontName";
            this.desktopPropertyName2 = "gnome.Xft/DPI";
        }
        if (this.desktopPropertyName != null) {
            this.desktopPropertyListener = propertyChangeEvent -> {
                if (!FlatSystemProperties.getBoolean("flatlaf.updateUIOnSystemFontChange", true)) {
                    return;
                }
                String string = propertyChangeEvent.getPropertyName();
                if (this.desktopPropertyName.equals(string) || string.equals(this.desktopPropertyName2)) {
                    FlatLaf.reSetLookAndFeel();
                } else if (DESKTOPFONTHINTS.equals(string) && UIManager.getLookAndFeel() instanceof FlatLaf) {
                    this.putAATextInfo(UIManager.getLookAndFeelDefaults());
                    FlatLaf.updateUILater();
                }
            };
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.getDesktopProperty("dummy");
            toolkit.addPropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            if (this.desktopPropertyName2 != null) {
                toolkit.addPropertyChangeListener(this.desktopPropertyName2, this.desktopPropertyListener);
            }
            toolkit.addPropertyChangeListener(DESKTOPFONTHINTS, this.desktopPropertyListener);
        }
        this.postInitialization = uIDefaults -> {
            Color color = uIDefaults.getColor("Component.linkColor");
            if (color != null) {
                new HTMLEditorKit().getStyleSheet().addRule(String.format("a, address { color: #%06x; }", color.getRGB() & 0xFFFFFF));
            }
        };
    }

    @Override
    public void uninitialize() {
        if (UIManager.getLookAndFeel() != this) {
            return;
        }
        if (this.desktopPropertyListener != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.removePropertyChangeListener(this.desktopPropertyName, this.desktopPropertyListener);
            if (this.desktopPropertyName2 != null) {
                toolkit.removePropertyChangeListener(this.desktopPropertyName2, this.desktopPropertyListener);
            }
            toolkit.removePropertyChangeListener(DESKTOPFONTHINTS, this.desktopPropertyListener);
            this.desktopPropertyName = null;
            this.desktopPropertyName2 = null;
            this.desktopPropertyListener = null;
        }
        if (this.oldPopupFactory != null) {
            PopupFactory.setSharedInstance(this.oldPopupFactory);
            this.oldPopupFactory = null;
        }
        if (this.mnemonicHandler != null) {
            this.mnemonicHandler.uninstall();
            this.mnemonicHandler = null;
        }
        if (this.subMenuUsabilityHelperInstalled) {
            SubMenuUsabilityHelper.uninstall();
            this.subMenuUsabilityHelperInstalled = false;
        }
        new HTMLEditorKit().getStyleSheet().addRule("a, address { color: blue; }");
        this.postInitialization = null;
        super.uninitialize();
    }

    private void initializeAqua() {
        BasicLookAndFeel basicLookAndFeel;
        Object object;
        if (aquaLoaded) {
            return;
        }
        aquaLoaded = true;
        String string = "com.apple.laf.AquaLookAndFeel";
        try {
            if (SystemInfo.isJava_9_orLater) {
                object = UIManager.class.getMethod("createLookAndFeel", String.class);
                basicLookAndFeel = (BasicLookAndFeel)((Method)object).invoke(null, "Mac OS X");
            } else {
                basicLookAndFeel = Class.forName(string).asSubclass(BasicLookAndFeel.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to initialize Aqua look and feel '" + string + "'.", exception);
            throw new IllegalStateException();
        }
        object = PopupFactory.getSharedInstance();
        basicLookAndFeel.initialize();
        basicLookAndFeel.uninitialize();
        PopupFactory.setSharedInstance((PopupFactory)object);
    }

    @Override
    public UIDefaults getDefaults() {
        FlatUIDefaults flatUIDefaults = new FlatUIDefaults(1500, 0.75f);
        this.initClassDefaults(flatUIDefaults);
        this.initSystemColorDefaults(flatUIDefaults);
        this.initComponentDefaults(flatUIDefaults);
        flatUIDefaults.put("laf.dark", (Object)this.isDark());
        this.initResourceBundle(flatUIDefaults, "com.formdev.flatlaf.resources.Bundle");
        this.putDefaults(flatUIDefaults, flatUIDefaults.getColor("control"), "Button.disabledBackground", "EditorPane.disabledBackground", "EditorPane.inactiveBackground", "FormattedTextField.disabledBackground", "PasswordField.disabledBackground", "RootPane.background", "Spinner.disabledBackground", "TextArea.disabledBackground", "TextArea.inactiveBackground", "TextField.disabledBackground", "TextPane.disabledBackground", "TextPane.inactiveBackground", "ToggleButton.disabledBackground");
        this.putDefaults(flatUIDefaults, flatUIDefaults.getColor("textInactiveText"), "Button.disabledText", "CheckBox.disabledText", "CheckBoxMenuItem.disabledForeground", "Menu.disabledForeground", "MenuItem.disabledForeground", "RadioButton.disabledText", "RadioButtonMenuItem.disabledForeground", "Spinner.disabledForeground", "ToggleButton.disabledText");
        this.putDefaults(flatUIDefaults, flatUIDefaults.getColor("textText"), "DesktopIcon.foreground", "RootPane.foreground");
        this.initFonts(flatUIDefaults);
        FlatLaf.initIconColors(flatUIDefaults, this.isDark());
        FlatInputMaps.initInputMaps(flatUIDefaults);
        Object v2 = flatUIDefaults.remove("InternalFrame.icon");
        flatUIDefaults.put("InternalFrame.icon", v2);
        flatUIDefaults.put("TitlePane.icon", v2);
        ServiceLoader<FlatDefaultsAddon> serviceLoader = ServiceLoader.load(FlatDefaultsAddon.class);
        ArrayList<FlatDefaultsAddon> arrayList = new ArrayList<FlatDefaultsAddon>();
        for (FlatDefaultsAddon object : serviceLoader) {
            arrayList.add(object);
        }
        arrayList.sort((flatDefaultsAddon, flatDefaultsAddon2) -> flatDefaultsAddon.getPriority() - flatDefaultsAddon2.getPriority());
        List<Class<?>> list = this.getLafClassesForDefaultsLoading();
        if (list != null) {
            UIDefaultsLoader.loadDefaultsFromProperties(list, arrayList, this.getAdditionalDefaults(), this.isDark(), (UIDefaults)flatUIDefaults);
        } else {
            UIDefaultsLoader.loadDefaultsFromProperties(this.getClass(), arrayList, this.getAdditionalDefaults(), this.isDark(), (UIDefaults)flatUIDefaults);
        }
        this.initDefaultFont(flatUIDefaults);
        if (SystemInfo.isMacOS && Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            flatUIDefaults.put("MenuBarUI", "com.apple.laf.AquaMenuBarUI");
            flatUIDefaults.put("MenuBar.backgroundPainter", BorderFactory.createEmptyBorder());
        }
        this.putAATextInfo(flatUIDefaults);
        this.applyAdditionalDefaults(flatUIDefaults);
        for (FlatDefaultsAddon flatDefaultsAddon3 : arrayList) {
            flatDefaultsAddon3.afterDefaultsLoading(this, flatUIDefaults);
        }
        flatUIDefaults.put("laf.scaleFactor", uIDefaults -> Float.valueOf(UIScale.getUserScaleFactor()));
        if (this.postInitialization != null) {
            this.postInitialization.accept(flatUIDefaults);
            this.postInitialization = null;
        }
        return flatUIDefaults;
    }

    void applyAdditionalDefaults(UIDefaults uIDefaults) {
    }

    protected List<Class<?>> getLafClassesForDefaultsLoading() {
        return null;
    }

    protected Properties getAdditionalDefaults() {
        if (globalExtraDefaults == null && this.extraDefaults == null) {
            return null;
        }
        Properties properties = new Properties();
        if (globalExtraDefaults != null) {
            properties.putAll(globalExtraDefaults);
        }
        if (this.extraDefaults != null) {
            properties.putAll(this.extraDefaults);
        }
        return properties;
    }

    private void initResourceBundle(UIDefaults uIDefaults, String string) {
        uIDefaults.addResourceBundle(string);
        if (uIDefaults.get("TabbedPane.moreTabsButtonToolTipText") != null) {
            return;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, uIDefaults.getDefaultLocale());
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                String string3 = resourceBundle.getString(string2);
                String string4 = StringUtils.removeTrailing(string2, ".textAndMnemonic");
                if (string4 != string2) {
                    String string5 = string3.replace("&", "");
                    String string6 = null;
                    int n2 = string3.indexOf(38);
                    if (n2 >= 0) {
                        string6 = Integer.toString(Character.toUpperCase(string3.charAt(n2 + 1)));
                    }
                    uIDefaults.put(string4 + "Text", string5);
                    if (string6 == null) continue;
                    uIDefaults.put(string4 + "Mnemonic", string6);
                    continue;
                }
                uIDefaults.put(string2, string3);
            }
        }
        catch (MissingResourceException missingResourceException) {
            LoggingFacade.INSTANCE.logSevere(null, missingResourceException);
        }
    }

    private void initFonts(UIDefaults uIDefaults) {
        ActiveFont activeFont = new ActiveFont(null, null, -1, 0, 0, 0, 0.0f);
        ArrayList<String> arrayList = new ArrayList<String>(50);
        for (Object object : uIDefaults.keySet()) {
            if (!(object instanceof String) || !((String)object).endsWith(".font") && !((String)object).endsWith("Font")) continue;
            arrayList.add((String)object);
        }
        for (String string : arrayList) {
            uIDefaults.put(string, activeFont);
        }
        uIDefaults.put("RootPane.font", activeFont);
        uIDefaults.put("TitlePane.font", activeFont);
    }

    private void initDefaultFont(UIDefaults uIDefaults) {
        Font font;
        Object object;
        Object object2 = null;
        if (SystemInfo.isWindows) {
            object = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
            if (object != null) {
                if (SystemInfo.isWinPE) {
                    font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.defaultGUI.font");
                    if (font != null) {
                        object2 = FlatLaf.createCompositeFont(font.getFamily(), font.getStyle(), ((Font)object).getSize());
                    }
                } else {
                    object2 = FlatLaf.createCompositeFont(((Font)object).getFamily(), ((Font)object).getStyle(), ((Font)object).getSize());
                }
            }
        } else if (SystemInfo.isMacOS) {
            object = SystemInfo.isMacOS_10_15_Catalina_orLater ? (SystemInfo.isJetBrainsJVM_11_orLater ? ".AppleSystemUIFont" : "Helvetica Neue") : (SystemInfo.isMacOS_10_11_ElCapitan_orLater ? ".SF NS Text" : "Lucida Grande");
            object2 = FlatLaf.createCompositeFont((String)object, 0, 13);
        } else if (SystemInfo.isLinux) {
            object = LinuxFontPolicy.getFont();
            Object object3 = object2 = object instanceof FontUIResource ? (FontUIResource)object : new FontUIResource((Font)object);
        }
        if (object2 == null) {
            object2 = FlatLaf.createCompositeFont("SansSerif", 0, 12);
        }
        if (preferredFontFamily != null && (!ActiveFont.isFallbackFont((Font)(object = FlatLaf.createCompositeFont(FlatLaf.preferredFontFamily, ((Font)object2).getStyle(), ((Font)object2).getSize()))) || ActiveFont.isDialogFamily(FlatLaf.preferredFontFamily))) {
            object2 = object;
        }
        if ((object = uIDefaults.remove("defaultFont")) instanceof ActiveFont) {
            font = object2;
            object2 = ((ActiveFont)object).derive(font, n2 -> Math.round((float)n2 * UIScale.computeFontScaleFactor(font)));
        }
        object2 = UIScale.applyCustomScaleFactor((FontUIResource)object2);
        uIDefaults.put("defaultFont", object2);
    }

    static FontUIResource createCompositeFont(String string, int n2, int n3) {
        FontUtils.loadFontFamily(string);
        Font font = StyleContext.getDefaultStyleContext().getFont(string, n2, n3);
        return font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
    }

    public static UIDefaults.ActiveValue createActiveFontValue(float f2) {
        return new ActiveFont(null, null, -1, 0, 0, 0, f2);
    }

    public static void initIconColors(UIDefaults uIDefaults, boolean bl2) {
        for (FlatIconColors flatIconColors : FlatIconColors.values()) {
            if (flatIconColors.light != !bl2 && flatIconColors.dark != bl2) continue;
            uIDefaults.put(flatIconColors.key, new ColorUIResource(flatIconColors.rgb));
        }
    }

    private void putAATextInfo(UIDefaults uIDefaults) {
        if (SystemInfo.isMacOS && SystemInfo.isJetBrainsJVM) {
            uIDefaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (SystemInfo.isJava_9_orLater) {
            Map map;
            Object v2;
            Object object = Toolkit.getDefaultToolkit().getDesktopProperty(DESKTOPFONTHINTS);
            if (object == null) {
                object = this.fallbackAATextInfo();
            }
            if (object instanceof Map && (v2 = (map = (Map)object).get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null && v2 != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && v2 != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                uIDefaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, v2);
                uIDefaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, map.get(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            }
        } else {
            try {
                Object object = Class.forName("sun.swing.SwingUtilities2").getField("AA_TEXT_PROPERTY_KEY").get(null);
                Object object2 = Class.forName("sun.swing.SwingUtilities2$AATextInfo").getMethod("getAATextInfo", Boolean.TYPE).invoke(null, true);
                if (object2 == null) {
                    object2 = this.fallbackAATextInfo();
                }
                uIDefaults.put(object, object2);
            }
            catch (Exception exception) {
                LoggingFacade.INSTANCE.logSevere(null, exception);
                throw new RuntimeException(exception);
            }
        }
    }

    private Object fallbackAATextInfo() {
        Object object;
        if (System.getProperty("awt.useSystemAAFontSettings") != null) {
            return null;
        }
        Object object2 = null;
        Object v2 = null;
        if (SystemInfo.isLinux && ((Toolkit)(object = Toolkit.getDefaultToolkit())).getDesktopProperty("gnome.Xft/Antialias") == null && ((Toolkit)object).getDesktopProperty("fontconfig/Antialias") == null) {
            object2 = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        }
        if (object2 == null) {
            return null;
        }
        if (SystemInfo.isJava_9_orLater) {
            object = new HashMap();
            object.put(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
            object.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, v2);
            return object;
        }
        try {
            return Class.forName("sun.swing.SwingUtilities2$AATextInfo").getConstructor(Object.class, Integer.class).newInstance(object2, v2);
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(null, exception);
            throw new RuntimeException(exception);
        }
    }

    private void putDefaults(UIDefaults uIDefaults, Object object, String ... stringArray) {
        for (String string : stringArray) {
            uIDefaults.put(string, object);
        }
    }

    static List<Object> getCustomDefaultsSources() {
        return customDefaultsSources;
    }

    public static void registerCustomDefaultsSource(String string) {
        FlatLaf.registerCustomDefaultsSource(string, null);
    }

    public static void unregisterCustomDefaultsSource(String string) {
        FlatLaf.unregisterCustomDefaultsSource(string, null);
    }

    public static void registerCustomDefaultsSource(String string, ClassLoader classLoader) {
        if (customDefaultsSources == null) {
            customDefaultsSources = new ArrayList<Object>();
        }
        customDefaultsSources.add(string);
        customDefaultsSources.add(classLoader);
    }

    public static void unregisterCustomDefaultsSource(String string, ClassLoader classLoader) {
        if (customDefaultsSources == null) {
            return;
        }
        int n2 = customDefaultsSources.size();
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            Object object = customDefaultsSources.get(i2);
            if (!string.equals(object) || customDefaultsSources.get(i2 + 1) != classLoader) continue;
            customDefaultsSources.remove(i2 + 1);
            customDefaultsSources.remove(i2);
            break;
        }
    }

    public static void registerCustomDefaultsSource(URL uRL) {
        if (customDefaultsSources == null) {
            customDefaultsSources = new ArrayList<Object>();
        }
        customDefaultsSources.add(uRL);
    }

    public static void unregisterCustomDefaultsSource(URL uRL) {
        if (customDefaultsSources == null) {
            return;
        }
        customDefaultsSources.remove(uRL);
    }

    public static void registerCustomDefaultsSource(File file) {
        if (customDefaultsSources == null) {
            customDefaultsSources = new ArrayList<Object>();
        }
        customDefaultsSources.add(file);
    }

    public static void unregisterCustomDefaultsSource(File file) {
        if (customDefaultsSources == null) {
            return;
        }
        customDefaultsSources.remove(file);
    }

    public static Map<String, String> getGlobalExtraDefaults() {
        return globalExtraDefaults;
    }

    public static void setGlobalExtraDefaults(Map<String, String> map) {
        globalExtraDefaults = map;
    }

    public Map<String, String> getExtraDefaults() {
        return this.extraDefaults;
    }

    public void setExtraDefaults(Map<String, String> map) {
        this.extraDefaults = map;
    }

    public static Object parseDefaultsValue(String string2, String string3, Class<?> clazz) throws IllegalArgumentException {
        Object object = UIDefaultsLoader.parseValue(string2, string3 = UIDefaultsLoader.resolveValueFromUIManager(string3), clazz, null, string -> UIDefaultsLoader.resolveValueFromUIManager(string), Collections.emptyList());
        if (object instanceof UIDefaults.LazyValue) {
            object = ((UIDefaults.LazyValue)object).createValue(null);
        } else if (object instanceof UIDefaults.ActiveValue) {
            object = ((UIDefaults.ActiveValue)object).createValue(null);
        }
        return object;
    }

    public static Function<String, Color> getSystemColorGetter() {
        return systemColorGetter;
    }

    public static void setSystemColorGetter(Function<String, Color> function) {
        systemColorGetter = function;
    }

    private static void reSetLookAndFeel() {
        EventQueue.invokeLater(() -> {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(UIManager.class, "lookAndFeel", lookAndFeel, lookAndFeel);
                for (PropertyChangeListener propertyChangeListener : UIManager.getPropertyChangeListeners()) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
                FlatLaf.updateUI();
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to reinitialize look and feel '" + lookAndFeel.getClass().getName() + "'.", unsupportedLookAndFeelException);
            }
        });
    }

    public static void updateUI() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUILater() {
        Class<FlatLaf> clazz = FlatLaf.class;
        synchronized (FlatLaf.class) {
            if (updateUIPending) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            updateUIPending = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            EventQueue.invokeLater(() -> {
                FlatLaf.updateUI();
                Class<FlatLaf> clazz = FlatLaf.class;
                synchronized (FlatLaf.class) {
                    updateUIPending = false;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            });
            return;
        }
    }

    public static boolean supportsNativeWindowDecorations() {
        return SystemInfo.isWindows_10_orLater && FlatNativeWindowBorder.isSupported();
    }

    public static boolean isUseNativeWindowDecorations() {
        return UIManager.getBoolean("TitlePane.useWindowDecorations");
    }

    public static void setUseNativeWindowDecorations(boolean bl2) {
        UIManager.put("TitlePane.useWindowDecorations", bl2);
        if (!(UIManager.getLookAndFeel() instanceof FlatLaf)) {
            return;
        }
        for (Window window : Window.getWindows()) {
            if (!FlatLaf.isDisplayableFrameOrDialog(window)) continue;
            FlatRootPaneUI.updateNativeWindowBorder(((RootPaneContainer)((Object)window)).getRootPane());
        }
    }

    public static void revalidateAndRepaintAllFramesAndDialogs() {
        for (Window window : Window.getWindows()) {
            JMenuBar jMenuBar;
            if (!FlatLaf.isDisplayableFrameOrDialog(window)) continue;
            JMenuBar jMenuBar2 = window instanceof JFrame ? ((JFrame)window).getJMenuBar() : (jMenuBar = window instanceof JDialog ? ((JDialog)window).getJMenuBar() : null);
            if (jMenuBar != null) {
                jMenuBar.revalidate();
            }
            window.revalidate();
            window.repaint();
        }
    }

    public static void repaintAllFramesAndDialogs() {
        for (Window window : Window.getWindows()) {
            if (!FlatLaf.isDisplayableFrameOrDialog(window)) continue;
            window.repaint();
        }
    }

    private static boolean isDisplayableFrameOrDialog(Window window) {
        return window.isDisplayable() && (window instanceof JFrame || window instanceof JDialog);
    }

    public static boolean isShowMnemonics() {
        return MnemonicHandler.isShowMnemonics();
    }

    public static void showMnemonics(Component component) {
        MnemonicHandler.showMnemonics(true, component);
    }

    public static void hideMnemonics() {
        MnemonicHandler.showMnemonics(false, null);
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void registerUIDefaultsGetter(Function<Object, Object> function) {
        if (this.uiDefaultsGetters == null) {
            this.uiDefaultsGetters = new ArrayList<Function<Object, Object>>();
        }
        this.uiDefaultsGetters.remove(function);
        this.uiDefaultsGetters.add(function);
        FlatUIUtils.setUseSharedUIs(false);
    }

    public void unregisterUIDefaultsGetter(Function<Object, Object> function) {
        if (this.uiDefaultsGetters == null) {
            return;
        }
        this.uiDefaultsGetters.remove(function);
        if (this.uiDefaultsGetters.isEmpty()) {
            FlatUIUtils.setUseSharedUIs(true);
        }
    }

    public static void runWithUIDefaultsGetter(Function<Object, Object> function, Runnable runnable) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof FlatLaf) {
            ((FlatLaf)lookAndFeel).registerUIDefaultsGetter(function);
            try {
                runnable.run();
            }
            finally {
                ((FlatLaf)lookAndFeel).unregisterUIDefaultsGetter(function);
            }
        } else {
            runnable.run();
        }
    }

    public static Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        ComponentUI componentUI = JavaCompatibility2.getUI(jComponent);
        return componentUI instanceof FlatStylingSupport.StyleableUI ? ((FlatStylingSupport.StyleableUI)((Object)componentUI)).getStyleableInfos(jComponent) : null;
    }

    public static <T> T getStyleableValue(JComponent jComponent, String string) {
        ComponentUI componentUI = JavaCompatibility2.getUI(jComponent);
        return (T)(componentUI instanceof FlatStylingSupport.StyleableUI ? ((FlatStylingSupport.StyleableUI)((Object)componentUI)).getStyleableValue(jComponent, string) : null);
    }

    public static String getPreferredFontFamily() {
        return preferredFontFamily;
    }

    public static void setPreferredFontFamily(String string) {
        preferredFontFamily = string;
    }

    public static String getPreferredLightFontFamily() {
        return preferredLightFontFamily;
    }

    public static void setPreferredLightFontFamily(String string) {
        preferredLightFontFamily = string;
    }

    public static String getPreferredSemiboldFontFamily() {
        return preferredSemiboldFontFamily;
    }

    public static void setPreferredSemiboldFontFamily(String string) {
        preferredSemiboldFontFamily = string;
    }

    public static String getPreferredMonospacedFontFamily() {
        return preferredMonospacedFontFamily;
    }

    public static void setPreferredMonospacedFontFamily(String string) {
        preferredMonospacedFontFamily = string;
    }

    static {
        NULL_VALUE = new Object();
    }

    public static interface DisabledIconProvider {
        public Icon getDisabledIcon();
    }

    private static class ImageIconUIResource
    extends ImageIcon
    implements UIResource {
        ImageIconUIResource(Image image) {
            super(image);
        }
    }

    static class ActiveFont
    implements UIDefaults.ActiveValue {
        private final String baseFontKey;
        private final List<String> families;
        private final int style;
        private final int styleChange;
        private final int absoluteSize;
        private final int relativeSize;
        private final float scaleSize;
        private FontUIResource font;
        private Font lastBaseFont;
        private boolean inCreateValue;

        ActiveFont(String string, List<String> list, int n2, int n3, int n4, int n5, float f2) {
            this.baseFontKey = string;
            this.families = list;
            this.style = n2;
            this.styleChange = n3;
            this.absoluteSize = n4;
            this.relativeSize = n5;
            this.scaleSize = f2;
        }

        @Override
        public synchronized Object createValue(UIDefaults uIDefaults) {
            if (this.inCreateValue) {
                throw new IllegalStateException("FlatLaf: endless recursion in font");
            }
            Font font = null;
            this.inCreateValue = true;
            try {
                if (this.baseFontKey != null) {
                    font = (Font)UIDefaultsLoader.lazyUIManagerGet(this.baseFontKey);
                }
                if (font == null) {
                    font = UIManager.getFont("defaultFont");
                }
                if (font == null) {
                    font = UIManager.getFont("Label.font");
                }
            }
            finally {
                this.inCreateValue = false;
            }
            if (this.lastBaseFont != font) {
                this.lastBaseFont = font;
                this.font = this.derive(font, n2 -> UIScale.scale(n2));
            }
            return this.font;
        }

        FontUIResource derive(Font font, IntUnaryOperator intUnaryOperator) {
            Object object;
            int n2;
            int n3;
            int n4 = font.getStyle();
            int n5 = font.getSize();
            int n6 = this.style != -1 ? this.style : (n3 = this.styleChange != 0 ? n4 & ~(this.styleChange >> 16 & 0xFFFF) | this.styleChange & 0xFFFF : n4);
            int n7 = this.absoluteSize > 0 ? intUnaryOperator.applyAsInt(this.absoluteSize) : (this.relativeSize != 0 ? n5 + intUnaryOperator.applyAsInt(this.relativeSize) : (n2 = this.scaleSize > 0.0f ? Math.round((float)n5 * this.scaleSize) : n5));
            if (n2 <= 0) {
                n2 = 1;
            }
            if (this.families != null && !this.families.isEmpty()) {
                Object object2;
                object = ActiveFont.preferredFamily(this.families);
                if (object != null && (!ActiveFont.isFallbackFont((Font)(object2 = FlatLaf.createCompositeFont((String)object, n3, n2))) || ActiveFont.isDialogFamily((String)object))) {
                    return this.toUIResource((Font)object2);
                }
                for (String string : this.families) {
                    FontUIResource fontUIResource = FlatLaf.createCompositeFont(string, n3, n2);
                    if (ActiveFont.isFallbackFont(fontUIResource) && !ActiveFont.isDialogFamily(string)) continue;
                    return this.toUIResource(fontUIResource);
                }
            }
            if (n3 != n4 || n2 != n5) {
                if ("Ubuntu Medium".equalsIgnoreCase(font.getName()) && "Ubuntu Light".equalsIgnoreCase(font.getFamily()) && !ActiveFont.isFallbackFont((Font)(object = FlatLaf.createCompositeFont("Ubuntu Medium", n3, n2)))) {
                    return this.toUIResource((Font)object);
                }
                return this.toUIResource(font.deriveFont(n3, n2));
            }
            return this.toUIResource(font);
        }

        private FontUIResource toUIResource(Font font) {
            return font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        }

        private static boolean isFallbackFont(Font font) {
            return "Dialog".equalsIgnoreCase(font.getFamily());
        }

        private static boolean isDialogFamily(String string) {
            return string.equalsIgnoreCase("Dialog");
        }

        private static String preferredFamily(List<String> list) {
            for (String string : list) {
                if ((string = string.toLowerCase(Locale.ENGLISH)).endsWith(" light") || string.endsWith("-thin")) {
                    return preferredLightFontFamily;
                }
                if (string.endsWith(" semibold") || string.endsWith("-medium")) {
                    return preferredSemiboldFontFamily;
                }
                if (!string.equals("monospaced")) continue;
                return preferredMonospacedFontFamily;
            }
            return null;
        }
    }

    private class FlatUIDefaults
    extends UIDefaults {
        private UIDefaults metalDefaults;

        FlatUIDefaults(int n2, float f2) {
            super(n2, f2);
        }

        @Override
        public Object get(Object object) {
            return this.get(object, null);
        }

        @Override
        public Object get(Object object, Locale locale) {
            Object object2 = this.getFromUIDefaultsGetters(object);
            if (object2 != null) {
                return object2 != NULL_VALUE ? object2 : null;
            }
            object2 = super.get(object, locale);
            if (object2 != null) {
                return object2;
            }
            return object instanceof String && ((String)object).startsWith("FileChooser.") ? this.getFromMetal((String)object, locale) : null;
        }

        private Object getFromUIDefaultsGetters(Object object) {
            List list = FlatLaf.this.uiDefaultsGetters;
            if (list == null) {
                return null;
            }
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                Object r2 = ((Function)list.get(i2)).apply(object);
                if (r2 == null) continue;
                return r2;
            }
            return null;
        }

        private synchronized Object getFromMetal(String string, Locale locale) {
            if (this.metalDefaults == null) {
                this.metalDefaults = new MetalLookAndFeel(){

                    @Override
                    protected void initClassDefaults(UIDefaults uIDefaults) {
                    }

                    @Override
                    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
                    }
                }.getDefaults();
                this.metalDefaults.clear();
            }
            return this.metalDefaults.get(string, locale);
        }
    }
}

