/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SubMenuUsabilityHelper
implements ChangeListener {
    private static final String KEY_USE_SAFE_TRIANGLE = "Menu.useSafeTriangle";
    private static final String KEY_SHOW_SAFE_TRIANGLE = "FlatLaf.debug.menu.showSafeTriangle";
    private static SubMenuUsabilityHelper instance;
    private boolean eventQueuePushNotSupported;
    private SubMenuEventQueue subMenuEventQueue;
    private SafeTrianglePainter safeTrianglePainter;
    private boolean changePending;
    private int mouseX;
    private int mouseY;
    private int targetX;
    private int targetTopY;
    private int targetBottomY;
    private Rectangle invokerBounds;

    SubMenuUsabilityHelper() {
    }

    static synchronized boolean install() {
        if (instance != null) {
            return false;
        }
        if (!FlatSystemProperties.getBoolean("flatlaf.useSubMenuSafeTriangle", true)) {
            return false;
        }
        instance = new SubMenuUsabilityHelper();
        MenuSelectionManager.defaultManager().addChangeListener(instance);
        return true;
    }

    static synchronized void uninstall() {
        if (instance == null) {
            return;
        }
        MenuSelectionManager.defaultManager().removeChangeListener(instance);
        instance.uninstallEventQueue();
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.eventQueuePushNotSupported || !FlatUIUtils.getUIBoolean(KEY_USE_SAFE_TRIANGLE, true)) {
            return;
        }
        SubMenuUsabilityHelper subMenuUsabilityHelper = this;
        synchronized (subMenuUsabilityHelper) {
            if (this.changePending) {
                return;
            }
            this.changePending = true;
        }
        EventQueue.invokeLater(() -> {
            SubMenuUsabilityHelper subMenuUsabilityHelper = this;
            synchronized (subMenuUsabilityHelper) {
                this.changePending = false;
            }
            this.menuSelectionChanged();
        });
    }

    private void menuSelectionChanged() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        int n2 = this.findSubMenu(menuElementArray);
        if (n2 < 0 || n2 != menuElementArray.length - 1) {
            this.uninstallEventQueue();
            return;
        }
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point point = pointerInfo != null ? pointerInfo.getLocation() : new Point();
        this.mouseX = point.x;
        this.mouseY = point.y;
        JPopupMenu jPopupMenu = (JPopupMenu)menuElementArray[n2];
        if (!jPopupMenu.isShowing()) {
            this.uninstallEventQueue();
            return;
        }
        Component component = jPopupMenu.getInvoker();
        Rectangle rectangle = this.invokerBounds = component != null && component.isShowing() ? new Rectangle(component.getLocationOnScreen(), component.getSize()) : null;
        if (this.invokerBounds != null && !this.invokerBounds.contains(this.mouseX, this.mouseY)) {
            this.uninstallEventQueue();
            return;
        }
        Point point2 = jPopupMenu.getLocationOnScreen();
        Dimension dimension = jPopupMenu.getSize();
        this.targetX = this.mouseX < point2.x + dimension.width / 2 ? point2.x : point2.x + dimension.width;
        this.targetTopY = point2.y;
        this.targetBottomY = point2.y + dimension.height;
        if (this.subMenuEventQueue == null) {
            SubMenuEventQueue subMenuEventQueue = new SubMenuEventQueue();
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.getSystemEventQueue().push(subMenuEventQueue);
                if (toolkit.getSystemEventQueue() != subMenuEventQueue) {
                    this.eventQueuePushNotSupported = true;
                    LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to push submenu event queue. Disabling submenu safe triangle.", null);
                    return;
                }
                this.subMenuEventQueue = subMenuEventQueue;
            }
            catch (RuntimeException runtimeException) {
                this.eventQueuePushNotSupported = true;
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to push submenu event queue. Disabling submenu safe triangle.", runtimeException);
                return;
            }
        }
        if (this.safeTrianglePainter == null && UIManager.getBoolean(KEY_SHOW_SAFE_TRIANGLE)) {
            this.safeTrianglePainter = new SafeTrianglePainter(jPopupMenu);
        }
    }

    private void uninstallEventQueue() {
        if (this.subMenuEventQueue != null) {
            this.subMenuEventQueue.uninstall();
            this.subMenuEventQueue = null;
        }
        if (this.safeTrianglePainter != null) {
            this.safeTrianglePainter.uninstall();
            this.safeTrianglePainter = null;
        }
    }

    private int findSubMenu(MenuElement[] menuElementArray) {
        for (int i2 = menuElementArray.length - 1; i2 >= 1; --i2) {
            if (!(menuElementArray[i2] instanceof JPopupMenu) || !(menuElementArray[i2 - 1] instanceof JMenu) || ((JMenu)menuElementArray[i2 - 1]).isTopLevelMenu()) continue;
            return i2;
        }
        return -1;
    }

    private Polygon createSafeTriangle() {
        return new Polygon(new int[]{this.mouseX, this.targetX, this.targetX}, new int[]{this.mouseY, this.targetTopY, this.targetBottomY}, 3);
    }

    private class SafeTrianglePainter
    extends JComponent {
        SafeTrianglePainter(JPopupMenu jPopupMenu) {
            Window window = SwingUtilities.windowForComponent(jPopupMenu.getInvoker());
            if (window instanceof RootPaneContainer) {
                JLayeredPane jLayeredPane = ((RootPaneContainer)((Object)window)).getLayeredPane();
                this.setSize(jLayeredPane.getSize());
                jLayeredPane.add((Component)this, (Object)(JLayeredPane.POPUP_LAYER + 1));
            }
        }

        void uninstall() {
            Container container = this.getParent();
            if (container != null) {
                container.remove(this);
                container.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Point point = this.getLocationOnScreen();
            graphics.translate(-point.x, -point.y);
            graphics.setColor(Color.red);
            ((Graphics2D)graphics).draw(SubMenuUsabilityHelper.this.createSafeTriangle());
        }
    }

    private class SubMenuEventQueue
    extends EventQueue {
        private Timer mouseUpdateTimer = new Timer(50, actionEvent -> {
            SubMenuUsabilityHelper.this.mouseX = this.newMouseX;
            SubMenuUsabilityHelper.this.mouseY = this.newMouseY;
            if (SubMenuUsabilityHelper.this.safeTrianglePainter != null) {
                SubMenuUsabilityHelper.this.safeTrianglePainter.repaint();
            }
        });
        private Timer timeoutTimer;
        private int newMouseX;
        private int newMouseY;
        private AWTEvent lastMouseEvent;

        SubMenuEventQueue() {
            this.mouseUpdateTimer.setRepeats(false);
            this.timeoutTimer = new Timer(200, actionEvent -> {
                if (SubMenuUsabilityHelper.this.invokerBounds != null && !SubMenuUsabilityHelper.this.invokerBounds.contains(this.newMouseX, this.newMouseY)) {
                    if (this.lastMouseEvent != null) {
                        this.postEvent(this.lastMouseEvent);
                        this.lastMouseEvent = null;
                    }
                    SubMenuUsabilityHelper.this.uninstallEventQueue();
                    return;
                }
            });
            this.timeoutTimer.setRepeats(false);
        }

        void uninstall() {
            this.mouseUpdateTimer.stop();
            this.mouseUpdateTimer = null;
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
            this.lastMouseEvent = null;
            super.pop();
        }

        @Override
        protected void dispatchEvent(AWTEvent aWTEvent) {
            int n2 = aWTEvent.getID();
            if (aWTEvent instanceof MouseEvent && (n2 == 503 || n2 == 506)) {
                this.newMouseX = ((MouseEvent)aWTEvent).getXOnScreen();
                this.newMouseY = ((MouseEvent)aWTEvent).getYOnScreen();
                if (SubMenuUsabilityHelper.this.safeTrianglePainter != null) {
                    SubMenuUsabilityHelper.this.safeTrianglePainter.repaint();
                }
                this.mouseUpdateTimer.stop();
                this.timeoutTimer.stop();
                if (SubMenuUsabilityHelper.this.createSafeTriangle().contains(this.newMouseX, this.newMouseY)) {
                    this.mouseUpdateTimer.start();
                    this.timeoutTimer.start();
                    this.lastMouseEvent = aWTEvent;
                    return;
                }
                SubMenuUsabilityHelper.this.mouseX = this.newMouseX;
                SubMenuUsabilityHelper.this.mouseY = this.newMouseY;
            }
            super.dispatchEvent(aWTEvent);
        }
    }
}

