/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDefaultsAddon;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.HSLColor;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SoftCache;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;

class UIDefaultsLoader {
    private static final String TYPE_PREFIX = "{";
    private static final String TYPE_PREFIX_END = "}";
    private static final String VARIABLE_PREFIX = "@";
    private static final String PROPERTY_PREFIX = "$";
    private static final String OPTIONAL_PREFIX = "?";
    private static final String WILDCARD_PREFIX = "*.";
    static final String KEY_VARIABLES = "FlatLaf.internal.variables";
    private static int parseColorDepth;
    private static Map<String, ColorUIResource> systemColorCache;
    private static final SoftCache<String, Object> fontCache;
    private static final ValueType[] tempResultValueType;
    private static Map<Class<?>, ValueType> javaValueTypes;
    private static Map<String, ValueType> knownValueTypes;

    UIDefaultsLoader() {
    }

    static void loadDefaultsFromProperties(Class<?> clazz, List<FlatDefaultsAddon> list, Properties properties, boolean bl2, UIDefaults uIDefaults) {
        ArrayList arrayList = new ArrayList();
        Class<?> clazz2 = clazz;
        while (FlatLaf.class.isAssignableFrom(clazz2)) {
            arrayList.add(0, clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        UIDefaultsLoader.loadDefaultsFromProperties(arrayList, list, properties, bl2, uIDefaults);
    }

    /*
     * WARNING - void declaration
     */
    static void loadDefaultsFromProperties(List<Class<?>> list, List<FlatDefaultsAddon> list2, Properties properties, boolean bl2, UIDefaults uIDefaults) {
        try {
            Object object;
            Object object22;
            void var9_25;
            Object object3;
            systemColorCache = FlatLaf.getSystemColorGetter() != null ? new HashMap() : null;
            Properties properties2 = new Properties();
            for (Class<?> list32 : list) {
                String string2 = '/' + list32.getName().replace('.', '/') + ".properties";
                InputStream inputStream = list32.getResourceAsStream(string2);
                try {
                    if (inputStream == null) continue;
                    properties2.load(inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            for (FlatDefaultsAddon flatDefaultsAddon : list2) {
                for (Class<?> clazz : list) {
                    object3 = flatDefaultsAddon.getDefaults(clazz);
                    try {
                        if (object3 == null) continue;
                        properties2.load((InputStream)object3);
                    }
                    finally {
                        if (object3 == null) continue;
                        ((InputStream)object3).close();
                    }
                }
            }
            ArrayList arrayList = new ArrayList();
            for (FlatDefaultsAddon flatDefaultsAddon : list2) {
                ClassLoader classLoader = flatDefaultsAddon.getClass().getClassLoader();
                if (arrayList.contains(classLoader)) continue;
                arrayList.add(classLoader);
            }
            List<Object> list3 = FlatLaf.getCustomDefaultsSources();
            int n2 = list3 != null ? list3.size() : 0;
            boolean bl3 = false;
            while (var9_25 < n2) {
                object3 = list3.get((int)var9_25);
                if (object3 instanceof String && var9_25 + true < n2) {
                    ClassLoader classLoader;
                    object22 = (String)object3;
                    if ((classLoader = (ClassLoader)list3.get((int)(++var9_25))) != null && !arrayList.contains(classLoader)) {
                        arrayList.add(classLoader);
                    }
                    object22 = ((String)object22).replace('.', '/');
                    if (classLoader == null) {
                        ClassLoader classLoader2 = FlatLaf.class.getClassLoader();
                    }
                    for (Class<?> clazz : list) {
                        void var12_36;
                        object = (String)object22 + '/' + UIDefaultsLoader.simpleClassName(clazz) + ".properties";
                        InputStream inputStream = var12_36.getResourceAsStream((String)object);
                        try {
                            if (inputStream == null) continue;
                            properties2.load(inputStream);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                } else if (object3 instanceof URL) {
                    object22 = (URL)object3;
                    for (Class<?> clazz : list) {
                        URL uRL = new URL(object22 + UIDefaultsLoader.simpleClassName(clazz) + ".properties");
                        try {
                            object = uRL.openStream();
                            try {
                                properties2.load((InputStream)object);
                            }
                            finally {
                                if (object == null) continue;
                                ((InputStream)object).close();
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                } else if (object3 instanceof File) {
                    object22 = (File)object3;
                    for (Class<?> clazz : list) {
                        File file = new File((File)object22, UIDefaultsLoader.simpleClassName(clazz) + ".properties");
                        if (!file.isFile()) continue;
                        object = new FileInputStream(file);
                        try {
                            properties2.load((InputStream)object);
                        }
                        finally {
                            ((InputStream)object).close();
                        }
                    }
                }
                ++var9_25;
            }
            if (properties != null) {
                properties2.putAll((Map<?, ?>)properties);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object object22 : properties2.keySet()) {
                String string3 = (String)object22;
                if (!string3.startsWith("[") || !string3.startsWith("[win]") && !string3.startsWith("[mac]") && !string3.startsWith("[linux]") && !string3.startsWith("[light]") && !string3.startsWith("[dark]")) continue;
                arrayList2.add(string3);
            }
            if (!arrayList2.isEmpty()) {
                object3 = bl2 ? "[dark]" : "[light]";
                for (String string4 : arrayList2) {
                    if (!string4.startsWith((String)object3)) continue;
                    properties2.put(string4.substring(((String)object3).length()), properties2.remove(string4));
                }
                object22 = SystemInfo.isWindows ? "[win]" : (SystemInfo.isMacOS ? "[mac]" : (SystemInfo.isLinux ? "[linux]" : "[unknown]"));
                for (String string5 : arrayList2) {
                    Object object4 = properties2.remove(string5);
                    if (!string5.startsWith((String)object22)) continue;
                    properties2.put(string5.substring(((String)object22).length()), object4);
                }
            }
            object3 = new HashMap<String, String>();
            object22 = properties2.entrySet().iterator();
            while (object22.hasNext()) {
                Map.Entry entry = (Map.Entry)object22.next();
                String string6 = (String)entry.getKey();
                if (!string6.startsWith(WILDCARD_PREFIX)) continue;
                ((HashMap)object3).put(string6.substring(WILDCARD_PREFIX.length()), (String)entry.getValue());
                object22.remove();
            }
            for (Object k2 : uIDefaults.keySet()) {
                String string7;
                int n3;
                if (!(k2 instanceof String) || properties2.containsKey(k2) || (n3 = ((String)k2).lastIndexOf(46)) < 0 || (string7 = (String)((HashMap)object3).get(object = ((String)k2).substring(n3 + 1))) == null) continue;
                properties2.put(k2, string7);
            }
            Function<String, String> function = string -> properties2.getProperty((String)string);
            Function<String, String> function2 = string -> UIDefaultsLoader.resolveValue(string, function);
            HashMap<String, String> hashMap = new HashMap<String, String>(50);
            for (Map.Entry entry : properties2.entrySet()) {
                String string8 = (String)entry.getKey();
                if (string8.startsWith(VARIABLE_PREFIX)) {
                    hashMap.put(string8, (String)entry.getValue());
                    continue;
                }
                String string9 = (String)entry.getValue();
                try {
                    string9 = UIDefaultsLoader.resolveValue(string9, function);
                    uIDefaults.put(string8, UIDefaultsLoader.parseValue(string8, string9, null, null, function2, arrayList));
                }
                catch (RuntimeException runtimeException) {
                    UIDefaultsLoader.logParseError(string8, string9, runtimeException, true);
                }
            }
            uIDefaults.put(KEY_VARIABLES, hashMap);
            systemColorCache = null;
        }
        catch (IOException iOException) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to load properties files.", iOException);
        }
    }

    static String simpleClassName(Class<?> clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    static void logParseError(String string, String string2, RuntimeException runtimeException, boolean bl2) {
        String string3 = "FlatLaf: Failed to parse: '" + string + '=' + string2 + '\'';
        if (bl2) {
            LoggingFacade.INSTANCE.logSevere(string3, runtimeException);
        } else {
            LoggingFacade.INSTANCE.logConfig(string3, runtimeException);
        }
    }

    static String resolveValue(String string, Function<String, String> function) throws IllegalArgumentException {
        String string2;
        String string3 = string = string.trim();
        if (string.startsWith(PROPERTY_PREFIX)) {
            string = string.substring(PROPERTY_PREFIX.length());
        } else if (!string.startsWith(VARIABLE_PREFIX)) {
            return string;
        }
        boolean bl2 = false;
        if (string.startsWith(OPTIONAL_PREFIX)) {
            string = string.substring(OPTIONAL_PREFIX.length());
            bl2 = true;
        }
        if ((string2 = function.apply(string)) == null) {
            if (bl2) {
                return "null";
            }
            throw new IllegalArgumentException("variable or property '" + string + "' not found");
        }
        if (string2.equals(string3)) {
            throw new IllegalArgumentException("endless recursion in variable or property '" + string + "'");
        }
        return UIDefaultsLoader.resolveValue(string2, function);
    }

    static String resolveValueFromUIManager(String string) throws IllegalArgumentException {
        if (string.startsWith(VARIABLE_PREFIX)) {
            String string2;
            Map map = (Map)UIManager.get(KEY_VARIABLES);
            String string3 = string2 = map != null ? (String)map.get(string) : null;
            if (string2 == null) {
                throw new IllegalArgumentException("variable '" + string + "' not found");
            }
            return UIDefaultsLoader.resolveValueFromUIManager(string2);
        }
        if (!string.startsWith(PROPERTY_PREFIX)) {
            return string;
        }
        String string4 = string.substring(PROPERTY_PREFIX.length());
        Object object = UIManager.get(string4);
        if (object == null) {
            throw new IllegalArgumentException("property '" + string4 + "' not found");
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            int n2 = color.getRGB() & 0xFFFFFF;
            int n3 = color.getAlpha();
            return n3 != 255 ? String.format("#%06x%02x", n2, n3) : String.format("#%06x", n2);
        }
        throw new IllegalArgumentException("property value type '" + object.getClass().getName() + "' not supported in references");
    }

    static Object parseValue(String string2, String string3, Class<?> clazz) throws IllegalArgumentException {
        return UIDefaultsLoader.parseValue(string2, string3, clazz, null, string -> string, Collections.emptyList());
    }

    static Object parseValue(String string, String string2, Class<?> clazz, ValueType[] valueTypeArray, Function<String, String> function, List<ClassLoader> list) throws IllegalArgumentException {
        if (valueTypeArray == null) {
            valueTypeArray = tempResultValueType;
        }
        if (string.startsWith("[style]")) {
            valueTypeArray[0] = ValueType.STRING;
            return string2;
        }
        if ((string2 = string2.trim()).equals("null") || string2.isEmpty()) {
            valueTypeArray[0] = ValueType.NULL;
            return null;
        }
        if (string2.startsWith("if(") && string2.endsWith(")")) {
            List<String> list2 = UIDefaultsLoader.splitFunctionParams(string2.substring(3, string2.length() - 1), ',');
            if (list2.size() != 3) {
                throw UIDefaultsLoader.newMissingParametersException(string2);
            }
            boolean bl2 = UIDefaultsLoader.parseCondition(list2.get(0), function, list);
            String string3 = list2.get(bl2 ? 1 : 2);
            return UIDefaultsLoader.parseValue(string, function.apply(string3), clazz, valueTypeArray, function, list);
        }
        ValueType valueType = ValueType.UNKNOWN;
        if (clazz != null) {
            if (javaValueTypes == null) {
                javaValueTypes = new HashMap();
                javaValueTypes.put(String.class, ValueType.STRING);
                javaValueTypes.put(Boolean.TYPE, ValueType.BOOLEAN);
                javaValueTypes.put(Boolean.class, ValueType.BOOLEAN);
                javaValueTypes.put(Character.TYPE, ValueType.CHARACTER);
                javaValueTypes.put(Character.class, ValueType.CHARACTER);
                javaValueTypes.put(Integer.TYPE, ValueType.INTEGER);
                javaValueTypes.put(Integer.class, ValueType.INTEGER);
                javaValueTypes.put(Float.TYPE, ValueType.FLOAT);
                javaValueTypes.put(Float.class, ValueType.FLOAT);
                javaValueTypes.put(Border.class, ValueType.BORDER);
                javaValueTypes.put(Icon.class, ValueType.ICON);
                javaValueTypes.put(Insets.class, ValueType.INSETS);
                javaValueTypes.put(Dimension.class, ValueType.DIMENSION);
                javaValueTypes.put(Color.class, ValueType.COLOR);
                javaValueTypes.put(Font.class, ValueType.FONT);
            }
            if ((valueType = javaValueTypes.get(clazz)) == null) {
                throw new IllegalArgumentException("unsupported value type '" + clazz.getName() + "'");
            }
            if (valueType == ValueType.STRING && string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
        } else {
            int n2;
            switch (string2) {
                case "false": {
                    valueTypeArray[0] = ValueType.BOOLEAN;
                    return false;
                }
                case "true": {
                    valueTypeArray[0] = ValueType.BOOLEAN;
                    return true;
                }
            }
            if (string2.startsWith("lazy(") && string2.endsWith(")")) {
                valueTypeArray[0] = ValueType.LAZY;
                String string4 = StringUtils.substringTrimmed(string2, 5, string2.length() - 1);
                return uIDefaults -> UIDefaultsLoader.lazyUIManagerGet(string4);
            }
            if (string2.startsWith("#")) {
                valueType = ValueType.COLOR;
            } else if (string2.startsWith(TYPE_PREFIX) && (n2 = string2.indexOf(TYPE_PREFIX_END)) != -1) {
                try {
                    String string5 = string2.substring(TYPE_PREFIX.length(), n2);
                    valueType = ValueType.valueOf(string5.toUpperCase(Locale.ENGLISH));
                    string2 = string2.substring(n2 + TYPE_PREFIX_END.length());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (valueType == ValueType.UNKNOWN) {
                if (knownValueTypes == null) {
                    knownValueTypes = new HashMap<String, ValueType>();
                    knownValueTypes.put("activeCaptionBorder", ValueType.COLOR);
                    knownValueTypes.put("inactiveCaptionBorder", ValueType.COLOR);
                    knownValueTypes.put("windowBorder", ValueType.COLOR);
                    knownValueTypes.put("SplitPane.dividerSize", ValueType.INTEGER);
                    knownValueTypes.put("SplitPaneDivider.gripDotSize", ValueType.INTEGER);
                    knownValueTypes.put("dividerSize", ValueType.INTEGER);
                    knownValueTypes.put("gripDotSize", ValueType.INTEGER);
                    knownValueTypes.put("TabbedPane.closeCrossPlainSize", ValueType.FLOAT);
                    knownValueTypes.put("TabbedPane.closeCrossFilledSize", ValueType.FLOAT);
                    knownValueTypes.put("closeCrossPlainSize", ValueType.FLOAT);
                    knownValueTypes.put("closeCrossFilledSize", ValueType.FLOAT);
                    knownValueTypes.put("Table.intercellSpacing", ValueType.DIMENSION);
                    knownValueTypes.put("intercellSpacing", ValueType.DIMENSION);
                }
                valueType = knownValueTypes.getOrDefault(string, ValueType.UNKNOWN);
            }
            if (valueType == ValueType.UNKNOWN) {
                if (string.endsWith("UI")) {
                    valueType = ValueType.STRING;
                } else if (string.endsWith("Color") || string.endsWith("ground") && (string.endsWith(".background") || string.endsWith("Background") || string.equals("background") || string.endsWith(".foreground") || string.endsWith("Foreground") || string.equals("foreground"))) {
                    valueType = ValueType.COLOR;
                } else if (string.endsWith(".font") || string.endsWith("Font") || string.equals("font")) {
                    valueType = ValueType.FONT;
                } else if (string.endsWith(".border") || string.endsWith("Border") || string.equals("border")) {
                    valueType = ValueType.BORDER;
                } else if (string.endsWith(".icon") || string.endsWith("Icon") || string.equals("icon")) {
                    valueType = ValueType.ICON;
                } else if (string.endsWith(".margin") || string.equals("margin") || string.endsWith(".padding") || string.equals("padding") || string.endsWith("Margins") || string.endsWith("Insets")) {
                    valueType = ValueType.INSETS;
                } else if (string.endsWith("Size")) {
                    valueType = ValueType.DIMENSION;
                } else if (string.endsWith("Width") || string.endsWith("Height")) {
                    valueType = ValueType.INTEGERORFLOAT;
                } else if (string.endsWith("Char")) {
                    valueType = ValueType.CHARACTER;
                } else if (string.endsWith("grayFilter")) {
                    valueType = ValueType.GRAYFILTER;
                }
            }
        }
        valueTypeArray[0] = valueType;
        switch (valueType) {
            case STRING: {
                return string2;
            }
            case BOOLEAN: {
                return UIDefaultsLoader.parseBoolean(string2);
            }
            case CHARACTER: {
                return UIDefaultsLoader.parseCharacter(string2);
            }
            case INTEGER: {
                return UIDefaultsLoader.parseInteger(string2);
            }
            case INTEGERORFLOAT: {
                return UIDefaultsLoader.parseIntegerOrFloat(string2);
            }
            case FLOAT: {
                return UIDefaultsLoader.parseFloat(string2);
            }
            case BORDER: {
                return UIDefaultsLoader.parseBorder(string2, function, list);
            }
            case ICON: {
                return UIDefaultsLoader.parseInstance(string2, function, list);
            }
            case INSETS: {
                return UIDefaultsLoader.parseInsets(string2);
            }
            case DIMENSION: {
                return UIDefaultsLoader.parseDimension(string2);
            }
            case COLOR: {
                return UIDefaultsLoader.parseColorOrFunction(string2, function);
            }
            case FONT: {
                return UIDefaultsLoader.parseFont(string2);
            }
            case SCALEDINTEGER: {
                return UIDefaultsLoader.parseScaledInteger(string2);
            }
            case SCALEDFLOAT: {
                return UIDefaultsLoader.parseScaledFloat(string2);
            }
            case SCALEDINSETS: {
                return UIDefaultsLoader.parseScaledInsets(string2);
            }
            case SCALEDDIMENSION: {
                return UIDefaultsLoader.parseScaledDimension(string2);
            }
            case INSTANCE: {
                return UIDefaultsLoader.parseInstance(string2, function, list);
            }
            case CLASS: {
                return UIDefaultsLoader.parseClass(string2, list);
            }
            case GRAYFILTER: {
                return UIDefaultsLoader.parseGrayFilter(string2);
            }
        }
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            valueTypeArray[0] = ValueType.STRING;
            return string2.substring(1, string2.length() - 1);
        }
        if (string2.startsWith("#") || string2.endsWith(")")) {
            Object object = UIDefaultsLoader.parseColorOrFunction(string2, function);
            valueTypeArray[0] = object != null ? ValueType.COLOR : ValueType.NULL;
            return object;
        }
        char c2 = string2.charAt(0);
        if (c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '+' || c2 == '.') {
            try {
                Integer n3 = UIDefaultsLoader.parseInteger(string2);
                valueTypeArray[0] = ValueType.INTEGER;
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Float f2 = UIDefaultsLoader.parseFloat(string2);
                    valueTypeArray[0] = ValueType.FLOAT;
                    return f2;
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        valueTypeArray[0] = ValueType.STRING;
        return string2;
    }

    private static boolean parseCondition(String string, Function<String, String> function, List<ClassLoader> list) {
        try {
            Object object = UIDefaultsLoader.parseValue("", function.apply(string), null, null, function, list);
            return object != null && !object.equals(false) && !object.equals(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static Object parseBorder(String string, Function<String, String> function, List<ClassLoader> list) throws IllegalArgumentException {
        if (string.indexOf(44) >= 0) {
            List<String> list2 = UIDefaultsLoader.splitFunctionParams(string, ',');
            Insets insets = UIDefaultsLoader.parseInsets(string);
            ColorUIResource colorUIResource = list2.size() >= 5 && !list2.get(4).isEmpty() ? (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply(list2.get(4)), function) : null;
            float f2 = list2.size() >= 6 && !list2.get(5).isEmpty() ? UIDefaultsLoader.parseFloat(list2.get(5)).floatValue() : 1.0f;
            int n2 = list2.size() >= 7 && !list2.get(6).isEmpty() ? UIDefaultsLoader.parseInteger(list2.get(6)) : -1;
            return uIDefaults -> colorUIResource != null || n2 > 0 ? new FlatLineBorder(insets, colorUIResource, f2, n2) : new FlatEmptyBorder(insets);
        }
        return UIDefaultsLoader.parseInstance(string, function, list);
    }

    private static Object parseInstance(String string, Function<String, String> function, List<ClassLoader> list) {
        return uIDefaults -> {
            try {
                if (string.indexOf(44) >= 0) {
                    List<String> list2 = UIDefaultsLoader.splitFunctionParams(string, ',');
                    String string2 = list2.get(0);
                    Class<?> clazz = UIDefaultsLoader.findClass(string2, list);
                    Executable[] executableArray = clazz.getDeclaredConstructors();
                    Object object = UIDefaultsLoader.invokeConstructorOrStaticMethod(executableArray, list2, function);
                    if (object != null) {
                        return object;
                    }
                    LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to instantiate '" + string2 + "': no constructor found for parameters '" + string.substring(string.indexOf(45)) + "'.", null);
                    return null;
                }
                return UIDefaultsLoader.findClass(string, list).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to instantiate '" + string + "'.", exception);
                return null;
            }
        };
    }

    private static Object parseClass(String string, List<ClassLoader> list) {
        return uIDefaults -> {
            try {
                return UIDefaultsLoader.findClass(string, list);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to find class '" + string + "'.", classNotFoundException);
                return null;
            }
        };
    }

    private static Class<?> findClass(String string, List<ClassLoader> list) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (ClassLoader classLoader : list) {
                try {
                    return classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw classNotFoundException;
        }
    }

    private static Insets parseInsets(String string) throws IllegalArgumentException {
        List<String> list = StringUtils.split(string, ',', true, false);
        try {
            return new InsetsUIResource(Integer.parseInt(list.get(0)), Integer.parseInt(list.get(1)), Integer.parseInt(list.get(2)), Integer.parseInt(list.get(3)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid insets '" + string + "'");
        }
    }

    private static Dimension parseDimension(String string) throws IllegalArgumentException {
        List<String> list = StringUtils.split(string, ',', true, false);
        try {
            return new DimensionUIResource(Integer.parseInt(list.get(0)), Integer.parseInt(list.get(1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid size '" + string + "'");
        }
    }

    private static Object parseColorOrFunction(String string, Function<String, String> function) throws IllegalArgumentException {
        if (string.endsWith(")")) {
            return UIDefaultsLoader.parseColorFunctions(string, function);
        }
        return UIDefaultsLoader.parseColor(string);
    }

    static ColorUIResource parseColor(String string) throws IllegalArgumentException {
        int n2 = UIDefaultsLoader.parseColorRGBA(string);
        return (n2 & 0xFF000000) == -16777216 ? new ColorUIResource(n2) : new ColorUIResource(new Color(n2, true));
    }

    static int parseColorRGBA(String string) throws IllegalArgumentException {
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        if (n5 != 4 && n5 != 5 && n5 != 7 && n5 != 9 || string.charAt(0) != '#') {
            throw UIDefaultsLoader.newInvalidColorException(string);
        }
        int n6 = 0;
        for (n4 = 1; n4 < n5; ++n4) {
            n3 = string.charAt(n4);
            if (n3 >= 48 && n3 <= 57) {
                n2 = n3 - 48;
            } else if (n3 >= 97 && n3 <= 102) {
                n2 = n3 - 97 + 10;
            } else if (n3 >= 65 && n3 <= 70) {
                n2 = n3 - 65 + 10;
            } else {
                throw UIDefaultsLoader.newInvalidColorException(string);
            }
            n6 = n6 << 4 | n2;
        }
        if (n5 <= 5) {
            n4 = n6 & 0xF000;
            n3 = n6 & 0xF00;
            n2 = n6 & 0xF0;
            int n7 = n6 & 0xF;
            n6 = n4 << 16 | n4 << 12 | n3 << 12 | n3 << 8 | n2 << 8 | n2 << 4 | n7 << 4 | n7;
        }
        return n5 == 4 || n5 == 7 ? 0xFF000000 | n6 : n6 >> 8 & 0xFFFFFF | (n6 & 0xFF) << 24;
    }

    private static IllegalArgumentException newInvalidColorException(String string) {
        return new IllegalArgumentException("invalid color '" + string + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object parseColorFunctions(String string, Function<String, String> function) throws IllegalArgumentException {
        int n2 = string.indexOf(40);
        if (n2 < 0) {
            throw new IllegalArgumentException("missing opening parenthesis in function '" + string + "'");
        }
        String string2 = StringUtils.substringTrimmed(string, 0, n2);
        List<String> list = UIDefaultsLoader.splitFunctionParams(string.substring(n2 + 1, string.length() - 1), ',');
        if (list.isEmpty()) {
            throw UIDefaultsLoader.newMissingParametersException(string);
        }
        if (parseColorDepth > 100) {
            throw new IllegalArgumentException("endless recursion in color function '" + string + "'");
        }
        ++parseColorDepth;
        try {
            switch (string2) {
                case "if": {
                    Object object = UIDefaultsLoader.parseColorIf(string, list, function);
                    return object;
                }
                case "systemColor": {
                    Object object = UIDefaultsLoader.parseColorSystemColor(string, list, function);
                    return object;
                }
                case "rgb": {
                    ColorUIResource colorUIResource = UIDefaultsLoader.parseColorRgbOrRgba(false, list, function);
                    return colorUIResource;
                }
                case "rgba": {
                    ColorUIResource colorUIResource = UIDefaultsLoader.parseColorRgbOrRgba(true, list, function);
                    return colorUIResource;
                }
                case "hsl": {
                    ColorUIResource colorUIResource = UIDefaultsLoader.parseColorHslOrHsla(false, list);
                    return colorUIResource;
                }
                case "hsla": {
                    ColorUIResource colorUIResource = UIDefaultsLoader.parseColorHslOrHsla(true, list);
                    return colorUIResource;
                }
                case "lighten": {
                    Object object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(2, true, list, function);
                    return object;
                }
                case "darken": {
                    Object object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(2, false, list, function);
                    return object;
                }
                case "saturate": {
                    Object object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(1, true, list, function);
                    return object;
                }
                case "desaturate": {
                    Object object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(1, false, list, function);
                    return object;
                }
                case "fadein": {
                    Object object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(3, true, list, function);
                    return object;
                }
                case "fadeout": {
                    Object object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(3, false, list, function);
                    return object;
                }
                case "fade": {
                    Object object = UIDefaultsLoader.parseColorFade(list, function);
                    return object;
                }
                case "spin": {
                    Object object = UIDefaultsLoader.parseColorSpin(list, function);
                    return object;
                }
                case "changeHue": {
                    Object object = UIDefaultsLoader.parseColorChange(0, list, function);
                    return object;
                }
                case "changeSaturation": {
                    Object object = UIDefaultsLoader.parseColorChange(1, list, function);
                    return object;
                }
                case "changeLightness": {
                    Object object = UIDefaultsLoader.parseColorChange(2, list, function);
                    return object;
                }
                case "changeAlpha": {
                    Object object = UIDefaultsLoader.parseColorChange(3, list, function);
                    return object;
                }
                case "mix": {
                    Object object = UIDefaultsLoader.parseColorMix(null, list, function);
                    return object;
                }
                case "tint": {
                    Object object = UIDefaultsLoader.parseColorMix("#fff", list, function);
                    return object;
                }
                case "shade": {
                    Object object = UIDefaultsLoader.parseColorMix("#000", list, function);
                    return object;
                }
                case "contrast": {
                    Object object = UIDefaultsLoader.parseColorContrast(list, function);
                    return object;
                }
                case "over": {
                    ColorUIResource colorUIResource = UIDefaultsLoader.parseColorOver(list, function);
                    return colorUIResource;
                }
            }
            throw new IllegalArgumentException("unknown color function '" + string + "'");
        }
        finally {
            --parseColorDepth;
        }
    }

    private static Object parseColorIf(String string, List<String> list, Function<String, String> function) throws IllegalArgumentException {
        if (list.size() != 3) {
            throw UIDefaultsLoader.newMissingParametersException(string);
        }
        boolean bl2 = UIDefaultsLoader.parseCondition(list.get(0), function, Collections.emptyList());
        String string2 = list.get(bl2 ? 1 : 2);
        return UIDefaultsLoader.parseColorOrFunction(function.apply(string2), function);
    }

    private static Object parseColorSystemColor(String string, List<String> list, Function<String, String> function) throws IllegalArgumentException {
        String string2;
        if (list.size() < 1) {
            throw UIDefaultsLoader.newMissingParametersException(string);
        }
        ColorUIResource colorUIResource = UIDefaultsLoader.getSystemColor(list.get(0));
        if (colorUIResource != null) {
            return colorUIResource;
        }
        String string3 = string2 = list.size() > 1 ? list.get(1) : "";
        if (string2.equals("null") || string2.isEmpty()) {
            return null;
        }
        return UIDefaultsLoader.parseColorOrFunction(function.apply(string2), function);
    }

    private static ColorUIResource getSystemColor(String string) {
        ColorUIResource colorUIResource;
        Function<String, Color> function = FlatLaf.getSystemColorGetter();
        if (function == null) {
            return null;
        }
        if (systemColorCache != null && systemColorCache.containsKey(string)) {
            return systemColorCache.get(string);
        }
        Color color = function.apply(string);
        ColorUIResource colorUIResource2 = colorUIResource = color != null ? new ColorUIResource(color) : null;
        if (systemColorCache != null) {
            systemColorCache.put(string, colorUIResource);
        }
        return colorUIResource;
    }

    private static ColorUIResource parseColorRgbOrRgba(boolean bl2, List<String> list, Function<String, String> function) throws IllegalArgumentException {
        if (bl2 && list.size() == 2) {
            String string = list.get(0);
            int n2 = UIDefaultsLoader.parseInteger(list.get(1), 0, 255, true);
            ColorUIResource colorUIResource = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply(string), function);
            return new ColorUIResource(new Color((n2 & 0xFF) << 24 | colorUIResource.getRGB() & 0xFFFFFF, true));
        }
        int n3 = UIDefaultsLoader.parseInteger(list.get(0), 0, 255, true);
        int n4 = UIDefaultsLoader.parseInteger(list.get(1), 0, 255, true);
        int n5 = UIDefaultsLoader.parseInteger(list.get(2), 0, 255, true);
        int n6 = bl2 ? UIDefaultsLoader.parseInteger(list.get(3), 0, 255, true) : 255;
        return bl2 ? new ColorUIResource(new Color(n3, n4, n5, n6)) : new ColorUIResource(n3, n4, n5);
    }

    private static ColorUIResource parseColorHslOrHsla(boolean bl2, List<String> list) throws IllegalArgumentException {
        int n2 = UIDefaultsLoader.parseInteger(list.get(0), 0, 360, false);
        int n3 = UIDefaultsLoader.parsePercentage(list.get(1));
        int n4 = UIDefaultsLoader.parsePercentage(list.get(2));
        int n5 = bl2 ? UIDefaultsLoader.parsePercentage(list.get(3)) : 100;
        float[] fArray = new float[]{n2, n3, n4};
        return new ColorUIResource(HSLColor.toRGB(fArray, (float)n5 / 100.0f));
    }

    private static Object parseColorHSLIncreaseDecrease(int n2, boolean bl2, List<String> list, Function<String, String> function) throws IllegalArgumentException {
        Object object;
        String string = list.get(0);
        int n3 = UIDefaultsLoader.parsePercentage(list.get(1));
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (list.size() > 2) {
            object = list.get(2);
            bl3 = ((String)object).contains("relative");
            bl4 = ((String)object).contains("autoInverse");
            bl5 = ((String)object).contains("lazy");
            bl6 = ((String)object).contains("derived");
            if (bl6 && !((String)object).contains("noAutoInverse")) {
                bl4 = true;
            }
        }
        object = new ColorFunctions.HSLIncreaseDecrease(n2, bl2, n3, bl3, bl4);
        if (bl5) {
            return arg_0 -> UIDefaultsLoader.lambda$parseColorHSLIncreaseDecrease$7(string, (ColorFunctions.ColorFunction)object, arg_0);
        }
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl6, function);
    }

    private static Object parseColorFade(List<String> list, Function<String, String> function) throws IllegalArgumentException {
        Object object;
        String string = list.get(0);
        int n2 = UIDefaultsLoader.parsePercentage(list.get(1));
        boolean bl2 = false;
        boolean bl3 = false;
        if (list.size() > 2) {
            object = list.get(2);
            bl2 = ((String)object).contains("derived");
            bl3 = ((String)object).contains("lazy");
        }
        object = new ColorFunctions.Fade(n2);
        if (bl3) {
            return arg_0 -> UIDefaultsLoader.lambda$parseColorFade$8(string, (ColorFunctions.ColorFunction)object, arg_0);
        }
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl2, function);
    }

    private static Object parseColorSpin(List<String> list, Function<String, String> function) throws IllegalArgumentException {
        Object object;
        String string = list.get(0);
        int n2 = UIDefaultsLoader.parseInteger(list.get(1));
        boolean bl2 = false;
        if (list.size() > 2) {
            object = list.get(2);
            bl2 = ((String)object).contains("derived");
        }
        object = new ColorFunctions.HSLIncreaseDecrease(0, true, n2, false, false);
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl2, function);
    }

    private static Object parseColorChange(int n2, List<String> list, Function<String, String> function) throws IllegalArgumentException {
        Object object;
        String string = list.get(0);
        int n3 = n2 == 0 ? UIDefaultsLoader.parseInteger(list.get(1)) : UIDefaultsLoader.parsePercentage(list.get(1));
        boolean bl2 = false;
        if (list.size() > 2) {
            object = list.get(2);
            bl2 = ((String)object).contains("derived");
        }
        object = new ColorFunctions.HSLChange(n2, n3);
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl2, function);
    }

    private static Object parseColorMix(String string, List<String> list, Function<String, String> function) throws IllegalArgumentException {
        int n2 = 0;
        if (string == null) {
            string = list.get(n2++);
        }
        String string2 = list.get(n2++);
        int n3 = list.size() > n2 ? UIDefaultsLoader.parsePercentage(list.get(n2)) : 50;
        ColorUIResource colorUIResource = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply(string2), function);
        if (colorUIResource == null) {
            return null;
        }
        ColorFunctions.Mix mix = new ColorFunctions.Mix(colorUIResource, n3);
        return UIDefaultsLoader.parseFunctionBaseColor(string, mix, false, function);
    }

    private static Object parseColorContrast(List<String> list, Function<String, String> function) throws IllegalArgumentException {
        String string = list.get(0);
        String string2 = list.get(1);
        String string3 = list.get(2);
        int n2 = list.size() > 3 ? UIDefaultsLoader.parsePercentage(list.get(3)) : 43;
        ColorUIResource colorUIResource = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply(string), function);
        if (colorUIResource == null) {
            return null;
        }
        String string4 = ColorFunctions.luma(colorUIResource) * 100.0f < (float)n2 ? string3 : string2;
        return UIDefaultsLoader.parseColorOrFunction(function.apply(string4), function);
    }

    private static ColorUIResource parseColorOver(List<String> list, Function<String, String> function) throws IllegalArgumentException {
        String string = list.get(0);
        String string2 = list.get(1);
        ColorUIResource colorUIResource = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply(string), function);
        if (colorUIResource == null || colorUIResource.getAlpha() == 255) {
            return colorUIResource;
        }
        ColorUIResource colorUIResource2 = new ColorUIResource(colorUIResource.getRGB());
        ColorUIResource colorUIResource3 = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply(string2), function);
        if (colorUIResource3 == null) {
            return colorUIResource2;
        }
        float f2 = (float)colorUIResource.getAlpha() / 255.0f;
        return new ColorUIResource(ColorFunctions.mix(colorUIResource2, colorUIResource3, f2));
    }

    private static Object parseFunctionBaseColor(String string, ColorFunctions.ColorFunction colorFunction, boolean bl2, Function<String, String> function) throws IllegalArgumentException {
        String string2 = function.apply(string);
        ColorUIResource colorUIResource = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(string2, function);
        if (colorUIResource == null) {
            return null;
        }
        Color color = ColorFunctions.applyFunctions(colorUIResource, colorFunction);
        if (bl2) {
            ColorFunctions.ColorFunction[] colorFunctionArray;
            if (colorUIResource instanceof DerivedColor && string2 == string) {
                ColorFunctions.ColorFunction[] colorFunctionArray2 = ((DerivedColor)colorUIResource).getFunctions();
                colorFunctionArray = new ColorFunctions.ColorFunction[colorFunctionArray2.length + 1];
                System.arraycopy(colorFunctionArray2, 0, colorFunctionArray, 0, colorFunctionArray2.length);
                colorFunctionArray[colorFunctionArray2.length] = colorFunction;
            } else {
                colorFunctionArray = new ColorFunctions.ColorFunction[]{colorFunction};
            }
            return new DerivedColor(color, colorFunctionArray);
        }
        return new ColorUIResource(color);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object parseFont(String string) throws IllegalArgumentException {
        Object object = fontCache.get(string);
        if (object != null) {
            return object;
        }
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        float f2 = 0.0f;
        List<String> list = null;
        String string2 = null;
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        try {
            block20: while (streamTokenizer.nextToken() != -1) {
                String string3;
                switch (string3 = streamTokenizer.sval) {
                    case "normal": {
                        n2 = 0;
                        continue block20;
                    }
                    case "bold": {
                        if (n2 == -1) {
                            n2 = 0;
                        }
                        n2 |= 1;
                        continue block20;
                    }
                    case "italic": {
                        if (n2 == -1) {
                            n2 = 0;
                        }
                        n2 |= 2;
                        continue block20;
                    }
                    case "+bold": {
                        n3 |= 1;
                        continue block20;
                    }
                    case "-bold": {
                        n3 |= 0x10000;
                        continue block20;
                    }
                    case "+italic": {
                        n3 |= 2;
                        continue block20;
                    }
                    case "-italic": {
                        n3 |= 0x20000;
                        continue block20;
                    }
                }
                char c2 = string3.charAt(0);
                if (Character.isDigit(c2) || c2 == '+' || c2 == '-') {
                    if (n4 != 0 || n5 != 0 || f2 != 0.0f) {
                        throw new IllegalArgumentException("size specified more than once in '" + string + "'");
                    }
                    if (c2 == '+' || c2 == '-') {
                        n5 = UIDefaultsLoader.parseInteger(string3);
                        continue;
                    }
                    if (string3.endsWith("%")) {
                        f2 = (float)UIDefaultsLoader.parseInteger(string3.substring(0, string3.length() - 1)).intValue() / 100.0f;
                        continue;
                    }
                    n4 = UIDefaultsLoader.parseInteger(string3);
                    continue;
                }
                if (c2 == '$') {
                    if (string2 != null) {
                        throw new IllegalArgumentException("baseFontKey specified more than once in '" + string + "'");
                    }
                    string2 = string3.substring(1);
                    continue;
                }
                if (list == null) {
                    list = Collections.singletonList(string3);
                    continue;
                }
                if (list.size() == 1) {
                    list = new ArrayList<String>(list);
                }
                list.add(string3);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        if (n2 != -1 && n3 != 0) {
            throw new IllegalArgumentException("can not mix absolute style (e.g. 'bold') with derived style (e.g. '+italic') in '" + string + "'");
        }
        if (n3 != 0) {
            if (n3 & true && (n3 & 0x10000) != 0) {
                throw new IllegalArgumentException("can not use '+bold' and '-bold' in '" + string + "'");
            }
            if ((n3 & 2) != 0 && (n3 & 0x20000) != 0) {
                throw new IllegalArgumentException("can not use '+italic' and '-italic' in '" + string + "'");
            }
        }
        object = new FlatLaf.ActiveFont(string2, list, n2, n3, n4, n5, f2);
        fontCache.put(string, object);
        return object;
    }

    private static int parsePercentage(String string) throws IllegalArgumentException, NumberFormatException {
        int n2;
        if (!string.endsWith("%")) {
            throw new NumberFormatException("invalid percentage '" + string + "'");
        }
        try {
            n2 = Integer.parseInt(string.substring(0, string.length() - 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("invalid percentage '" + string + "'");
        }
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("percentage out of range (0-100%) '" + string + "'");
        }
        return n2;
    }

    private static Boolean parseBoolean(String string) throws IllegalArgumentException {
        switch (string) {
            case "false": {
                return false;
            }
            case "true": {
                return true;
            }
        }
        throw new IllegalArgumentException("invalid boolean '" + string + "'");
    }

    private static Character parseCharacter(String string) throws IllegalArgumentException {
        if (string.length() != 1) {
            throw new IllegalArgumentException("invalid character '" + string + "'");
        }
        return Character.valueOf(string.charAt(0));
    }

    private static Integer parseInteger(String string, int n2, int n3, boolean bl2) throws IllegalArgumentException, NumberFormatException {
        if (bl2 && string.endsWith("%")) {
            int n4 = UIDefaultsLoader.parsePercentage(string);
            return n3 * n4 / 100;
        }
        Integer n5 = UIDefaultsLoader.parseInteger(string);
        if (n5 < n2 || n5 > n3) {
            throw new NumberFormatException("integer '" + string + "' out of range (" + n2 + '-' + n3 + ')');
        }
        return n5;
    }

    private static Integer parseInteger(String string) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("invalid integer '" + string + "'");
        }
    }

    private static Number parseIntegerOrFloat(String string) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException2) {
                throw new NumberFormatException("invalid integer or float '" + string + "'");
            }
        }
    }

    private static Float parseFloat(String string) throws NumberFormatException {
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("invalid float '" + string + "'");
        }
    }

    private static UIDefaults.ActiveValue parseScaledInteger(String string) throws NumberFormatException {
        int n2 = UIDefaultsLoader.parseInteger(string);
        return uIDefaults -> UIScale.scale(n2);
    }

    private static UIDefaults.ActiveValue parseScaledFloat(String string) throws NumberFormatException {
        float f2 = UIDefaultsLoader.parseFloat(string).floatValue();
        return uIDefaults -> Float.valueOf(UIScale.scale(f2));
    }

    private static UIDefaults.ActiveValue parseScaledInsets(String string) throws IllegalArgumentException {
        Insets insets = UIDefaultsLoader.parseInsets(string);
        return uIDefaults -> UIScale.scale(insets);
    }

    private static UIDefaults.ActiveValue parseScaledDimension(String string) throws IllegalArgumentException {
        Dimension dimension = UIDefaultsLoader.parseDimension(string);
        return uIDefaults -> UIScale.scale(dimension);
    }

    private static Object parseGrayFilter(String string) throws IllegalArgumentException {
        List<String> list = StringUtils.split(string, ',', true, false);
        try {
            int n2 = Integer.parseInt(list.get(0));
            int n3 = Integer.parseInt(list.get(1));
            int n4 = Integer.parseInt(list.get(2));
            return uIDefaults -> new GrayFilter(n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid gray filter '" + string + "'");
        }
    }

    private static List<String> splitFunctionParams(String string, char c2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == '(') {
                ++n2;
                continue;
            }
            if (c3 == ')') {
                --n2;
                continue;
            }
            if (n2 != 0 || c3 != c2) continue;
            arrayList.add(StringUtils.substringTrimmed(string, n3, i2));
            n3 = i2 + 1;
        }
        String string2 = StringUtils.substringTrimmed(string, n3);
        if (!string2.isEmpty() || !arrayList.isEmpty()) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static Object invokeConstructorOrStaticMethod(Executable[] executableArray, List<String> list, Function<String, String> function) throws Exception {
        executableArray = (Executable[])executableArray.clone();
        Arrays.sort(executableArray, (executable, executable2) -> {
            Class<?>[] classArray;
            Class<?>[] classArray2 = executable.getParameterTypes();
            if (classArray2.length != (classArray = executable2.getParameterTypes()).length) {
                return classArray2.length - classArray.length;
            }
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                Class<?> clazz = classArray2[i2];
                Class<?> clazz2 = classArray[i2];
                if (clazz == clazz2) continue;
                if (clazz == String.class) {
                    return 2;
                }
                if (clazz2 == String.class) {
                    return -2;
                }
                if (clazz == Integer.TYPE) {
                    return -1;
                }
                if (clazz2 != Integer.TYPE) continue;
                return 1;
            }
            return 0;
        });
        for (Executable executable3 : executableArray) {
            Object[] objectArray;
            if (executable3.getParameterCount() != list.size() - 1 || (objectArray = UIDefaultsLoader.parseMethodParams(executable3.getParameterTypes(), list, function)) == null) continue;
            if (executable3 instanceof Constructor) {
                return ((Constructor)executable3).newInstance(objectArray);
            }
            return ((Method)executable3).invoke(null, objectArray);
        }
        return null;
    }

    private static Object[] parseMethodParams(Class<?>[] classArray, List<String> list, Function<String, String> function) {
        Object[] objectArray = new Object[classArray.length];
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Class<?> clazz = classArray[i2];
                String string = list.get(i2 + 1);
                if (clazz == String.class) {
                    objectArray[i2] = string;
                    continue;
                }
                if (clazz == Boolean.TYPE) {
                    objectArray[i2] = UIDefaultsLoader.parseBoolean(string);
                    continue;
                }
                if (clazz == Integer.TYPE) {
                    objectArray[i2] = UIDefaultsLoader.parseInteger(string);
                    continue;
                }
                if (clazz == Float.TYPE) {
                    objectArray[i2] = UIDefaultsLoader.parseFloat(string);
                    continue;
                }
                if (clazz == Color.class) {
                    objectArray[i2] = UIDefaultsLoader.parseColorOrFunction(function.apply(string), function);
                    continue;
                }
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return objectArray;
    }

    static Object lazyUIManagerGet(String string) {
        Object object;
        boolean bl2 = false;
        if (string.startsWith(OPTIONAL_PREFIX)) {
            string = string.substring(OPTIONAL_PREFIX.length());
            bl2 = true;
        }
        if ((object = UIManager.get(string)) == null && !bl2) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: '" + string + "' not found in UI defaults.", null);
        }
        return object;
    }

    private static IllegalArgumentException newMissingParametersException(String string) {
        return new IllegalArgumentException("missing parameters in function '" + string + "'");
    }

    private static /* synthetic */ Object lambda$parseColorFade$8(String string, ColorFunctions.ColorFunction colorFunction, UIDefaults uIDefaults) {
        Object object = UIDefaultsLoader.lazyUIManagerGet(string);
        return object instanceof Color ? new ColorUIResource(ColorFunctions.applyFunctions((Color)object, colorFunction)) : null;
    }

    private static /* synthetic */ Object lambda$parseColorHSLIncreaseDecrease$7(String string, ColorFunctions.ColorFunction colorFunction, UIDefaults uIDefaults) {
        Object object = UIDefaultsLoader.lazyUIManagerGet(string);
        return object instanceof Color ? new ColorUIResource(ColorFunctions.applyFunctions((Color)object, colorFunction)) : null;
    }

    static {
        fontCache = new SoftCache();
        tempResultValueType = new ValueType[1];
    }

    static enum ValueType {
        UNKNOWN,
        STRING,
        BOOLEAN,
        CHARACTER,
        INTEGER,
        INTEGERORFLOAT,
        FLOAT,
        BORDER,
        ICON,
        INSETS,
        DIMENSION,
        COLOR,
        FONT,
        SCALEDINTEGER,
        SCALEDFLOAT,
        SCALEDINSETS,
        SCALEDDIMENSION,
        INSTANCE,
        CLASS,
        GRAYFILTER,
        NULL,
        LAZY;

    }
}

