/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.Animator;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.VolatileImage;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;

public class FlatAnimatedLafChange {
    public static int duration = 160;
    public static int resolution = 30;
    private static Animator animator;
    private static final Map<JLayeredPane, JComponent> oldUIsnapshots;
    private static final Map<JLayeredPane, JComponent> newUIsnapshots;
    private static float alpha;
    private static boolean inShowSnapshot;

    public static void showSnapshot() {
        if (!FlatSystemProperties.getBoolean("flatlaf.animatedLafChange", true)) {
            return;
        }
        if (animator != null) {
            animator.stop();
        }
        alpha = 1.0f;
        FlatAnimatedLafChange.showSnapshot(true, oldUIsnapshots);
    }

    private static void showSnapshot(final boolean bl2, Map<JLayeredPane, JComponent> map) {
        Window[] windowArray;
        inShowSnapshot = true;
        for (Window window : windowArray = Window.getWindows()) {
            VolatileImage volatileImage;
            if (!(window instanceof RootPaneContainer) || !window.isShowing() || (volatileImage = window.createVolatileImage(window.getWidth(), window.getHeight())) == null) continue;
            JLayeredPane jLayeredPane = ((RootPaneContainer)((Object)window)).getLayeredPane();
            jLayeredPane.paint(volatileImage.getGraphics());
            JComponent jComponent = new JComponent(){

                @Override
                public void paint(Graphics graphics) {
                    if (inShowSnapshot || volatileImage.contentsLost()) {
                        return;
                    }
                    if (bl2) {
                        ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, alpha));
                    }
                    graphics.drawImage(volatileImage, 0, 0, null);
                }

                @Override
                public void removeNotify() {
                    super.removeNotify();
                    volatileImage.flush();
                }
            };
            if (!bl2) {
                jComponent.setOpaque(true);
            }
            jComponent.setSize(jLayeredPane.getSize());
            jLayeredPane.add((Component)jComponent, (Object)(JLayeredPane.DRAG_LAYER + (bl2 ? 2 : 1)));
            map.put(jLayeredPane, jComponent);
        }
        inShowSnapshot = false;
    }

    public static void hideSnapshotWithAnimation() {
        if (!FlatSystemProperties.getBoolean("flatlaf.animatedLafChange", true)) {
            return;
        }
        if (oldUIsnapshots.isEmpty()) {
            return;
        }
        FlatAnimatedLafChange.showSnapshot(false, newUIsnapshots);
        animator = new Animator(duration, f2 -> {
            if ((double)f2 < 0.1 || (double)f2 > 0.9) {
                return;
            }
            alpha = 1.0f - f2;
            for (Map.Entry<JLayeredPane, JComponent> entry : oldUIsnapshots.entrySet()) {
                if (!entry.getKey().isShowing()) continue;
                entry.getValue().repaint();
            }
            Toolkit.getDefaultToolkit().sync();
        }, () -> {
            FlatAnimatedLafChange.hideSnapshot();
            animator = null;
        });
        animator.setResolution(resolution);
        animator.start();
    }

    private static void hideSnapshot() {
        FlatAnimatedLafChange.hideSnapshot(oldUIsnapshots);
        FlatAnimatedLafChange.hideSnapshot(newUIsnapshots);
    }

    private static void hideSnapshot(Map<JLayeredPane, JComponent> map) {
        for (Map.Entry<JLayeredPane, JComponent> entry : map.entrySet()) {
            entry.getKey().remove(entry.getValue());
            entry.getKey().repaint();
        }
        map.clear();
    }

    public static void stop() {
        if (animator != null) {
            animator.stop();
        } else {
            FlatAnimatedLafChange.hideSnapshot();
        }
    }

    static {
        oldUIsnapshots = new WeakHashMap<JLayeredPane, JComponent>();
        newUIsnapshots = new WeakHashMap<JLayeredPane, JComponent>();
    }
}

