/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Consumer;

public class FlatDesktop {
    public static boolean isSupported(Action action) {
        if (SystemInfo.isJava_9_orLater) {
            try {
                return Desktop.getDesktop().isSupported(Enum.valueOf(Desktop.Action.class, action.name()));
            }
            catch (Exception exception) {
                LoggingFacade.INSTANCE.logSevere(null, exception);
                return false;
            }
        }
        return SystemInfo.isMacOS;
    }

    public static void setAboutHandler(Runnable runnable) {
        String string;
        if (!FlatDesktop.isSupported(Action.APP_ABOUT)) {
            return;
        }
        if (SystemInfo.isJava_9_orLater) {
            string = "java.awt.desktop.AboutHandler";
        } else if (SystemInfo.isMacOS) {
            string = "com.apple.eawt.AboutHandler";
        } else {
            return;
        }
        FlatDesktop.setHandler("setAboutHandler", string, runnable);
    }

    public static void setPreferencesHandler(Runnable runnable) {
        String string;
        if (!FlatDesktop.isSupported(Action.APP_PREFERENCES)) {
            return;
        }
        if (SystemInfo.isJava_9_orLater) {
            string = "java.awt.desktop.PreferencesHandler";
        } else if (SystemInfo.isMacOS) {
            string = "com.apple.eawt.PreferencesHandler";
        } else {
            return;
        }
        FlatDesktop.setHandler("setPreferencesHandler", string, runnable);
    }

    private static void setHandler(String string, String string2, Runnable runnable) {
        try {
            Object object2 = FlatDesktop.getDesktopOrApplication();
            Class<?> clazz = Class.forName(string2);
            Method method2 = object2.getClass().getMethod(string, clazz);
            method2.invoke(object2, Proxy.newProxyInstance(FlatDesktop.class.getClassLoader(), new Class[]{clazz}, (object, method, objectArray) -> {
                EventQueue.invokeLater(() -> runnable.run());
                return null;
            }));
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(null, exception);
        }
    }

    public static void setQuitHandler(Consumer<QuitResponse> consumer) {
        String string;
        if (!FlatDesktop.isSupported(Action.APP_QUIT_HANDLER)) {
            return;
        }
        if (SystemInfo.isJava_9_orLater) {
            string = "java.awt.desktop.QuitHandler";
        } else if (SystemInfo.isMacOS) {
            string = "com.apple.eawt.QuitHandler";
        } else {
            return;
        }
        try {
            Object object2 = FlatDesktop.getDesktopOrApplication();
            Class<?> clazz = Class.forName(string);
            Method method2 = object2.getClass().getMethod("setQuitHandler", clazz);
            method2.invoke(object2, Proxy.newProxyInstance(FlatDesktop.class.getClassLoader(), new Class[]{clazz}, (object, method, objectArray) -> {
                final Object object2 = objectArray[1];
                final String string = SystemInfo.isJava_9_orLater ? "java.awt.desktop.QuitResponse" : "com.apple.eawt.QuitResponse";
                consumer.accept(new QuitResponse(){

                    @Override
                    public void performQuit() {
                        try {
                            Class.forName(string).getMethod("performQuit", new Class[0]).invoke(object2, new Object[0]);
                        }
                        catch (Exception exception) {
                            LoggingFacade.INSTANCE.logSevere(null, exception);
                        }
                    }

                    @Override
                    public void cancelQuit() {
                        try {
                            Class.forName(string).getMethod("cancelQuit", new Class[0]).invoke(object2, new Object[0]);
                        }
                        catch (Exception exception) {
                            LoggingFacade.INSTANCE.logSevere(null, exception);
                        }
                    }
                });
                return null;
            }));
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(null, exception);
        }
    }

    private static Object getDesktopOrApplication() throws Exception {
        if (SystemInfo.isJava_9_orLater) {
            return Desktop.getDesktop();
        }
        if (SystemInfo.isMacOS) {
            try {
                Class<?> clazz = Class.forName("com.apple.eawt.Application");
                return clazz.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                LoggingFacade.INSTANCE.logSevere(null, exception);
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static interface QuitResponse {
        public void performQuit();

        public void cancelQuit();
    }

    public static enum Action {
        APP_ABOUT,
        APP_PREFERENCES,
        APP_QUIT_HANDLER;

    }
}

