/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class FlatInspector {
    private static final Integer HIGHLIGHT_LAYER = JLayeredPane.POPUP_LAYER - 1;
    private static final int KEY_MODIFIERS_MASK = 960;
    private final JRootPane rootPane;
    private final MouseMotionListener mouseMotionListener;
    private final AWTEventListener keyListener;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final WindowListener windowListener;
    private Window window;
    private boolean enabled;
    private Object oldGlassPaneFullHeight;
    private Component lastComponent;
    private int lastX;
    private int lastY;
    private int inspectParentLevel;
    private boolean wasModifierKeyPressed;
    private boolean showClassHierarchy;
    private long lastWhen;
    private JComponent highlightFigure;
    private Popup popup;

    public static void install(String string) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEvent -> {
            if (aWTEvent.getID() == 402 && ((KeyEvent)aWTEvent).getKeyCode() == keyStroke.getKeyCode() && (((KeyEvent)aWTEvent).getModifiersEx() & 0x3C0) == (keyStroke.getModifiers() & 0x3C0)) {
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                RootPaneContainer rootPaneContainer = null;
                if (window instanceof RootPaneContainer) {
                    rootPaneContainer = (RootPaneContainer)((Object)window);
                } else {
                    for (Component component : window.getComponents()) {
                        if (!(component instanceof RootPaneContainer)) continue;
                        rootPaneContainer = (RootPaneContainer)((Object)component);
                        break;
                    }
                }
                if (rootPaneContainer != null) {
                    JRootPane jRootPane = rootPaneContainer.getRootPane();
                    FlatInspector flatInspector = (FlatInspector)jRootPane.getClientProperty(FlatInspector.class);
                    if (flatInspector == null) {
                        flatInspector = new FlatInspector(jRootPane);
                        jRootPane.putClientProperty(FlatInspector.class, flatInspector);
                        flatInspector.setEnabled(true);
                    } else {
                        flatInspector.setEnabled(false);
                        jRootPane.putClientProperty(FlatInspector.class, null);
                    }
                }
            }
        }, 8L);
    }

    public FlatInspector(JRootPane jRootPane) {
        this.rootPane = jRootPane;
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                FlatInspector.this.lastX = mouseEvent.getX();
                FlatInspector.this.lastY = mouseEvent.getY();
                FlatInspector.this.inspect(FlatInspector.this.lastX, FlatInspector.this.lastY);
            }
        };
        this.keyListener = aWTEvent -> {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            int n2 = keyEvent.getKeyCode();
            int n3 = aWTEvent.getID();
            if (n3 == 401) {
                if (n2 == 17 || n2 == 16 || n2 == 18) {
                    this.wasModifierKeyPressed = true;
                }
            } else if (n3 == 402 && this.wasModifierKeyPressed) {
                int n4;
                if (keyEvent.getWhen() - this.lastWhen <= 5L) {
                    return;
                }
                this.lastWhen = keyEvent.getWhen();
                if (n2 == 17) {
                    ++this.inspectParentLevel;
                    n4 = this.inspect(this.lastX, this.lastY);
                    if (this.inspectParentLevel > n4) {
                        this.inspectParentLevel = n4;
                    }
                } else if (n2 == 16 && this.inspectParentLevel > 0) {
                    --this.inspectParentLevel;
                    n4 = this.inspect(this.lastX, this.lastY);
                    if (this.inspectParentLevel > n4) {
                        this.inspectParentLevel = Math.max(n4 - 1, 0);
                        this.inspect(this.lastX, this.lastY);
                    }
                } else if (n2 == 18 && this.lastComponent != null) {
                    this.showClassHierarchy = !this.showClassHierarchy;
                    this.showToolTip(this.lastComponent, this.lastX, this.lastY, this.inspectParentLevel);
                }
            }
            if (n2 == 27) {
                keyEvent.consume();
                if (n3 == 401) {
                    this.setEnabled(false);
                    FlatInspector flatInspector = (FlatInspector)jRootPane.getClientProperty(FlatInspector.class);
                    if (flatInspector == this) {
                        jRootPane.putClientProperty(FlatInspector.class, null);
                    }
                }
            }
        };
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                FlatInspector.this.update();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                FlatInspector.this.hidePopup();
            }
        };
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        if (this.enabled == bl2) {
            return;
        }
        this.enabled = bl2;
        if (bl2) {
            this.oldGlassPaneFullHeight = this.rootPane.getClientProperty("JRootPane.glassPaneFullHeight");
            this.rootPane.putClientProperty("JRootPane.glassPaneFullHeight", true);
            this.rootPane.validate();
        } else {
            this.rootPane.putClientProperty("JRootPane.glassPaneFullHeight", this.oldGlassPaneFullHeight);
        }
        ((JComponent)this.rootPane.getGlassPane()).setOpaque(false);
        this.rootPane.getGlassPane().setVisible(bl2);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (bl2) {
            toolkit.addAWTEventListener(this.keyListener, 8L);
        } else {
            toolkit.removeAWTEventListener(this.keyListener);
        }
        if (bl2) {
            this.rootPane.getGlassPane().addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.rootPane.getGlassPane().removeMouseMotionListener(this.mouseMotionListener);
        }
        if (bl2) {
            this.window = SwingUtilities.windowForComponent(this.rootPane);
            if (this.window != null) {
                this.window.addWindowListener(this.windowListener);
            }
        } else if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window = null;
        }
        if (bl2) {
            Point point = new Point(MouseInfo.getPointerInfo().getLocation());
            SwingUtilities.convertPointFromScreen(point, this.rootPane);
            this.lastX = point.x;
            this.lastY = point.y;
            this.inspect(this.lastX, this.lastY);
        } else {
            this.lastComponent = null;
            this.inspectParentLevel = 0;
            if (this.highlightFigure != null) {
                this.highlightFigure.getParent().remove(this.highlightFigure);
            }
            this.highlightFigure = null;
            this.hidePopup();
        }
        this.propertyChangeSupport.firePropertyChange("enabled", !bl2, bl2);
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void update() {
        if (!this.rootPane.getGlassPane().isVisible()) {
            return;
        }
        EventQueue.invokeLater(() -> {
            this.setEnabled(false);
            this.setEnabled(true);
            this.inspect(this.lastX, this.lastY);
        });
    }

    private int inspect(int n2, int n3) {
        Container container;
        Point point = SwingUtilities.convertPoint(this.rootPane.getGlassPane(), n2, n3, this.rootPane);
        Component component = this.getDeepestComponentAt(this.rootPane, point.x, point.y);
        int n4 = 0;
        for (int i2 = 0; i2 < this.inspectParentLevel && component != null && (container = component.getParent()) != null; ++i2) {
            component = container;
            ++n4;
        }
        if (component == this.lastComponent) {
            return n4;
        }
        this.lastComponent = component;
        this.highlight(component);
        this.showToolTip(component, n2, n3, n4);
        return n4;
    }

    private Component getDeepestComponentAt(Component component, int n2, int n3) {
        if (!component.contains(n2, n3)) {
            return null;
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                Component component3;
                if (component2 == null || !component2.isVisible()) continue;
                int n4 = n2 - component2.getX();
                int n5 = n3 - component2.getY();
                Component component4 = component3 = component2 instanceof Container ? this.getDeepestComponentAt(component2, n4, n5) : component2.getComponentAt(n4, n5);
                if (component3 == null || !component3.isVisible() || component3 == this.highlightFigure || component3.getParent() instanceof JRootPane && component3 == ((JRootPane)component3.getParent()).getGlassPane() || "com.formdev.flatlaf.ui.FlatWindowResizer".equals(component3.getClass().getName())) continue;
                return component3;
            }
        }
        return component;
    }

    private void highlight(Component component) {
        if (this.highlightFigure == null) {
            this.highlightFigure = this.createHighlightFigure();
            this.rootPane.getLayeredPane().add((Component)this.highlightFigure, HIGHLIGHT_LAYER);
        }
        this.highlightFigure.setVisible(component != null);
        if (component != null) {
            Insets insets = this.rootPane.getInsets();
            this.highlightFigure.setBounds(new Rectangle(SwingUtilities.convertPoint(component, -insets.left, -insets.top, this.rootPane), component.getSize()));
        }
    }

    private JComponent createHighlightFigure() {
        JComponent jComponent = new JComponent(){

            @Override
            protected void paintComponent(Graphics graphics) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            @Override
            protected void paintBorder(Graphics graphics) {
                Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
                super.paintBorder(graphics);
                FlatUIUtils.resetRenderingHints(graphics, objectArray);
            }
        };
        jComponent.setBackground(new Color(255, 0, 0, 32));
        jComponent.setBorder(new LineBorder(Color.red));
        return jComponent;
    }

    private void showToolTip(Component component, int n2, int n3, int n4) {
        this.hidePopup();
        if (component == null || this.window != null && !this.window.isActive()) {
            return;
        }
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(FlatInspector.buildToolTipText(component, n4, this.showClassHierarchy));
        jToolTip.putClientProperty("Popup.forceHeavyWeight", true);
        Point point = new Point(n2, n3);
        SwingUtilities.convertPointToScreen(point, this.rootPane.getGlassPane());
        int n5 = point.x + UIScale.scale(8);
        int n6 = point.y + UIScale.scale(16);
        Dimension dimension = jToolTip.getPreferredSize();
        Rectangle rectangle = this.rootPane.getGraphicsConfiguration().getBounds();
        if (n5 + dimension.width > rectangle.x + rectangle.width) {
            n5 -= dimension.width + UIScale.scale(16);
        }
        if (n6 + dimension.height > rectangle.y + rectangle.height) {
            n6 -= dimension.height + UIScale.scale(32);
        }
        if (n5 < rectangle.x) {
            n5 = rectangle.x;
        }
        if (n6 < rectangle.y) {
            n6 = rectangle.y;
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(component, jToolTip, n5, n6);
        this.popup.show();
    }

    private static String buildToolTipText(Component component, int n2, boolean bl2) {
        Object object;
        Cloneable cloneable;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder(1500);
        stringBuilder.append("<html><style>");
        stringBuilder.append("td { padding: 0 10 0 0; }");
        stringBuilder.append("</style><table>");
        FlatInspector.appendRow(stringBuilder, "Class", FlatInspector.toString(component.getClass(), bl2));
        FlatInspector.appendRow(stringBuilder, "Size", component.getWidth() + ", " + component.getHeight() + "&nbsp;&nbsp; @ " + component.getX() + ", " + component.getY());
        if (component instanceof Container) {
            FlatInspector.appendRow(stringBuilder, "Insets", FlatInspector.toString(((Container)component).getInsets()));
        }
        Insets insets = null;
        if (component instanceof AbstractButton) {
            insets = ((AbstractButton)component).getMargin();
        } else if (component instanceof JTextComponent) {
            insets = ((JTextComponent)component).getMargin();
        } else if (component instanceof JMenuBar) {
            insets = ((JMenuBar)component).getMargin();
        } else if (component instanceof JToolBar) {
            insets = ((JToolBar)component).getMargin();
        }
        if (insets != null) {
            FlatInspector.appendRow(stringBuilder, "Margin", FlatInspector.toString(insets));
        }
        if (component instanceof JComponent) {
            object2 = ((JComponent)component).getClientProperty(MigLayoutVisualPadding.VISUAL_PADDING_PROPERTY);
            Cloneable cloneable2 = object2 instanceof int[] ? new Insets(((int[])object2)[0], ((int[])object2)[1], ((int[])object2)[2], ((int[])object2)[3]) : (cloneable = object2 instanceof Insets ? (Insets)object2 : null);
            if (cloneable != null) {
                FlatInspector.appendRow(stringBuilder, "Mig visual padding", FlatInspector.toString((Insets)cloneable));
            }
        }
        object2 = component.getPreferredSize();
        cloneable = component.getMinimumSize();
        Dimension dimension = component.getMaximumSize();
        FlatInspector.appendRow(stringBuilder, "Pref size", ((Dimension)object2).width + ", " + ((Dimension)object2).height);
        FlatInspector.appendRow(stringBuilder, "Min size", cloneable.width + ", " + cloneable.height);
        FlatInspector.appendRow(stringBuilder, "Max size", dimension.width + ", " + dimension.height);
        if (component instanceof JComponent) {
            FlatInspector.appendRow(stringBuilder, "Border", FlatInspector.toString(((JComponent)component).getBorder(), bl2));
        }
        FlatInspector.appendRow(stringBuilder, "Background", FlatInspector.toString(component.getBackground()) + (component.isBackgroundSet() ? "" : "  NOT SET"));
        FlatInspector.appendRow(stringBuilder, "Foreground", FlatInspector.toString(component.getForeground()) + (component.isForegroundSet() ? "" : "  NOT SET"));
        FlatInspector.appendRow(stringBuilder, "Font", FlatInspector.toString(component.getFont()) + (component.isFontSet() ? "" : "  NOT SET"));
        if (component instanceof JComponent) {
            try {
                if (SystemInfo.isJava_9_orLater) {
                    Method method = JComponent.class.getMethod("getUI", new Class[0]);
                    object = method.invoke((Object)component, new Object[0]);
                } else {
                    Field field = JComponent.class.getDeclaredField("ui");
                    field.setAccessible(true);
                    object = field.get(component);
                }
                FlatInspector.appendRow(stringBuilder, "UI", object != null ? FlatInspector.toString(object.getClass(), bl2) : "null");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (component instanceof Container && (object = ((Container)component).getLayout()) != null) {
            FlatInspector.appendRow(stringBuilder, "Layout", FlatInspector.toString(object.getClass(), bl2));
        }
        FlatInspector.appendRow(stringBuilder, "Enabled", String.valueOf(component.isEnabled()));
        FlatInspector.appendRow(stringBuilder, "Opaque", String.valueOf(component.isOpaque()) + (component instanceof JComponent && FlatUIUtils.hasOpaqueBeenExplicitlySet((JComponent)component) ? " EXPLICIT" : ""));
        if (component instanceof AbstractButton) {
            FlatInspector.appendRow(stringBuilder, "ContentAreaFilled", String.valueOf(((AbstractButton)component).isContentAreaFilled()));
        }
        FlatInspector.appendRow(stringBuilder, "Focusable", String.valueOf(component.isFocusable()));
        FlatInspector.appendRow(stringBuilder, "Left-to-right", String.valueOf(component.getComponentOrientation().isLeftToRight()));
        FlatInspector.appendRow(stringBuilder, "Parent", component.getParent() != null ? FlatInspector.toString(component.getParent().getClass(), bl2) : "null");
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("FlatLaf.style")) != null) {
            FlatInspector.appendRow(stringBuilder, "FlatLaf Style", object.toString());
        }
        stringBuilder.append("<tr><td colspan=\"2\">");
        if (n2 > 0) {
            stringBuilder.append("<br>Parent level: " + n2);
        }
        stringBuilder.append("<br>(").append(n2 > 0 ? "press <b>Ctrl/Shift</b> to increase/decrease level" : "press <b>Ctrl</b> key to inspect parent").append("; &nbsp;").append(bl2 ? "press <b>Alt</b> key to hide class hierarchy" : "press <b>Alt</b> key to show class hierarchy").append(')');
        stringBuilder.append("</td></tr>");
        stringBuilder.append("</table></html>");
        return stringBuilder.toString();
    }

    private static void appendRow(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append("<tr><td valign=\"top\">").append(string).append(":</td><td>").append(string2).append("</td></tr>");
    }

    private static String toString(Class<?> clazz, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(100);
        int n2 = 0;
        while (clazz != null) {
            if (n2 > 0) {
                if (clazz == Object.class) break;
                stringBuilder.append("<br>&nbsp;");
                for (int i2 = 1; i2 < n2; ++i2) {
                    stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                stringBuilder.append("\u2570 ");
            }
            ++n2;
            String string = clazz.getName();
            int n3 = string.lastIndexOf(46);
            String string2 = n3 >= 0 ? string.substring(0, n3) : "-";
            String string3 = n3 >= 0 ? string.substring(n3 + 1) : string;
            stringBuilder.append(string3).append(' ').append(FlatInspector.toDimmedText("(" + string2 + ")"));
            if (UIResource.class.isAssignableFrom(clazz)) {
                stringBuilder.append(" UI");
            }
            if (!bl2) break;
            clazz = clazz.getSuperclass();
        }
        return stringBuilder.toString();
    }

    private static String toString(Insets insets) {
        if (insets == null) {
            return "null";
        }
        return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + (insets instanceof UIResource ? " UI" : "");
    }

    private static String toString(Color color) {
        if (color == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("<tt>");
        stringBuilder.append(color.getAlpha() != 255 ? String.format("#%06x%02x", color.getRGB() & 0xFFFFFF, color.getRGB() >> 24 & 0xFF) : String.format("#%06x", color.getRGB() & 0xFFFFFF));
        stringBuilder.append("</tt>");
        if (color instanceof UIResource) {
            stringBuilder.append(" UI");
        }
        stringBuilder.append("&nbsp; &nbsp;").append("<span style=\"background: ").append(String.format("#%06x", color.getRGB() & 0xFFFFFF)).append(";\">").append("&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;").append("</span>");
        if (color.getAlpha() != 255) {
            stringBuilder.append(" ").append(Math.round((float)color.getAlpha() / 2.55f)).append('%');
        }
        return stringBuilder.toString();
    }

    private static String toString(Font font) {
        if (font == null) {
            return "null";
        }
        return font.getFamily() + " " + font.getSize() + " " + font.getStyle() + (font instanceof UIResource ? " UI" : "");
    }

    private static String toString(Border border, boolean bl2) {
        if (border == null) {
            return "null";
        }
        String string = FlatInspector.toString(border.getClass(), bl2);
        if (border instanceof EmptyBorder) {
            String string2 = " (" + FlatInspector.toString(((EmptyBorder)border).getBorderInsets()) + ')';
            int n2 = string.indexOf("<br>");
            string = n2 >= 0 ? string.substring(0, n2) + string2 + string.substring(n2) : string + string2;
        }
        return string;
    }

    private static String toDimmedText(String string) {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color == null) {
            color = UIManager.getColor("Label.disabledText");
        }
        if (color == null) {
            color = Color.GRAY;
        }
        return String.format("<span color=\"#%06x\">%s</span>", color.getRGB() & 0xFFFFFF, string);
    }
}

