/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.FlatIconColors;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.SoftCache;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import o.N;
import o.__9;
import o.dm;

public class FlatSVGIcon
extends ImageIcon
implements FlatLaf.DisabledIconProvider {
    private static boolean loggingEnabled = true;
    private static boolean svgCacheEnabled = true;
    private static final SoftCache<String, __9> svgCache = new SoftCache();
    private static final N svgLoader = new N();
    private final String name;
    private final int width;
    private final int height;
    private final float scale;
    private final boolean disabled;
    private final ClassLoader classLoader;
    private final URL url;
    private ColorFilter colorFilter;
    private __9 document;
    private boolean dark;
    private boolean loadFailed;
    private static Boolean darkLaf;

    public FlatSVGIcon(String string) {
        this(string, -1, -1, 1.0f, false, null, null);
    }

    public FlatSVGIcon(String string, ClassLoader classLoader) {
        this(string, -1, -1, 1.0f, false, classLoader, null);
    }

    public FlatSVGIcon(String string, int n2, int n3) {
        this(string, n2, n3, 1.0f, false, null, null);
    }

    public FlatSVGIcon(String string, int n2, int n3, ClassLoader classLoader) {
        this(string, n2, n3, 1.0f, false, classLoader, null);
    }

    public FlatSVGIcon(String string, float f2) {
        this(string, -1, -1, f2, false, null, null);
    }

    public FlatSVGIcon(String string, float f2, ClassLoader classLoader) {
        this(string, -1, -1, f2, false, classLoader, null);
    }

    public FlatSVGIcon(URL uRL) {
        this(null, -1, -1, 1.0f, false, null, uRL);
    }

    public FlatSVGIcon(URI uRI) {
        this(null, -1, -1, 1.0f, false, null, FlatSVGIcon.uri2url(uRI));
    }

    public FlatSVGIcon(File file) {
        this(null, -1, -1, 1.0f, false, null, FlatSVGIcon.uri2url(file.toURI()));
    }

    public FlatSVGIcon(InputStream inputStream) throws IOException {
        this(null, -1, -1, 1.0f, false, null, null);
        try (InputStream inputStream2 = inputStream;){
            this.document = svgLoader.O0(inputStream2);
            if (this.document == null) {
                this.loadFailed = true;
                if (loggingEnabled) {
                    LoggingFacade.INSTANCE.logConfig("FlatSVGIcon: failed to load SVG icon from input stream", null);
                }
            }
        }
    }

    public FlatSVGIcon(FlatSVGIcon flatSVGIcon) {
        this(flatSVGIcon.name, flatSVGIcon.width, flatSVGIcon.height, flatSVGIcon.scale, flatSVGIcon.disabled, flatSVGIcon.classLoader, flatSVGIcon.url);
        this.colorFilter = flatSVGIcon.colorFilter;
        this.document = flatSVGIcon.document;
        this.dark = flatSVGIcon.dark;
    }

    protected FlatSVGIcon(String string, int n2, int n3, float f2, boolean bl2, ClassLoader classLoader, URL uRL) {
        this.name = string;
        this.width = n2;
        this.height = n3;
        this.scale = f2;
        this.disabled = bl2;
        this.classLoader = classLoader;
        this.url = uRL;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getScale() {
        return this.scale;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FlatSVGIcon derive(int n2, int n3) {
        if (n2 == this.width && n3 == this.height) {
            return this;
        }
        FlatSVGIcon flatSVGIcon = new FlatSVGIcon(this.name, n2, n3, this.scale, this.disabled, this.classLoader, this.url);
        flatSVGIcon.colorFilter = this.colorFilter;
        flatSVGIcon.document = this.document;
        flatSVGIcon.dark = this.dark;
        return flatSVGIcon;
    }

    public FlatSVGIcon derive(float f2) {
        if (f2 == this.scale) {
            return this;
        }
        FlatSVGIcon flatSVGIcon = new FlatSVGIcon(this.name, this.width, this.height, f2, this.disabled, this.classLoader, this.url);
        flatSVGIcon.colorFilter = this.colorFilter;
        flatSVGIcon.document = this.document;
        flatSVGIcon.dark = this.dark;
        return flatSVGIcon;
    }

    @Override
    public Icon getDisabledIcon() {
        if (this.disabled) {
            return this;
        }
        FlatSVGIcon flatSVGIcon = new FlatSVGIcon(this.name, this.width, this.height, this.scale, true, this.classLoader, this.url);
        flatSVGIcon.colorFilter = this.colorFilter;
        flatSVGIcon.document = this.document;
        flatSVGIcon.dark = this.dark;
        return flatSVGIcon;
    }

    public ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    public FlatSVGIcon setColorFilter(ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
        return this;
    }

    private void update() {
        if (this.loadFailed) {
            return;
        }
        if (this.dark == FlatSVGIcon.isDarkLaf() && this.document != null) {
            return;
        }
        this.dark = FlatSVGIcon.isDarkLaf();
        if (this.document != null && this.name == null) {
            return;
        }
        URL uRL = this.url;
        if (uRL == null) {
            uRL = this.getIconURL(this.name, this.dark);
            if (uRL == null && this.dark) {
                uRL = this.getIconURL(this.name, false);
            }
            if (uRL == null) {
                this.loadFailed = true;
                if (loggingEnabled) {
                    LoggingFacade.INSTANCE.logConfig("FlatSVGIcon: resource '" + this.name + "' not found (if using Java modules, check whether icon package is opened in module-info.java)", null);
                }
                return;
            }
        }
        this.document = FlatSVGIcon.loadSVG(uRL);
        this.loadFailed = this.document == null;
    }

    static synchronized __9 loadSVG(URL uRL) {
        if (!svgCacheEnabled) {
            return FlatSVGIcon.loadSVGUncached(uRL);
        }
        String string = uRL.toString();
        __9 __92 = svgCache.get(string);
        if (__92 != null) {
            return __92;
        }
        __92 = FlatSVGIcon.loadSVGUncached(uRL);
        svgCache.put(string, __92);
        return __92;
    }

    private static __9 loadSVGUncached(URL uRL) {
        __9 __92 = svgLoader.O0(uRL);
        if (__92 == null) {
            if (loggingEnabled) {
                LoggingFacade.INSTANCE.logConfig("FlatSVGIcon: failed to load '" + uRL + "'", null);
            }
            return null;
        }
        return __92;
    }

    private URL getIconURL(String string, boolean bl2) {
        if (bl2) {
            int n2 = string.lastIndexOf(46);
            string = string.substring(0, n2) + "_dark" + string.substring(n2);
        }
        ClassLoader classLoader = this.classLoader != null ? this.classLoader : FlatSVGIcon.class.getClassLoader();
        return classLoader.getResource(string);
    }

    public boolean hasFound() {
        this.update();
        return this.document != null;
    }

    @Override
    public int getIconWidth() {
        if (this.width > 0) {
            return this.scaleSize(this.width);
        }
        this.update();
        return this.scaleSize(this.document != null ? Math.round(this.document.O0().\u03b9) : 16);
    }

    @Override
    public int getIconHeight() {
        if (this.height > 0) {
            return this.scaleSize(this.height);
        }
        this.update();
        return this.scaleSize(this.document != null ? Math.round(this.document.O0().\u03ba) : 16);
    }

    private int scaleSize(int n2) {
        int n3 = UIScale.scale(n2);
        if (this.scale != 1.0f) {
            n3 = Math.round((float)n3 * this.scale);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        Object object;
        this.update();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && !rectangle.intersects(new Rectangle(n2, n3, this.getIconWidth(), this.getIconHeight()))) {
            return;
        }
        RGBImageFilter rGBImageFilter = null;
        if (this.disabled) {
            object = UIManager.get("Component.grayFilter");
            rGBImageFilter = object instanceof RGBImageFilter ? (RGBImageFilter)object : GrayFilter.createDisabledIconFilter(this.dark);
        }
        object = new GraphicsFilter((Graphics2D)graphics.create(), this.colorFilter, ColorFilter.getInstance(), rGBImageFilter);
        try {
            FlatSVGIcon.setRenderingHints((Graphics2D)object);
            this.paintSvg((Graphics2D)object, n2, n3);
        }
        finally {
            ((Graphics)object).dispose();
        }
    }

    private void paintSvg(Graphics2D graphics2D, int n2, int n3) {
        if (this.document == null) {
            this.paintSvgError(graphics2D, n2, n3);
            return;
        }
        graphics2D.translate(n2, n3);
        graphics2D.clipRect(0, 0, this.getIconWidth(), this.getIconHeight());
        UIScale.scaleGraphics(graphics2D);
        if (this.width > 0 || this.height > 0) {
            double d2;
            dm dm2 = this.document.O0();
            double d3 = this.width > 0 ? (double)((float)this.width / dm2.\u03b9) : 1.0;
            double d4 = d2 = this.height > 0 ? (double)((float)this.height / dm2.\u03ba) : 1.0;
            if (d3 != 1.0 || d2 != 1.0) {
                graphics2D.scale(d3, d2);
            }
        }
        if (this.scale != 1.0f) {
            graphics2D.scale(this.scale, this.scale);
        }
        try {
            this.document.O0(null, graphics2D);
        }
        catch (Exception exception) {
            this.paintSvgError(graphics2D, 0, 0);
        }
    }

    private void paintSvgError(Graphics2D graphics2D, int n2, int n3) {
        if (graphics2D instanceof GraphicsFilter) {
            ((GraphicsFilter)graphics2D).setColorUnfiltered(Color.red);
        } else {
            graphics2D.setColor(Color.red);
        }
        graphics2D.fillRect(n2, n3, this.getIconWidth(), this.getIconHeight());
    }

    @Override
    public Image getImage() {
        this.update();
        int n2 = this.getIconWidth();
        int n3 = this.getIconHeight();
        Dimension[] dimensionArray = new Dimension[]{new Dimension(n2, n3), new Dimension(n2 * 2, n3 * 2)};
        Function<Dimension, Image> function = dimension -> {
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                double d2;
                double d3 = dimension.width > 0 ? (double)((float)dimension.width / (float)n2) : 1.0;
                double d4 = d2 = dimension.height > 0 ? (double)((float)dimension.height / (float)n3) : 1.0;
                if (d3 != 1.0 || d2 != 1.0) {
                    graphics2D.scale(d3, d2);
                }
                this.paintIcon(null, graphics2D, 0, 0);
            }
            finally {
                graphics2D.dispose();
            }
            return bufferedImage;
        };
        return MultiResolutionImageSupport.create(0, dimensionArray, function);
    }

    static void setRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    static URL uri2url(URI uRI) {
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public static boolean isDarkLaf() {
        if (darkLaf == null) {
            FlatSVGIcon.lafChanged();
            UIManager.addPropertyChangeListener(propertyChangeEvent -> FlatSVGIcon.lafChanged());
        }
        return darkLaf;
    }

    private static void lafChanged() {
        darkLaf = FlatLaf.isLafDark();
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static void setLoggingEnabled(boolean bl2) {
        loggingEnabled = bl2;
    }

    public static boolean isSVGDocumentEnabled() {
        return svgCacheEnabled;
    }

    public static void setSVGDocumentEnabled(boolean bl2) {
        svgCacheEnabled = bl2;
        if (!bl2) {
            FlatSVGIcon.clearSVGDocumentCache();
        }
    }

    public static void clearSVGDocumentCache() {
        svgCache.clear();
    }

    private static class GraphicsFilter
    extends Graphics2DProxy {
        private final ColorFilter colorFilter;
        private final ColorFilter globalColorFilter;
        private final RGBImageFilter grayFilter;

        GraphicsFilter(Graphics2D graphics2D, ColorFilter colorFilter, ColorFilter colorFilter2, RGBImageFilter rGBImageFilter) {
            super(graphics2D);
            this.colorFilter = colorFilter;
            this.globalColorFilter = colorFilter2;
            this.grayFilter = rGBImageFilter;
        }

        @Override
        public Graphics create() {
            return new GraphicsFilter((Graphics2D)super.create(), this.colorFilter, this.globalColorFilter, this.grayFilter);
        }

        @Override
        public Graphics create(int n2, int n3, int n4, int n5) {
            return new GraphicsFilter((Graphics2D)super.create(n2, n3, n4, n5), this.colorFilter, this.globalColorFilter, this.grayFilter);
        }

        @Override
        public void setColor(Color color) {
            super.setColor(this.filterColor(color));
        }

        void setColorUnfiltered(Color color) {
            super.setColor(color);
        }

        @Override
        public void setPaint(Paint paint) {
            LinearGradientPaint linearGradientPaint;
            Color[] colorArray;
            if (paint instanceof Color) {
                paint = this.filterColor((Color)paint);
            } else if (paint instanceof LinearGradientPaint && (colorArray = this.filterColors((linearGradientPaint = (LinearGradientPaint)paint).getColors())) != null) {
                paint = new LinearGradientPaint(linearGradientPaint.getStartPoint(), linearGradientPaint.getEndPoint(), linearGradientPaint.getFractions(), colorArray, linearGradientPaint.getCycleMethod(), linearGradientPaint.getColorSpace(), linearGradientPaint.getTransform());
            }
            super.setPaint(paint);
        }

        private Color filterColor(Color color) {
            Color color2;
            color = this.colorFilter != null ? ((color2 = this.colorFilter.filter(color)) != color ? color2 : this.globalColorFilter.filter(color)) : this.globalColorFilter.filter(color);
            if (this.grayFilter != null) {
                int n2 = color.getRGB();
                int n3 = this.grayFilter.filterRGB(0, 0, n2);
                color = n3 != n2 ? new Color(n3, true) : color;
            }
            return color;
        }

        private Color[] filterColors(Color[] colorArray) {
            Color[] colorArray2 = new Color[colorArray.length];
            boolean bl2 = false;
            for (int i2 = 0; i2 < colorArray.length; ++i2) {
                colorArray2[i2] = this.filterColor(colorArray[i2]);
                bl2 = bl2 || colorArray2[i2] != colorArray[i2];
            }
            return bl2 ? colorArray2 : null;
        }
    }

    public static class ColorFilter {
        private static ColorFilter instance;
        private Map<Integer, String> rgb2keyMap;
        private Map<Color, Color> colorMap;
        private Map<Color, Color> darkColorMap;
        private Function<Color, Color> mapper;

        public static ColorFilter getInstance() {
            if (instance == null) {
                instance = new ColorFilter();
                ColorFilter.instance.rgb2keyMap = new HashMap<Integer, String>();
                for (FlatIconColors flatIconColors : FlatIconColors.values()) {
                    ColorFilter.instance.rgb2keyMap.put(flatIconColors.rgb, flatIconColors.key);
                }
            }
            return instance;
        }

        public ColorFilter() {
        }

        public ColorFilter(Function<Color, Color> function) {
            this.setMapper(function);
        }

        public Function<Color, Color> getMapper() {
            return this.mapper;
        }

        public void setMapper(Function<Color, Color> function) {
            this.mapper = function;
        }

        public Map<Color, Color> getLightColorMap() {
            return this.colorMap != null ? Collections.unmodifiableMap(this.colorMap) : Collections.emptyMap();
        }

        public Map<Color, Color> getDarkColorMap() {
            return this.darkColorMap != null ? Collections.unmodifiableMap(this.darkColorMap) : this.getLightColorMap();
        }

        public ColorFilter addAll(Map<Color, Color> map) {
            this.ensureColorMap();
            this.colorMap.putAll(map);
            if (this.darkColorMap != null) {
                this.darkColorMap.putAll(map);
            }
            return this;
        }

        public ColorFilter addAll(Map<Color, Color> map, Map<Color, Color> map2) {
            this.ensureColorMap();
            this.ensureDarkColorMap();
            this.colorMap.putAll(map);
            this.darkColorMap.putAll(map2);
            return this;
        }

        public ColorFilter add(Color color, Color color2) {
            this.ensureColorMap();
            this.colorMap.put(color, color2);
            if (this.darkColorMap != null) {
                this.darkColorMap.put(color, color2);
            }
            return this;
        }

        public ColorFilter add(Color color, Color color2, Color color3) {
            this.ensureColorMap();
            this.ensureDarkColorMap();
            if (color2 != null) {
                this.colorMap.put(color, color2);
            }
            if (color3 != null) {
                this.darkColorMap.put(color, color3);
            }
            return this;
        }

        public ColorFilter remove(Color color) {
            if (this.colorMap != null) {
                this.colorMap.remove(color);
            }
            if (this.darkColorMap != null) {
                this.darkColorMap.remove(color);
            }
            return this;
        }

        public ColorFilter removeAll() {
            this.colorMap = null;
            this.darkColorMap = null;
            return this;
        }

        private void ensureColorMap() {
            if (this.colorMap == null) {
                this.colorMap = new HashMap<Color, Color>();
            }
        }

        private void ensureDarkColorMap() {
            if (this.darkColorMap == null) {
                this.darkColorMap = new HashMap<Color, Color>(this.colorMap);
            }
        }

        public Color filter(Color color) {
            color = this.applyMappings(color);
            if (this.mapper != null) {
                color = this.mapper.apply(color);
            }
            return color;
        }

        private Color applyMappings(Color color) {
            Object object;
            Color color2;
            if (this.colorMap != null && (color2 = (object = this.darkColorMap != null && FlatSVGIcon.isDarkLaf() ? this.darkColorMap : this.colorMap).get(color)) != null) {
                return color2;
            }
            if (this.rgb2keyMap != null) {
                object = this.rgb2keyMap.get(color.getRGB() & 0xFFFFFF);
                if (object == null) {
                    return color;
                }
                color2 = UIManager.getColor(object);
                if (color2 == null) {
                    return color;
                }
                return color2.getAlpha() != color.getAlpha() ? new Color(color2.getRGB() & 0xFFFFFF | color.getRGB() & 0xFF000000) : color2;
            }
            return color;
        }

        public static Function<Color, Color> createRGBImageFilterFunction(RGBImageFilter rGBImageFilter) {
            return color -> {
                int n2 = color.getRGB();
                int n3 = rGBImageFilter.filterRGB(0, 0, n2);
                return n3 != n2 ? new Color(n3, true) : color;
            };
        }
    }
}

