/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.components.FlatTextField;
import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatMarginBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.HSLColor;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.ScaledEmptyBorder;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class FlatUIDefaultsInspector {
    private static final int KEY_MODIFIERS_MASK = 960;
    private static JFrame inspectorFrame;
    private final PropertyChangeListener lafListener = this::lafChanged;
    private final PropertyChangeListener lafDefaultsListener = this::lafDefaultsChanged;
    private boolean refreshPending;
    private Properties derivedColorKeys;
    private JPanel panel;
    private JPanel filterPanel;
    private JLabel filterLabel;
    private FlatTextField filterField;
    private JLabel valueTypeLabel;
    private JComboBox<String> valueTypeField;
    private JScrollPane scrollPane;
    private JTable table;
    private JPopupMenu tablePopupMenu;
    private JMenuItem copyKeyMenuItem;
    private JMenuItem copyValueMenuItem;
    private JMenuItem copyKeyAndValueMenuItem;

    public static void install(String string) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEvent -> {
            if (aWTEvent.getID() == 402 && ((KeyEvent)aWTEvent).getKeyCode() == keyStroke.getKeyCode() && (((KeyEvent)aWTEvent).getModifiersEx() & 0x3C0) == (keyStroke.getModifiers() & 0x3C0)) {
                FlatUIDefaultsInspector.show();
            }
        }, 8L);
    }

    public static void show() {
        if (inspectorFrame != null) {
            FlatUIDefaultsInspector.ensureOnScreen(inspectorFrame);
            inspectorFrame.toFront();
            return;
        }
        inspectorFrame = new FlatUIDefaultsInspector().createFrame();
        inspectorFrame.setVisible(true);
    }

    public static void hide() {
        if (inspectorFrame != null) {
            inspectorFrame.dispose();
        }
    }

    public static JComponent createInspectorPanel() {
        return new FlatUIDefaultsInspector().panel;
    }

    private FlatUIDefaultsInspector() {
        this.initComponents();
        this.panel.setBorder(new ScaledEmptyBorder(10, 10, 10, 10));
        this.filterPanel.setBorder(new ScaledEmptyBorder(0, 0, 10, 0));
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FlatUIDefaultsInspector.this.filterChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FlatUIDefaultsInspector.this.filterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FlatUIDefaultsInspector.this.filterChanged();
            }
        });
        this.delegateKey(38, "unitScrollUp");
        this.delegateKey(40, "unitScrollDown");
        this.delegateKey(33, "scrollUp");
        this.delegateKey(34, "scrollDown");
        this.table.setModel(new ItemsTableModel(this.getUIDefaultsItems()));
        this.table.setDefaultRenderer(String.class, new KeyRenderer());
        this.table.setDefaultRenderer(Item.class, new ValueRenderer());
        this.table.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        Preferences preferences = this.getPrefs();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(preferences.getInt("column1width", 100));
        tableColumnModel.getColumn(1).setPreferredWidth(preferences.getInt("column2width", 100));
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            if ("width".equals(propertyChangeEvent.getPropertyName())) {
                preferences.putInt("column1width", tableColumnModel.getColumn(0).getWidth());
                preferences.putInt("column2width", tableColumnModel.getColumn(1).getWidth());
            }
        };
        tableColumnModel.getColumn(0).addPropertyChangeListener(propertyChangeListener);
        tableColumnModel.getColumn(1).addPropertyChangeListener(propertyChangeListener);
        String string = preferences.get("filter", "");
        String string2 = preferences.get("valueType", null);
        if (string != null && !string.isEmpty()) {
            this.filterField.setText(string);
        }
        if (string2 != null) {
            this.valueTypeField.setSelectedItem(string2);
        }
        this.panel.addPropertyChangeListener("ancestor", propertyChangeEvent -> {
            if (propertyChangeEvent.getNewValue() != null) {
                UIManager.addPropertyChangeListener(this.lafListener);
                UIManager.getDefaults().addPropertyChangeListener(this.lafDefaultsListener);
            } else {
                UIManager.removePropertyChangeListener(this.lafListener);
                UIManager.getDefaults().removePropertyChangeListener(this.lafDefaultsListener);
            }
        });
        this.panel.registerKeyboardAction(actionEvent -> this.refresh(), KeyStroke.getKeyStroke(116, 0, false), 1);
    }

    private JFrame createFrame() {
        final JFrame jFrame = new JFrame();
        jFrame.setTitle("UI Defaults Inspector");
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                inspectorFrame = null;
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FlatUIDefaultsInspector.this.saveWindowBounds(jFrame);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                FlatUIDefaultsInspector.this.saveWindowBounds(jFrame);
            }
        });
        FlatUIDefaultsInspector.updateWindowTitle(jFrame);
        jFrame.getContentPane().add((Component)this.panel, "Center");
        Preferences preferences = this.getPrefs();
        int n2 = preferences.getInt("x", -1);
        int n3 = preferences.getInt("y", -1);
        int n4 = preferences.getInt("width", UIScale.scale(600));
        int n5 = preferences.getInt("height", UIScale.scale(800));
        jFrame.setSize(n4, n5);
        if (n2 != -1 && n3 != -1) {
            jFrame.setLocation(n2, n3);
            FlatUIDefaultsInspector.ensureOnScreen(jFrame);
        } else {
            jFrame.setLocationRelativeTo(null);
        }
        ((JComponent)jFrame.getContentPane()).registerKeyboardAction(actionEvent -> jFrame.dispose(), KeyStroke.getKeyStroke(27, 0, false), 1);
        return jFrame;
    }

    private void delegateKey(int n2, final String string) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n2, 0);
        String string2 = "delegate-" + string;
        this.filterField.getInputMap().put(keyStroke, string2);
        this.filterField.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action = FlatUIDefaultsInspector.this.scrollPane.getActionMap().get(string);
                if (action != null) {
                    action.actionPerformed(new ActionEvent(FlatUIDefaultsInspector.this.scrollPane, actionEvent.getID(), string, actionEvent.getWhen(), actionEvent.getModifiers()));
                }
            }
        });
    }

    private static void ensureOnScreen(JFrame jFrame) {
        Rectangle rectangle = jFrame.getBounds();
        boolean bl2 = false;
        for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle2 = FlatUIUtils.subtractInsets(graphicsConfiguration.getBounds(), Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration));
            if (!rectangle.intersects(rectangle2)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            jFrame.setLocationRelativeTo(null);
        }
    }

    private void lafChanged(PropertyChangeEvent propertyChangeEvent) {
        if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
            this.refresh();
        }
    }

    private void lafDefaultsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.refreshPending) {
            return;
        }
        this.refreshPending = true;
        EventQueue.invokeLater(() -> {
            this.refresh();
            this.refreshPending = false;
        });
    }

    private void refresh() {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.table.getModel();
        itemsTableModel.setItems(this.getUIDefaultsItems());
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.panel);
        if (jFrame != null) {
            FlatUIDefaultsInspector.updateWindowTitle(jFrame);
        }
    }

    private Item[] getUIDefaultsItems() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        UIDefaults uIDefaults2 = UIManager.getLookAndFeelDefaults();
        Set set = uIDefaults.entrySet();
        ArrayList<Item> arrayList = new ArrayList<Item>(set.size());
        HashSet hashSet = new HashSet(set.size());
        Color[] colorArray = new Color[1];
        for (Map.Entry entry : set) {
            Object object;
            Object object2;
            Object k2 = entry.getKey();
            if (!(k2 instanceof String) || ((String)k2).startsWith("FlatLaf.internal.") || (object2 = uIDefaults.get(k2)) instanceof Class || !hashSet.add(k2)) continue;
            Color[] colorArray2 = null;
            if (object2 instanceof DerivedColor && (object = this.resolveDerivedColor(uIDefaults, (String)k2, (DerivedColor)object2, colorArray)) != object2) {
                colorArray2 = new Color[]{object, colorArray[0]};
            }
            object = null;
            if (uIDefaults.containsKey(k2)) {
                object = uIDefaults2.get(k2);
            }
            arrayList.add(new Item(String.valueOf(k2), object2, object, colorArray2));
        }
        return arrayList.toArray(new Item[arrayList.size()]);
    }

    private Color resolveDerivedColor(UIDefaults uIDefaults, String string, Color color, Color[] colorArray) {
        Object object;
        if (colorArray != null) {
            colorArray[0] = null;
        }
        if (!(color instanceof DerivedColor)) {
            return color;
        }
        if (this.derivedColorKeys == null) {
            this.derivedColorKeys = this.loadDerivedColorKeys();
        }
        if ((object = this.derivedColorKeys.get(string)) == null) {
            return color;
        }
        if ("null".equals(object)) {
            return color;
        }
        Color color2 = uIDefaults.getColor(object);
        if (color2 == null) {
            return color;
        }
        if (color2 instanceof DerivedColor) {
            color2 = this.resolveDerivedColor(uIDefaults, (String)object, color2, null);
        }
        if (colorArray != null) {
            colorArray[0] = color2;
        }
        Color color3 = FlatUIUtils.deriveColor(color, color2);
        return new Color(color3.getRGB(), true);
    }

    private Properties loadDerivedColorKeys() {
        String string = "/com/formdev/flatlaf/extras/resources/DerivedColorKeys.properties";
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to load '" + string + "'.", iOException);
        }
        return properties;
    }

    private static void updateWindowTitle(JFrame jFrame) {
        String string;
        String string2 = jFrame.getTitle();
        int n2 = string2.indexOf(string = "  -  ");
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        jFrame.setTitle(string2 + string + UIManager.getLookAndFeel().getName());
    }

    private void saveWindowBounds(JFrame jFrame) {
        Preferences preferences = this.getPrefs();
        preferences.putInt("x", jFrame.getX());
        preferences.putInt("y", jFrame.getY());
        preferences.putInt("width", jFrame.getWidth());
        preferences.putInt("height", jFrame.getHeight());
    }

    private Preferences getPrefs() {
        return Preferences.userRoot().node("flatlaf-uidefaults-inspector");
    }

    private void filterChanged() {
        Object object;
        Pattern[] patternArray;
        String string = this.filterField.getText().trim();
        String string2 = (String)this.valueTypeField.getSelectedItem();
        String[] stringArray = !string.isEmpty() ? string.split(" +") : null;
        Pattern[] patternArray2 = patternArray = stringArray != null ? new Pattern[stringArray.length] : null;
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].toLowerCase(Locale.ENGLISH);
                object = stringArray[i2];
                boolean bl2 = ((String)object).startsWith("^");
                boolean bl3 = ((String)object).endsWith("$");
                if (((String)object).indexOf(42) < 0 && ((String)object).indexOf(63) < 0 && !bl2 && !bl3) continue;
                if (bl2) {
                    object = ((String)object).substring(1);
                }
                if (bl3) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                String string3 = ("\\Q" + (String)object + "\\E").replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q");
                if (!bl2) {
                    string3 = ".*" + string3;
                }
                if (!bl3) {
                    string3 = string3 + ".*";
                }
                patternArray[i2] = Pattern.compile(string3);
            }
        }
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.table.getModel();
        itemsTableModel.setFilter(item -> {
            if (string2 != null && !string2.equals("(any)") && !this.typeOfValue(item.value).startsWith(string2)) {
                return false;
            }
            if (stringArray == null) {
                return true;
            }
            String string2 = item.key.toLowerCase(Locale.ENGLISH);
            String string3 = item.getValueAsString().toLowerCase(Locale.ENGLISH);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string4;
                Pattern pattern = patternArray[i2];
                if (!(pattern != null ? pattern.matcher(string2).matches() || pattern.matcher(string3).matches() : string2.contains(string4 = stringArray[i2]) || string3.contains(string4))) continue;
                return true;
            }
            return false;
        });
        object = this.getPrefs();
        ((Preferences)object).put("filter", string);
        ((Preferences)object).put("valueType", string2);
    }

    private String typeOfValue(Object object) {
        if (object instanceof Boolean) {
            return "Boolean";
        }
        if (object instanceof Border) {
            return "Border";
        }
        if (object instanceof Color) {
            if (((Color)object).getAlpha() != 255) {
                return "Color (\u03b1)";
            }
            if (object instanceof DerivedColor) {
                return "Color (\u0192)";
            }
            return "Color";
        }
        if (object instanceof Dimension) {
            return "Dimension";
        }
        if (object instanceof Float) {
            return "Float";
        }
        if (object instanceof Font) {
            return "Font";
        }
        if (object instanceof Icon) {
            return "Icon";
        }
        if (object instanceof Insets) {
            return "Insets";
        }
        if (object instanceof Integer) {
            return "Integer";
        }
        if (object instanceof String) {
            return "String";
        }
        return "(other)";
    }

    private void tableMousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        int n2 = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n2 >= 0 && !this.table.isRowSelected(n2)) {
            this.table.setRowSelectionInterval(n2, n2);
        }
    }

    private void copyKey() {
        this.copyToClipboard(0);
    }

    private void copyValue() {
        this.copyToClipboard(1);
    }

    private void copyKeyAndValue() {
        this.copyToClipboard(-1);
    }

    private void copyToClipboard(int n2) {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append('\n');
            }
            if (n2 < 0 || n2 == 0) {
                stringBuilder.append(this.table.getValueAt(nArray[i2], 0));
            }
            if (n2 < 0) {
                stringBuilder.append(" = ");
            }
            if (n2 >= 0 && n2 != 1) continue;
            stringBuilder.append(this.table.getValueAt(nArray[i2], 1));
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.filterPanel = new JPanel();
        this.filterLabel = new JLabel();
        this.filterField = new FlatTextField();
        this.valueTypeLabel = new JLabel();
        this.valueTypeField = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.tablePopupMenu = new JPopupMenu();
        this.copyKeyMenuItem = new JMenuItem();
        this.copyValueMenuItem = new JMenuItem();
        this.copyKeyAndValueMenuItem = new JMenuItem();
        this.panel.setLayout(new BorderLayout());
        this.filterPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.filterPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.filterPanel.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.filterPanel.getLayout()).columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.filterPanel.getLayout()).rowWeights = new double[]{0.0, 1.0E-4};
        this.filterLabel.setText("Filter:");
        this.filterLabel.setLabelFor(this.filterField);
        this.filterLabel.setDisplayedMnemonic('F');
        this.filterPanel.add((Component)this.filterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.filterField.setPlaceholderText("enter one or more filter strings, separated by space characters");
        this.filterField.setShowClearButton(true);
        this.filterPanel.add((Component)this.filterField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.valueTypeLabel.setText("Value Type:");
        this.valueTypeLabel.setLabelFor(this.valueTypeField);
        this.valueTypeLabel.setDisplayedMnemonic('T');
        this.filterPanel.add((Component)this.valueTypeLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.valueTypeField.setModel(new DefaultComboBoxModel<String>(new String[]{"(any)", "Boolean", "Border", "Color", "Color (\u03b1)", "Color (\u0192)", "Dimension", "Float", "Font", "Icon", "Insets", "Integer", "String", "(other)"}));
        this.valueTypeField.addActionListener(actionEvent -> this.filterChanged());
        this.filterPanel.add(this.valueTypeField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.filterPanel, "North");
        this.table.setAutoCreateRowSorter(true);
        this.table.setComponentPopupMenu(this.tablePopupMenu);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FlatUIDefaultsInspector.this.tableMousePressed(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.table);
        this.panel.add((Component)this.scrollPane, "Center");
        this.copyKeyMenuItem.setText("Copy Key");
        this.copyKeyMenuItem.addActionListener(actionEvent -> this.copyKey());
        this.tablePopupMenu.add(this.copyKeyMenuItem);
        this.copyValueMenuItem.setText("Copy Value");
        this.copyValueMenuItem.addActionListener(actionEvent -> this.copyValue());
        this.tablePopupMenu.add(this.copyValueMenuItem);
        this.copyKeyAndValueMenuItem.setText("Copy Key and Value");
        this.copyKeyAndValueMenuItem.addActionListener(actionEvent -> this.copyKeyAndValue());
        this.tablePopupMenu.add(this.copyKeyAndValueMenuItem);
    }

    private static class SafeIcon
    implements Icon {
        private final Icon icon;

        SafeIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            int n4 = this.getIconWidth();
            int n5 = this.getIconHeight();
            try {
                graphics.setColor(UIManager.getColor("Panel.background"));
                graphics.fillRect(n2, n3, n4, n5);
                this.icon.paintIcon(component, graphics, n2, n3);
            }
            catch (Exception exception) {
                graphics.setColor(Color.red);
                graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    private static class ValueRenderer
    extends Renderer {
        private Item item;
        private Color valueColor;

        private ValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Object object2;
            this.item = (Item)object;
            this.init(jTable, this.item.key, bl2, n2);
            if (!(this.item.value instanceof Color)) {
                this.setBackground(null);
                this.setForeground(null);
            }
            if (!(this.item.value instanceof Icon)) {
                this.setIcon(null);
            }
            object = this.item.getValueAsString();
            super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (this.item.value instanceof Color) {
                object2 = this.item.info instanceof Color[] ? ((Color[])this.item.info)[0] : (Color)this.item.value;
                boolean bl4 = new HSLColor((Color)object2).getLuminance() < 70.0f && ((Color)object2).getAlpha() >= 128;
                this.valueColor = object2;
                this.setForeground(bl4 ? Color.white : Color.black);
            } else if (this.item.value instanceof Icon) {
                object2 = (Icon)this.item.value;
                this.setIcon(new SafeIcon((Icon)object2));
            }
            Object object3 = object2 = this.item.value instanceof Object[] ? Arrays.toString((Object[])this.item.value).replace(", ", ",\n") : String.valueOf(this.item.value);
            if (this.item.lafValue != null) {
                object2 = (String)object2 + "    \n\nLaF UI default value was overridden with UIManager.put(key,value):\n    " + Item.valueAsString(this.item.lafValue, null) + "\n    " + String.valueOf(this.item.lafValue);
            }
            this.setToolTipText((String)object2);
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.item.value instanceof Color) {
                Object object;
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                Color color = this.valueColor;
                this.fillRect(graphics, color, 0, 0, n2, n3);
                if (this.item.info instanceof Color[]) {
                    int n4;
                    int n5 = n3 * 2;
                    this.fillRect(graphics, ((Color[])this.item.info)[1], n2 - n5, 0, n5, n3);
                    object = (Color)this.item.value;
                    if (object != null && !((Color)object).equals(color)) {
                        n4 = n3 / 2;
                        this.fillRect(graphics, (Color)object, n2 - n4, 0, n4, n3);
                    }
                    n4 = n3 / 4;
                    graphics.setColor(Color.magenta);
                    graphics.fillRect(n2 - n4, 0, n4, n3);
                }
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                object = this.getText();
                Rectangle rectangle = new Rectangle();
                this.layoutLabel(fontMetrics, (String)object, rectangle);
                int n6 = rectangle.x;
                int n7 = rectangle.y + fontMetrics.getAscent();
                graphics.setColor(this.getForeground());
                int n8 = ((String)object).indexOf("HSL");
                if (n8 > 0) {
                    String string = ((String)object).substring(0, n8);
                    String string2 = ((String)object).substring(n8);
                    int n9 = Math.max(fontMetrics.stringWidth(string), fontMetrics.stringWidth("#12345678  "));
                    FlatUIUtils.drawString(this, graphics, string, n6, n7);
                    FlatUIUtils.drawString(this, graphics, string2, n6 + n9, n7);
                } else {
                    FlatUIUtils.drawString(this, graphics, (String)object, n6, n7);
                }
            } else {
                super.paintComponent(graphics);
            }
            this.paintSeparator(graphics);
        }

        private void fillRect(Graphics graphics, Color color, int n2, int n3, int n4, int n5) {
            if (color.getAlpha() != 255) {
                graphics.setColor(Color.white);
                graphics.fillRect(n2, n3, n4, n5);
            }
            graphics.setColor(color);
            graphics.fillRect(n2, n3, n4, n5);
        }
    }

    private static class KeyRenderer
    extends Renderer {
        private String key;
        private boolean isOverridden;
        private Icon overriddenIcon;

        private KeyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            this.key = (String)object;
            this.init(jTable, this.key, bl2, n2);
            Item item = (Item)jTable.getValueAt(n2, 1);
            this.isOverridden = item.lafValue != null;
            String string = this.key;
            if (this.isOverridden) {
                string = string + "    \n\nLaF UI default value was overridden with UIManager.put(key,value).";
            }
            this.setToolTipText(string);
            return super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Rectangle rectangle = new Rectangle();
            String string = this.layoutLabel(fontMetrics, this.key, rectangle);
            int n2 = rectangle.x;
            int n3 = rectangle.y + fontMetrics.getAscent();
            int n4 = this.key.indexOf(46);
            if (n4 > 0 && !this.selected) {
                graphics.setColor(FlatUIUtils.getUIColor("Label.disabledForeground", FlatUIUtils.getUIColor("Label.disabledText", Color.gray)));
                if (n4 >= string.length()) {
                    FlatUIUtils.drawString(this, graphics, string, n2, n3);
                } else {
                    String string2 = string.substring(0, n4 + 1);
                    String string3 = string.substring(n4 + 1);
                    FlatUIUtils.drawString(this, graphics, string2, n2, n3);
                    graphics.setColor(this.getForeground());
                    FlatUIUtils.drawString(this, graphics, string3, n2 + fontMetrics.stringWidth(string2), n3);
                }
            } else {
                graphics.setColor(this.getForeground());
                FlatUIUtils.drawString(this, graphics, string, n2, n3);
            }
            if (this.isOverridden) {
                if (this.overriddenIcon == null) {
                    this.overriddenIcon = new FlatAbstractIcon(16, 16, null){

                        @Override
                        protected void paintIcon(Component component, Graphics2D graphics2D) {
                            graphics2D.setColor(FlatUIUtils.getUIColor("Actions.Red", Color.red));
                            graphics2D.setStroke(new BasicStroke(2.0f));
                            graphics2D.draw(FlatUIUtils.createPath(false, 3.0, 10.0, 8.0, 5.0, 13.0, 10.0));
                        }
                    };
                }
                this.overriddenIcon.paintIcon(this, graphics, this.getWidth() - this.overriddenIcon.getIconWidth(), (this.getHeight() - this.overriddenIcon.getIconHeight()) / 2);
            }
            this.paintSeparator(graphics);
        }
    }

    private static class Renderer
    extends DefaultTableCellRenderer {
        protected boolean selected;
        protected boolean first;

        private Renderer() {
        }

        protected void init(JTable jTable, String string, boolean bl2, int n2) {
            this.selected = bl2;
            this.first = false;
            if (n2 > 0) {
                String string2;
                String string3 = (String)jTable.getValueAt(n2 - 1, 0);
                int n3 = string.indexOf(46);
                this.first = n3 > 0 ? !string3.startsWith(string2 = string.substring(0, n3 + 1)) : string3.indexOf(46) > 0;
            }
        }

        protected void paintSeparator(Graphics graphics) {
            if (this.first && !this.selected) {
                graphics.setColor(FlatLaf.isLafDark() ? Color.gray : Color.lightGray);
                graphics.fillRect(0, 0, this.getWidth() - 1, 1);
            }
        }

        protected String layoutLabel(FontMetrics fontMetrics, String string, Rectangle rectangle) {
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            Insets insets = this.getInsets();
            Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n2 - (insets.left + insets.right), n3 - (insets.top + insets.bottom));
            Rectangle rectangle3 = new Rectangle();
            return SwingUtilities.layoutCompoundLabel(this, fontMetrics, string, null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle2, rectangle3, rectangle, this.getIconTextGap());
        }
    }

    private static class ItemsTableModel
    extends AbstractTableModel {
        private Item[] allItems;
        private Item[] items;
        private Predicate<Item> filter;

        ItemsTableModel(Item[] itemArray) {
            this.items = itemArray;
            this.allItems = itemArray;
        }

        void setItems(Item[] itemArray) {
            this.items = itemArray;
            this.allItems = itemArray;
            this.setFilter(this.filter);
        }

        void setFilter(Predicate<Item> predicate) {
            this.filter = predicate;
            if (predicate != null) {
                ArrayList<Item> arrayList = new ArrayList<Item>(this.allItems.length);
                for (Item item : this.allItems) {
                    if (!predicate.test(item)) continue;
                    arrayList.add(item);
                }
                this.items = arrayList.toArray(new Item[arrayList.size()]);
            } else {
                this.items = this.allItems;
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.items.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n2) {
            switch (n2) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return super.getColumnName(n2);
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Item.class;
                }
            }
            return super.getColumnClass(n2);
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            Item item = this.items[n2];
            switch (n3) {
                case 0: {
                    return item.key;
                }
                case 1: {
                    return item;
                }
            }
            return null;
        }
    }

    private static class Item {
        final String key;
        final Object value;
        final Object lafValue;
        final Object info;
        private String valueStr;

        Item(String string, Object object, Object object2, Object object3) {
            this.key = string;
            this.value = object;
            this.lafValue = object2;
            this.info = object3;
        }

        String getValueAsString() {
            if (this.valueStr == null) {
                this.valueStr = Item.valueAsString(this.value, this.info);
            }
            return this.valueStr;
        }

        static String valueAsString(Object object, Object object2) {
            if (object instanceof Color) {
                Color color = object2 instanceof Color[] ? ((Color[])object2)[0] : (Color)object;
                HSLColor hSLColor = new HSLColor(color);
                int n2 = Math.round(hSLColor.getHue());
                int n3 = Math.round(hSLColor.getSaturation());
                int n4 = Math.round(hSLColor.getLuminance());
                if (color.getAlpha() == 255) {
                    return String.format("%-9s HSL %3d %3d %3d", Item.color2hex(color), n2, n3, n4);
                }
                int n5 = Math.round(hSLColor.getAlpha() * 100.0f);
                return String.format("%-9s HSL %3d %3d %3d %2d", Item.color2hex(color), n2, n3, n4, n5);
            }
            if (object instanceof Insets) {
                Insets insets = (Insets)object;
                return insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right;
            }
            if (object instanceof Dimension) {
                Dimension dimension = (Dimension)object;
                return dimension.width + "," + dimension.height;
            }
            if (object instanceof Font) {
                Font font = (Font)object;
                String string = font.getFamily() + " " + font.getSize();
                if (font.isBold()) {
                    string = string + " bold";
                }
                if (font.isItalic()) {
                    string = string + " italic";
                }
                return string;
            }
            if (object instanceof Icon) {
                Icon icon = (Icon)object;
                return icon.getIconWidth() + "x" + icon.getIconHeight() + "   " + icon.getClass().getName();
            }
            if (object instanceof Border) {
                Border border = (Border)object;
                if (border instanceof FlatLineBorder) {
                    FlatLineBorder flatLineBorder = (FlatLineBorder)border;
                    return Item.valueAsString(flatLineBorder.getUnscaledBorderInsets(), null) + "  " + Item.color2hex(flatLineBorder.getLineColor()) + "  " + flatLineBorder.getLineThickness() + "    " + border.getClass().getName();
                }
                if (border instanceof EmptyBorder) {
                    Insets insets = border instanceof FlatEmptyBorder ? ((FlatEmptyBorder)border).getUnscaledBorderInsets() : ((EmptyBorder)border).getBorderInsets();
                    return Item.valueAsString(insets, null) + "    " + border.getClass().getName();
                }
                if (border instanceof FlatBorder || border instanceof FlatMarginBorder) {
                    return border.getClass().getName();
                }
                return String.valueOf(object);
            }
            if (object instanceof GrayFilter) {
                GrayFilter grayFilter = (GrayFilter)object;
                return grayFilter.getBrightness() + "," + grayFilter.getContrast() + " " + grayFilter.getAlpha() + "    " + grayFilter.getClass().getName();
            }
            if (object instanceof ActionMap) {
                ActionMap actionMap = (ActionMap)object;
                return "ActionMap (" + actionMap.size() + ")";
            }
            if (object instanceof InputMap) {
                InputMap inputMap = (InputMap)object;
                return "InputMap (" + inputMap.size() + ")";
            }
            if (object instanceof Object[]) {
                return Arrays.toString((Object[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            return String.valueOf(object);
        }

        private static String color2hex(Color color) {
            boolean bl2;
            int n2 = color.getRGB();
            boolean bl3 = color.getAlpha() != 255;
            boolean bl4 = bl2 = (n2 & 0xF0000000) == (n2 & 0xF000000) << 4 && (n2 & 0xF00000) == (n2 & 0xF0000) << 4 && (n2 & 0xF000) == (n2 & 0xF00) << 4 && (n2 & 0xF0) == (n2 & 0xF) << 4;
            if (bl2) {
                int n3 = (n2 & 0xF0000) >> 8 | (n2 & 0xF00) >> 4 | n2 & 0xF;
                return String.format(bl3 ? "#%03X%X" : "#%03X", n3, n2 >> 24 & 0xF);
            }
            return String.format(bl3 ? "#%06X%02X" : "#%06X", n2 & 0xFFFFFF, n2 >> 24 & 0xFF);
        }

        public String toString() {
            return this.getValueAsString();
        }
    }
}

