/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras.components;

import com.formdev.flatlaf.FlatLaf;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class FlatTriStateCheckBox
extends JCheckBox {
    private State state;
    private boolean allowIndeterminate = true;
    private boolean altStateCycleOrder = UIManager.getBoolean("FlatTriStateCheckBox.altStateCycleOrder");

    public FlatTriStateCheckBox() {
        this((String)null);
    }

    public FlatTriStateCheckBox(String string) {
        this(string, State.INDETERMINATE);
    }

    public FlatTriStateCheckBox(String string, State state) {
        super(string);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public boolean isSelected() {
                return FlatTriStateCheckBox.this.state != State.UNSELECTED;
            }

            @Override
            public void setSelected(boolean bl2) {
                FlatTriStateCheckBox.this.setState(FlatTriStateCheckBox.this.nextState(FlatTriStateCheckBox.this.state));
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
            }
        });
        this.setState(state);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (this.state == state) {
            return;
        }
        State state2 = this.state;
        this.state = state;
        this.putClientProperty("JButton.selectedState", state == State.INDETERMINATE ? "indeterminate" : null);
        this.firePropertyChange("state", (Object)state2, (Object)state);
        this.repaint();
    }

    protected State nextState(State state) {
        if (!this.altStateCycleOrder) {
            switch (state) {
                default: {
                    return this.allowIndeterminate ? State.INDETERMINATE : State.SELECTED;
                }
                case INDETERMINATE: {
                    return State.SELECTED;
                }
                case SELECTED: 
            }
            return State.UNSELECTED;
        }
        switch (state) {
            default: {
                return State.SELECTED;
            }
            case INDETERMINATE: {
                return State.UNSELECTED;
            }
            case SELECTED: 
        }
        return this.allowIndeterminate ? State.INDETERMINATE : State.UNSELECTED;
    }

    public Boolean getChecked() {
        switch (this.state) {
            default: {
                return false;
            }
            case INDETERMINATE: {
                return null;
            }
            case SELECTED: 
        }
        return true;
    }

    public void setChecked(Boolean bl2) {
        this.setState(bl2 == null ? State.INDETERMINATE : (bl2 != false ? State.SELECTED : State.UNSELECTED));
    }

    @Override
    public void setSelected(boolean bl2) {
        this.setState(bl2 ? State.SELECTED : State.UNSELECTED);
    }

    public boolean isIndeterminate() {
        return this.state == State.INDETERMINATE;
    }

    public void setIndeterminate(boolean bl2) {
        if (bl2) {
            this.setState(State.INDETERMINATE);
        } else if (this.state == State.INDETERMINATE) {
            this.setState(State.UNSELECTED);
        }
    }

    public boolean isAllowIndeterminate() {
        return this.allowIndeterminate;
    }

    public void setAllowIndeterminate(boolean bl2) {
        this.allowIndeterminate = bl2;
    }

    public boolean isAltStateCycleOrder() {
        return this.altStateCycleOrder;
    }

    public void setAltStateCycleOrder(boolean bl2) {
        this.altStateCycleOrder = bl2;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.state == State.INDETERMINATE && !this.isIndeterminateStateSupported()) {
            this.paintIndeterminateState(graphics);
        }
    }

    protected void paintIndeterminateState(Graphics graphics) {
        graphics.setColor(Color.magenta);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    protected boolean isIndeterminateStateSupported() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel instanceof FlatLaf || lookAndFeel.getClass().getName().equals("com.apple.laf.AquaLookAndFeel");
    }

    public static enum State {
        UNSELECTED,
        INDETERMINATE,
        SELECTED;

    }
}

