/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;

public class FlatAscendingSortIcon
extends FlatAbstractIcon {
    protected boolean chevron = FlatUIUtils.isChevron(UIManager.getString("Component.arrowType"));
    protected Color sortIconColor = UIManager.getColor("Table.sortIconColor");

    public FlatAscendingSortIcon() {
        super(10, 5, null);
    }

    @Override
    protected void paintIcon(Component component, Graphics2D graphics2D) {
        TableHeaderUI tableHeaderUI;
        boolean bl2 = this.chevron;
        Color color = this.sortIconColor;
        JTableHeader jTableHeader = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, component);
        if (jTableHeader != null && (tableHeaderUI = jTableHeader.getUI()) instanceof FlatTableHeaderUI) {
            FlatTableHeaderUI flatTableHeaderUI = (FlatTableHeaderUI)tableHeaderUI;
            if (flatTableHeaderUI.arrowType != null) {
                bl2 = FlatUIUtils.isChevron(flatTableHeaderUI.arrowType);
            }
            if (flatTableHeaderUI.sortIconColor != null) {
                color = flatTableHeaderUI.sortIconColor;
            }
        }
        graphics2D.setColor(color);
        this.paintArrow(component, graphics2D, bl2);
    }

    protected void paintArrow(Component component, Graphics2D graphics2D, boolean bl2) {
        if (bl2) {
            Path2D path2D = FlatUIUtils.createPath(false, 1.0, 4.0, 5.0, 0.0, 9.0, 4.0);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(path2D);
        } else {
            graphics2D.fill(FlatUIUtils.createPath(0.5, 5.0, 5.0, 0.0, 9.5, 5.0));
        }
    }
}

