/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FlatCheckBoxIcon
extends FlatAbstractIcon {
    protected final String style = UIManager.getString(this.getPropertyPrefix() + "icon.style");
    @FlatStylingSupport.Styleable
    protected float focusWidth = FlatCheckBoxIcon.getUIFloat("CheckBox.icon.focusWidth", UIManager.getInt("Component.focusWidth"), this.style);
    @FlatStylingSupport.Styleable
    protected Color focusColor = FlatUIUtils.getUIColor("CheckBox.icon.focusColor", UIManager.getColor("Component.focusColor"));
    @FlatStylingSupport.Styleable
    protected float borderWidth = FlatCheckBoxIcon.getUIFloat("CheckBox.icon.borderWidth", FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f), this.style);
    @FlatStylingSupport.Styleable
    protected float selectedBorderWidth = FlatCheckBoxIcon.getUIFloat("CheckBox.icon.selectedBorderWidth", Float.MIN_VALUE, this.style);
    @FlatStylingSupport.Styleable
    protected float disabledSelectedBorderWidth = FlatCheckBoxIcon.getUIFloat("CheckBox.icon.disabledSelectedBorderWidth", Float.MIN_VALUE, this.style);
    @FlatStylingSupport.Styleable
    protected int arc = FlatUIUtils.getUIInt("CheckBox.arc", 2);
    @FlatStylingSupport.Styleable
    protected Color borderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.borderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color background = FlatCheckBoxIcon.getUIColor("CheckBox.icon.background", this.style);
    @FlatStylingSupport.Styleable
    protected Color selectedBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.selectedBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color selectedBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.selectedBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color checkmarkColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.checkmarkColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color disabledBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.disabledBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color disabledBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.disabledBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.disabledSelectedBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.disabledSelectedBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color disabledCheckmarkColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.disabledCheckmarkColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color focusedBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.focusedBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color focusedBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.focusedBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color focusedSelectedBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.focusedSelectedBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color focusedSelectedBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.focusedSelectedBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color focusedCheckmarkColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.focusedCheckmarkColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.hoverBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color hoverBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.hoverBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color hoverSelectedBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.hoverSelectedBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color hoverSelectedBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.hoverSelectedBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color hoverCheckmarkColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.hoverCheckmarkColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color pressedBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.pressedBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color pressedBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.pressedBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color pressedSelectedBorderColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.pressedSelectedBorderColor", this.style);
    @FlatStylingSupport.Styleable
    protected Color pressedSelectedBackground = FlatCheckBoxIcon.getUIColor("CheckBox.icon.pressedSelectedBackground", this.style);
    @FlatStylingSupport.Styleable
    protected Color pressedCheckmarkColor = FlatCheckBoxIcon.getUIColor("CheckBox.icon.pressedCheckmarkColor", this.style);
    static final int ICON_SIZE = 15;

    protected String getPropertyPrefix() {
        return "CheckBox.";
    }

    protected static Color getUIColor(String string, String string2) {
        Color color;
        if (string2 != null && (color = UIManager.getColor(FlatCheckBoxIcon.styleKey(string, string2))) != null) {
            return color;
        }
        return UIManager.getColor(string);
    }

    protected static float getUIFloat(String string, float f2, String string2) {
        float f3;
        if (string2 != null && (f3 = FlatUIUtils.getUIFloat(FlatCheckBoxIcon.styleKey(string, string2), Float.MIN_VALUE)) != Float.MIN_VALUE) {
            return f3;
        }
        return FlatUIUtils.getUIFloat(string, f2);
    }

    private static String styleKey(String string, String string2) {
        return string.replace(".icon.", ".icon[" + string2 + "].");
    }

    public FlatCheckBoxIcon() {
        super(15, 15, null);
    }

    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    protected void paintIcon(Component component, Graphics2D graphics2D) {
        float f2;
        boolean bl2 = this.isIndeterminate(component);
        boolean bl3 = bl2 || this.isSelected(component);
        boolean bl4 = FlatUIUtils.isPermanentFocusOwner(component);
        float f3 = bl3 ? (this.disabledSelectedBorderWidth != Float.MIN_VALUE && !component.isEnabled() ? this.disabledSelectedBorderWidth : (this.selectedBorderWidth != Float.MIN_VALUE ? this.selectedBorderWidth : this.borderWidth)) : (f2 = this.borderWidth);
        if (bl4 && this.focusWidth > 0.0f && FlatButtonUI.isFocusPainted(component)) {
            graphics2D.setColor(this.getFocusColor(component));
            this.paintFocusBorder(component, graphics2D);
        }
        graphics2D.setColor(this.getBorderColor(component, bl3));
        this.paintBorder(component, graphics2D, f2);
        Color color = FlatUIUtils.deriveColor(this.getBackground(component, bl3), bl3 ? this.selectedBackground : this.background);
        if (color.getAlpha() < 255) {
            graphics2D.setColor(bl3 ? this.selectedBackground : this.background);
            this.paintBackground(component, graphics2D, f2);
        }
        graphics2D.setColor(color);
        this.paintBackground(component, graphics2D, f2);
        if (bl3) {
            graphics2D.setColor(this.getCheckmarkColor(component));
            if (bl2) {
                this.paintIndeterminate(component, graphics2D);
            } else {
                this.paintCheckmark(component, graphics2D);
            }
        }
    }

    protected void paintFocusBorder(Component component, Graphics2D graphics2D) {
        float f2 = 14.0f + this.focusWidth * 2.0f;
        float f3 = (float)this.arc + this.focusWidth * 2.0f;
        graphics2D.fill(new RoundRectangle2D.Float(-this.focusWidth + 1.0f, -this.focusWidth, f2, f2, f3, f3));
    }

    protected void paintBorder(Component component, Graphics2D graphics2D, float f2) {
        if (f2 == 0.0f) {
            return;
        }
        int n2 = this.arc;
        graphics2D.fillRoundRect(1, 0, 14, 14, n2, n2);
    }

    protected void paintBackground(Component component, Graphics2D graphics2D, float f2) {
        float f3 = f2;
        float f4 = 14.0f - f2 * 2.0f;
        float f5 = (float)this.arc - f2;
        graphics2D.fill(new RoundRectangle2D.Float(1.0f + f3, f3, f4, f4, f5, f5));
    }

    protected void paintCheckmark(Component component, Graphics2D graphics2D) {
        Path2D.Float float_ = new Path2D.Float(1, 3);
        float_.moveTo(4.5f, 7.5f);
        float_.lineTo(6.6f, 10.0f);
        float_.lineTo(11.25f, 3.5f);
        graphics2D.setStroke(new BasicStroke(1.9f, 1, 1));
        graphics2D.draw(float_);
    }

    protected void paintIndeterminate(Component component, Graphics2D graphics2D) {
        graphics2D.fill(new RoundRectangle2D.Float(3.75f, 5.75f, 8.5f, 2.5f, 2.0f, 2.0f));
    }

    protected boolean isIndeterminate(Component component) {
        return component instanceof JComponent && FlatClientProperties.clientPropertyEquals((JComponent)component, "JButton.selectedState", "indeterminate");
    }

    protected boolean isSelected(Component component) {
        return component instanceof AbstractButton && ((AbstractButton)component).isSelected();
    }

    public float getFocusWidth() {
        return this.focusWidth;
    }

    protected Color getFocusColor(Component component) {
        return this.focusColor;
    }

    protected Color getBorderColor(Component component, boolean bl2) {
        return FlatButtonUI.buttonStateColor(component, bl2 ? this.selectedBorderColor : this.borderColor, bl2 && this.disabledSelectedBorderColor != null ? this.disabledSelectedBorderColor : this.disabledBorderColor, bl2 && this.focusedSelectedBorderColor != null ? this.focusedSelectedBorderColor : this.focusedBorderColor, bl2 && this.hoverSelectedBorderColor != null ? this.hoverSelectedBorderColor : this.hoverBorderColor, bl2 && this.pressedSelectedBorderColor != null ? this.pressedSelectedBorderColor : this.pressedBorderColor);
    }

    protected Color getBackground(Component component, boolean bl2) {
        return FlatButtonUI.buttonStateColor(component, bl2 ? this.selectedBackground : this.background, bl2 && this.disabledSelectedBackground != null ? this.disabledSelectedBackground : this.disabledBackground, bl2 && this.focusedSelectedBackground != null ? this.focusedSelectedBackground : this.focusedBackground, bl2 && this.hoverSelectedBackground != null ? this.hoverSelectedBackground : this.hoverBackground, bl2 && this.pressedSelectedBackground != null ? this.pressedSelectedBackground : this.pressedBackground);
    }

    protected Color getCheckmarkColor(Component component) {
        return FlatButtonUI.buttonStateColor(component, this.checkmarkColor, this.disabledCheckmarkColor, this.focusedCheckmarkColor, this.hoverCheckmarkColor, this.pressedCheckmarkColor);
    }
}

