/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.Map;
import javax.swing.UIManager;

public class FlatHelpButtonIcon
extends FlatAbstractIcon {
    @FlatStylingSupport.Styleable
    protected int focusWidth = UIManager.getInt("Component.focusWidth");
    @FlatStylingSupport.Styleable
    protected Color focusColor = UIManager.getColor("Component.focusColor");
    @FlatStylingSupport.Styleable
    protected float innerFocusWidth = FlatUIUtils.getUIFloat("HelpButton.innerFocusWidth", FlatUIUtils.getUIFloat("Component.innerFocusWidth", 0.0f));
    @FlatStylingSupport.Styleable
    protected int borderWidth = FlatUIUtils.getUIInt("HelpButton.borderWidth", 1);
    @FlatStylingSupport.Styleable
    protected Color borderColor = UIManager.getColor("HelpButton.borderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledBorderColor = UIManager.getColor("HelpButton.disabledBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedBorderColor = UIManager.getColor("HelpButton.focusedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = UIManager.getColor("HelpButton.hoverBorderColor");
    @FlatStylingSupport.Styleable
    protected Color background = UIManager.getColor("HelpButton.background");
    @FlatStylingSupport.Styleable
    protected Color disabledBackground = UIManager.getColor("HelpButton.disabledBackground");
    @FlatStylingSupport.Styleable
    protected Color focusedBackground = UIManager.getColor("HelpButton.focusedBackground");
    @FlatStylingSupport.Styleable
    protected Color hoverBackground = UIManager.getColor("HelpButton.hoverBackground");
    @FlatStylingSupport.Styleable
    protected Color pressedBackground = UIManager.getColor("HelpButton.pressedBackground");
    @FlatStylingSupport.Styleable
    protected Color questionMarkColor = UIManager.getColor("HelpButton.questionMarkColor");
    @FlatStylingSupport.Styleable
    protected Color disabledQuestionMarkColor = UIManager.getColor("HelpButton.disabledQuestionMarkColor");

    public FlatHelpButtonIcon() {
        super(0, 0, null);
    }

    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    protected void paintIcon(Component component, Graphics2D graphics2D) {
        boolean bl2 = component == null || component.isEnabled();
        boolean bl3 = component != null && FlatUIUtils.isPermanentFocusOwner(component);
        float f2 = 0.5f;
        float f3 = this.iconSize() - 1;
        if (bl3 && FlatButtonUI.isFocusPainted(component)) {
            graphics2D.setColor(this.focusColor);
            graphics2D.fill(new Ellipse2D.Float(f2, f2, f3, f3));
        }
        graphics2D.setColor(FlatButtonUI.buttonStateColor(component, this.borderColor, this.disabledBorderColor, this.focusedBorderColor, this.hoverBorderColor, null));
        graphics2D.fill(new Ellipse2D.Float(f2 += (float)this.focusWidth, f2, f3 -= (float)(this.focusWidth * 2), f3));
        f2 += (float)this.borderWidth;
        f3 -= (float)(this.borderWidth * 2);
        if (this.innerFocusWidth > 0.0f && bl3 && FlatButtonUI.isFocusPainted(component)) {
            graphics2D.setColor(this.focusColor);
            graphics2D.fill(new Ellipse2D.Float(f2, f2, f3, f3));
            f2 += this.innerFocusWidth;
            f3 -= this.innerFocusWidth * 2.0f;
        }
        graphics2D.setColor(FlatUIUtils.deriveColor(FlatButtonUI.buttonStateColor(component, this.background, this.disabledBackground, this.focusedBackground, this.hoverBackground, this.pressedBackground), this.background));
        graphics2D.fill(new Ellipse2D.Float(f2, f2, f3, f3));
        Path2D.Float float_ = new Path2D.Float(1, 10);
        ((Path2D)float_).moveTo(8.0, 8.5);
        ((Path2D)float_).curveTo(8.25, 7.0, 9.66585007, 6.0, 11.0, 6.0);
        ((Path2D)float_).curveTo(12.5, 6.0, 14.0, 7.0, 14.0, 8.5);
        ((Path2D)float_).curveTo(14.0, 10.5, 11.0, 11.0, 11.0, 13.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        graphics2D.translate(this.focusWidth, this.focusWidth);
        graphics2D.setColor(bl2 ? this.questionMarkColor : this.disabledQuestionMarkColor);
        graphics2D.draw(float_);
        graphics2D.fill(new Ellipse2D.Float(9.8f, 14.8f, 2.4f, 2.4f));
    }

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.iconSize());
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.iconSize());
    }

    private int iconSize() {
        return 22 + this.focusWidth * 2;
    }
}

