/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.icons.FlatTreeCollapsedIcon;
import com.formdev.flatlaf.util.ColorFunctions;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.UIManager;

public class FlatTreeLeafIcon
extends FlatAbstractIcon {
    public FlatTreeLeafIcon() {
        super(16, 16, UIManager.getColor("Tree.icon.leafColor"));
    }

    @Override
    protected void paintIcon(Component component, Graphics2D graphics2D) {
        FlatTreeCollapsedIcon.setStyleColorFromTreeUI(component, graphics2D, flatTreeUI -> flatTreeUI.iconLeafColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics2D.draw(new RoundRectangle2D.Float(2.5f, 1.5f, 11.0f, 13.0f, 3.0f, 3.0f));
        graphics2D.setColor(ColorFunctions.fade(graphics2D.getColor(), 0.6f));
        graphics2D.draw(new Line2D.Float(5.5f, 5.5f, 10.5f, 5.5f));
        graphics2D.draw(new Line2D.Float(5.5f, 8.0f, 10.5f, 8.0f));
        graphics2D.draw(new Line2D.Float(5.5f, 10.5f, 10.5f, 10.5f));
    }
}

