/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public abstract class FlatWindowAbstractIcon
extends FlatAbstractIcon {
    private final int symbolHeight;
    private final Color hoverBackground;
    private final Color pressedBackground;

    protected FlatWindowAbstractIcon(String string) {
        this(FlatUIUtils.getSubUIDimension("TitlePane.buttonSize", string), FlatUIUtils.getSubUIInt("TitlePane.buttonSymbolHeight", string, 10), FlatUIUtils.getSubUIColor("TitlePane.buttonHoverBackground", string), FlatUIUtils.getSubUIColor("TitlePane.buttonPressedBackground", string));
    }

    protected FlatWindowAbstractIcon(Dimension dimension, int n2, Color color, Color color2) {
        super(dimension.width, dimension.height, null);
        this.symbolHeight = n2;
        this.hoverBackground = color;
        this.pressedBackground = color2;
    }

    @Override
    protected void paintIcon(Component component, Graphics2D graphics2D) {
        this.paintBackground(component, graphics2D);
        graphics2D.setColor(this.getForeground(component));
        HiDPIUtils.paintAtScale1x(graphics2D, 0, 0, this.width, this.height, this::paintIconAt1x);
    }

    protected abstract void paintIconAt1x(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);

    protected void paintBackground(Component component, Graphics2D graphics2D) {
        Color color = FlatButtonUI.buttonStateColor(component, null, null, null, this.hoverBackground, this.pressedBackground);
        if (color != null) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setColor(FlatUIUtils.deriveColor(color, component.getBackground()));
            graphics2D.fillRect(0, 0, this.width, this.height);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    protected Color getForeground(Component component) {
        return component.getForeground();
    }

    protected int getSymbolHeight() {
        return this.symbolHeight;
    }
}

