/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.icons.FlatHelpButtonIcon;
import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class FlatButtonUI
extends BasicButtonUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    protected int iconTextGap;
    protected Color background;
    protected Color foreground;
    protected Color startBackground;
    protected Color endBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedForeground;
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color pressedBackground;
    @FlatStylingSupport.Styleable
    protected Color pressedForeground;
    @FlatStylingSupport.Styleable
    protected Color selectedBackground;
    @FlatStylingSupport.Styleable
    protected Color selectedForeground;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledText;
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultBackground;
    protected Color defaultEndBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected boolean defaultBoldText;
    @FlatStylingSupport.Styleable
    protected boolean paintShadow;
    @FlatStylingSupport.Styleable
    protected int shadowWidth;
    @FlatStylingSupport.Styleable
    protected Color shadowColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultShadowColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarPressedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarPressedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarDisabledSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarDisabledSelectedForeground;
    @FlatStylingSupport.Styleable
    protected String buttonType;
    @FlatStylingSupport.Styleable
    protected boolean squareSize;
    @FlatStylingSupport.Styleable
    protected int minimumHeight;
    private Icon helpButtonIcon;
    private Insets defaultMargin;
    private final boolean shared;
    private boolean helpButtonIconShared = true;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;
    static final int TYPE_OTHER = -1;
    static final int TYPE_SQUARE = 0;
    static final int TYPE_ROUND_RECT = 1;
    private static Rectangle viewR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle iconR = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.canUseSharedUI(jComponent) && !FlatUIUtils.needsLightAWTPeer(jComponent) ? FlatUIUtils.createSharedUI(FlatButtonUI.class, () -> new FlatButtonUI(true)) : new FlatButtonUI(false);
    }

    protected FlatButtonUI(boolean bl2) {
        this.shared = bl2;
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((AbstractButton)jComponent);
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            this.minimumWidth = UIManager.getInt((String)object + "minimumWidth");
            this.iconTextGap = FlatUIUtils.getUIInt((String)object + "iconTextGap", 4);
            this.background = UIManager.getColor((String)object + "background");
            this.foreground = UIManager.getColor((String)object + "foreground");
            this.startBackground = UIManager.getColor((String)object + "startBackground");
            this.endBackground = UIManager.getColor((String)object + "endBackground");
            this.focusedBackground = UIManager.getColor((String)object + "focusedBackground");
            this.focusedForeground = UIManager.getColor((String)object + "focusedForeground");
            this.hoverBackground = UIManager.getColor((String)object + "hoverBackground");
            this.hoverForeground = UIManager.getColor((String)object + "hoverForeground");
            this.pressedBackground = UIManager.getColor((String)object + "pressedBackground");
            this.pressedForeground = UIManager.getColor((String)object + "pressedForeground");
            this.selectedBackground = UIManager.getColor((String)object + "selectedBackground");
            this.selectedForeground = UIManager.getColor((String)object + "selectedForeground");
            this.disabledBackground = UIManager.getColor((String)object + "disabledBackground");
            this.disabledText = UIManager.getColor((String)object + "disabledText");
            this.disabledSelectedBackground = UIManager.getColor((String)object + "disabledSelectedBackground");
            this.disabledSelectedForeground = UIManager.getColor((String)object + "disabledSelectedForeground");
            this.defaultBackground = FlatUIUtils.getUIColor("Button.default.startBackground", "Button.default.background");
            this.defaultEndBackground = UIManager.getColor("Button.default.endBackground");
            this.defaultForeground = UIManager.getColor("Button.default.foreground");
            this.defaultFocusedBackground = UIManager.getColor("Button.default.focusedBackground");
            this.defaultFocusedForeground = UIManager.getColor("Button.default.focusedForeground");
            this.defaultHoverBackground = UIManager.getColor("Button.default.hoverBackground");
            this.defaultHoverForeground = UIManager.getColor("Button.default.hoverForeground");
            this.defaultPressedBackground = UIManager.getColor("Button.default.pressedBackground");
            this.defaultPressedForeground = UIManager.getColor("Button.default.pressedForeground");
            this.defaultBoldText = UIManager.getBoolean("Button.default.boldText");
            this.paintShadow = UIManager.getBoolean("Button.paintShadow");
            this.shadowWidth = FlatUIUtils.getUIInt("Button.shadowWidth", 2);
            this.shadowColor = UIManager.getColor("Button.shadowColor");
            this.defaultShadowColor = UIManager.getColor("Button.default.shadowColor");
            this.toolbarHoverBackground = UIManager.getColor((String)object + "toolbar.hoverBackground");
            this.toolbarHoverForeground = UIManager.getColor((String)object + "toolbar.hoverForeground");
            this.toolbarPressedBackground = UIManager.getColor((String)object + "toolbar.pressedBackground");
            this.toolbarPressedForeground = UIManager.getColor((String)object + "toolbar.pressedForeground");
            this.toolbarSelectedBackground = UIManager.getColor((String)object + "toolbar.selectedBackground");
            this.toolbarSelectedForeground = UIManager.getColor((String)object + "toolbar.selectedForeground");
            this.toolbarDisabledSelectedBackground = UIManager.getColor((String)object + "toolbar.disabledSelectedBackground");
            this.toolbarDisabledSelectedForeground = UIManager.getColor((String)object + "toolbar.disabledSelectedForeground");
            this.helpButtonIcon = UIManager.getIcon("HelpButton.icon");
            this.defaultMargin = UIManager.getInsets((String)object + "margin");
            this.helpButtonIconShared = true;
            this.defaults_initialized = true;
        }
        if (this.startBackground != null && ((object = abstractButton.getBackground()) == null || object instanceof UIResource)) {
            abstractButton.setBackground(this.startBackground);
        }
        LookAndFeel.installProperty(abstractButton, "opaque", false);
        LookAndFeel.installProperty(abstractButton, "iconTextGap", UIScale.scale(this.iconTextGap));
        MigLayoutVisualPadding.install(abstractButton);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(abstractButton);
        this.defaults_initialized = false;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new FlatButtonListener(abstractButton);
    }

    protected void propertyChange(AbstractButton abstractButton, PropertyChangeEvent propertyChangeEvent) {
        switch (propertyChangeEvent.getPropertyName()) {
            case "html": {
                FlatHTML.updateRendererCSSFontBaseSize(abstractButton);
                break;
            }
            case "JButton.squareSize": 
            case "JComponent.minimumWidth": 
            case "JComponent.minimumHeight": {
                abstractButton.revalidate();
                break;
            }
            case "JButton.buttonType": {
                abstractButton.revalidate();
                HiDPIUtils.repaint(abstractButton);
                break;
            }
            case "JComponent.outline": {
                HiDPIUtils.repaint(abstractButton);
                break;
            }
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                if (this.shared && FlatStylingSupport.hasStyleProperty(abstractButton)) {
                    abstractButton.updateUI();
                } else {
                    this.installStyle(abstractButton);
                }
                abstractButton.revalidate();
                HiDPIUtils.repaint(abstractButton);
            }
        }
    }

    protected void installStyle(AbstractButton abstractButton) {
        try {
            this.applyStyle(abstractButton, FlatStylingSupport.getResolvedStyle(abstractButton, this.getStyleType()));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    String getStyleType() {
        return "Button";
    }

    protected void applyStyle(AbstractButton abstractButton, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(abstractButton, (String)string, object));
    }

    protected Object applyStyleProperty(AbstractButton abstractButton, String string, Object object) {
        if (string.startsWith("help.")) {
            if (!(this.helpButtonIcon instanceof FlatHelpButtonIcon)) {
                return new FlatStylingSupport.UnknownStyleException(string);
            }
            if (this.helpButtonIconShared) {
                this.helpButtonIcon = FlatStylingSupport.cloneIcon(this.helpButtonIcon);
                this.helpButtonIconShared = false;
            }
            string = string.substring("help.".length());
            return ((FlatHelpButtonIcon)this.helpButtonIcon).applyStyleProperty(string, object);
        }
        if ("iconTextGap".equals(string) && object instanceof Integer) {
            object = UIScale.scale((Integer)object);
        }
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, abstractButton, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        Map<String, Class<?>> map = FlatStylingSupport.getAnnotatedStyleableInfos(this, jComponent.getBorder());
        if (this.helpButtonIcon instanceof FlatHelpButtonIcon) {
            FlatStylingSupport.putAllPrefixKey(map, "help.", ((FlatHelpButtonIcon)this.helpButtonIcon).getStyleableInfos());
        }
        return map;
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.startsWith("help.")) {
            return this.helpButtonIcon instanceof FlatHelpButtonIcon ? ((FlatHelpButtonIcon)this.helpButtonIcon).getStyleableValue(string.substring("help.".length())) : null;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, jComponent.getBorder(), string);
    }

    static boolean isContentAreaFilled(Component component) {
        return !(component instanceof AbstractButton) || ((AbstractButton)component).isContentAreaFilled();
    }

    public static boolean isFocusPainted(Component component) {
        return !(component instanceof AbstractButton) || ((AbstractButton)component).isFocusPainted();
    }

    static boolean isDefaultButton(Component component) {
        return component instanceof JButton && ((JButton)component).isDefaultButton();
    }

    static boolean isIconOnlyOrSingleCharacterButton(Component component) {
        if (!(component instanceof JButton) && !(component instanceof JToggleButton)) {
            return false;
        }
        Icon icon = ((AbstractButton)component).getIcon();
        String string = ((AbstractButton)component).getText();
        return icon != null && (string == null || string.isEmpty()) || icon == null && string != null && ("...".equals(string) || string.length() == 1 || string.length() == 2 && Character.isSurrogatePair(string.charAt(0), string.charAt(1)));
    }

    static int getButtonType(Component component) {
        if (!(component instanceof AbstractButton)) {
            return -1;
        }
        String string = FlatButtonUI.getButtonTypeStr((AbstractButton)component);
        if (string == null) {
            return -1;
        }
        switch (string) {
            case "square": {
                return 0;
            }
            case "roundRect": {
                return 1;
            }
        }
        return -1;
    }

    static boolean isHelpButton(Component component) {
        return component instanceof JButton && "help".equals(FlatButtonUI.getButtonTypeStr((JButton)component));
    }

    static boolean isToolBarButton(Component component) {
        return component.getParent() instanceof JToolBar || component instanceof AbstractButton && "toolBarButton".equals(FlatButtonUI.getButtonTypeStr((AbstractButton)component));
    }

    static boolean isBorderlessButton(Component component) {
        return component instanceof AbstractButton && "borderless".equals(FlatButtonUI.getButtonTypeStr((AbstractButton)component));
    }

    static String getButtonTypeStr(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty("JButton.buttonType");
        if (object instanceof String) {
            return (String)object;
        }
        ButtonUI buttonUI = abstractButton.getUI();
        return buttonUI instanceof FlatButtonUI ? ((FlatButtonUI)buttonUI).buttonType : null;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        if (FlatButtonUI.isHelpButton(jComponent)) {
            this.helpButtonIcon.paintIcon(jComponent, graphics, 0, 0);
            return;
        }
        if (FlatButtonUI.isContentAreaFilled(jComponent)) {
            this.paintBackground(graphics, jComponent);
        }
        this.paint(graphics, jComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        Color color = this.getBackground(jComponent);
        if (color == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Color color2;
            Serializable serializable;
            JTextField jTextField;
            FlatUIUtils.setRenderingHints(graphics2D);
            boolean bl2 = FlatButtonUI.isDefaultButton(jComponent);
            boolean bl3 = FlatButtonUI.isToolBarButton(jComponent);
            float f2 = bl3 ? 0.0f : FlatUIUtils.getBorderFocusWidth(jComponent);
            float f3 = FlatUIUtils.getBorderArc(jComponent);
            float f4 = 0.0f;
            if (bl3 && FlatClientProperties.clientProperty(jComponent, "FlatLaf.styleClass", "", String.class).contains("inTextField") && (jTextField = (JTextField)SwingUtilities.getAncestorOfClass(JTextField.class, jComponent)) != null) {
                f4 = FlatUIUtils.getBorderArc(jTextField);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = jComponent.getWidth();
            int n5 = jComponent.getHeight();
            if (bl3 && jComponent.getBorder() instanceof FlatButtonBorder) {
                serializable = UIScale.scale(((FlatButtonBorder)jComponent.getBorder()).toolbarSpacingInsets);
                n2 += ((Insets)serializable).left;
                n3 += ((Insets)serializable).top;
                n4 -= ((Insets)serializable).left + ((Insets)serializable).right;
                n5 -= ((Insets)serializable).top + ((Insets)serializable).bottom;
                f4 -= (float)(((Insets)serializable).top + ((Insets)serializable).bottom);
            }
            if (f3 < f4) {
                f3 = f4;
            }
            Color color3 = serializable = bl2 ? this.defaultShadowColor : this.shadowColor;
            if (!(!this.paintShadow || serializable == null || this.shadowWidth <= 0 || !(f2 > 0.0f) || !jComponent.isEnabled() || bl3 || FlatButtonUI.isBorderlessButton(jComponent) || FlatButtonUI.isFocusPainted(jComponent) && FlatUIUtils.isPermanentFocusOwner(jComponent))) {
                graphics2D.setColor((Color)serializable);
                graphics2D.fill(new RoundRectangle2D.Float(f2, f2 + UIScale.scale((float)this.shadowWidth), (float)n4 - f2 * 2.0f, (float)n5 - f2 * 2.0f, f3, f3));
            }
            Color color4 = bl2 ? this.defaultBackground : this.startBackground;
            Color color5 = color2 = bl2 ? this.defaultEndBackground : this.endBackground;
            if (color == color4 && color2 != null && !color4.equals(color2)) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color4, 0.0f, n5, color2));
            } else {
                graphics2D.setColor(FlatUIUtils.deriveColor(color, this.getBackgroundBase(jComponent, bl2)));
            }
            FlatUIUtils.paintComponentBackground(graphics2D, n2, n3, n4, n5, f2, f3);
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        graphics = FlatLabelUI.createGraphicsHTMLTextYCorrection(graphics, jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = FlatButtonUI.layout(abstractButton, abstractButton.getFontMetrics(abstractButton.getFont()), abstractButton.getWidth(), abstractButton.getHeight());
        this.clearTextShiftOffset();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, abstractButton, iconR);
        }
        if (string != null && !string.isEmpty()) {
            View view = (View)abstractButton.getClientProperty("html");
            if (view != null) {
                if (abstractButton.isEnabled()) {
                    FlatHTML.updateRendererCSSForeground(view, this.getForeground(abstractButton));
                }
                view.paint(graphics, textR);
            } else {
                this.paintText(graphics, abstractButton, textR, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewR, textR, iconR);
        }
    }

    @Override
    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n2 = this.defaultBoldPlainWidthDiff(jComponent) / 2;
        if (n2 > 0) {
            boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
            switch (((AbstractButton)jComponent).getHorizontalTextPosition()) {
                case 4: {
                    rectangle.x -= n2;
                    break;
                }
                case 2: {
                    rectangle.x += n2;
                    break;
                }
                case 11: {
                    rectangle.x = rectangle.x - (bl2 ? n2 : -n2);
                    break;
                }
                case 10: {
                    rectangle.x = rectangle.x + (bl2 ? n2 : -n2);
                }
            }
        }
        super.paintIcon(graphics, jComponent, rectangle);
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        if (FlatButtonUI.isHelpButton(abstractButton)) {
            return;
        }
        if (this.defaultBoldText && FlatButtonUI.isDefaultButton(abstractButton) && abstractButton.getFont() instanceof UIResource) {
            Font font = graphics.getFont().deriveFont(1);
            graphics.setFont(font);
            int n2 = abstractButton.getFontMetrics(font).stringWidth(string);
            if (n2 > rectangle.width) {
                rectangle.x -= (n2 - rectangle.width) / 2;
                rectangle.width = n2;
            }
        }
        FlatButtonUI.paintText(graphics, abstractButton, rectangle, string, this.getForeground(abstractButton));
    }

    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, Color color) {
        FontMetrics fontMetrics = abstractButton.getFontMetrics(abstractButton.getFont());
        int n2 = FlatLaf.isShowMnemonics() ? abstractButton.getDisplayedMnemonicIndex() : -1;
        graphics.setColor(color);
        FlatUIUtils.drawStringUnderlineCharAt(abstractButton, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected Color getBackground(JComponent jComponent) {
        boolean bl2;
        boolean bl3 = bl2 = FlatButtonUI.isToolBarButton(jComponent) || FlatButtonUI.isBorderlessButton(jComponent);
        if (((AbstractButton)jComponent).isSelected()) {
            return FlatButtonUI.buttonStateColor(jComponent, bl2 ? this.toolbarSelectedBackground : this.selectedBackground, bl2 ? (this.toolbarDisabledSelectedBackground != null ? this.toolbarDisabledSelectedBackground : this.toolbarSelectedBackground) : this.disabledSelectedBackground, null, null, bl2 ? this.toolbarPressedBackground : this.pressedBackground);
        }
        if (bl2) {
            Color color = jComponent.getBackground();
            return FlatButtonUI.buttonStateColor(jComponent, this.isCustomBackground(color) ? color : null, null, null, this.toolbarHoverBackground, this.toolbarPressedBackground);
        }
        boolean bl4 = FlatButtonUI.isDefaultButton(jComponent);
        return FlatButtonUI.buttonStateColor(jComponent, this.getBackgroundBase(jComponent, bl4), this.disabledBackground, this.isCustomBackground(jComponent.getBackground()) ? null : (bl4 ? this.defaultFocusedBackground : this.focusedBackground), bl4 ? this.defaultHoverBackground : this.hoverBackground, bl4 ? this.defaultPressedBackground : this.pressedBackground);
    }

    protected Color getBackgroundBase(JComponent jComponent, boolean bl2) {
        if (FlatUIUtils.isAWTPeer(jComponent)) {
            return this.background;
        }
        Color color = jComponent.getBackground();
        if (this.isCustomBackground(color)) {
            return color;
        }
        return bl2 ? this.defaultBackground : color;
    }

    protected boolean isCustomBackground(Color color) {
        return color != this.background && (this.startBackground == null || color != this.startBackground);
    }

    public static Color buttonStateColor(Component component, Color color, Color color2, Color color3, Color color4, Color color5) {
        if (component == null) {
            return color;
        }
        if (!component.isEnabled()) {
            return color2;
        }
        if (component instanceof AbstractButton) {
            ButtonModel buttonModel = ((AbstractButton)component).getModel();
            if (color5 != null && buttonModel.isPressed()) {
                return color5;
            }
            if (color4 != null && buttonModel.isRollover()) {
                return color4;
            }
        }
        if (color3 != null && FlatButtonUI.isFocusPainted(component) && FlatUIUtils.isPermanentFocusOwner(component)) {
            return color3;
        }
        return color;
    }

    protected Color getForeground(JComponent jComponent) {
        boolean bl2;
        Color color = jComponent.getForeground();
        boolean bl3 = bl2 = FlatButtonUI.isToolBarButton(jComponent) || FlatButtonUI.isBorderlessButton(jComponent);
        if (((AbstractButton)jComponent).isSelected()) {
            return FlatButtonUI.buttonStateColor(jComponent, bl2 ? (this.toolbarSelectedForeground != null ? this.toolbarSelectedForeground : color) : (this.isCustomForeground(color) ? color : this.selectedForeground), bl2 ? (this.toolbarDisabledSelectedForeground != null ? this.toolbarDisabledSelectedForeground : this.disabledText) : (this.disabledSelectedForeground != null ? this.disabledSelectedForeground : this.disabledText), null, null, bl2 ? this.toolbarPressedForeground : this.pressedForeground);
        }
        if (bl2) {
            return FlatButtonUI.buttonStateColor(jComponent, color, this.disabledText, null, this.toolbarHoverForeground, this.toolbarPressedForeground);
        }
        boolean bl4 = FlatButtonUI.isDefaultButton(jComponent);
        return FlatButtonUI.buttonStateColor(jComponent, this.getForegroundBase(jComponent, bl4), this.disabledText, this.isCustomForeground(color) ? null : (bl4 ? this.defaultFocusedForeground : this.focusedForeground), bl4 ? this.defaultHoverForeground : this.hoverForeground, bl4 ? this.defaultPressedForeground : this.pressedForeground);
    }

    protected Color getForegroundBase(JComponent jComponent, boolean bl2) {
        Color color = jComponent.getForeground();
        if (this.isCustomForeground(color)) {
            return color;
        }
        return bl2 ? this.defaultForeground : color;
    }

    protected boolean isCustomForeground(Color color) {
        return color != this.foreground;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (FlatButtonUI.isHelpButton(jComponent)) {
            return new Dimension(this.helpButtonIcon.getIconWidth(), this.helpButtonIcon.getIconHeight());
        }
        Dimension dimension = super.getPreferredSize(jComponent);
        if (dimension == null) {
            return null;
        }
        dimension.width += this.defaultBoldPlainWidthDiff(jComponent);
        boolean bl2 = FlatButtonUI.isIconOnlyOrSingleCharacterButton(jComponent);
        if (FlatClientProperties.clientPropertyBoolean(jComponent, "JButton.squareSize", this.squareSize)) {
            dimension.width = dimension.height = Math.max(dimension.width, dimension.height);
        } else if (bl2 && ((AbstractButton)jComponent).getIcon() == null) {
            dimension.width = Math.max(dimension.width, dimension.height);
        } else if (!bl2 && !FlatButtonUI.isToolBarButton(jComponent) && jComponent.getBorder() instanceof FlatButtonBorder && this.hasDefaultMargins(jComponent)) {
            int n2 = Math.round(FlatUIUtils.getBorderFocusWidth(jComponent) * 2.0f);
            dimension.width = Math.max(dimension.width, UIScale.scale(FlatUIUtils.minimumWidth(jComponent, this.minimumWidth)) + n2);
            dimension.height = Math.max(dimension.height, UIScale.scale(FlatUIUtils.minimumHeight(jComponent, this.minimumHeight)) + n2);
        }
        return dimension;
    }

    private int defaultBoldPlainWidthDiff(JComponent jComponent) {
        if (this.defaultBoldText && FlatButtonUI.isDefaultButton(jComponent) && jComponent.getFont() instanceof UIResource) {
            int n2;
            String string = ((AbstractButton)jComponent).getText();
            if (string == null || string.isEmpty()) {
                return 0;
            }
            Font font = jComponent.getFont();
            Font font2 = font.deriveFont(1);
            int n3 = jComponent.getFontMetrics(font2).stringWidth(string);
            if (n3 > (n2 = jComponent.getFontMetrics(font).stringWidth(string))) {
                return n3 - n2;
            }
        }
        return 0;
    }

    private boolean hasDefaultMargins(JComponent jComponent) {
        Insets insets = ((AbstractButton)jComponent).getMargin();
        return insets instanceof UIResource && Objects.equals(insets, this.defaultMargin);
    }

    @Override
    public int getBaseline(JComponent jComponent, int n2, int n3) {
        return FlatButtonUI.getBaselineImpl(jComponent, n2, n3);
    }

    static int getBaselineImpl(JComponent jComponent, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        if (string == null || string.isEmpty()) {
            return -1;
        }
        FontMetrics fontMetrics = abstractButton.getFontMetrics(abstractButton.getFont());
        FlatButtonUI.layout(abstractButton, fontMetrics, n2, n3);
        View view = (View)abstractButton.getClientProperty("html");
        if (view != null) {
            int n4 = BasicHTML.getHTMLBaseline(view, FlatButtonUI.textR.width, FlatButtonUI.textR.height);
            return n4 >= 0 ? FlatButtonUI.textR.y + n4 : n4;
        }
        return FlatButtonUI.textR.y + fontMetrics.getAscent();
    }

    private static String layout(AbstractButton abstractButton, FontMetrics fontMetrics, int n2, int n3) {
        Insets insets = abstractButton.getInsets();
        viewR.setBounds(insets.left, insets.top, n2 - insets.left - insets.right, n3 - insets.top - insets.bottom);
        textR.setBounds(0, 0, 0, 0);
        iconR.setBounds(0, 0, 0, 0);
        String string = abstractButton.getText();
        return SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewR, iconR, textR, string != null ? abstractButton.getIconTextGap() : 0);
    }

    protected class FlatButtonListener
    extends BasicButtonListener {
        private final AbstractButton b;

        protected FlatButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            this.b = abstractButton;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            FlatButtonUI.this.propertyChange(this.b, propertyChangeEvent);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JToolBar jToolBar;
            ToolBarUI toolBarUI;
            HiDPIUtils.repaint(this.b);
            AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
            Container container = abstractButton.getParent();
            if (container instanceof JToolBar && (toolBarUI = (jToolBar = (JToolBar)container).getUI()) instanceof FlatToolBarUI) {
                ((FlatToolBarUI)toolBarUI).repaintButtonGroup(abstractButton);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            HiDPIUtils.repaint(this.b);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            HiDPIUtils.repaint(this.b);
        }
    }
}

