/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.icons.FlatCheckBoxMenuItemIcon;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatListUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

@FlatStylingSupport.StyleableField(cls=BasicComboBoxUI.class, key="padding")
public class FlatComboBoxUI
extends BasicComboBoxUI
implements FlatStylingSupport.StyleableLookupProvider,
FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    @FlatStylingSupport.Styleable
    protected int editorColumns;
    @FlatStylingSupport.Styleable
    protected String buttonStyle;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    private Color background;
    @FlatStylingSupport.Styleable
    protected Color editableBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color buttonBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonEditableBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonFocusedBackground;
    @FlatStylingSupport.Styleable
    protected float buttonSeparatorWidth;
    @FlatStylingSupport.Styleable
    protected Color buttonSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedArrowColor;
    @FlatStylingSupport.Styleable
    protected Color popupBackground;
    @FlatStylingSupport.Styleable
    protected Insets popupInsets;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    private MouseListener hoverListener;
    protected boolean hover;
    protected boolean pressed;
    private CellPaddingBorder paddingBorder;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setKeySelectionManager(new FlatKeySelectionManager(this.comboBox.getKeySelectionManager()));
        this.installStyle();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hoverListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.hover = true;
                this.repaintArrowButton();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.hover = false;
                this.repaintArrowButton();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.pressed = true;
                this.repaintArrowButton();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FlatComboBoxUI.this.pressed = false;
                this.repaintArrowButton();
            }

            private void repaintArrowButton() {
                if (FlatComboBoxUI.this.arrowButton != null && !FlatComboBoxUI.this.comboBox.isEditable()) {
                    HiDPIUtils.repaint(FlatComboBoxUI.this.arrowButton);
                }
            }
        };
        this.comboBox.addMouseListener(this.hoverListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.hoverListener);
        this.hoverListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.comboBox, "opaque", false);
        this.minimumWidth = UIManager.getInt("ComboBox.minimumWidth");
        this.editorColumns = UIManager.getInt("ComboBox.editorColumns");
        this.buttonStyle = UIManager.getString("ComboBox.buttonStyle");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.background = UIManager.getColor("ComboBox.background");
        this.editableBackground = UIManager.getColor("ComboBox.editableBackground");
        this.focusedBackground = UIManager.getColor("ComboBox.focusedBackground");
        this.disabledBackground = UIManager.getColor("ComboBox.disabledBackground");
        this.disabledForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.buttonBackground = UIManager.getColor("ComboBox.buttonBackground");
        this.buttonFocusedBackground = UIManager.getColor("ComboBox.buttonFocusedBackground");
        this.buttonEditableBackground = UIManager.getColor("ComboBox.buttonEditableBackground");
        this.buttonSeparatorWidth = FlatUIUtils.getUIFloat("ComboBox.buttonSeparatorWidth", FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f));
        this.buttonSeparatorColor = UIManager.getColor("ComboBox.buttonSeparatorColor");
        this.buttonDisabledSeparatorColor = UIManager.getColor("ComboBox.buttonDisabledSeparatorColor");
        this.buttonArrowColor = UIManager.getColor("ComboBox.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("ComboBox.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("ComboBox.buttonHoverArrowColor");
        this.buttonPressedArrowColor = UIManager.getColor("ComboBox.buttonPressedArrowColor");
        this.popupBackground = UIManager.getColor("ComboBox.popupBackground");
        this.popupInsets = UIManager.getInsets("ComboBox.popupInsets");
        this.selectionInsets = UIManager.getInsets("ComboBox.selectionInsets");
        this.selectionArc = UIManager.getInt("ComboBox.selectionArc");
        int n2 = UIManager.getInt("ComboBox.maximumRowCount");
        if (n2 > 0 && n2 != 8 && this.comboBox.getMaximumRowCount() == 8) {
            this.comboBox.setMaximumRowCount(n2);
        }
        this.paddingBorder = new CellPaddingBorder(this.padding);
        MigLayoutVisualPadding.install(this.comboBox);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.editableBackground = null;
        this.focusedBackground = null;
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.buttonBackground = null;
        this.buttonEditableBackground = null;
        this.buttonFocusedBackground = null;
        this.buttonSeparatorColor = null;
        this.buttonDisabledSeparatorColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        this.buttonPressedArrowColor = null;
        this.popupBackground = null;
        this.paddingBorder.uninstall();
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(this.comboBox);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                if (FlatComboBoxUI.this.arrowButton != null && FlatComboBoxUI.this.comboBox.getFont() != null) {
                    FontMetrics fontMetrics = FlatComboBoxUI.this.comboBox.getFontMetrics(FlatComboBoxUI.this.comboBox.getFont());
                    int n2 = fontMetrics.getHeight() + UIScale.scale(((FlatComboBoxUI)FlatComboBoxUI.this).padding.top) + UIScale.scale(((FlatComboBoxUI)FlatComboBoxUI.this).padding.bottom);
                    int n3 = n2 * 3 / 4;
                    Insets insets = FlatComboBoxUI.this.getInsets();
                    int n4 = Math.min(Math.max(container.getHeight() - insets.top - insets.bottom, n3), n2);
                    if (n4 != FlatComboBoxUI.this.arrowButton.getWidth()) {
                        int n5 = FlatComboBoxUI.this.comboBox.getComponentOrientation().isLeftToRight() ? FlatComboBoxUI.this.arrowButton.getWidth() - n4 : 0;
                        FlatComboBoxUI.this.arrowButton.setBounds(FlatComboBoxUI.this.arrowButton.getX() + n5, FlatComboBoxUI.this.arrowButton.getY(), n4, FlatComboBoxUI.this.arrowButton.getHeight());
                        if (FlatComboBoxUI.this.editor != null) {
                            FlatComboBoxUI.this.editor.setBounds(FlatComboBoxUI.this.rectangleForCurrentValue());
                        }
                    }
                }
            }
        };
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                if (FlatComboBoxUI.this.comboBox != null) {
                    HiDPIUtils.repaint(FlatComboBoxUI.this.comboBox);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                if (FlatComboBoxUI.this.comboBox != null) {
                    HiDPIUtils.repaint(FlatComboBoxUI.this.comboBox);
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (this.editor != null && (object == this.comboBox && string == "foreground" || object == this.editor && string == "enabled")) {
                this.updateEditorColors();
            } else if (this.editor != null && object == this.comboBox && string == "componentOrientation") {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                this.editor.applyComponentOrientation(componentOrientation);
            } else {
                switch (string) {
                    case "JTextField.placeholderText": {
                        if (this.editor == null) break;
                        HiDPIUtils.repaint(this.editor);
                        break;
                    }
                    case "JComponent.roundRect": 
                    case "JComponent.outline": {
                        HiDPIUtils.repaint(this.comboBox);
                        break;
                    }
                    case "JComponent.minimumWidth": {
                        this.comboBox.revalidate();
                        break;
                    }
                    case "FlatLaf.style": 
                    case "FlatLaf.styleClass": {
                        this.installStyle();
                        this.comboBox.revalidate();
                        HiDPIUtils.repaint(this.comboBox);
                    }
                }
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        return new FlatComboPopup(this.comboBox);
    }

    @Override
    protected void configureEditor() {
        Serializable serializable;
        super.configureEditor();
        if (this.editor instanceof JTextField) {
            serializable = (JTextField)this.editor;
            serializable.setColumns(this.editorColumns);
            Border border = serializable.getBorder();
            if (border == null || border instanceof UIResource) {
                serializable.setBorder(BorderFactory.createEmptyBorder());
            }
        }
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setOpaque(false);
        }
        this.editor.applyComponentOrientation(this.comboBox.getComponentOrientation());
        this.updateEditorPadding();
        this.updateEditorColors();
        if (SystemInfo.isMacOS && this.editor instanceof JTextComponent) {
            serializable = ((JTextComponent)this.editor).getInputMap();
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("UP"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("KP_UP"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("DOWN"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("KP_DOWN"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("HOME"));
            new EditorDelegateAction((InputMap)serializable, KeyStroke.getKeyStroke("END"));
        }
    }

    private void updateEditorPadding() {
        if (!(this.editor instanceof JTextField)) {
            return;
        }
        JTextField jTextField = (JTextField)this.editor;
        Insets insets = jTextField.getInsets();
        Insets insets2 = this.padding;
        if (insets.top != 0 || insets.left != 0 || insets.bottom != 0 || insets.right != 0) {
            insets2 = new Insets(UIScale.unscale(Math.max(UIScale.scale(this.padding.top) - insets.top, 0)), UIScale.unscale(Math.max(UIScale.scale(this.padding.left) - insets.left, 0)), UIScale.unscale(Math.max(UIScale.scale(this.padding.bottom) - insets.bottom, 0)), UIScale.unscale(Math.max(UIScale.scale(this.padding.right) - insets.right, 0)));
        }
        jTextField.putClientProperty("JTextField.padding", insets2);
    }

    private void updateEditorColors() {
        boolean bl2 = this.editor instanceof JTextComponent;
        this.editor.setForeground(FlatUIUtils.nonUIResource(this.getForeground(bl2 || this.editor.isEnabled())));
        if (bl2) {
            ((JTextComponent)this.editor).setDisabledTextColor(FlatUIUtils.nonUIResource(this.getForeground(false)));
        }
    }

    @Override
    protected JButton createArrowButton() {
        return new FlatComboBoxButton();
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.comboBox, "ComboBox"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        Insets insets = this.padding;
        int n2 = this.editorColumns;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (!this.padding.equals(insets)) {
            this.paddingBorder.padding = this.padding;
            this.updateEditorPadding();
        }
        if (this.arrowButton instanceof FlatComboBoxButton) {
            ((FlatComboBoxButton)this.arrowButton).updateStyle();
        }
        if (this.popup instanceof FlatComboPopup) {
            ((FlatComboPopup)this.popup).updateStyle();
        }
        if (this.editorColumns != n2 && this.editor instanceof JTextField) {
            ((JTextField)this.editor).setColumns(this.editorColumns);
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.comboBox, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.comboBox.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.comboBox.getBorder(), string);
    }

    @Override
    public MethodHandles.Lookup getLookupForStyling() {
        return MethodHandles.lookup();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f2 = FlatUIUtils.getBorderFocusWidth(jComponent);
        float f3 = FlatUIUtils.getBorderArc(jComponent);
        boolean bl2 = true;
        boolean bl3 = jComponent.getParent() instanceof CellRendererPane;
        if (bl3) {
            f2 = 0.0f;
            f3 = 0.0f;
            bl2 = this.isCellRendererBackgroundChanged();
        }
        if (jComponent.isOpaque() && (f2 > 0.0f || f3 > 0.0f)) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics2D);
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        int n4 = this.arrowButton.getX();
        int n5 = this.arrowButton.getWidth();
        boolean bl4 = (this.comboBox.isEditable() || "button".equals(this.buttonStyle)) && !"none".equals(this.buttonStyle) && !this.isMacStyle();
        boolean bl5 = this.comboBox.isEnabled();
        boolean bl6 = this.comboBox.getComponentOrientation().isLeftToRight();
        if (bl2 || jComponent.isOpaque()) {
            Color color;
            graphics2D.setColor(this.getBackground(bl5));
            FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, n2, n3, f2, f3);
            if (bl5 && !bl3) {
                Color color2 = bl4 ? this.buttonEditableBackground : ((this.buttonFocusedBackground != null || this.focusedBackground != null) && FlatComboBoxUI.isPermanentFocusOwner(this.comboBox) ? (this.buttonFocusedBackground != null ? this.buttonFocusedBackground : this.focusedBackground) : (color = this.buttonBackground));
                if (color != null) {
                    Object object;
                    graphics2D.setColor(color);
                    if (this.isMacStyle()) {
                        object = this.comboBox.getInsets();
                        int n6 = UIScale.scale(2);
                        FlatUIUtils.paintComponentBackground(graphics2D, n4 + n6, ((Insets)object).top + n6, n5 - n6 * 2, n3 - ((Insets)object).top - ((Insets)object).bottom - n6 * 2, 0.0f, f3 - f2);
                    } else {
                        object = graphics2D.getClip();
                        if (bl6) {
                            graphics2D.clipRect(n4, 0, n2 - n4, n3);
                        } else {
                            graphics2D.clipRect(0, 0, n4 + n5, n3);
                        }
                        FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, n2, n3, f2, f3);
                        graphics2D.setClip((Shape)object);
                    }
                }
            }
            if (bl4) {
                Color color3 = color = bl5 ? this.buttonSeparatorColor : this.buttonDisabledSeparatorColor;
                if (color != null && this.buttonSeparatorWidth > 0.0f) {
                    graphics2D.setColor(color);
                    float f4 = UIScale.scale(this.buttonSeparatorWidth);
                    float f5 = bl6 ? (float)n4 : (float)(n4 + n5) - f4;
                    graphics2D.fill(new Rectangle2D.Float(f5, f2, f4, (float)(n3 - 1) - f2 * 2.0f));
                }
            }
        }
        FlatUIUtils.resetRenderingHints(graphics2D, objectArray);
        this.paint(graphics, jComponent);
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl2) {
        this.paddingBorder.uninstall();
        DefaultListCellRenderer defaultListCellRenderer = this.comboBox.getRenderer();
        if (defaultListCellRenderer == null) {
            defaultListCellRenderer = new DefaultListCellRenderer();
        }
        Component component = defaultListCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        component.setFont(this.comboBox.getFont());
        component.applyComponentOrientation(this.comboBox.getComponentOrientation());
        boolean bl3 = this.comboBox.isEnabled();
        component.setBackground(this.getBackground(bl3));
        component.setForeground(this.getForeground(bl3));
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
        boolean bl4 = component instanceof JPanel;
        this.paddingBorder.install(component, 0);
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl4);
        this.paddingBorder.uninstall();
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(true);
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl2) {
    }

    protected Color getBackground(boolean bl2) {
        if (bl2) {
            if (FlatUIUtils.isAWTPeer(this.comboBox)) {
                return this.background;
            }
            Color color = this.comboBox.getBackground();
            if (!(color instanceof UIResource)) {
                return color;
            }
            if (this.focusedBackground != null && FlatComboBoxUI.isPermanentFocusOwner(this.comboBox)) {
                return this.focusedBackground;
            }
            return this.editableBackground != null && this.comboBox.isEditable() ? this.editableBackground : color;
        }
        return this.disabledBackground;
    }

    protected Color getForeground(boolean bl2) {
        return bl2 ? this.comboBox.getForeground() : this.disabledForeground;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        int n2 = Math.round(FlatUIUtils.getBorderFocusWidth(jComponent) * 2.0f);
        dimension.width = Math.max(dimension.width, UIScale.scale(FlatUIUtils.minimumWidth(jComponent, this.minimumWidth)) + n2);
        return dimension;
    }

    @Override
    protected Dimension getDefaultSize() {
        this.paddingBorder.uninstall();
        Dimension dimension = super.getDefaultSize();
        this.paddingBorder.uninstall();
        return dimension;
    }

    @Override
    protected Dimension getDisplaySize() {
        this.paddingBorder.uninstall();
        Dimension dimension = super.getDisplaySize();
        this.paddingBorder.uninstall();
        int n2 = dimension.width - this.padding.left - this.padding.right;
        int n3 = dimension.height - this.padding.top - this.padding.bottom;
        if (n2 == 100 && this.comboBox.isEditable() && this.comboBox.getItemCount() == 0 && this.comboBox.getPrototypeDisplayValue() == null) {
            n2 = Math.max(this.getDefaultSize().width, this.editor.getPreferredSize().width);
        }
        return new Dimension(n2, n3);
    }

    @Override
    protected Dimension getSizeForComponent(Component component) {
        this.paddingBorder.install(component, 0);
        Dimension dimension = super.getSizeForComponent(component);
        this.paddingBorder.uninstall();
        return dimension;
    }

    private boolean isCellRenderer() {
        return this.comboBox.getParent() instanceof CellRendererPane;
    }

    private boolean isCellRendererBackgroundChanged() {
        Container container = this.comboBox.getParent().getParent();
        return container != null && !this.comboBox.getBackground().equals(container.getBackground());
    }

    private boolean isMacStyle() {
        return "mac".equals(this.buttonStyle);
    }

    public static boolean isPermanentFocusOwner(JComboBox<?> jComboBox) {
        if (jComboBox.isEditable()) {
            if (FlatUIUtils.isPermanentFocusOwner(jComboBox)) {
                return true;
            }
            Component component = jComboBox.getEditor().getEditorComponent();
            return component != null && FlatUIUtils.isPermanentFocusOwner(component);
        }
        return FlatUIUtils.isPermanentFocusOwner(jComboBox);
    }

    private class FlatKeySelectionManager
    implements JComboBox.KeySelectionManager,
    UIResource {
        private final JComboBox.KeySelectionManager delegate;
        private final long timeFactor;
        private long lastTime;

        FlatKeySelectionManager(JComboBox.KeySelectionManager keySelectionManager) {
            this.delegate = keySelectionManager;
            Long l2 = (Long)UIManager.get("ComboBox.timeFactor");
            this.timeFactor = l2 != null ? l2 : 1000L;
        }

        public int selectionForKey(char c2, ComboBoxModel comboBoxModel) {
            long l2 = EventQueue.getMostRecentEventTime();
            long l3 = this.lastTime;
            this.lastTime = l2;
            if (c2 == ' ' && l2 - l3 >= this.timeFactor && !FlatComboBoxUI.this.comboBox.isPopupVisible()) {
                FlatComboBoxUI.this.comboBox.setPopupVisible(true);
                return -1;
            }
            return this.delegate.selectionForKey(c2, comboBoxModel);
        }
    }

    private class EditorDelegateAction
    extends AbstractAction {
        private final KeyStroke keyStroke;

        EditorDelegateAction(InputMap inputMap, KeyStroke keyStroke) {
            this.keyStroke = keyStroke;
            inputMap.put(keyStroke, this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionListener actionListener = FlatComboBoxUI.this.comboBox.getActionForKeyStroke(this.keyStroke);
            if (actionListener != null) {
                actionListener.actionPerformed(new ActionEvent(FlatComboBoxUI.this.comboBox, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }
    }

    private static class MacCheckedItemIcon
    extends FlatCheckBoxMenuItemIcon {
        static MacCheckedItemIcon INSTANCE = new MacCheckedItemIcon();

        private MacCheckedItemIcon() {
        }

        @Override
        protected void paintIcon(Component component, Graphics2D graphics2D) {
            graphics2D.setColor(component.getForeground());
            this.paintCheckmark(graphics2D);
        }
    }

    private static class CellPaddingBorder
    extends AbstractBorder {
        static final String KEY_MAC_STYLE_HINT = "FlatLaf.internal.FlatComboBoxUI.macStyleHint";
        static final int MAC_STYLE_GAP = 4;
        private Insets padding;
        private JComponent rendererComponent;
        private Border rendererBorder;
        private int focusWidth;

        CellPaddingBorder(Insets insets) {
            this.padding = insets;
        }

        synchronized void install(Component component, int n2) {
            if (!(component instanceof JComponent)) {
                return;
            }
            this.focusWidth = n2;
            JComponent jComponent = (JComponent)component;
            Border border = jComponent.getBorder();
            if (border == this) {
                return;
            }
            if (border instanceof CellPaddingBorder) {
                ((CellPaddingBorder)border).uninstall();
            }
            this.uninstall();
            this.rendererComponent = jComponent;
            this.rendererBorder = jComponent.getBorder();
            jComponent.setBorder(this);
        }

        synchronized void uninstall() {
            if (this.rendererComponent == null) {
                return;
            }
            this.rendererComponent.putClientProperty(KEY_MAC_STYLE_HINT, null);
            if (this.rendererComponent.getBorder() == this) {
                this.rendererComponent.setBorder(this.rendererBorder);
            }
            this.rendererComponent = null;
            this.rendererBorder = null;
        }

        @Override
        public synchronized Insets getBorderInsets(Component component, Insets insets) {
            Serializable serializable;
            Insets insets2 = UIScale.scale(this.padding);
            if (this.rendererBorder != null && !(this.rendererBorder instanceof CellPaddingBorder)) {
                serializable = this.rendererBorder.getBorderInsets(component);
                insets.top = Math.max(insets2.top, serializable.top);
                insets.left = Math.max(insets2.left, serializable.left);
                insets.bottom = Math.max(insets2.bottom, serializable.bottom);
                insets.right = Math.max(insets2.right, serializable.right);
            } else {
                insets.top = insets2.top;
                insets.left = insets2.left;
                insets.bottom = insets2.bottom;
                insets.right = insets2.right;
            }
            insets.left += this.focusWidth;
            insets.right += this.focusWidth;
            if (component instanceof JComponent && (serializable = FlatClientProperties.clientPropertyBooleanStrict((JComponent)component, KEY_MAC_STYLE_HINT, null)) != null) {
                int n2 = MacCheckedItemIcon.INSTANCE.getIconWidth() + UIScale.scale(4);
                if (component.getComponentOrientation().isLeftToRight()) {
                    insets.left += n2;
                } else {
                    insets.right += n2;
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Boolean bl2;
            if (this.rendererBorder != null) {
                this.rendererBorder.paintBorder(component, graphics, n2, n3, n4, n5);
            }
            if (component instanceof JComponent && (bl2 = FlatClientProperties.clientPropertyBooleanStrict((JComponent)component, KEY_MAC_STYLE_HINT, null)) == Boolean.TRUE) {
                int n6 = component.getComponentOrientation().isLeftToRight() ? n2 + UIScale.scale(this.padding.left) : n2 + n4 - UIScale.scale(this.padding.right) - MacCheckedItemIcon.INSTANCE.getIconWidth();
                MacCheckedItemIcon.INSTANCE.paintIcon(component, graphics, n6, n3 + (n5 - MacCheckedItemIcon.INSTANCE.getIconHeight()) / 2);
            }
        }
    }

    protected class FlatComboPopup
    extends BasicComboPopup {
        protected FlatComboPopup(JComboBox jComboBox) {
            super(jComboBox);
            ComponentOrientation componentOrientation = this.comboBox.getComponentOrientation();
            this.list.setComponentOrientation(componentOrientation);
            this.scroller.setComponentOrientation(componentOrientation);
            this.setComponentOrientation(componentOrientation);
        }

        @Override
        protected Rectangle computePopupBounds(int n2, int n3, int n4, int n5) {
            Insets insets;
            JScrollBar jScrollBar;
            Object object;
            int n6 = FlatComboBoxUI.this.getDisplaySize().width;
            for (Border border : new Border[]{this.scroller.getViewportBorder(), this.scroller.getBorder()}) {
                if (border == null) continue;
                object = border.getBorderInsets(null);
                n6 += ((Insets)object).left + ((Insets)object).right;
            }
            boolean bl2 = this.isPopupOverComboBox();
            int n7 = -1;
            if (bl2 && (n7 = this.comboBox.getSelectedIndex()) >= 0) {
                n6 += MacCheckedItemIcon.INSTANCE.getIconWidth() + UIScale.scale(4);
            }
            if ((jScrollBar = this.scroller.getVerticalScrollBar()) != null) {
                n6 += jScrollBar.getPreferredSize().width;
            }
            int n8 = n4;
            if (n6 > n4) {
                Cloneable cloneable;
                object = this.comboBox.getGraphicsConfiguration();
                if (object != null) {
                    cloneable = ((GraphicsConfiguration)object).getBounds();
                    insets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)object);
                    n6 = Math.min(n6, cloneable.width - insets.left - insets.right);
                } else {
                    cloneable = Toolkit.getDefaultToolkit().getScreenSize();
                    n6 = Math.min(n6, ((Dimension)cloneable).width);
                }
                int n9 = n6 - n4;
                n4 = n6;
                if (!this.comboBox.getComponentOrientation().isLeftToRight()) {
                    n2 -= n9;
                }
            }
            if (bl2 && n7 >= 0 && (object = this.list.getCellBounds(0, 0)) != null) {
                Insets insets2 = this.comboBox.getInsets();
                insets = this.list.getInsets();
                Insets insets3 = this.getInsets();
                int n10 = Math.min(n4 - n8, MacCheckedItemIcon.INSTANCE.getIconWidth()) + UIScale.scale(4);
                n2 = this.comboBox.getComponentOrientation().isLeftToRight() ? (n2 -= n10 + insets2.right + insets.right) : (n2 += n10 + insets2.left + insets.left);
                return new Rectangle(n2, n3 -= ((Rectangle)object).height * (n7 + 1) + insets2.top + insets.top + insets3.top, n4, n5);
            }
            return super.computePopupBounds(n2, n3, n4, n5);
        }

        @Override
        protected void configurePopup() {
            super.configurePopup();
            this.setOpaque(true);
            Border border = UIManager.getBorder("PopupMenu.border");
            if (border != null) {
                this.setBorder(FlatUIUtils.nonUIResource(border));
            }
            this.list.setCellRenderer(new PopupListCellRenderer());
            this.updateStyle();
        }

        void updateStyle() {
            if (FlatComboBoxUI.this.popupBackground != null) {
                this.list.setBackground(FlatComboBoxUI.this.popupBackground);
            }
            this.setBackground(FlatUIUtils.nonUIResource(this.list.getBackground()));
            this.scroller.setViewportBorder(FlatComboBoxUI.this.popupInsets != null ? new FlatEmptyBorder(FlatComboBoxUI.this.popupInsets) : null);
            this.scroller.setOpaque(false);
            if (this.list.getUI() instanceof FlatListUI) {
                FlatListUI flatListUI = (FlatListUI)this.list.getUI();
                flatListUI.selectionInsets = FlatComboBoxUI.this.selectionInsets;
                flatListUI.selectionArc = FlatComboBoxUI.this.selectionArc;
            }
        }

        @Override
        protected PropertyChangeListener createPropertyChangeListener() {
            PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
            return propertyChangeEvent -> {
                propertyChangeListener.propertyChange(propertyChangeEvent);
                if (propertyChangeEvent.getPropertyName() == "renderer") {
                    this.list.setCellRenderer(new PopupListCellRenderer());
                }
            };
        }

        @Override
        protected int getPopupHeightForRowCount(int n2) {
            int n3 = super.getPopupHeightForRowCount(n2);
            FlatComboBoxUI.this.paddingBorder.uninstall();
            return n3;
        }

        @Override
        public void show(Component component, int n2, int n3) {
            int n4;
            Border border;
            if (n3 < 0 && !SystemInfo.isJava_9_orLater && (border = this.getBorder()) != null) {
                Insets insets = border.getBorderInsets(this);
                n3 -= insets.top + insets.bottom;
            }
            if (this.list.getHeight() == 0 && (n4 = this.list.getSelectedIndex()) >= 1) {
                int n5 = this.comboBox.getMaximumRowCount();
                if (n4 < n5) {
                    this.list.scrollRectToVisible(new Rectangle());
                } else {
                    int n6 = Math.max(n4 - n5 / 2, 0);
                    if (n6 > 0) {
                        this.list.ensureIndexIsVisible(n6);
                    }
                }
            }
            super.show(component, n2, n3);
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
            FlatComboBoxUI.this.paddingBorder.uninstall();
        }

        private boolean isPopupOverComboBox() {
            return FlatComboBoxUI.this.isMacStyle() && !this.comboBox.isEditable() && this.comboBox.getItemCount() > 0 && this.comboBox.getItemCount() <= this.comboBox.getMaximumRowCount() && !FlatClientProperties.clientPropertyBoolean(this.comboBox, "JComboBox.isPopDown", false);
        }

        private class PopupListCellRenderer
        implements ListCellRenderer {
            private PopupListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                FlatComboBoxUI.this.paddingBorder.uninstall();
                DefaultListCellRenderer defaultListCellRenderer = FlatComboPopup.this.comboBox.getRenderer();
                if (defaultListCellRenderer == null) {
                    defaultListCellRenderer = new DefaultListCellRenderer();
                }
                Component component = defaultListCellRenderer.getListCellRendererComponent(jList, object, n2, bl2, bl3);
                component.applyComponentOrientation(FlatComboPopup.this.comboBox.getComponentOrientation());
                if (FlatComboPopup.this.isPopupOverComboBox() && component instanceof JComponent) {
                    int n3 = FlatComboPopup.this.comboBox.getSelectedIndex();
                    ((JComponent)component).putClientProperty("FlatLaf.internal.FlatComboBoxUI.macStyleHint", n3 >= 0 ? Boolean.valueOf(n2 == n3) : null);
                }
                FlatComboBoxUI.this.paddingBorder.install(component, Math.round(FlatUIUtils.getBorderFocusWidth(FlatComboPopup.this.comboBox)));
                return component;
            }
        }
    }

    protected class FlatComboBoxButton
    extends FlatArrowButton {
        protected FlatComboBoxButton() {
            this(5, flatComboBoxUI.arrowType, flatComboBoxUI.buttonArrowColor, flatComboBoxUI.buttonDisabledArrowColor, flatComboBoxUI.buttonHoverArrowColor, null, flatComboBoxUI.buttonPressedArrowColor, null);
        }

        protected FlatComboBoxButton(int n2, String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
            super(n2, string, color, color2, color3, color4, color5, color6);
        }

        protected void updateStyle() {
            this.updateStyle(FlatComboBoxUI.this.arrowType, FlatComboBoxUI.this.buttonArrowColor, FlatComboBoxUI.this.buttonDisabledArrowColor, FlatComboBoxUI.this.buttonHoverArrowColor, null, FlatComboBoxUI.this.buttonPressedArrowColor, null);
        }

        @Override
        public int getArrowWidth() {
            return FlatComboBoxUI.this.isMacStyle() ? (this.getWidth() % 2 == 0 ? 6 : 7) : super.getArrowWidth();
        }

        @Override
        public float getArrowThickness() {
            return FlatComboBoxUI.this.isMacStyle() ? 1.5f : super.getArrowThickness();
        }

        @Override
        public boolean isRoundBorderAutoXOffset() {
            return FlatComboBoxUI.this.isMacStyle() ? false : super.isRoundBorderAutoXOffset();
        }

        @Override
        protected boolean isHover() {
            return super.isHover() || !FlatComboBoxUI.this.comboBox.isEditable() && FlatComboBoxUI.this.hover;
        }

        @Override
        protected boolean isPressed() {
            return super.isPressed() || !FlatComboBoxUI.this.comboBox.isEditable() && FlatComboBoxUI.this.pressed;
        }

        @Override
        protected Color getArrowColor() {
            if (FlatComboBoxUI.this.isCellRenderer() && FlatComboBoxUI.this.isCellRendererBackgroundChanged()) {
                return FlatComboBoxUI.this.comboBox.getForeground();
            }
            return super.getArrowColor();
        }

        @Override
        protected void paintArrow(Graphics2D graphics2D) {
            if (FlatComboBoxUI.this.isMacStyle() && !FlatComboBoxUI.this.comboBox.isEditable()) {
                int n2 = this.getHeight();
                int n3 = Math.round((float)n2 / 2.0f);
                FlatUIUtils.paintArrow(graphics2D, 0, 0, this.getWidth(), n3, 1, this.chevron, this.getArrowWidth(), this.getArrowThickness(), this.getXOffset(), this.getYOffset() + 1.25f);
                FlatUIUtils.paintArrow(graphics2D, 0, n2 - n3, this.getWidth(), n3, 5, this.chevron, this.getArrowWidth(), this.getArrowThickness(), this.getXOffset(), this.getYOffset() - 1.25f);
            } else {
                super.paintArrow(graphics2D);
            }
        }
    }
}

