/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class FlatDesktopPaneUI
extends BasicDesktopPaneUI {
    private LayoutDockListener layoutDockListener;
    private boolean layoutDockPending;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatDesktopPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.layoutDockLaterOnce();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.layoutDockListener = new LayoutDockListener();
        this.desktop.addContainerListener(this.layoutDockListener);
        this.desktop.addComponentListener(this.layoutDockListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.desktop.removeContainerListener(this.layoutDockListener);
        this.desktop.removeComponentListener(this.layoutDockListener);
        this.layoutDockListener = null;
    }

    private void layoutDockLaterOnce() {
        if (this.layoutDockPending) {
            return;
        }
        this.layoutDockPending = true;
        EventQueue.invokeLater(() -> {
            this.layoutDockPending = false;
            if (this.desktop != null) {
                this.layoutDock();
            }
        });
    }

    protected void layoutDock() {
        Dimension dimension = this.desktop.getSize();
        int n2 = 0;
        int n3 = dimension.height;
        int n4 = 0;
        for (Component component : this.desktop.getComponents()) {
            if (!(component instanceof JInternalFrame.JDesktopIcon)) continue;
            JInternalFrame.JDesktopIcon jDesktopIcon = (JInternalFrame.JDesktopIcon)component;
            Dimension dimension2 = jDesktopIcon.getPreferredSize();
            if (n2 + dimension2.width > dimension.width) {
                n2 = 0;
                n3 -= n4;
                n4 = 0;
            }
            jDesktopIcon.setLocation(n2, n3 - dimension2.height);
            n2 += dimension2.width;
            n4 = Math.max(dimension2.height, n4);
        }
    }

    private class LayoutDockListener
    extends ComponentAdapter
    implements ContainerListener {
        private LayoutDockListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            FlatDesktopPaneUI.this.layoutDockLaterOnce();
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            FlatDesktopPaneUI.this.layoutDockLaterOnce();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            FlatDesktopPaneUI.this.layoutDockLaterOnce();
        }
    }
}

