/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.image.BufferedImage;
import java.util.Map;

public class FlatDropShadowBorder
extends FlatEmptyBorder
implements FlatStylingSupport.StyleableBorder {
    @FlatStylingSupport.Styleable
    protected Color shadowColor;
    @FlatStylingSupport.Styleable
    protected Insets shadowInsets;
    @FlatStylingSupport.Styleable
    protected float shadowOpacity;
    private int shadowSize;
    private Image shadowImage;
    private Color lastShadowColor;
    private float lastShadowOpacity;
    private int lastShadowSize;
    private double lastSystemScaleFactor;
    private float lastUserScaleFactor;

    public FlatDropShadowBorder() {
        this((Color)null);
    }

    public FlatDropShadowBorder(Color color) {
        this(color, 4, 0.5f);
    }

    public FlatDropShadowBorder(Color color, int n2, float f2) {
        this(color, new Insets(-n2, -n2, n2, n2), f2);
    }

    public FlatDropShadowBorder(Color color, Insets insets, float f2) {
        super(FlatDropShadowBorder.nonNegativeInsets(insets));
        this.shadowColor = color;
        this.shadowInsets = insets;
        this.shadowOpacity = f2;
        this.shadowSize = this.maxInset(insets);
    }

    private static Insets nonNegativeInsets(Insets insets) {
        return new Insets(Math.max(insets.top, 0), Math.max(insets.left, 0), Math.max(insets.bottom, 0), Math.max(insets.right, 0));
    }

    private int maxInset(Insets insets) {
        return Math.max(Math.max(insets.left, insets.right), Math.max(insets.top, insets.bottom));
    }

    @Override
    public Object applyStyleProperty(String string, Object object) {
        Object object2 = FlatStylingSupport.applyToAnnotatedObject(this, string, object);
        if (string.equals("shadowInsets")) {
            this.applyStyleProperty(FlatDropShadowBorder.nonNegativeInsets(this.shadowInsets));
            this.shadowSize = this.maxInset(this.shadowInsets);
        }
        return object2;
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.shadowSize <= 0) {
            return;
        }
        HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n2, n3, n4, n5, this::paintImpl);
    }

    private void paintImpl(Graphics2D graphics2D, int n2, int n3, int n4, int n5, double d2) {
        Color color = this.shadowColor != null ? this.shadowColor : graphics2D.getColor();
        int n6 = this.scale(this.shadowSize, d2);
        float f2 = UIScale.getUserScaleFactor();
        if (this.shadowImage == null || !color.equals(this.lastShadowColor) || this.lastShadowOpacity != this.shadowOpacity || this.lastShadowSize != n6 || this.lastSystemScaleFactor != d2 || this.lastUserScaleFactor != f2) {
            this.shadowImage = FlatDropShadowBorder.createShadowImage(color, n6, this.shadowOpacity, (float)(d2 * (double)f2));
            this.lastShadowColor = color;
            this.lastShadowOpacity = this.shadowOpacity;
            this.lastShadowSize = n6;
            this.lastSystemScaleFactor = d2;
            this.lastUserScaleFactor = f2;
        }
        int n7 = this.scale(this.shadowInsets.left, d2);
        int n8 = this.scale(this.shadowInsets.right, d2);
        int n9 = this.scale(this.shadowInsets.top, d2);
        int n10 = this.scale(this.shadowInsets.bottom, d2);
        int n11 = n2 - Math.min(n7, 0);
        int n12 = n3 - Math.min(n9, 0);
        int n13 = n2 + n4 + Math.min(n8, 0);
        int n14 = n3 + n5 + Math.min(n10, 0);
        int n15 = n11 + n6;
        int n16 = n12 + n6;
        int n17 = n13 - n6;
        int n18 = n14 - n6;
        int n19 = n6 * 2 - 1;
        int n20 = n6 - 1;
        if (n7 > 0 || n9 > 0) {
            graphics2D.drawImage(this.shadowImage, n11, n12, n15, n16, 0, 0, n20, n20, null);
        }
        if (n9 > 0) {
            graphics2D.drawImage(this.shadowImage, n15, n12, n17, n16, n20, 0, n20 + 1, n20, null);
        }
        if (n8 > 0 || n9 > 0) {
            graphics2D.drawImage(this.shadowImage, n17, n12, n13, n16, n20, 0, n19, n20, null);
        }
        if (n7 > 0) {
            graphics2D.drawImage(this.shadowImage, n11, n16, n15, n18, 0, n20, n20, n20 + 1, null);
        }
        if (n8 > 0) {
            graphics2D.drawImage(this.shadowImage, n17, n16, n13, n18, n20, n20, n19, n20 + 1, null);
        }
        if (n7 > 0 || n10 > 0) {
            graphics2D.drawImage(this.shadowImage, n11, n18, n15, n14, 0, n20, n20, n19, null);
        }
        if (n10 > 0) {
            graphics2D.drawImage(this.shadowImage, n15, n18, n17, n14, n20, n20, n20 + 1, n19, null);
        }
        if (n8 > 0 || n10 > 0) {
            graphics2D.drawImage(this.shadowImage, n17, n18, n13, n14, n20, n20, n19, n19, null);
        }
    }

    private int scale(int n2, double d2) {
        return (int)Math.ceil((double)UIScale.scale(n2) * d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createShadowImage(Color color, int n2, float f2, float f3) {
        int n3 = color.getRGB() & 0xFFFFFF;
        int n4 = (int)(255.0f * f2);
        Color color2 = new Color(n3 | (n4 & 0xFF) << 24, true);
        Color color3 = new Color(n3 | (n4 / 2 & 0xFF) << 24, true);
        Color color4 = new Color(n3, true);
        int n5 = n2 * 2 - 1;
        int n6 = n2 - 1;
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(n6, (float)n6, (float)n2 - 0.75f * f3, new float[]{0.0f, 0.35f, 1.0f}, new Color[]{color2, color3, color4});
        BufferedImage bufferedImage = new BufferedImage(n5, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setPaint(radialGradientPaint);
            graphics2D.fillRect(0, 0, n5, n5);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

