/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatFileViewDirectoryIcon;
import com.formdev.flatlaf.ui.JavaCompatibility2;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.ScaledImageIcon;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.table.TableCellRenderer;

public class FlatFileChooserUI
extends MetalFileChooserUI {
    private final FlatFileView fileView = new FlatFileView();
    private FlatShortcutsPanel shortcutsPanel;
    private JScrollPane shortcutsScrollPane;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatFileChooserUI((JFileChooser)jComponent);
    }

    public FlatFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        FlatShortcutsPanel flatShortcutsPanel;
        super.installComponents(jFileChooser);
        this.patchUI(jFileChooser);
        if (!UIManager.getBoolean("FileChooser.noPlacesBar") && (flatShortcutsPanel = this.createShortcutsPanel(jFileChooser)).getComponentCount() > 0) {
            this.shortcutsPanel = flatShortcutsPanel;
            this.shortcutsScrollPane = new JScrollPane(this.shortcutsPanel, 20, 31);
            this.shortcutsScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jFileChooser.add((Component)this.shortcutsScrollPane, "Before");
            jFileChooser.addPropertyChangeListener(this.shortcutsPanel);
        }
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        super.uninstallComponents(jFileChooser);
        if (this.shortcutsPanel != null) {
            jFileChooser.removePropertyChangeListener(this.shortcutsPanel);
            this.shortcutsPanel = null;
            this.shortcutsScrollPane = null;
        }
    }

    private void patchUI(JFileChooser jFileChooser) {
        Component component;
        Component component2;
        Component[] componentArray;
        Object object;
        Component component3 = jFileChooser.getComponent(0);
        if (component3 instanceof JPanel && ((JPanel)component3).getLayout() instanceof BorderLayout && (object = ((JPanel)component3).getComponent(0)) instanceof JPanel && ((JPanel)object).getLayout() instanceof BoxLayout) {
            Insets insets = UIManager.getInsets("Button.margin");
            componentArray = ((JPanel)object).getComponents();
            for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
                component2 = componentArray[i2];
                if (component2 instanceof JButton || component2 instanceof JToggleButton) {
                    component = (AbstractButton)component2;
                    ((JComponent)component).putClientProperty("JButton.buttonType", "toolBarButton");
                    ((AbstractButton)component).setMargin(insets);
                    component.setFocusable(false);
                    continue;
                }
                if (!(component2 instanceof Box.Filler)) continue;
                ((JPanel)object).remove(i2);
            }
        }
        try {
            int n2;
            object = ((JPanel)component3).getComponent(2);
            if (object instanceof JComboBox && (n2 = UIManager.getInt("ComboBox.maximumRowCount")) > 0) {
                ((JComboBox)object).setMaximumRowCount(n2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        object = jFileChooser.getLayout();
        if (object instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)object;
            borderLayout.setHgap(8);
            componentArray = borderLayout.getLayoutComponent("North");
            Component component4 = borderLayout.getLayoutComponent("After");
            component2 = borderLayout.getLayoutComponent("Center");
            component = borderLayout.getLayoutComponent("South");
            if (componentArray != null && component4 != null && component2 != null && component != null) {
                JPanel jPanel = new JPanel(new BorderLayout(0, 11));
                jPanel.add((Component)componentArray, "North");
                jPanel.add(component4, "After");
                jPanel.add(component2, "Center");
                jPanel.add(component, "South");
                jFileChooser.add((Component)jPanel, "Center");
            }
        }
    }

    @Override
    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        JPanel jPanel = super.createDetailsView(jFileChooser);
        if (!SystemInfo.isWindows) {
            return jPanel;
        }
        JScrollPane jScrollPane = null;
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)component;
            break;
        }
        if (jScrollPane == null) {
            return jPanel;
        }
        Component component = jScrollPane.getViewport().getView();
        if (!(component instanceof JTable)) {
            return jPanel;
        }
        JTable jTable = (JTable)component;
        final TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(Object.class);
        jTable.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                if (object instanceof String && ((String)object).startsWith("\u200e")) {
                    String string = (String)object;
                    char[] cArray = new char[string.length()];
                    int n4 = 0;
                    for (int i2 = 0; i2 < cArray.length; ++i2) {
                        char c2 = string.charAt(i2);
                        if (c2 == '\u200e' || c2 == '\u200f') continue;
                        cArray[n4++] = c2;
                    }
                    object = new String(cArray, 0, n4);
                }
                return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            }
        });
        return jPanel;
    }

    protected FlatShortcutsPanel createShortcutsPanel(JFileChooser jFileChooser) {
        return new FlatShortcutsPanel(jFileChooser);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        Dimension dimension2 = this.getMinimumSize(jComponent);
        int n2 = this.shortcutsScrollPane != null ? this.shortcutsScrollPane.getPreferredSize().width : 0;
        return new Dimension(Math.max(dimension.width, dimension2.width + n2), Math.max(dimension.height, dimension2.height));
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return UIScale.scale(super.getMinimumSize(jComponent));
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        return FlatFileChooserUI.doNotUseSystemIcons() ? super.getFileView(jFileChooser) : this.fileView;
    }

    @Override
    public void clearIconCache() {
        if (FlatFileChooserUI.doNotUseSystemIcons()) {
            super.clearIconCache();
        } else {
            this.fileView.clearIconCache();
        }
    }

    private static boolean doNotUseSystemIcons() {
        return SystemInfo.isWindows && SystemInfo.isX86 && SystemInfo.isJava_17_orLater && SystemInfo.javaVersion < SystemInfo.toVersion(17, 0, 3, 0);
    }

    private static class ShortcutIcon
    implements Icon {
        private final Icon icon;
        private final int iconWidth;
        private final int iconHeight;

        ShortcutIcon(Icon icon, int n2, int n3) {
            this.icon = icon;
            this.iconWidth = n2;
            this.iconHeight = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                double d2 = (double)this.getIconWidth() / (double)this.icon.getIconWidth();
                graphics2D.translate(n2, n3);
                graphics2D.scale(d2, d2);
                this.icon.paintIcon(component, graphics2D, 0, 0);
            }
            finally {
                graphics2D.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return UIScale.scale(this.iconWidth);
        }

        @Override
        public int getIconHeight() {
            return UIScale.scale(this.iconHeight);
        }
    }

    public static class FlatShortcutsPanel
    extends JToolBar
    implements PropertyChangeListener,
    Scrollable {
        private final JFileChooser fc;
        private final Dimension buttonSize;
        private final Dimension iconSize;
        private final Function<File[], File[]> filesFunction;
        private final Function<File, String> displayNameFunction;
        private final Function<File, Icon> iconFunction;
        protected final File[] files;
        protected final JToggleButton[] buttons;
        protected final ButtonGroup buttonGroup = new ButtonGroup();

        public FlatShortcutsPanel(JFileChooser jFileChooser) {
            super(1);
            this.fc = jFileChooser;
            this.setFloatable(false);
            this.putClientProperty("FlatLaf.style", "hoverButtonGroupBackground: null");
            this.buttonSize = UIScale.scale(this.getUIDimension("FileChooser.shortcuts.buttonSize", 84, 64));
            this.iconSize = this.getUIDimension("FileChooser.shortcuts.iconSize", 32, 32);
            this.filesFunction = (Function)UIManager.get("FileChooser.shortcuts.filesFunction");
            this.displayNameFunction = (Function)UIManager.get("FileChooser.shortcuts.displayNameFunction");
            this.iconFunction = (Function)UIManager.get("FileChooser.shortcuts.iconFunction");
            FileSystemView fileSystemView = jFileChooser.getFileSystemView();
            File[] fileArray = JavaCompatibility2.getChooserShortcutPanelFiles(fileSystemView);
            if (this.filesFunction != null) {
                fileArray = this.filesFunction.apply(fileArray);
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<JToggleButton> arrayList2 = new ArrayList<JToggleButton>();
            for (File file : fileArray) {
                if (file == null) continue;
                if (fileSystemView.isFileSystemRoot(file)) {
                    file = fileSystemView.createFileObject(file.getAbsolutePath());
                }
                String string = this.getDisplayName(fileSystemView, file);
                Icon icon = this.getIcon(fileSystemView, file);
                if (string == null) continue;
                int n2 = string.lastIndexOf(File.separatorChar);
                if (n2 >= 0 && n2 < string.length() - 1) {
                    string = string.substring(n2 + 1);
                }
                if (icon instanceof ImageIcon) {
                    icon = new ScaledImageIcon((ImageIcon)icon, this.iconSize.width, this.iconSize.height);
                } else if (icon != null) {
                    icon = new ShortcutIcon(icon, this.iconSize.width, this.iconSize.height);
                }
                JToggleButton jToggleButton = this.createButton(string, icon, file.toString());
                File file2 = file;
                jToggleButton.addActionListener(actionEvent -> jFileChooser.setCurrentDirectory(file2));
                this.add(jToggleButton);
                this.buttonGroup.add(jToggleButton);
                arrayList.add(file);
                arrayList2.add(jToggleButton);
            }
            this.files = arrayList.toArray(new File[arrayList.size()]);
            this.buttons = arrayList2.toArray(new JToggleButton[arrayList2.size()]);
            this.directoryChanged(jFileChooser.getCurrentDirectory());
        }

        private Dimension getUIDimension(String string, int n2, int n3) {
            Dimension dimension = UIManager.getDimension(string);
            if (dimension == null) {
                dimension = new Dimension(n2, n3);
            }
            return dimension;
        }

        protected JToggleButton createButton(String string, Icon icon, String string2) {
            JToggleButton jToggleButton = new JToggleButton(string, icon);
            jToggleButton.setToolTipText(string2);
            jToggleButton.setVerticalTextPosition(3);
            jToggleButton.setHorizontalTextPosition(0);
            jToggleButton.setAlignmentX(0.5f);
            jToggleButton.setIconTextGap(0);
            jToggleButton.setPreferredSize(this.buttonSize);
            jToggleButton.setMaximumSize(this.buttonSize);
            return jToggleButton;
        }

        protected String getDisplayName(FileSystemView fileSystemView, File file) {
            String string;
            if (this.displayNameFunction != null && (string = this.displayNameFunction.apply(file)) != null) {
                return string;
            }
            return fileSystemView.getSystemDisplayName(file);
        }

        protected Icon getIcon(FileSystemView fileSystemView, File file) {
            Object object;
            if (this.iconFunction != null && (object = this.iconFunction.apply(file)) != null) {
                return object;
            }
            if (FlatFileChooserUI.doNotUseSystemIcons()) {
                return new FlatFileViewDirectoryIcon();
            }
            try {
                block9: {
                    try {
                        if (SystemInfo.isJava_17_orLater) {
                            object = fileSystemView.getClass().getMethod("getSystemIcon", File.class, Integer.TYPE, Integer.TYPE);
                            return (Icon)((Method)object).invoke((Object)fileSystemView, file, this.iconSize.width, this.iconSize.height);
                        }
                        if ((this.iconSize.width > 16 || this.iconSize.height > 16) && ((Class)(object = Class.forName("sun.awt.shell.ShellFolder"))).isInstance(file)) {
                            Method method = file.getClass().getMethod("getIcon", Boolean.TYPE);
                            method.setAccessible(true);
                            Image image = (Image)method.invoke((Object)file, true);
                            if (image != null) {
                                return new ImageIcon(image);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if ("java.lang.reflect.InaccessibleObjectException".equals(exception.getClass().getName())) break block9;
                        LoggingFacade.INSTANCE.logSevere(null, exception);
                    }
                }
                return fileSystemView.getSystemIcon(file);
            }
            catch (NullPointerException nullPointerException) {
                return new FlatFileViewDirectoryIcon();
            }
        }

        protected void directoryChanged(File file) {
            if (file != null) {
                String string = file.getAbsolutePath();
                for (int i2 = 0; i2 < this.files.length; ++i2) {
                    if (!this.files[i2].equals(file) && !this.files[i2].getAbsolutePath().equals(string)) continue;
                    this.buttons[i2].setSelected(true);
                    return;
                }
            }
            this.buttonGroup.clearSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "directoryChanged": {
                    this.directoryChanged(this.fc.getCurrentDirectory());
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            if (this.getComponentCount() > 0) {
                Insets insets = this.getInsets();
                int n2 = this.getComponent((int)0).getPreferredSize().height * 5 + insets.top + insets.bottom;
                return new Dimension(this.getPreferredSize().width, n2);
            }
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
            if (n2 == 1 && this.getComponentCount() > 0) {
                return this.getComponent((int)0).getPreferredSize().height;
            }
            return this.getScrollableBlockIncrement(rectangle, n2, n3) / 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
            return n2 == 1 ? rectangle.height : rectangle.width;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class FlatFileView
    extends BasicFileChooserUI.BasicFileView {
        private FlatFileView() {
            super(FlatFileChooserUI.this);
        }

        @Override
        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                try {
                    icon = FlatFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(file);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (icon != null) {
                    if (icon instanceof ImageIcon) {
                        icon = new ScaledImageIcon((ImageIcon)icon);
                    }
                    this.cacheIcon(file, icon);
                    return icon;
                }
            }
            if ((icon = super.getIcon(file)) instanceof ImageIcon) {
                icon = new ScaledImageIcon((ImageIcon)icon);
                this.cacheIcon(file, icon);
            }
            return icon;
        }
    }
}

