/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.LabelView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class FlatHTML {
    private static final Set<String> absoluteSizeKeywordsSet = new HashSet<String>(Arrays.asList("xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"));

    private FlatHTML() {
    }

    public static void updateRendererCSSFontBaseSize(JComponent jComponent) {
        int n2;
        String string;
        View view = (View)jComponent.getClientProperty("html");
        if (view == null) {
            return;
        }
        Document document = view.getDocument();
        if (!(document instanceof HTMLDocument)) {
            return;
        }
        StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
        int n3 = jComponent.getFont().getSize();
        if (styleSheet.getPointSize(7) != 36.0f || styleSheet.getPointSize(4) == (float)n3) {
            return;
        }
        if (!FlatHTML.usesAbsoluteSizeKeywordForFontSize(view)) {
            return;
        }
        if (jComponent instanceof JLabel) {
            string = ((JLabel)jComponent).getText();
        } else if (jComponent instanceof AbstractButton) {
            string = ((AbstractButton)jComponent).getText();
        } else if (jComponent instanceof JToolTip) {
            string = ((JToolTip)jComponent).getTipText();
        } else {
            return;
        }
        if (string == null) {
            return;
        }
        String string2 = "<style>BASE_SIZE " + jComponent.getFont().getSize() + "</style>";
        String string3 = "";
        String string4 = "";
        String string5 = string.toLowerCase(Locale.ENGLISH);
        int n4 = string5.indexOf("<head>");
        if (n4 >= 0) {
            n2 = n4 + "<head>".length();
        } else {
            int n5 = string5.indexOf("<style>");
            if (n5 >= 0) {
                n2 = n5;
            } else {
                n2 = "<html>".length();
                string3 = "<head>";
                string4 = "</head>";
            }
        }
        String string6 = string.substring(0, n2) + string3 + string2 + string4 + string.substring(n2);
        BasicHTML.updateRenderer(jComponent, string6);
    }

    private static boolean usesAbsoluteSizeKeywordForFontSize(View view) {
        Object object;
        AttributeSet attributeSet = view.getAttributes();
        if (attributeSet != null && (object = attributeSet.getAttribute(CSS.Attribute.FONT_SIZE)) != null && absoluteSizeKeywordsSet.contains(object.toString())) {
            return true;
        }
        int n2 = view.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!FlatHTML.usesAbsoluteSizeKeywordForFontSize(view.getView(i2))) continue;
            return true;
        }
        return false;
    }

    public static void updateRendererCSSForeground(View view, Color color) {
        Document document = view.getDocument();
        if (!(document instanceof HTMLDocument) || color == null) {
            return;
        }
        Style style = ((HTMLDocument)document).getStyle("body");
        if (style == null) {
            StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
            styleSheet.addRule(String.format("body { color: #%06x; }", color.getRGB() & 0xFFFFFF));
            FlatHTML.clearViewCaches(view);
        } else if (!color.equals(style.getAttribute(StyleConstants.Foreground))) {
            style.addAttribute(StyleConstants.Foreground, color);
            FlatHTML.clearViewCaches(view);
        }
    }

    private static void clearViewCaches(View view) {
        if (view instanceof LabelView) {
            ((LabelView)view).changedUpdate(null, null, null);
        }
        int n2 = view.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            FlatHTML.clearViewCaches(view.getView(i2));
        }
    }

    public static PropertyChangeListener createPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        return propertyChangeEvent -> {
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            FlatHTML.propertyChange(propertyChangeEvent);
        };
    }

    public static void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("html".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof View) {
            FlatHTML.updateRendererCSSFontBaseSize((JComponent)propertyChangeEvent.getSource());
        }
    }
}

