/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatPanelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class FlatLabelUI
extends BasicLabelUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected int arc = -1;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.canUseSharedUI(jComponent) ? FlatUIUtils.createSharedUI(FlatLabelUI.class, () -> new FlatLabelUI(true)) : new FlatLabelUI(false);
    }

    protected FlatLabelUI(boolean bl2) {
        this.shared = bl2;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((JLabel)jComponent);
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
        if (!this.defaults_initialized) {
            this.disabledForeground = UIManager.getColor("Label.disabledForeground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(JLabel jLabel) {
        super.uninstallDefaults(jLabel);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installComponents(JLabel jLabel) {
        super.installComponents(jLabel);
        FlatHTML.updateRendererCSSFontBaseSize(jLabel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("FlatLaf.style") || string.equals("FlatLaf.styleClass")) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            if (this.shared && FlatStylingSupport.hasStyleProperty(jLabel)) {
                jLabel.updateUI();
            } else {
                this.installStyle(jLabel);
            }
            jLabel.revalidate();
            HiDPIUtils.repaint(jLabel);
        }
        super.propertyChange(propertyChangeEvent);
        FlatHTML.propertyChange(propertyChangeEvent);
    }

    protected void installStyle(JLabel jLabel) {
        try {
            this.applyStyle(jLabel, FlatStylingSupport.getResolvedStyle(jLabel, "Label"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(JLabel jLabel, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(jLabel, (String)string, object));
    }

    protected Object applyStyleProperty(JLabel jLabel, String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, jLabel, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        FlatPanelUI.fillRoundedBackground(graphics, jComponent, this.arc);
        this.paint(graphics, jComponent);
    }

    static Graphics createGraphicsHTMLTextYCorrection(Graphics graphics, JComponent jComponent) {
        return jComponent.getClientProperty("html") != null ? HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics) : graphics;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(graphics, jComponent), jComponent);
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        int n4 = FlatLaf.isShowMnemonics() ? jLabel.getDisplayedMnemonicIndex() : -1;
        graphics.setColor(jLabel.getForeground());
        FlatUIUtils.drawStringUnderlineCharAt(jLabel, graphics, string, n4, n2, n3);
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        int n4 = FlatLaf.isShowMnemonics() ? jLabel.getDisplayedMnemonicIndex() : -1;
        graphics.setColor(this.disabledForeground);
        FlatUIUtils.drawStringUnderlineCharAt(jLabel, graphics, string, n4, n2, n3);
    }

    @Override
    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, UIScale.scale(jLabel.getIconTextGap()));
    }
}

