/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatPanelUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FlatLineBorder
extends FlatEmptyBorder {
    private final Color lineColor;
    private final float lineThickness;
    private final int arc;

    public FlatLineBorder(Insets insets, Color color) {
        this(insets, color, 1.0f, -1);
    }

    public FlatLineBorder(Insets insets, Color color, float f2, int n2) {
        super(insets);
        this.lineColor = color;
        this.lineThickness = f2;
        this.arc = n2;
    }

    public FlatLineBorder(Insets insets, int n2) {
        this(insets, null, 0.0f, n2);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public int getArc() {
        return this.arc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Object object;
        if (component instanceof JComponent && ((JComponent)component).getClientProperty("FlatLaf.internal.FlatPopupFactory.popupUsesNativeBorder") != null) {
            return;
        }
        Color color = this.getLineColor();
        float f2 = this.getLineThickness();
        if (color == null || f2 <= 0.0f) {
            return;
        }
        int n6 = this.getArc();
        if (n6 < 0) {
            Object object2 = component instanceof JLabel ? ((JLabel)component).getUI() : (object = component instanceof JPanel ? ((JPanel)component).getUI() : null);
            if (object instanceof FlatLabelUI) {
                n6 = ((FlatLabelUI)object).arc;
            } else if (object instanceof FlatPanelUI) {
                n6 = ((FlatPanelUI)object).arc;
            }
            if (n6 < 0) {
                n6 = 0;
            }
        }
        object = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)object);
            FlatUIUtils.paintOutlinedComponent((Graphics2D)object, n2, n3, n4, n5, 0.0f, 0.0f, 0.0f, UIScale.scale(f2), UIScale.scale(n6), null, color, null);
        }
        finally {
            ((Graphics)object).dispose();
        }
    }
}

