/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicListUI;

public class FlatListUI
extends BasicListUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color cellFocusColor;
    @FlatStylingSupport.Styleable
    protected Boolean showCellFocusIndicator;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatListUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectionBackground = UIManager.getColor("List.selectionBackground");
        this.selectionForeground = UIManager.getColor("List.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("List.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("List.selectionInactiveForeground");
        this.selectionInsets = UIManager.getInsets("List.selectionInsets");
        this.selectionArc = UIManager.getInt("List.selectionArc");
        this.toggleSelectionColors();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.oldStyleValues = null;
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicListUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                FlatListUI.this.toggleSelectionColors();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                EventQueue.invokeLater(() -> FlatListUI.this.toggleSelectionColors());
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            switch (propertyChangeEvent.getPropertyName()) {
                case "JComponent.focusOwner": {
                    this.toggleSelectionColors();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.list.revalidate();
                    HiDPIUtils.repaint(this.list);
                }
            }
        };
    }

    @Override
    protected ListSelectionListener createListSelectionListener() {
        ListSelectionListener listSelectionListener = super.createListSelectionListener();
        return listSelectionEvent -> {
            listSelectionListener.valueChanged(listSelectionEvent);
            if (this.useUnitedRoundedSelection(true, true) && !this.list.isSelectionEmpty() && this.list.getMaxSelectionIndex() - this.list.getMinSelectionIndex() >= 1) {
                int n2;
                int n3 = this.list.getModel().getSize();
                int n4 = Math.min(Math.max(listSelectionEvent.getFirstIndex(), 0), n3 - 1);
                Rectangle rectangle = this.getCellBounds(this.list, n4, n2 = Math.min(Math.max(listSelectionEvent.getLastIndex(), 0), n3 - 1));
                if (rectangle != null) {
                    int n5 = (int)Math.ceil(UIScale.scale((float)this.selectionArc / 2.0f));
                    HiDPIUtils.repaint(this.list, rectangle.x - n5, rectangle.y - n5, rectangle.width + n5 * 2, rectangle.height + n5 * 2);
                }
            }
        };
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.list, "List"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        Color color;
        Color color2 = this.selectionBackground;
        Color color3 = this.selectionForeground;
        Color color4 = this.selectionInactiveBackground;
        Color color5 = this.selectionInactiveForeground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.selectionBackground != color2) {
            color = this.list.getSelectionBackground();
            if (color == color2) {
                this.list.setSelectionBackground(this.selectionBackground);
            } else if (color == color4) {
                this.list.setSelectionBackground(this.selectionInactiveBackground);
            }
        }
        if (this.selectionForeground != color3) {
            color = this.list.getSelectionForeground();
            if (color == color3) {
                this.list.setSelectionForeground(this.selectionForeground);
            } else if (color == color5) {
                this.list.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.list, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    private void toggleSelectionColors() {
        if (this.list == null) {
            return;
        }
        if (FlatUIUtils.isPermanentFocusOwner(this.list)) {
            if (this.list.getSelectionBackground() == this.selectionInactiveBackground) {
                this.list.setSelectionBackground(this.selectionBackground);
            }
            if (this.list.getSelectionForeground() == this.selectionInactiveForeground) {
                this.list.setSelectionForeground(this.selectionForeground);
            }
        } else {
            if (this.list.getSelectionBackground() == this.selectionBackground) {
                this.list.setSelectionBackground(this.selectionInactiveBackground);
            }
            if (this.list.getSelectionForeground() == this.selectionForeground) {
                this.list.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected void paintCell(Graphics graphics, int n2, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n3) {
        int n4;
        int n5;
        boolean bl2 = listSelectionModel.isSelectedIndex(n2);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, listModel.getElementAt(n2), n2, bl2, FlatUIUtils.isPermanentFocusOwner(this.list) && n2 == n3);
        boolean bl3 = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        if (bl3) {
            n5 = Math.min(rectangle.width, component.getPreferredSize().width + 4);
            n4 = this.list.getComponentOrientation().isLeftToRight() ? rectangle.x : rectangle.x + (rectangle.width - n5);
        } else {
            n4 = rectangle.x;
            n5 = rectangle.width;
        }
        if (bl2 && !bl3 && (component instanceof DefaultListCellRenderer || component instanceof BasicComboBoxRenderer) && (this.selectionArc > 0 || this.selectionInsets != null && !FlatUIUtils.isInsetsEmpty(this.selectionInsets))) {
            class RoundedSelectionGraphics
            extends Graphics2DProxy {
                private boolean inPaintSelection;
                final /* synthetic */ Rectangle val$rowBounds;
                final /* synthetic */ Component val$rendererComponent;
                final /* synthetic */ int val$row;

                RoundedSelectionGraphics(Graphics graphics) {
                    this.val$rowBounds = rectangle;
                    this.val$rendererComponent = component;
                    this.val$row = n2;
                    super((Graphics2D)graphics);
                }

                @Override
                public Graphics create() {
                    return new RoundedSelectionGraphics(super.create());
                }

                @Override
                public Graphics create(int n2, int n3, int n4, int n5) {
                    return new RoundedSelectionGraphics(super.create(n2, n3, n4, n5));
                }

                @Override
                public void fillRect(int n2, int n3, int n4, int n5) {
                    if (!this.inPaintSelection && n2 == 0 && n3 == 0 && n4 == this.val$rowBounds.width && n5 == this.val$rowBounds.height && this.getColor() == this.val$rendererComponent.getBackground()) {
                        this.inPaintSelection = true;
                        FlatListUI.this.paintCellSelection(this, this.val$row, n2, n3, n4, n5);
                        this.inPaintSelection = false;
                    } else {
                        super.fillRect(n2, n3, n4, n5);
                    }
                }
            }
            graphics = new RoundedSelectionGraphics(graphics);
        }
        this.rendererPane.paintComponent(graphics, component, this.list, n4, rectangle.y, n5, rectangle.height, true);
    }

    protected void paintCellSelection(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        float f2;
        float f3 = f2 = UIScale.scale((float)this.selectionArc / 2.0f);
        float f4 = f2;
        float f5 = f2;
        if (this.list.getLayoutOrientation() == 0) {
            if (this.useUnitedRoundedSelection(true, false)) {
                if (n2 > 0 && this.list.isSelectedIndex(n2 - 1)) {
                    f4 = 0.0f;
                    f5 = 0.0f;
                }
                if (n2 < this.list.getModel().getSize() - 1 && this.list.isSelectedIndex(n2 + 1)) {
                    f2 = 0.0f;
                    f3 = 0.0f;
                }
            }
        } else {
            int n7;
            int n8;
            Rectangle rectangle = null;
            if (this.useUnitedRoundedSelection(true, false)) {
                rectangle = this.getCellBounds(this.list, n2, n2);
                n8 = this.locationToIndex(this.list, new Point(rectangle.x, rectangle.y - 1));
                n7 = this.locationToIndex(this.list, new Point(rectangle.x, rectangle.y + rectangle.height));
                if (n8 >= 0 && n8 != n2 && this.list.isSelectedIndex(n8)) {
                    f4 = 0.0f;
                    f5 = 0.0f;
                }
                if (n7 >= 0 && n7 != n2 && this.list.isSelectedIndex(n7)) {
                    f2 = 0.0f;
                    f3 = 0.0f;
                }
            }
            if (this.useUnitedRoundedSelection(false, true)) {
                if (rectangle == null) {
                    rectangle = this.getCellBounds(this.list, n2, n2);
                }
                n8 = this.locationToIndex(this.list, new Point(rectangle.x - 1, rectangle.y));
                n7 = this.locationToIndex(this.list, new Point(rectangle.x + rectangle.width, rectangle.y));
                boolean bl2 = this.list.getComponentOrientation().isLeftToRight();
                if (!bl2 && n8 >= 0 && n8 != n2 && n8 == this.locationToIndex(this.list, new Point(rectangle.x - 1, rectangle.y - 1))) {
                    n8 = -1;
                }
                if (bl2 && n7 >= 0 && n7 != n2 && n7 == this.locationToIndex(this.list, new Point(rectangle.x + rectangle.width, rectangle.y - 1))) {
                    n7 = -1;
                }
                if (n8 >= 0 && n8 != n2 && this.list.isSelectedIndex(n8)) {
                    f3 = 0.0f;
                    f5 = 0.0f;
                }
                if (n7 >= 0 && n7 != n2 && this.list.isSelectedIndex(n7)) {
                    f2 = 0.0f;
                    f4 = 0.0f;
                }
            }
        }
        FlatUIUtils.paintSelection((Graphics2D)graphics, n3, n4, n5, n6, UIScale.scale(this.selectionInsets), f5, f4, f3, f2, 0);
    }

    private boolean useUnitedRoundedSelection(boolean bl2, boolean bl3) {
        return this.selectionArc > 0 && (this.selectionInsets == null || bl2 && this.selectionInsets.top == 0 && this.selectionInsets.bottom == 0 || bl3 && this.selectionInsets.left == 0 && this.selectionInsets.right == 0);
    }

    public static void paintCellSelection(JList<?> jList, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        if (!(jList.getUI() instanceof FlatListUI)) {
            return;
        }
        FlatListUI flatListUI = (FlatListUI)jList.getUI();
        flatListUI.paintCellSelection(graphics, n2, n3, n4, n5, n6);
    }
}

