/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

@FlatStylingSupport.StyleableFields(value={@FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionBackground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="disabledForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorSelectionForeground")})
public class FlatMenuItemUI
extends BasicMenuItemUI
implements FlatStylingSupport.StyleableLookupProvider,
FlatStylingSupport.StyleableUI {
    private FlatMenuItemRenderer renderer;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatMenuItemUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", FlatUIUtils.getUIInt("MenuItem.iconTextGap", 4));
        this.renderer = this.createRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        FlatMenuItemRenderer.clearClientProperties(this.menuItem.getParent());
        this.renderer = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void installComponents(JMenuItem jMenuItem) {
        super.installComponents(jMenuItem);
        FlatHTML.updateRendererCSSFontBaseSize(jMenuItem);
    }

    protected FlatMenuItemRenderer createRenderer() {
        return new FlatMenuItemRenderer(this.menuItem, this.checkIcon, this.arrowIcon, this.acceleratorFont, this.acceleratorDelimiter);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return FlatHTML.createPropertyChangeListener(FlatStylingSupport.createPropertyChangeListener(jComponent, this::installStyle, super.createPropertyChangeListener(jComponent)));
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.menuItem, "MenuItem"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatMenuItemUI.applyStyleProperty(this.menuItem, this, this.renderer, string, object);
    }

    static Object applyStyleProperty(JMenuItem jMenuItem, BasicMenuItemUI basicMenuItemUI, FlatMenuItemRenderer flatMenuItemRenderer, String string, Object object) {
        try {
            return flatMenuItemRenderer.applyStyleProperty(string, object);
        }
        catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {
            return FlatStylingSupport.applyToAnnotatedObjectOrComponent(basicMenuItemUI, jMenuItem, string, object);
        }
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatMenuItemUI.getStyleableInfos(this, this.renderer);
    }

    static Map<String, Class<?>> getStyleableInfos(BasicMenuItemUI basicMenuItemUI, FlatMenuItemRenderer flatMenuItemRenderer) {
        Map<String, Class<?>> map = FlatStylingSupport.getAnnotatedStyleableInfos(basicMenuItemUI);
        map.putAll(flatMenuItemRenderer.getStyleableInfos());
        return map;
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatMenuItemUI.getStyleableValue(this, this.renderer, string);
    }

    static Object getStyleableValue(BasicMenuItemUI basicMenuItemUI, FlatMenuItemRenderer flatMenuItemRenderer, String string) {
        Object object = flatMenuItemRenderer.getStyleableValue(string);
        if (object == null) {
            object = FlatStylingSupport.getAnnotatedStyleableValue(basicMenuItemUI, string);
        }
        return object;
    }

    @Override
    public MethodHandles.Lookup getLookupForStyling() {
        return MethodHandles.lookup();
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        return this.renderer.getPreferredMenuItemSize();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.renderer.paintMenuItem(graphics, this.selectionBackground, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
    }
}

