/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.NativeLibrary;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;

class FlatNativeLibrary {
    private static boolean initialized;
    private static NativeLibrary nativeLibrary;

    FlatNativeLibrary() {
    }

    private static native int getApiVersion();

    static synchronized boolean isLoaded(int n2) {
        FlatNativeLibrary.initialize(n2);
        return nativeLibrary != null ? nativeLibrary.isLoaded() : false;
    }

    private static void initialize(int n2) {
        String string;
        String string2;
        if (initialized) {
            return;
        }
        initialized = true;
        if (!FlatSystemProperties.getBoolean("flatlaf.useNativeLibrary", true)) {
            return;
        }
        if (SystemInfo.isWindows_10_orLater && (SystemInfo.isX86 || SystemInfo.isX86_64 || SystemInfo.isAARCH64)) {
            string2 = SystemInfo.isAARCH64 ? "windows-arm64" : (SystemInfo.isX86_64 ? "windows-x86_64" : "windows-x86");
            string = "dll";
        } else if (SystemInfo.isMacOS_10_14_Mojave_orLater && (SystemInfo.isAARCH64 || SystemInfo.isX86_64)) {
            string2 = SystemInfo.isAARCH64 ? "macos-arm64" : "macos-x86_64";
            string = "dylib";
        } else if (SystemInfo.isLinux && SystemInfo.isX86_64) {
            string2 = "linux-x86_64";
            string = "so";
            FlatNativeLibrary.loadJAWT();
        } else {
            return;
        }
        NativeLibrary nativeLibrary = FlatNativeLibrary.createNativeLibrary(string2, string);
        if (!nativeLibrary.isLoaded()) {
            return;
        }
        try {
            int n3 = FlatNativeLibrary.getApiVersion();
            if (n3 != n2) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Wrong API version in native library (expected " + n2 + ", actual " + n3 + "). Ignoring native library.", null);
                return;
            }
        }
        catch (Throwable throwable) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to get API version of native library. Ignoring native library.", throwable);
            return;
        }
        FlatNativeLibrary.nativeLibrary = nativeLibrary;
    }

    private static NativeLibrary createNativeLibrary(String string, String string2) {
        Object object;
        String string3 = "flatlaf-" + string;
        String string4 = System.getProperty("flatlaf.nativeLibraryPath");
        if (string4 != null) {
            if ("system".equals(string4)) {
                object = new NativeLibrary(string3, true);
                if (((NativeLibrary)object).isLoaded()) {
                    return object;
                }
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Native library '" + System.mapLibraryName(string3) + "' not found in java.library.path '" + System.getProperty("java.library.path") + "'. Using extracted native library instead.", null);
            } else {
                File file;
                object = new File(string4, System.mapLibraryName(string3));
                if (((File)object).exists()) {
                    return new NativeLibrary((File)object, true);
                }
                String string5 = null;
                File file2 = FlatNativeLibrary.getJarFile();
                if (file2 != null && (file = new File(string4, string5 = FlatNativeLibrary.buildLibraryName(file2, string, string2))).exists()) {
                    return new NativeLibrary(file, true);
                }
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Native library '" + ((File)object).getName() + (string5 != null ? "' or '" + string5 : "") + "' not found in '" + ((File)object).getParentFile().getAbsolutePath() + "'. Using extracted native library instead.", null);
            }
        }
        if ((object = FlatNativeLibrary.findLibraryBesideJar(string, string2)) != null) {
            return new NativeLibrary((File)object, true);
        }
        return new NativeLibrary("com/formdev/flatlaf/natives/" + string3, null, true);
    }

    private static File findLibraryBesideJar(String string, String string2) {
        File[] fileArray;
        File file;
        File file2 = FlatNativeLibrary.getJarFile();
        if (file2 == null) {
            return null;
        }
        String string3 = FlatNativeLibrary.buildLibraryName(file2, string, string2);
        File file3 = file2.getParentFile();
        File file4 = new File(file3, string3);
        if (file4.isFile()) {
            return file4;
        }
        if (file3.getName().equalsIgnoreCase("lib") && (file4 = new File(file3.getParentFile(), "bin/" + string3)).isFile()) {
            return file4;
        }
        String string4 = file3.getAbsolutePath().replace('\\', '/');
        if (string4.contains("/.gradle/caches/") && string3.contains((file = file3.getParentFile()).getName()) && (fileArray = file.listFiles()) != null) {
            for (File file5 : fileArray) {
                file4 = new File(file5, string3);
                if (!file4.isFile()) continue;
                return file4;
            }
        }
        return null;
    }

    private static File getJarFile() {
        try {
            URL uRL;
            CodeSource codeSource = FlatNativeLibrary.class.getProtectionDomain().getCodeSource();
            URL uRL2 = uRL = codeSource != null ? codeSource.getLocation() : null;
            if (uRL == null) {
                return null;
            }
            if (!"file".equals(uRL.getProtocol())) {
                return null;
            }
            File file = new File(uRL.toURI());
            if (!file.isFile()) {
                return null;
            }
            return file;
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(exception.getMessage(), exception);
            return null;
        }
    }

    private static String buildLibraryName(File file, String string, String string2) {
        String string3 = file.getName();
        String string4 = string3.substring(0, string3.lastIndexOf(46));
        string4 = StringUtils.removeTrailing(string4, "-no-natives");
        return string4 + (string4.contains("flatlaf") ? "" : "-flatlaf") + '-' + string + '.' + string2;
    }

    private static void loadJAWT() {
        try {
            System.loadLibrary("jawt");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = unsatisfiedLinkError.getMessage();
            if (string == null || !string.contains("already loaded in another classloader")) {
                LoggingFacade.INSTANCE.logSevere(string, unsatisfiedLinkError);
            }
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere(exception.getMessage(), exception);
        }
    }
}

