/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatWindowsNativeWindowBorder;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.util.function.Predicate;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;

public class FlatNativeWindowBorder {
    private static final boolean canUseWindowDecorations = SystemInfo.isWindows_10_orLater && (SystemInfo.isWindows_11_orLater || !FlatSystemProperties.getBoolean("sun.java2d.opengl", false)) && !SystemInfo.isProjector && !SystemInfo.isWebswing && !SystemInfo.isWinPE && FlatSystemProperties.getBoolean("flatlaf.useWindowDecorations", true);
    private static Boolean supported;
    private static Provider nativeProvider;

    public static boolean isSupported() {
        FlatNativeWindowBorder.initialize();
        return supported;
    }

    static Object install(JRootPane jRootPane) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return null;
        }
        Container container = jRootPane.getParent();
        if (container != null && !(container instanceof Window)) {
            return null;
        }
        if (container instanceof Window && container.isDisplayable()) {
            FlatNativeWindowBorder.install((Window)container);
        }
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof Window) {
                FlatNativeWindowBorder.install((Window)object);
            } else if (object == null && propertyChangeEvent.getOldValue() instanceof Window) {
                FlatNativeWindowBorder.uninstall((Window)propertyChangeEvent.getOldValue());
            }
        };
        jRootPane.addPropertyChangeListener("ancestor", propertyChangeListener);
        return propertyChangeListener;
    }

    static void install(Window window) {
        if (FlatNativeWindowBorder.hasCustomDecoration(window)) {
            return;
        }
        if (UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            return;
        }
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            JRootPane jRootPane = jFrame.getRootPane();
            if (!FlatNativeWindowBorder.useWindowDecorations(jRootPane)) {
                return;
            }
            if (jFrame.isUndecorated()) {
                return;
            }
            FlatNativeWindowBorder.setHasCustomDecoration(jFrame, true);
            if (!FlatNativeWindowBorder.hasCustomDecoration(jFrame)) {
                return;
            }
            jRootPane.setWindowDecorationStyle(1);
        } else if (window instanceof JDialog) {
            JDialog jDialog = (JDialog)window;
            JRootPane jRootPane = jDialog.getRootPane();
            if (!FlatNativeWindowBorder.useWindowDecorations(jRootPane)) {
                return;
            }
            if (jDialog.isUndecorated()) {
                return;
            }
            FlatNativeWindowBorder.setHasCustomDecoration(jDialog, true);
            if (!FlatNativeWindowBorder.hasCustomDecoration(jDialog)) {
                return;
            }
            jRootPane.setWindowDecorationStyle(2);
        }
    }

    static void uninstall(JRootPane jRootPane, Object object) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return;
        }
        if (object instanceof PropertyChangeListener) {
            jRootPane.removePropertyChangeListener("ancestor", (PropertyChangeListener)object);
        }
        if (UIManager.getLookAndFeel() instanceof FlatLaf && FlatNativeWindowBorder.useWindowDecorations(jRootPane)) {
            return;
        }
        Container container = jRootPane.getParent();
        if (container instanceof Window) {
            FlatNativeWindowBorder.uninstall((Window)container);
        }
    }

    private static void uninstall(Window window) {
        if (!FlatNativeWindowBorder.hasCustomDecoration(window)) {
            return;
        }
        FlatNativeWindowBorder.setHasCustomDecoration(window, false);
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.getRootPane().setWindowDecorationStyle(0);
        } else if (window instanceof JDialog) {
            JDialog jDialog = (JDialog)window;
            jDialog.getRootPane().setWindowDecorationStyle(0);
        }
    }

    private static boolean useWindowDecorations(JRootPane jRootPane) {
        return FlatUIUtils.getBoolean(jRootPane, "flatlaf.useWindowDecorations", "JRootPane.useWindowDecorations", "TitlePane.useWindowDecorations", false);
    }

    public static boolean hasCustomDecoration(Window window) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return false;
        }
        return nativeProvider.hasCustomDecoration(window);
    }

    public static void setHasCustomDecoration(Window window, boolean bl2) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return;
        }
        nativeProvider.setHasCustomDecoration(window, bl2);
    }

    static void setTitleBarHeightAndHitTestSpots(Window window, int n2, Predicate<Point> predicate, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return;
        }
        nativeProvider.updateTitleBarInfo(window, n2, predicate, rectangle, rectangle2, rectangle3, rectangle4);
    }

    static boolean showWindow(Window window, int n2) {
        if (!FlatNativeWindowBorder.isSupported()) {
            return false;
        }
        return nativeProvider.showWindow(window, n2);
    }

    private static void initialize() {
        if (supported != null) {
            return;
        }
        supported = false;
        if (!canUseWindowDecorations) {
            return;
        }
        try {
            FlatNativeWindowBorder.setNativeProvider(FlatWindowsNativeWindowBorder.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setNativeProvider(Provider provider) {
        if (nativeProvider != null) {
            throw new IllegalStateException();
        }
        nativeProvider = provider;
        supported = nativeProvider != null;
    }

    static class WindowTopBorder
    extends BorderUIResource.EmptyBorderUIResource {
        private static WindowTopBorder instance;
        private final Color activeLightColor = new Color(0x707070);
        private final Color activeDarkColor = new Color(2960943);
        private final Color inactiveLightColor = new Color(0xAAAAAA);
        private final Color inactiveDarkColor = new Color(4803147);
        private boolean colorizationAffectsBorders;
        private Color activeColor;

        static WindowTopBorder getInstance() {
            if (instance == null) {
                instance = new WindowTopBorder();
            }
            return instance;
        }

        WindowTopBorder() {
            super(1, 0, 0, 0);
            this.update();
            this.installListeners();
        }

        void update() {
            this.colorizationAffectsBorders = this.isColorizationColorAffectsBorders();
            this.activeColor = this.calculateActiveBorderColor();
        }

        void installListeners() {
            nativeProvider.addChangeListener(changeEvent -> {
                this.update();
                for (Window window : Window.getWindows()) {
                    if (!window.isDisplayable()) continue;
                    window.repaint(0, 0, window.getWidth(), 1);
                }
            });
        }

        boolean isColorizationColorAffectsBorders() {
            return nativeProvider.isColorizationColorAffectsBorders();
        }

        Color getColorizationColor() {
            return nativeProvider.getColorizationColor();
        }

        int getColorizationColorBalance() {
            return nativeProvider.getColorizationColorBalance();
        }

        private Color calculateActiveBorderColor() {
            if (!this.colorizationAffectsBorders) {
                return null;
            }
            Color color = this.getColorizationColor();
            if (color != null) {
                int n2 = this.getColorizationColorBalance();
                if (n2 < 0 || n2 > 100) {
                    n2 = 100;
                }
                if (n2 == 0) {
                    return new Color(0xD9D9D9);
                }
                if (n2 == 100) {
                    return color;
                }
                float f2 = (float)n2 / 100.0f;
                float f3 = 1.0f - f2;
                int n3 = Math.round((float)color.getRed() * f2 + 217.0f * f3);
                int n4 = Math.round((float)color.getGreen() * f2 + 217.0f * f3);
                int n5 = Math.round((float)color.getBlue() * f2 + 217.0f * f3);
                n3 = Math.min(Math.max(n3, 0), 255);
                n4 = Math.min(Math.max(n4, 0), 255);
                n5 = Math.min(Math.max(n5, 0), 255);
                return new Color(n3, n4, n5);
            }
            Color color2 = (Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.activeBorderColor");
            return color2 != null ? color2 : UIManager.getColor("MenuBar.borderColor");
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Window window = SwingUtilities.windowForComponent(component);
            boolean bl2 = window != null && window.isActive();
            boolean bl3 = FlatLaf.isLafDark();
            graphics.setColor(bl2 ? (this.activeColor != null ? this.activeColor : (bl3 ? this.activeDarkColor : this.activeLightColor)) : (bl3 ? this.inactiveDarkColor : this.inactiveLightColor));
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n2, n3, n4, n5, this::paintImpl);
        }

        private void paintImpl(Graphics2D graphics2D, int n2, int n3, int n4, int n5, double d2) {
            graphics2D.fillRect(n2, n3, n4, 1);
        }

        void repaintBorder(Component component) {
            component.repaint(0, 0, component.getWidth(), 1);
        }
    }

    public static interface Provider {
        public static final int SW_MAXIMIZE = 3;
        public static final int SW_MINIMIZE = 6;
        public static final int SW_RESTORE = 9;

        public boolean hasCustomDecoration(Window var1);

        public void setHasCustomDecoration(Window var1, boolean var2);

        public void updateTitleBarInfo(Window var1, int var2, Predicate<Point> var3, Rectangle var4, Rectangle var5, Rectangle var6, Rectangle var7);

        public boolean showWindow(Window var1, int var2);

        public boolean isColorizationColorAffectsBorders();

        public Color getColorizationColor();

        public int getColorizationColorBalance();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

