/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FullWindowContentSupport;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class FlatPanelUI
extends BasicPanelUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    @FlatStylingSupport.Styleable
    protected int arc = -1;
    private final boolean shared;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.canUseSharedUI(jComponent) ? FlatUIUtils.createSharedUI(FlatPanelUI.class, () -> new FlatPanelUI(true)) : new FlatPanelUI(false);
    }

    protected FlatPanelUI(boolean bl2) {
        this.shared = bl2;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.addPropertyChangeListener(this);
        if (jComponent.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.registerPlaceholder(jComponent);
        }
        this.installStyle((JPanel)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.removePropertyChangeListener(this);
        if (jComponent.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.unregisterPlaceholder(jComponent);
        }
        this.oldStyleValues = null;
    }

    @Override
    protected void installDefaults(JPanel jPanel) {
        super.installDefaults(jPanel);
        if (jPanel.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            LookAndFeel.installProperty(jPanel, "opaque", false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        switch (propertyChangeEvent.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JPanel jPanel = (JPanel)propertyChangeEvent.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(jPanel)) {
                    jPanel.updateUI();
                } else {
                    this.installStyle(jPanel);
                }
                jPanel.revalidate();
                HiDPIUtils.repaint(jPanel);
                break;
            }
            case "FlatLaf.fullWindowContent.buttonsPlaceholder": {
                JPanel jPanel = (JPanel)propertyChangeEvent.getSource();
                if (propertyChangeEvent.getOldValue() != null) {
                    FullWindowContentSupport.unregisterPlaceholder(jPanel);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    FullWindowContentSupport.registerPlaceholder(jPanel);
                }
                LookAndFeel.installProperty(jPanel, "opaque", propertyChangeEvent.getNewValue() == null);
            }
        }
    }

    protected void installStyle(JPanel jPanel) {
        try {
            this.applyStyle(jPanel, FlatStylingSupport.getResolvedStyle(jPanel, "Panel"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(JPanel jPanel, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(jPanel, (String)string, object));
    }

    protected Object applyStyleProperty(JPanel jPanel, String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, jPanel, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        FlatPanelUI.fillRoundedBackground(graphics, jComponent, this.arc);
        this.paint(graphics, jComponent);
    }

    public static void fillRoundedBackground(Graphics graphics, JComponent jComponent, int n2) {
        Object[] objectArray;
        if (n2 < 0) {
            objectArray = jComponent.getBorder();
            int n3 = n2 = objectArray instanceof FlatLineBorder ? ((FlatLineBorder)objectArray).getArc() : 0;
        }
        if (jComponent.isOpaque()) {
            if (n2 > 0) {
                FlatUIUtils.paintParentBackground(graphics, jComponent);
            } else {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
        if (n2 > 0) {
            graphics.setColor(jComponent.getBackground());
            objectArray = FlatUIUtils.setRenderingHints(graphics);
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), 0.0f, UIScale.scale(n2));
            FlatUIUtils.resetRenderingHints(graphics, objectArray);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Object object = jComponent.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder");
        if (object != null) {
            return FullWindowContentSupport.getPlaceholderPreferredSize(jComponent, (String)object);
        }
        return super.getPreferredSize(jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (jComponent.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.debugPaint(graphics, jComponent);
        }
    }
}

